/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.modules.options.indentation.IndentationModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class IndentationPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private IndentationModel model;
    private String originalText;
    private boolean listen = false;
    private boolean changed = false;
    private JCheckBox cbExpandTabsToSpaces;
    private JEditorPane epPreview;
    private JScrollPane jScrollPane1;
    private JLabel lExpandTabsToSpaces;
    private JLabel lNumberOfSpacesPerIndent;
    private JLabel lPreview;
    private JLabel lRightMargin;
    private JLabel lTabSize;
    private JSpinner sNumberOfSpacesPerIndent;
    private JSpinner sRightMargin;
    private JSpinner sTabSize;

    public IndentationPanel() {
        this.initComponents();
        this.setName(IndentationPanel.loc("Indentation_Tab"));
        IndentationPanel.loc(this.lNumberOfSpacesPerIndent, "Indent");
        IndentationPanel.loc(this.lTabSize, "TabSize");
        IndentationPanel.loc(this.lPreview, "Preview");
        IndentationPanel.loc(this.lExpandTabsToSpaces, "Expand_Tabs");
        IndentationPanel.loc(this.lRightMargin, "Right_Margin");
        this.cbExpandTabsToSpaces.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_Expand_Tabs"));
        this.cbExpandTabsToSpaces.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_Expand_Tabs"));
        this.epPreview.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_Preview"));
        this.epPreview.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_Preview"));
        this.epPreview.setBorder(new EtchedBorder());
        this.cbExpandTabsToSpaces.addActionListener(this);
        this.sNumberOfSpacesPerIndent.setModel(new SpinnerNumberModel(4, 1, 50, 1));
        this.sNumberOfSpacesPerIndent.addChangeListener(this);
        this.sTabSize.setModel(new SpinnerNumberModel(4, 1, 50, 1));
        this.sTabSize.addChangeListener(this);
        this.sRightMargin.setModel(new SpinnerNumberModel(120, 1, 200, 10));
        this.sRightMargin.addChangeListener(this);
        this.epPreview.setEnabled(false);
    }

    private void initComponents() {
        this.lNumberOfSpacesPerIndent = new JLabel();
        this.sNumberOfSpacesPerIndent = new JSpinner();
        this.cbExpandTabsToSpaces = new JCheckBox();
        this.lPreview = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.epPreview = new JEditorPane();
        this.lTabSize = new JLabel();
        this.sTabSize = new JSpinner();
        this.lExpandTabsToSpaces = new JLabel();
        this.lRightMargin = new JLabel();
        this.sRightMargin = new JSpinner();
        this.lNumberOfSpacesPerIndent.setLabelFor(this.sNumberOfSpacesPerIndent);
        this.lNumberOfSpacesPerIndent.setText("Number of Spaces per Indent:");
        this.cbExpandTabsToSpaces.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbExpandTabsToSpaces.setMargin(new Insets(0, 0, 0, 0));
        this.lPreview.setText("Preview:");
        this.jScrollPane1.setViewportView(this.epPreview);
        this.lTabSize.setLabelFor(this.sTabSize);
        this.lTabSize.setText("Tab Size:");
        this.lExpandTabsToSpaces.setLabelFor(this.cbExpandTabsToSpaces);
        this.lExpandTabsToSpaces.setText("Expand Tabs To Spaces:");
        this.lRightMargin.setLabelFor(this.sRightMargin);
        this.lRightMargin.setText("Right Margin:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 763, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lPreview).addContainerGap()).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lNumberOfSpacesPerIndent, -1, 211, Short.MAX_VALUE).add((Component)this.lTabSize, -1, 211, Short.MAX_VALUE)).addPreferredGap(0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lRightMargin).add(140, 140, 140))).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.sRightMargin).add((Component)this.sTabSize).add((Component)this.sNumberOfSpacesPerIndent, -1, 42, Short.MAX_VALUE)).add(204, 204, 204)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbExpandTabsToSpaces).addPreferredGap(0).add((Component)this.lExpandTabsToSpaces))).add(294, 294, 294)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(14, 14, 14).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbExpandTabsToSpaces).add((Component)this.lExpandTabsToSpaces)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lNumberOfSpacesPerIndent).add((Component)this.sNumberOfSpacesPerIndent, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lTabSize).add((Component)this.sTabSize, -2, -1, -2)).add(6, 6, 6).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lRightMargin).add((Component)this.sRightMargin, -2, -1, -2)).addPreferredGap(1).add((Component)this.lPreview).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 165, Short.MAX_VALUE)));
    }

    private static String loc(String string) {
        return NbBundle.getMessage(IndentationPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)IndentationPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)IndentationPanel.loc("CTL_" + string));
        }
    }

    private void updatePreview() {
        this.model.setExpandTabs(this.cbExpandTabsToSpaces.isSelected());
        this.model.setSpacesPerTab((Integer)this.sNumberOfSpacesPerIndent.getValue());
        this.model.setTabSize((Integer)this.sTabSize.getValue());
        this.model.setRightMargin((Integer)this.sRightMargin.getValue());
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IndentationPanel.this.epPreview.setText(IndentationPanel.this.originalText);
                Document document = IndentationPanel.this.epPreview.getDocument();
                if (document instanceof BaseDocument) {
                    BaseDocument baseDocument = (BaseDocument)document;
                    Formatter formatter = baseDocument.getFormatter();
                    formatter.reformatLock();
                    baseDocument.atomicLock();
                    try {
                        formatter.reformat(baseDocument, 0, baseDocument.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    finally {
                        baseDocument.atomicUnlock();
                        formatter.reformatUnlock();
                    }
                }
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.listen) {
            return;
        }
        this.updatePreview();
        if (this.changed != this.model.isChanged()) {
            this.firePropertyChange("changed", (Object)this.changed, (Object)this.model.isChanged());
        }
        this.changed = this.model.isChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        this.updatePreview();
        if (this.changed != this.model.isChanged()) {
            this.firePropertyChange("changed", (Object)this.changed, (Object)this.model.isChanged());
        }
        this.changed = this.model.isChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        this.model = new IndentationModel();
        if (this.originalText == null) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/org/netbeans/modules/options/indentation/indentationExample");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        stringBuffer.append(string).append('\n');
                        string = bufferedReader.readLine();
                    }
                    this.originalText = new String(stringBuffer);
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.listen = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndentationPanel.this.epPreview.setContentType("text/xml");
                IndentationPanel.this.cbExpandTabsToSpaces.setSelected(IndentationPanel.this.model.isExpandTabs());
                IndentationPanel.this.sNumberOfSpacesPerIndent.setValue(IndentationPanel.this.model.getSpacesPerTab());
                IndentationPanel.this.sTabSize.setValue(IndentationPanel.this.model.getTabSize());
                IndentationPanel.this.sRightMargin.setValue(IndentationPanel.this.model.getRightMargin());
                IndentationPanel.this.listen = true;
                IndentationPanel.this.updatePreview();
            }
        });
    }

    public void applyChanges() {
        if (this.model != null) {
            this.model.applyChanges();
        }
    }

    public void cancel() {
        if (this.model != null) {
            this.model.revertChanges();
        }
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }
}

