/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.codetemplates;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.api.CodeTemplateSettingsFactory;
import org.netbeans.modules.editor.settings.storage.codetemplates.CodeTemplatesStorage;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeTemplateSettingsImpl
extends CodeTemplateSettingsFactory {
    public static final String PROP_CODE_TEMPLATES = "CodeTemplateSettingsImpl.PROP_CODE_TEMPLATES";
    public static final String PROP_EXPANSION_KEY = "CodeTemplateSettingsImpl.PROP_EXPANSION_KEY";
    private static final KeyStroke DEFAULT_EXPANSION_KEY = KeyStroke.getKeyStroke(9, 0);
    private static final Map<MimePath, WeakReference<CodeTemplateSettingsImpl>> INSTANCES = new WeakHashMap<MimePath, WeakReference<CodeTemplateSettingsImpl>>();
    private static final CodeTemplateDescriptionComparator CTC = new CodeTemplateDescriptionComparator();
    private final MimePath mimePath;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Map<String, CodeTemplateDescription> codeTamplatesMap = null;

    public static synchronized CodeTemplateSettingsImpl get(MimePath mimePath) {
        CodeTemplateSettingsImpl codeTemplateSettingsImpl;
        WeakReference<CodeTemplateSettingsImpl> weakReference = INSTANCES.get(mimePath);
        CodeTemplateSettingsImpl codeTemplateSettingsImpl2 = codeTemplateSettingsImpl = weakReference == null ? null : (CodeTemplateSettingsImpl)weakReference.get();
        if (codeTemplateSettingsImpl == null) {
            codeTemplateSettingsImpl = new CodeTemplateSettingsImpl(mimePath);
            INSTANCES.put(mimePath, new WeakReference<CodeTemplateSettingsImpl>(codeTemplateSettingsImpl));
        }
        return codeTemplateSettingsImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, CodeTemplateDescription> getCodeTemplates() {
        CodeTemplateSettingsImpl codeTemplateSettingsImpl = this;
        synchronized (codeTemplateSettingsImpl) {
            if (this.codeTamplatesMap == null) {
                this.codeTamplatesMap = CodeTemplatesStorage.load(this.mimePath, false);
            }
            return this.codeTamplatesMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCodeTemplates(Map<String, CodeTemplateDescription> map) {
        CodeTemplateSettingsImpl codeTemplateSettingsImpl = this;
        synchronized (codeTemplateSettingsImpl) {
            if (map == null) {
                CodeTemplatesStorage.delete(this.mimePath, false);
                map = null;
            } else {
                Map<String, CodeTemplateDescription> map2 = CodeTemplatesStorage.load(this.mimePath, true);
                ArrayList<String> arrayList = new ArrayList<String>();
                map = Collections.unmodifiableMap(new HashMap<String, CodeTemplateDescription>(map));
                arrayList.addAll(map2.keySet());
                arrayList.removeAll(map.keySet());
                CodeTemplatesStorage.save(this.mimePath, false, CodeTemplateSettingsImpl.diff(map2, map, CTC).values(), arrayList);
                this.codeTamplatesMap = map;
            }
        }
        this.pcs.firePropertyChange(PROP_CODE_TEMPLATES, null, null);
    }

    @Override
    public KeyStroke getExpandKey() {
        return CodeTemplateSettingsImpl.BaseOptions_getCodeTemplateExpandKey();
    }

    @Override
    public void setExpandKey(KeyStroke keyStroke) {
        CodeTemplateSettingsImpl.BaseOptions_setCodeTemplateExpandKey(keyStroke);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EditorSettingsImpl.getInstance().notifyExpansionKeyChange();
    }

    public Object createInstanceForLookup() {
        Map<String, CodeTemplateDescription> map = this.getCodeTemplates();
        return new Immutable(Collections.unmodifiableList(new ArrayList<CodeTemplateDescription>(map.values())), this.getExpandKey());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private CodeTemplateSettingsImpl(MimePath mimePath) {
        this.mimePath = mimePath;
    }

    private static KeyStroke BaseOptions_getCodeTemplateExpandKey() {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.editor.options.BaseOptions");
            Method method = clazz.getDeclaredMethod("getCodeTemplateExpandKey", new Class[0]);
            return (KeyStroke)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return DEFAULT_EXPANSION_KEY;
        }
    }

    private static void BaseOptions_setCodeTemplateExpandKey(KeyStroke keyStroke) {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.editor.options.BaseOptions");
            Method method = clazz.getDeclaredMethod("setCodeTemplateExpandKey", KeyStroke.class);
            method.invoke(null, keyStroke);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean compareTexts(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = null;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = null;
        }
        if (string != null && string2 != null) {
            return string.equals(string2);
        }
        return string == null && string2 == null;
    }

    private static <K, V> Map<K, V> diff(Map<K, V> map, Map<K, V> map2, Comparator<V> comparator) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (K k : map2.keySet()) {
            V v = map2.get(k);
            V v2 = map.get(k);
            if (v2 != null && 0 == comparator.compare(v2, v)) continue;
            hashMap.put(k, v);
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CodeTemplateDescriptionComparator
    implements Comparator<CodeTemplateDescription> {
        private CodeTemplateDescriptionComparator() {
        }

        @Override
        public int compare(CodeTemplateDescription codeTemplateDescription, CodeTemplateDescription codeTemplateDescription2) {
            if (codeTemplateDescription.getAbbreviation().equals(codeTemplateDescription2.getAbbreviation()) && CodeTemplateSettingsImpl.compareTexts(codeTemplateDescription.getDescription(), codeTemplateDescription2.getDescription()) && CodeTemplateSettingsImpl.compareTexts(codeTemplateDescription.getParametrizedText(), codeTemplateDescription2.getParametrizedText()) && Utilities.compareObjects((Object)codeTemplateDescription.getContexts(), (Object)codeTemplateDescription2.getContexts())) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Immutable
    extends CodeTemplateSettings {
        private final List<CodeTemplateDescription> codeTemplates;
        private final KeyStroke expansionKey;

        public Immutable(List<CodeTemplateDescription> list, KeyStroke keyStroke) {
            this.codeTemplates = list;
            this.expansionKey = keyStroke;
        }

        public List<CodeTemplateDescription> getCodeTemplateDescriptions() {
            return this.codeTemplates;
        }

        public KeyStroke getExpandKey() {
            return this.expansionKey;
        }
    }
}

