/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyMapsStorage {
    private static final Logger LOG = Logger.getLogger(KeyMapsStorage.class.getName());
    private static final String ROOT = "bindings";
    private static final String E_BIND = "bind";
    private static final String A_ACTION_NAME = "actionName";
    private static final String A_KEY = "key";
    private static final String A_REMOVE = "remove";
    private static final String V_TRUE = "true";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor KeyBindings settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorKeyBindings-1_1.dtd";

    private KeyMapsStorage() {
    }

    public static Map<Collection<KeyStroke>, MultiKeyBinding> loadKeyMaps(MimePath mimePath, String string, boolean bl) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors");
        HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
        SettingsType.KEYBINDINGS.getLocator().scan(fileObject, mimePath.getPath(), string, true, true, !bl, hashMap);
        assert (hashMap.size() <= 1) : "Too many results in the scan";
        List list = (List)hashMap.get(string);
        if (list == null) {
            return Collections.emptyMap();
        }
        HashMap hashMap2 = new HashMap();
        for (Object[] objectArray : list) {
            FileObject fileObject2 = (FileObject)objectArray[0];
            FileObject fileObject3 = (FileObject)objectArray[1];
            boolean bl2 = (Boolean)objectArray[2];
            Object[] objectArray2 = (Object[])XMLStorage.load(fileObject3, new KeyMapsReader());
            Map map = (Map)objectArray2[0];
            Collection collection = (Collection)objectArray2[1];
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Loading keybindings from: '" + fileObject3.getPath() + "'");
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("--- Removing keybindings: " + collection);
            }
            for (Collection collection2 : collection) {
                hashMap2.remove(collection2);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("--- Adding keybindings: " + map);
            }
            hashMap2.putAll(map);
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest("-------------------------------------");
        }
        return Collections.unmodifiableMap(hashMap2);
    }

    public static void deleteProfile(MimePath mimePath, String string, boolean bl) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors");
        HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
        SettingsType.KEYBINDINGS.getLocator().scan(fileObject, mimePath.getPath(), string, true, bl, !bl, hashMap);
        assert (hashMap.size() <= 1) : "Too many results in the scan";
        final List list = (List)hashMap.get(string);
        if (list != null) {
            try {
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() {
                        for (Object[] objectArray : list) {
                            FileObject fileObject = (FileObject)objectArray[1];
                            try {
                                fileObject.delete();
                            }
                            catch (IOException iOException) {
                                LOG.log(Level.WARNING, "Can't delete editor settings file " + fileObject.getPath(), iOException);
                            }
                        }
                    }
                });
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't delete editor keybindings for " + mimePath.getPath() + ", " + string, iOException);
            }
        }
    }

    public static void saveKeyMaps(MimePath mimePath, String string, boolean bl, final Collection<MultiKeyBinding> collection, final Set<Collection<KeyStroke>> set) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        final FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        final String string2 = SettingsType.KEYBINDINGS.getLocator().getWritableFileName(mimePath.getPath(), string, null, bl);
        try {
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject = fileSystem.findResource("Editors");
                    FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string2);
                    KeyMapsStorage.saveKeybindings(fileObject2, collection, set);
                }
            });
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't save editor keybindings for " + mimePath.getPath() + ", " + string, iOException);
        }
    }

    private static void saveKeybindings(FileObject fileObject, Collection<MultiKeyBinding> collection, Set<Collection<KeyStroke>> set) {
        Object object;
        Document document = XMLUtil.createDocument((String)ROOT, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
        Node node = document.getElementsByTagName(ROOT).item(0);
        for (MultiKeyBinding object2 : collection) {
            object = document.createElement(E_BIND);
            node.appendChild((Node)object);
            object.setAttribute(A_ACTION_NAME, object2.getActionName());
            object.setAttribute(A_KEY, Utils.keyStrokesToString(object2.getKeyStrokeList()));
        }
        for (Collection collection2 : set) {
            object = Utils.keyStrokesToString(collection2);
            Element element = document.createElement(E_BIND);
            node.appendChild(element);
            element.setAttribute(A_KEY, (String)object);
            element.setAttribute(A_REMOVE, V_TRUE);
        }
        XMLStorage.save(fileObject, document);
    }

    private static class KeyMapsReader
    extends XMLStorage.Handler {
        private Map<Collection<KeyStroke>, MultiKeyBinding> keyMap = new HashMap<Collection<KeyStroke>, MultiKeyBinding>();
        private Collection<Collection<KeyStroke>> removedShortcuts = new HashSet<Collection<KeyStroke>>();

        private KeyMapsReader() {
        }

        public Object getResult() {
            return new Object[]{this.keyMap, this.removedShortcuts};
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (!string3.equals(KeyMapsStorage.ROOT) && string3.equals(KeyMapsStorage.E_BIND)) {
                    int n;
                    String string4 = attributes.getValue(KeyMapsStorage.A_KEY);
                    if (this.isModuleFile() && this.isDefaultProfile() && string4 != null && string4.length() > 0 && (n = string4.indexOf(45)) != -1 && (string4.charAt(0) == 'A' || string4.charAt(0) == 'C')) {
                        LOG.warning("The keybinding '" + string4 + "' in " + this.getProcessedFile().getPath() + " may not work correctly on Mac. " + "Keybindings starting with Alt or Ctrl should " + "be coded with latin capital letters 'O' " + "or 'D' respectively. For details see org.openide.util.Utilities.stringToKey().");
                    }
                    KeyStroke[] keyStrokeArray = Utils.stringToKeyStrokes(string4);
                    String string5 = attributes.getValue(KeyMapsStorage.A_REMOVE);
                    if (Boolean.valueOf(string5).booleanValue()) {
                        this.removedShortcuts.add(Arrays.asList(keyStrokeArray));
                    } else {
                        String string6 = attributes.getValue(KeyMapsStorage.A_ACTION_NAME);
                        if (string6 != null) {
                            MultiKeyBinding multiKeyBinding = new MultiKeyBinding(keyStrokeArray, string6);
                            this.keyMap.put(Arrays.asList(keyStrokeArray), multiKeyBinding);
                        } else {
                            LOG.warning("Ignoring keybinding '" + string4 + "' with no action name.");
                        }
                    }
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't parse keybindings file " + this.getProcessedFile().getPath(), exception);
            }
        }
    }
}

