/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Rowset
implements XmlaConstants {
    protected static final Logger LOGGER = Logger.getLogger(Rowset.class);
    protected final RowsetDefinition rowsetDefinition;
    protected final Map<String, List<String>> restrictions;
    protected final Map<String, String> properties;
    protected final XmlaRequest request;
    protected final XmlaHandler handler;
    private final RowsetDefinition.Column[] restrictedColumns;

    Rowset(RowsetDefinition definition, XmlaRequest request, XmlaHandler handler) {
        this.rowsetDefinition = definition;
        this.restrictions = request.getRestrictions();
        this.properties = request.getProperties();
        this.request = request;
        this.handler = handler;
        ArrayList<RowsetDefinition.Column> list = new ArrayList<RowsetDefinition.Column>();
        for (Map.Entry<String, List<String>> entry : this.restrictions.entrySet()) {
            String restrictedColumn = entry.getKey();
            LOGGER.debug((Object)("Rowset<init>: restrictedColumn=\"" + restrictedColumn + "\""));
            RowsetDefinition.Column column = definition.lookupColumn(restrictedColumn);
            if (column == null) {
                throw Util.newError("Rowset '" + definition.name() + "' does not contain column '" + restrictedColumn + "'");
            }
            if (!column.restriction) {
                throw Util.newError("Rowset '" + definition.name() + "' column '" + restrictedColumn + "' does not allow restrictions");
            }
            List<String> requiredValue = entry.getValue();
            if (requiredValue.size() > 1) {
                RowsetDefinition.Type type = column.type;
                switch (type) {
                    case StringArray: 
                    case EnumerationArray: 
                    case StringSometimesArray: {
                        break;
                    }
                    default: {
                        throw Util.newError("Rowset '" + definition.name() + "' column '" + restrictedColumn + "' can only be restricted on one value at a time");
                    }
                }
            }
            list.add(column);
        }
        list = this.pruneRestrictions(list);
        this.restrictedColumns = list.toArray(new RowsetDefinition.Column[list.size()]);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String propertyName = entry.getKey();
            PropertyDefinition propertyDef = Util.lookup(PropertyDefinition.class, propertyName);
            if (propertyDef == null) {
                throw Util.newError("Rowset '" + definition.name() + "' does not support property '" + propertyName + "'");
            }
            String propertyValue = (String)entry.getValue();
            this.setProperty(propertyDef, propertyValue);
        }
    }

    protected ArrayList<RowsetDefinition.Column> pruneRestrictions(ArrayList<RowsetDefinition.Column> list) {
        return list;
    }

    protected void setProperty(PropertyDefinition propertyDef, String value) {
        switch (propertyDef) {
            case Format: {
                break;
            }
            case DataSourceInfo: {
                break;
            }
            case Catalog: {
                break;
            }
            case LocaleIdentifier: {
                if (value != null && value.equals("1033")) {
                    return;
                }
            }
            default: {
                LOGGER.warn((Object)("Warning: Rowset '" + this.rowsetDefinition.name() + "' does not support property '" + propertyDef.name() + "' (value is '" + value + "')"));
            }
        }
    }

    public final void unparse(XmlaResponse response) throws XmlaException {
        ArrayList<Row> rows = new ArrayList<Row>();
        this.populate(response, rows);
        Comparator<Row> comparator = this.rowsetDefinition.getComparator();
        if (comparator != null) {
            Collections.sort(rows, comparator);
        }
        for (Row row : rows) {
            this.emit(row, response);
        }
    }

    public abstract void populate(XmlaResponse var1, List<Row> var2) throws XmlaException;

    protected final boolean addRow(Row row, List<Row> rows) throws XmlaException {
        return rows.add(row);
    }

    protected void emit(Row row, XmlaResponse response) throws XmlaException {
        SaxWriter writer = response.getWriter();
        writer.startElement("row");
        for (RowsetDefinition.Column column : this.rowsetDefinition.columnDefinitions) {
            Object values;
            Object value = row.get(column.name);
            if (value == null) {
                if (column.nullable) continue;
                throw new XmlaException("Client", "00HSBB16", "XMLA SOAP non-nullable column", Util.newInternal("Value required for column " + column.name + " of rowset " + this.rowsetDefinition.name()));
            }
            if (value instanceof XmlElement[]) {
                XmlElement[] elements = (XmlElement[])value;
                for (XmlElement element : elements) {
                    this.emitXmlElement(writer, element);
                }
                continue;
            }
            if (value instanceof Object[]) {
                values = (Object[])value;
                for (Object value1 : values) {
                    writer.startElement(column.name);
                    writer.characters(value1.toString());
                    writer.endElement();
                }
                continue;
            }
            if (value instanceof List) {
                values = (List)value;
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    Object value1 = i$.next();
                    if (value1 instanceof XmlElement) {
                        XmlElement xmlElement = (XmlElement)value1;
                        this.emitXmlElement(writer, xmlElement);
                        continue;
                    }
                    writer.startElement(column.name);
                    writer.characters(value1.toString());
                    writer.endElement();
                }
                continue;
            }
            writer.startElement(column.name);
            writer.characters(value.toString());
            writer.endElement();
        }
        writer.endElement();
    }

    private void emitXmlElement(SaxWriter writer, XmlElement element) {
        if (element.attributes == null) {
            writer.startElement(element.tag);
        } else {
            writer.startElement(element.tag, element.attributes);
        }
        if (element.text == null) {
            for (XmlElement aChildren : element.children) {
                this.emitXmlElement(writer, aChildren);
            }
        } else {
            writer.characters(element.text);
        }
        writer.endElement();
    }

    protected void emit(Object row, XmlaResponse response) throws XmlaException {
        SaxWriter writer = response.getWriter();
        writer.startElement("row");
        for (RowsetDefinition.Column column : this.rowsetDefinition.columnDefinitions) {
            Object value = column.get(row);
            if (value != null) {
                writer.startElement(column.name);
                writer.characters(value.toString());
                writer.endElement();
                continue;
            }
            writer.startElement(column.name);
            writer.endElement();
        }
        writer.endElement();
    }

    protected <E extends Enum<E>> void emit(Class<E> clazz, XmlaResponse response) throws XmlaException {
        Enum[] valuesSortedByName = (Enum[])((Enum[])clazz.getEnumConstants()).clone();
        Arrays.sort(valuesSortedByName, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Enum)o1).name().compareTo(((Enum)o2).name());
            }
        });
        for (Enum value : valuesSortedByName) {
            this.emit(value, response);
        }
    }

    RestrictionTest getRestrictionTest(RowsetDefinition.Column column) {
        final List<String> requiredValue = this.restrictions.get(column.name);
        if (requiredValue == null) {
            return new RestrictionTest(){

                public boolean passes(int ival) {
                    return true;
                }

                public boolean passes(Object value) {
                    return true;
                }
            };
        }
        return new RestrictionTest(){

            public boolean passes(Object value) {
                return requiredValue.contains(value);
            }
        };
    }

    private List<String> getRestrictionValue(RowsetDefinition.Column column) {
        return this.restrictions.get(column.name);
    }

    String getRestrictionValueAsString(RowsetDefinition.Column column) {
        List<String> rval = this.getRestrictionValue(column);
        return rval != null && rval.size() == 1 ? rval.get(0) : null;
    }

    int getRestrictionValueAsInt(RowsetDefinition.Column column) {
        List<String> rval = this.getRestrictionValue(column);
        if (rval != null && rval.size() == 1) {
            try {
                return Integer.parseInt(rval.get(0));
            }
            catch (NumberFormatException ex) {
                LOGGER.info((Object)("Rowset.getRestrictionValue: bad integer restriction \"" + rval + "\""));
                return -1;
            }
        }
        return -1;
    }

    protected boolean isRestricted(RowsetDefinition.Column column) {
        return this.restrictions.get(column.name) != null;
    }

    protected class XmlElement {
        private final String tag;
        private final String[] attributes;
        private final String text;
        private final XmlElement[] children;

        XmlElement(String tag, String[] attributes) {
            this(tag, attributes, null, null);
        }

        XmlElement(String tag, String[] attributes, String text) {
            this(tag, attributes, text, null);
        }

        XmlElement(String tag, String[] attributes, XmlElement[] children) {
            this(tag, attributes, null, children);
        }

        private XmlElement(String tag, String[] attributes, String text, XmlElement[] children) {
            this.tag = tag;
            this.attributes = attributes;
            this.text = text;
            this.children = children;
        }
    }

    protected class Row {
        private final ArrayList<String> names = new ArrayList();
        private final ArrayList<Object> values = new ArrayList();

        Row() {
        }

        void set(String name, Object value) {
            this.names.add(name);
            this.values.add(value);
        }

        void set(String name, boolean value) {
            this.set(name, value ? "true" : "false");
        }

        public Object get(String name) {
            int i = this.names.indexOf(name);
            return i < 0 ? null : this.values.get(i);
        }
    }

    static abstract class RestrictionTest {
        RestrictionTest() {
        }

        public abstract boolean passes(Object var1);
    }
}

