/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mondrian.olap.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Format {
    private String formatString;
    private BasicFormat format;
    private FormatLocale locale;
    private static final FieldPosition dummyFieldPos = Format.createDummyFieldPos();
    public static final int CacheLimit = 1000;
    private static Map<String, Format> cache = new LinkedHashMap<String, Format>(){

        @Override
        public boolean removeEldestEntry(Map.Entry<String, Format> entry) {
            return this.size() > 1000;
        }
    };
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char thousandSeparator_en = ',';
    static final char decimalPlaceholder_en = '.';
    static final String dateSeparator_en = "/";
    static final String timeSeparator_en = ":";
    static final String currencySymbol_en = "$";
    static final String currencyFormat_en = "$#,##0.00";
    static final String[] daysOfWeekShort_en = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] daysOfWeekLong_en = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    static final String[] monthsShort_en = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};
    static final String[] monthsLong_en = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""};
    static final char intlCurrencySymbol = '\u08a4';
    private static final Map<String, FormatLocale> mapLocaleToFormatLocale = new HashMap<String, FormatLocale>();
    static final FormatLocale locale_US = Format.createLocale('\u0000', '\u0000', null, null, null, null, null, null, null, null, Locale.US);
    private static final int CASE_ASIS = 0;
    private static final int CASE_UPPER = 1;
    private static final int CASE_LOWER = 2;
    private static final int GENERAL = 0;
    private static final int DATE = 3;
    private static final int NUMERIC = 4;
    private static final int STRING = 5;
    private static final int SPECIAL = 8;
    private static final int FORMAT_NULL = 0;
    private static final int FORMAT_C = 3;
    private static final int FORMAT_D = 4;
    private static final int FORMAT_DD = 5;
    private static final int FORMAT_DDD = 6;
    private static final int FORMAT_DDDD = 7;
    private static final int FORMAT_DDDDD = 8;
    private static final int FORMAT_DDDDDD = 9;
    private static final int FORMAT_W = 10;
    private static final int FORMAT_WW = 11;
    private static final int FORMAT_M = 12;
    private static final int FORMAT_MM = 13;
    private static final int FORMAT_MMM_UPPER = 14;
    private static final int FORMAT_MMMM_UPPER = 15;
    private static final int FORMAT_Q = 16;
    private static final int FORMAT_Y = 17;
    private static final int FORMAT_YY = 18;
    private static final int FORMAT_YYYY = 19;
    private static final int FORMAT_H = 20;
    private static final int FORMAT_HH = 21;
    private static final int FORMAT_N = 22;
    private static final int FORMAT_NN = 23;
    private static final int FORMAT_S = 24;
    private static final int FORMAT_SS = 25;
    private static final int FORMAT_TTTTT = 26;
    private static final int FORMAT_UPPER_AM_SOLIDUS_PM = 27;
    private static final int FORMAT_LOWER_AM_SOLIDUS_PM = 28;
    private static final int FORMAT_UPPER_A_SOLIDUS_P = 29;
    private static final int FORMAT_LOWER_A_SOLIDUS_P = 30;
    private static final int FORMAT_AMPM = 31;
    private static final int FORMAT_0 = 32;
    private static final int FORMAT_POUND = 33;
    private static final int FORMAT_DECIMAL = 34;
    private static final int FORMAT_PERCENT = 35;
    private static final int FORMAT_THOUSEP = 36;
    private static final int FORMAT_TIMESEP = 37;
    private static final int FORMAT_DATESEP = 38;
    private static final int FORMAT_E_MINUS_UPPER = 39;
    private static final int FORMAT_E_PLUS_UPPER = 40;
    private static final int FORMAT_E_MINUS_LOWER = 41;
    private static final int FORMAT_E_PLUS_LOWER = 42;
    private static final int FORMAT_LITERAL = 43;
    private static final int FORMAT_BACKSLASH = 44;
    private static final int FORMAT_QUOTE = 45;
    private static final int FORMAT_CHARACTER_OR_SPACE = 46;
    private static final int FORMAT_CHARACTER_OR_NOTHING = 47;
    private static final int FORMAT_LOWER = 48;
    private static final int FORMAT_UPPER = 49;
    private static final int FORMAT_FILL_FROM_LEFT = 50;
    private static final int FORMAT_SEMI = 51;
    private static final int FORMAT_GENERAL_NUMBER = 52;
    private static final int FORMAT_GENERAL_DATE = 53;
    private static final int FORMAT_INTL_CURRENCY = 54;
    private static final int FORMAT_MMM_LOWER = 55;
    private static final int FORMAT_MMMM_LOWER = 56;
    private static final int FORMAT_USD = 57;
    static final Token[] tokens = new Token[]{Format.nfe(0, 4, null, "No formatting", "Display the number with no formatting."), Format.nfe(3, 3, "C", null, "Display the date as ddddd and display the time as t t t t t, in that order. Display only date information if there is no fractional part to the date serial number; display only time information if there is no integer portion."), Format.nfe(4, 3, "d", null, "Display the day as a number without a leading zero (1 - 31)."), Format.nfe(5, 3, "dd", null, "Display the day as a number with a leading zero (01 - 31)."), Format.nfe(6, 3, "Ddd", null, "Display the day as an abbreviation (Sun - Sat)."), Format.nfe(7, 3, "dddd", null, "Display the day as a full name (Sunday - Saturday)."), Format.nfe(8, 3, "ddddd", null, "Display the date as a complete date (including day, month, and year), formatted according to your system's short date format setting. The default short date format is m/d/yy."), Format.nfe(9, 3, "dddddd", null, "Display a date serial number as a complete date (including day, month, and year) formatted according to the long date setting recognized by your system. The default long date format is mmmm dd, yyyy."), Format.nfe(10, 3, "w", null, "Display the day of the week as a number (1 for Sunday through 7 for Saturday)."), Format.nfe(11, 3, "ww", null, "Display the week of the year as a number (1 - 53)."), Format.nfe(12, 11, "m", null, "Display the month as a number without a leading zero (1 - 12). If m immediately follows h or hh, the minute rather than the month is displayed."), Format.nfe(13, 11, "mm", null, "Display the month as a number with a leading zero (01 - 12). If m immediately follows h or hh, the minute rather than the month is displayed."), Format.nfe(55, 3, "mmm", null, "Display the month as an abbreviation (Jan - Dec)."), Format.nfe(56, 3, "mmmm", null, "Display the month as a full month name (January - December)."), Format.nfe(14, 3, "mmm", null, "Display the month as an abbreviation (Jan - Dec)."), Format.nfe(15, 3, "mmmm", null, "Display the month as a full month name (January - December)."), Format.nfe(16, 3, "q", null, "Display the quarter of the year as a number (1 - 4)."), Format.nfe(17, 3, "y", null, "Display the day of the year as a number (1 - 366)."), Format.nfe(18, 3, "yy", null, "Display the year as a 2-digit number (00 - 99)."), Format.nfe(19, 3, "yyyy", null, "Display the year as a 4-digit number (100 - 9999)."), Format.nfe(20, 3, "h", null, "Display the hour as a number without leading zeros (0 - 23)."), Format.nfe(21, 3, "hh", null, "Display the hour as a number with leading zeros (00 - 23)."), Format.nfe(22, 3, "n", null, "Display the minute as a number without leading zeros (0 - 59)."), Format.nfe(23, 3, "nn", null, "Display the minute as a number with leading zeros (00 - 59)."), Format.nfe(24, 3, "s", null, "Display the second as a number without leading zeros (0 - 59)."), Format.nfe(25, 3, "ss", null, "Display the second as a number with leading zeros (00 - 59)."), Format.nfe(26, 3, "ttttt", null, "Display a time as a complete time (including hour, minute, and second), formatted using the time separator defined by the time format recognized by your system. A leading zero is displayed if the leading zero option is selected and the time is before 10:00 A.M. or P.M. The default time format is h:mm:ss."), Format.nfe(27, 3, "AM/PM", null, "Use the 12-hour clock and display an uppercase AM with any hour before noon; display an uppercase PM with any hour between noon and 11:59 P.M."), Format.nfe(28, 3, "am/pm", null, "Use the 12-hour clock and display a lowercase AM with any hour before noon; display a lowercase PM with any hour between noon and 11:59 P.M."), Format.nfe(29, 3, "A/P", null, "Use the 12-hour clock and display an uppercase A with any hour before noon; display an uppercase P with any hour between noon and 11:59 P.M."), Format.nfe(30, 3, "a/p", null, "Use the 12-hour clock and display a lowercase A with any hour before noon; display a lowercase P with any hour between noon and 11:59 P.M."), Format.nfe(31, 3, "AMPM", null, "Use the 12-hour clock and display the AM string literal as defined by your system with any hour before noon; display the PM string literal as defined by your system with any hour between noon and 11:59 P.M. AMPM can be either uppercase or lowercase, but the case of the string displayed matches the string as defined by your system settings. The default format is AM/PM."), Format.nfe(32, 12, "0", "Digit placeholder", "Display a digit or a zero. If the expression has a digit in the position where the 0 appears in the format string, display it; otherwise, display a zero in that position. If the number has fewer digits than there are zeros (on either side of the decimal) in the format expression, display leading or trailing zeros. If the number has more digits to the right of the decimal separator than there are zeros to the right of the decimal separator in the format expression, round the number to as many decimal places as there are zeros. If the number has more digits to the left of the decimal separator than there are zeros to the left of the decimal separator in the format expression, display the extra digits without modification."), Format.nfe(33, 12, "#", "Digit placeholder", "Display a digit or nothing. If the expression has a digit in the position where the # appears in the format string, display it; otherwise, display nothing in that position.  This symbol works like the 0 digit placeholder, except that leading and trailing zeros aren't displayed if the number has the same or fewer digits than there are # characters on either side of the decimal separator in the format expression."), Format.nfe(34, 12, ".", "Decimal placeholder", "In some locales, a comma is used as the decimal separator. The decimal placeholder determines how many digits are displayed to the left and right of the decimal separator. If the format expression contains only number signs to the left of this symbol, numbers smaller than 1 begin with a decimal separator. If you always want a leading zero displayed with fractional numbers, use 0 as the first digit placeholder to the left of the decimal separator instead. The actual character used as a decimal placeholder in the formatted output depends on the Number Format recognized by your system."), Format.nfe(35, 4, "%", "Percent placeholder", "The expression is multiplied by 100. The percent character (%) is inserted in the position where it appears in the format string."), Format.nfe(36, 12, ",", "Thousand separator", "In some locales, a period is used as a thousand separator. The thousand separator separates thousands from hundreds within a number that has four or more places to the left of the decimal separator. Standard use of the thousand separator is specified if the format contains a thousand separator surrounded by digit placeholders (0 or #). Two adjacent thousand separators or a thousand separator immediately to the left of the decimal separator (whether or not a decimal is specified) means \"scale the number by dividing it by 1000, rounding as needed.\"  You can scale large numbers using this technique. For example, you can use the format string \"##0,,\" to represent 100 million as 100. Numbers smaller than 1 million are displayed as 0. Two adjacent thousand separators in any position other than immediately to the left of the decimal separator are treated simply as specifying the use of a thousand separator. The actual character used as the thousand separator in the formatted output depends on the Number Format recognized by your system."), Format.nfe(37, 11, ":", "Time separator", "In some locales, other characters may be used to represent the time separator. The time separator separates hours, minutes, and seconds when time values are formatted. The actual character used as the time separator in formatted output is determined by your system settings."), Format.nfe(38, 11, "/", "Date separator", "In some locales, other characters may be used to represent the date separator. The date separator separates the day, month, and year when date values are formatted. The actual character used as the date separator in formatted output is determined by your system settings."), Format.nfe(39, 12, "E-", "Scientific format", "If the format expression contains at least one digit placeholder (0 or #) to the right of E-, E+, e-, or e+, the number is displayed in scientific format and E or e is inserted between the number and its exponent. The number of digit placeholders to the right determines the number of digits in the exponent. Use E- or e- to place a minus sign next to negative exponents. Use E+ or e+ to place a minus sign next to negative exponents and a plus sign next to positive exponents."), Format.nfe(40, 12, "E+", "Scientific format", "See E-."), Format.nfe(41, 12, "e-", "Scientific format", "See E-."), Format.nfe(42, 12, "e+", "Scientific format", "See E-."), Format.nfe(43, 0, "-", "Display a literal character", "To display a character other than one of those listed, precede it with a backslash (\\) or enclose it in double quotation marks (\" \")."), Format.nfe(43, 0, "+", "Display a literal character", "See -."), Format.nfe(43, 0, "$", "Display a literal character", "See -."), Format.nfe(43, 0, "(", "Display a literal character", "See -."), Format.nfe(43, 0, ")", "Display a literal character", "See -."), Format.nfe(43, 0, " ", "Display a literal character", "See -."), Format.nfe(44, 8, "\\", "Display the next character in the format string", "Many characters in the format expression have a special meaning and can't be displayed as literal characters unless they are preceded by a backslash. The backslash itself isn't displayed. Using a backslash is the same as enclosing the next character in double quotation marks. To display a backslash, use two backslashes (\\).  Examples of characters that can't be displayed as literal characters are the date- and time-formatting characters (a, c, d, h, m, n, p, q, s, t, w, y, and /:), the numeric-formatting characters (#, 0, %, E, e, comma, and period), and the string-formatting characters (@, &, <, >, and !)."), Format.nfe(45, 8, "\"", "Display the string inside the double quotation marks", "To include a string in format from within code, you must use Chr(34) to enclose the text (34 is the character code for a double quotation mark)."), Format.nfe(46, 5, "@", "Character placeholder", "Display a character or a space. If the string has a character in the position where the @ appears in the format string, display it; otherwise, display a space in that position. Placeholders are filled from right to left unless there is an ! character in the format string. See below."), Format.nfe(47, 5, "&", "Character placeholder", "Display a character or nothing. If the string has a character in the position where the & appears, display it; otherwise, display nothing. Placeholders are filled from right to left unless there is an ! character in the format string. See below."), Format.nfe(48, 13, "<", "Force lowercase", "Display all characters in lowercase format."), Format.nfe(49, 13, ">", "Force uppercase", "Display all characters in uppercase format."), Format.nfe(50, 13, "!", "Force left to right fill of placeholders", "The default is to fill from right to left."), Format.nfe(51, 8, ";", "Separates format strings for different kinds of values", "If there is one section, the format expression applies to all values. If there are two sections, the first section applies to positive values and zeros, the second to negative values. If there are three sections, the first section applies to positive values, the second to negative values, and the third to zeros. If there are four sections, the first section applies to positive values, the second to negative values, the third to zeros, and the fourth to Null values."), Format.nfe(54, 12, "\u08a4", null, "Display the locale's currency symbol."), Format.nfe(57, 0, "USD", null, "Display USD (U.S. Dollars)."), Format.nfe(52, 12, "General Number", null, "Shows numbers as entered."), Format.nfe(53, 11, "General Date", null, "Shows date and time if expression contains both. If expression is only a date or a time, the missing information is not displayed.")};
    private static final MacroToken[] macroTokens = new MacroToken[]{new MacroToken("Currency", null, "Shows currency values according to the locale's CurrencyFormat.  Negative numbers are inside parentheses."), new MacroToken("Fixed", "0", "Shows at least one digit."), new MacroToken("Standard", "#,##0", "Uses a thousands separator."), new MacroToken("Percent", "0.00%", "Multiplies the value by 100 with a percent sign at the end."), new MacroToken("Scientific", "0.00e+00", "Uses standard scientific notation."), new MacroToken("Long Date", "dddd, mmmm dd, yyyy", "Uses the Long Date format specified in the Regional Settings dialog box of the Microsoft Windows Control Panel."), new MacroToken("Medium Date", "dd-mmm-yy", "Uses the dd-mmm-yy format (for example, 03-Apr-93)"), new MacroToken("Short Date", "m/d/yy", "Uses the Short Date format specified in the Regional Settings dialog box of the Windows Control Panel."), new MacroToken("Long Time", "h:mm:ss AM/PM", "Shows the hour, minute, second, and \"AM\" or \"PM\" using the h:mm:ss format."), new MacroToken("Medium Time", "h:mm AM/PM", "Shows the hour, minute, and \"AM\" or \"PM\" using the \"hh:mm AM/PM\" format."), new MacroToken("Short Time", "hh:mm", "Shows the hour and minute using the hh:mm format."), new MacroToken("Yes/No", "\\Y\\e\\s;\\Y\\e\\s;\\N\\o;\\N\\o", "Any nonzero numeric value (usually - 1) is Yes. Zero is No."), new MacroToken("True/False", "\\T\\r\\u\\e;\\T\\r\\u\\e;\\F\\a\\l\\s\\e;\\F\\a\\l\\s\\e", "Any nonzero numeric value (usually - 1) is True. Zero is False."), new MacroToken("On/Off", "\\O\\n;\\O\\n;\\O\\f\\f;\\O\\f\\f", "Any nonzero numeric value (usually - 1) is On. Zero is Off.")};
    static final int NOT_IN_A_NUMBER = 0;
    static final int LEFT_OF_POINT = 1;
    static final int RIGHT_OF_POINT = 2;
    static final int RIGHT_OF_EXP = 3;

    private static FieldPosition createDummyFieldPos() {
        final FieldPosition[] pos = new FieldPosition[]{null};
        new DecimalFormat(){

            public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
                pos[0] = fieldPosition;
                return result;
            }
        }.format(0.0);
        return pos[0];
    }

    static String format(Object o, String formatString, Locale locale) {
        Format format = new Format(formatString, locale);
        return format.format(o);
    }

    private static final Token nfe(int code, int flags, String token, String purpose, String description) {
        Util.discard((Object)purpose);
        Util.discard((Object)description);
        return new Token(code, flags, token);
    }

    public static final List<Token> getTokenList() {
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    public Format(String formatString, Locale locale) {
        this(formatString, Format.getBestFormatLocale(locale));
    }

    public Format(String formatString, FormatLocale locale) {
        if (formatString == null) {
            formatString = "";
        }
        this.formatString = formatString;
        if (locale == null) {
            locale = locale_US;
        }
        this.locale = locale;
        ArrayList<BasicFormat> alternateFormatList = new ArrayList<BasicFormat>();
        while (formatString.length() > 0) {
            formatString = this.parseFormatString(formatString, alternateFormatList);
        }
        if (alternateFormatList.size() == 0 || alternateFormatList.get(0) == null) {
            this.format = new JavaFormat(locale.locale);
        } else if (alternateFormatList.size() == 1) {
            this.format = (BasicFormat)alternateFormatList.get(0);
        } else {
            BasicFormat[] alternateFormats = alternateFormatList.toArray(new BasicFormat[alternateFormatList.size()]);
            this.format = new AlternateFormat(alternateFormats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Format get(String formatString, Locale locale) {
        String key = formatString + "@@@" + locale;
        Format format = cache.get(key);
        if (format == null) {
            Map<String, Format> map = cache;
            synchronized (map) {
                format = cache.get(key);
                if (format == null) {
                    format = new Format(formatString, locale);
                    cache.put(key, format);
                }
            }
        }
        return format;
    }

    public static FormatLocale createLocale(char thousandSeparator, char decimalPlaceholder, String dateSeparator, String timeSeparator, String currencySymbol, String currencyFormat, String[] daysOfWeekShort, String[] daysOfWeekLong, String[] monthsShort, String[] monthsLong, Locale locale) {
        FormatLocale formatLocale = new FormatLocale(thousandSeparator, decimalPlaceholder, dateSeparator, timeSeparator, currencySymbol, currencyFormat, daysOfWeekShort, daysOfWeekLong, monthsShort, monthsLong, locale);
        if (locale != null) {
            Format.registerFormatLocale(formatLocale, locale);
        }
        return formatLocale;
    }

    public static FormatLocale createLocale(Locale locale) {
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(locale);
        DateFormatSymbols dateSymbols = new DateFormatSymbols(locale);
        Calendar calendar = Calendar.getInstance(locale);
        calendar.set(1969, 11, 31, 0, 0, 0);
        Date date = calendar.getTime();
        java.text.DateFormat dateFormat = java.text.DateFormat.getDateInstance(3, locale);
        String dateValue = dateFormat.format(date);
        String dateSeparator = dateValue.substring(2, 3);
        java.text.DateFormat timeFormat = java.text.DateFormat.getTimeInstance(3, locale);
        String timeValue = timeFormat.format(date);
        String timeSeparator = timeValue.substring(2, 3);
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(locale);
        String currencyValue = currencyFormat.format(123456.78);
        String currencyLeft = currencyValue.substring(0, currencyValue.indexOf("1"));
        String currencyRight = currencyValue.substring(currencyValue.indexOf("8") + 1);
        StringBuilder buf = new StringBuilder();
        buf.append(currencyLeft);
        int minimumIntegerDigits = currencyFormat.getMinimumIntegerDigits();
        for (int i = Math.max(minimumIntegerDigits, 4) - 1; i >= 0; --i) {
            buf.append(i < minimumIntegerDigits ? (char)'0' : '#');
            if (i % 3 != 0 || i <= 0) continue;
            buf.append(',');
        }
        if (currencyFormat.getMaximumFractionDigits() > 0) {
            buf.append('.');
            Format.appendTimes(buf, '0', currencyFormat.getMinimumFractionDigits());
            Format.appendTimes(buf, '#', currencyFormat.getMaximumFractionDigits() - currencyFormat.getMinimumFractionDigits());
        }
        buf.append(currencyRight);
        String currencyFormatString = buf.toString();
        return Format.createLocale(decimalSymbols.getGroupingSeparator(), decimalSymbols.getDecimalSeparator(), dateSeparator, timeSeparator, decimalSymbols.getCurrencySymbol(), currencyFormatString, dateSymbols.getShortWeekdays(), dateSymbols.getWeekdays(), dateSymbols.getShortMonths(), dateSymbols.getMonths(), locale);
    }

    private static void appendTimes(StringBuilder buf, char c, int i) {
        while (i-- > 0) {
            buf.append(c);
        }
    }

    public static FormatLocale getFormatLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.US;
        }
        String key = locale.toString();
        return mapLocaleToFormatLocale.get(key);
    }

    public static synchronized FormatLocale getBestFormatLocale(Locale locale) {
        if (locale == null) {
            return locale_US;
        }
        String key = locale.toString();
        FormatLocale formatLocale = mapLocaleToFormatLocale.get(key);
        if (formatLocale == null) {
            formatLocale = Format.getFormatLocaleUsingFactory(locale);
            if (formatLocale == null) {
                formatLocale = locale_US;
            }
            mapLocaleToFormatLocale.put(key, formatLocale);
        }
        return formatLocale;
    }

    private static FormatLocale getFormatLocaleUsingFactory(Locale locale) {
        FormatLocale formatLocale;
        if (!locale.getVariant().equals("")) {
            formatLocale = Format.createLocale(locale);
            if (formatLocale != null) {
                return formatLocale;
            }
            locale = new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (!locale.getCountry().equals("")) {
            formatLocale = Format.createLocale(locale);
            if (formatLocale != null) {
                return formatLocale;
            }
            locale = new Locale(locale.getLanguage());
        }
        if ((formatLocale = Format.createLocale(locale)) != null) {
            return formatLocale;
        }
        return null;
    }

    public static FormatLocale registerFormatLocale(FormatLocale formatLocale, Locale locale) {
        String key = locale.toString();
        FormatLocale previous = mapLocaleToFormatLocale.put(key, formatLocale);
        return previous;
    }

    private String parseFormatString(String formatString, List<BasicFormat> alternateFormatList) {
        int i;
        int numberState = 0;
        StringBuilder ignored = new StringBuilder();
        String prevIgnored = null;
        boolean haveSeenNumber = false;
        int digitsLeftOfPoint = 0;
        int digitsRightOfPoint = 0;
        int digitsRightOfExp = 0;
        int zeroesLeftOfPoint = 0;
        int zeroesRightOfPoint = 0;
        int zeroesRightOfExp = 0;
        int stringCase = 0;
        boolean useDecimal = false;
        boolean useThouSep = false;
        boolean fillFromRight = true;
        int expFormat = 0;
        for (int i2 = 0; i2 < macroTokens.length; ++i2) {
            if (!formatString.equals(Format.macroTokens[i2].name)) continue;
            if (Format.macroTokens[i2].translation == null) {
                if (Format.macroTokens[i2].name.equals("Currency")) {
                    formatString = this.locale.currencyFormat + ";(" + this.locale.currencyFormat + ")";
                    break;
                }
                throw new Error("Format: internal: token " + Format.macroTokens[i2].name + " should have translation");
            }
            formatString = Format.macroTokens[i2].translation;
            break;
        }
        if (!formatString.endsWith(";")) {
            formatString = formatString + ";";
        }
        ArrayList<BasicFormat> formatList = new ArrayList<BasicFormat>();
        block37: while (formatString.length() > 0) {
            BasicFormat format = null;
            String newFormatString = null;
            boolean ignoreToken = false;
            for (i = tokens.length - 1; i > 0; --i) {
                Token token = tokens[i];
                if (!formatString.startsWith(token.token)) continue;
                String matched = token.token;
                newFormatString = formatString.substring(matched.length());
                if (token.isSpecial()) {
                    block0 : switch (token.code) {
                        case 51: {
                            formatString = newFormatString;
                            break block37;
                        }
                        case 33: {
                            switch (numberState) {
                                case 0: {
                                    numberState = 1;
                                }
                                case 1: {
                                    ++digitsLeftOfPoint;
                                    break block0;
                                }
                                case 2: {
                                    ++digitsRightOfPoint;
                                    break block0;
                                }
                                case 3: {
                                    ++digitsRightOfExp;
                                    break block0;
                                }
                            }
                            throw new Error();
                        }
                        case 32: {
                            switch (numberState) {
                                case 0: {
                                    numberState = 1;
                                }
                                case 1: {
                                    ++zeroesLeftOfPoint;
                                    break block0;
                                }
                                case 2: {
                                    ++zeroesRightOfPoint;
                                    break block0;
                                }
                                case 3: {
                                    ++zeroesRightOfExp;
                                    break block0;
                                }
                            }
                            throw new Error();
                        }
                        case 12: 
                        case 13: {
                            int j;
                            boolean theyMeantMinute = false;
                            for (j = formatList.size() - 1; j >= 0; --j) {
                                BasicFormat prevFormat = (BasicFormat)formatList.get(j);
                                if (prevFormat instanceof LiteralFormat) {
                                    continue;
                                }
                                if (prevFormat.code == 20 || prevFormat.code == 21) {
                                    theyMeantMinute = true;
                                    break;
                                }
                                theyMeantMinute = false;
                                break;
                            }
                            if (theyMeantMinute) {
                                format = new DateFormat(token.code == 12 ? 22 : 23, matched, this.locale, false);
                                break;
                            }
                            format = token.makeFormat(this.locale);
                            break;
                        }
                        case 34: {
                            numberState = 2;
                            useDecimal = true;
                            break;
                        }
                        case 36: {
                            if (numberState == 1) {
                                useThouSep = true;
                                break;
                            }
                            format = token.makeFormat(this.locale);
                            break;
                        }
                        case 37: {
                            format = new LiteralFormat(this.locale.timeSeparator);
                            break;
                        }
                        case 38: {
                            format = new LiteralFormat(this.locale.dateSeparator);
                            break;
                        }
                        case 44: {
                            String s = "";
                            if (formatString.length() == 1) {
                                s = "";
                                newFormatString = "";
                            } else {
                                s = formatString.substring(1, 2);
                                newFormatString = formatString.substring(2);
                            }
                            format = new LiteralFormat(s);
                            break;
                        }
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: {
                            numberState = 3;
                            expFormat = token.code;
                            if (zeroesLeftOfPoint != 0 || zeroesRightOfPoint != 0) break;
                            zeroesLeftOfPoint = 1;
                            break;
                        }
                        case 45: {
                            String s;
                            int j = formatString.indexOf("\"", 1);
                            if (j == -1) {
                                s = formatString.substring(1);
                                newFormatString = "";
                            } else {
                                s = formatString.substring(1, j);
                                newFormatString = formatString.substring(j + 1);
                            }
                            format = new LiteralFormat(s);
                            break;
                        }
                        case 49: {
                            stringCase = 1;
                            break;
                        }
                        case 48: {
                            stringCase = 2;
                            break;
                        }
                        case 50: {
                            fillFromRight = false;
                            break;
                        }
                        case 52: {
                            format = new JavaFormat(this.locale.locale);
                            break;
                        }
                        case 53: {
                            format = new JavaFormat(this.locale.locale);
                            break;
                        }
                        case 54: {
                            format = new LiteralFormat(this.locale.currencySymbol);
                            break;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                    if (format == null) {
                        ignoreToken = true;
                        ignored.append(matched);
                        break;
                    }
                    prevIgnored = ignored.toString();
                    ignored.setLength(0);
                    break;
                }
                format = token.makeFormat(this.locale);
                break;
            }
            if (format == null && !ignoreToken) {
                format = new LiteralFormat(formatString.substring(0, 1));
                newFormatString = formatString.substring(1);
            }
            if (format != null) {
                if (numberState != 0) {
                    NumericFormat numericFormat = new NumericFormat(prevIgnored, this.locale, expFormat, digitsLeftOfPoint, zeroesLeftOfPoint, digitsRightOfPoint, zeroesRightOfPoint, digitsRightOfExp, zeroesRightOfExp, useDecimal, useThouSep);
                    formatList.add(numericFormat);
                    numberState = 0;
                    haveSeenNumber = true;
                }
                formatList.add(format);
            }
            formatString = newFormatString;
        }
        if (numberState != 0) {
            NumericFormat numericFormat = new NumericFormat(prevIgnored, this.locale, expFormat, digitsLeftOfPoint, zeroesLeftOfPoint, digitsRightOfPoint, zeroesRightOfPoint, digitsRightOfExp, zeroesRightOfExp, useDecimal, useThouSep);
            formatList.add(numericFormat);
            numberState = 0;
            haveSeenNumber = true;
        }
        BasicFormat[] formats = formatList.toArray(new BasicFormat[formatList.size()]);
        boolean twelveHourClock = false;
        int decimalShift = 0;
        block40: for (i = 0; i < formats.length; ++i) {
            switch (formats[i].code) {
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    twelveHourClock = true;
                    continue block40;
                }
                case 35: {
                    decimalShift += 2;
                    continue block40;
                }
                case 36: {
                    if (!haveSeenNumber || i + 1 >= formats.length || formats[i + 1].code == 36 || formats[i + 1].code == 32 || formats[i + 1].code == 33) continue block40;
                    for (int j = i; j >= 0 && formats[j].code == 36; --j) {
                        decimalShift -= 3;
                        formats[j] = new LiteralFormat("");
                    }
                    continue block40;
                }
            }
        }
        if (twelveHourClock) {
            for (i = 0; i < formats.length; ++i) {
                if (!(formats[i] instanceof DateFormat)) continue;
                ((DateFormat)formats[i]).setTwelveHourClock(true);
            }
        }
        if (decimalShift != 0) {
            for (i = 0; i < formats.length; ++i) {
                if (!(formats[i] instanceof NumericFormat)) continue;
                ((NumericFormat)formats[i]).decimalShift = decimalShift;
            }
        }
        CompoundFormat alternateFormat = formats.length == 0 ? null : (formats.length == 1 ? formats[0] : new CompoundFormat(formats));
        alternateFormatList.add(alternateFormat);
        return formatString;
    }

    public String format(Object o) {
        StringBuilder buf = new StringBuilder();
        this.format(o, buf);
        return buf.toString();
    }

    private StringBuilder format(Object o, StringBuilder buf) {
        if (o == null) {
            this.format.formatNull(buf);
        } else {
            Class<?> clazz = o.getClass();
            if (clazz == Double.class) {
                this.format.format((Double)o, buf);
            } else if (clazz == Float.class) {
                this.format.format(((Float)o).floatValue(), buf);
            } else if (clazz == Integer.class) {
                this.format.format(((Integer)o).intValue(), buf);
            } else if (clazz == Long.class) {
                this.format.format((Long)o, buf);
            } else if (clazz == Short.class) {
                this.format.format(((Short)o).shortValue(), buf);
            } else if (clazz == Byte.class) {
                this.format.format(((Byte)o).byteValue(), buf);
            } else if (o instanceof BigDecimal) {
                this.format.format(((BigDecimal)o).doubleValue(), buf);
            } else if (o instanceof BigInteger) {
                this.format.format(((BigInteger)o).longValue(), buf);
            } else if (clazz == String.class) {
                this.format.format((String)o, buf);
            } else if (o instanceof Date) {
                this.format.format((Date)o, buf);
            } else {
                buf.append(o.toString());
            }
        }
        return buf;
    }

    public String getFormatString() {
        return this.formatString;
    }

    static class FDBigInt {
        int nWords;
        int[] data;
        private static boolean debugging = false;

        public static void setDebugging(boolean d) {
            debugging = d;
        }

        public FDBigInt(int v) {
            this.nWords = 1;
            this.data = new int[1];
            this.data[0] = v;
        }

        public FDBigInt(long v) {
            this.data = new int[2];
            this.data[0] = (int)v;
            this.data[1] = (int)(v >>> 32);
            this.nWords = this.data[1] == 0 ? 1 : 2;
        }

        public FDBigInt(FDBigInt other) {
            this.nWords = other.nWords;
            this.data = new int[this.nWords];
            System.arraycopy(other.data, 0, this.data, 0, this.nWords);
        }

        private FDBigInt(int[] d, int n) {
            this.data = d;
            this.nWords = n;
        }

        public void lshiftMe(int c) throws IllegalArgumentException {
            if (c <= 0) {
                if (c == 0) {
                    return;
                }
                throw new IllegalArgumentException("negative shift count");
            }
            int wordcount = c >> 5;
            int bitcount = c & 0x1F;
            int anticount = 32 - bitcount;
            int[] t = this.data;
            int[] s = this.data;
            if (this.nWords + wordcount + 1 > t.length) {
                t = new int[this.nWords + wordcount + 1];
            }
            int target = this.nWords + wordcount;
            int src = this.nWords - 1;
            if (bitcount == 0) {
                System.arraycopy(s, 0, t, wordcount, this.nWords);
                target = wordcount - 1;
            } else {
                t[target--] = s[src] >>> anticount;
                while (src >= 1) {
                    t[target--] = s[src] << bitcount | s[--src] >>> anticount;
                }
                t[target--] = s[src] << bitcount;
            }
            while (target >= 0) {
                t[target--] = 0;
            }
            this.data = t;
            this.nWords += wordcount + 1;
            while (this.nWords > 1 && this.data[this.nWords - 1] == 0) {
                --this.nWords;
            }
        }

        public int normalizeMe() throws IllegalArgumentException {
            int src;
            int wordcount = 0;
            int bitcount = 0;
            int v = 0;
            for (src = this.nWords - 1; src >= 0 && (v = this.data[src]) == 0; --src) {
                ++wordcount;
            }
            if (src < 0) {
                throw new IllegalArgumentException("zero value");
            }
            this.nWords -= wordcount;
            if ((v & 0xF0000000) != 0) {
                bitcount = 32;
                while ((v & 0xF0000000) != 0) {
                    v >>>= 1;
                    --bitcount;
                }
            } else {
                while (v <= 1048575) {
                    v <<= 8;
                    bitcount += 8;
                }
                while (v <= 0x7FFFFFF) {
                    v <<= 1;
                    ++bitcount;
                }
            }
            if (bitcount != 0) {
                this.lshiftMe(bitcount);
            }
            return bitcount;
        }

        public FDBigInt mult(int iv) {
            long v = iv;
            int[] r = new int[v * ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) > 0xFFFFFFFL ? this.nWords + 1 : this.nWords];
            long p = 0L;
            for (int i = 0; i < this.nWords; ++i) {
                r[i] = (int)(p += v * ((long)this.data[i] & 0xFFFFFFFFL));
                p >>>= 32;
            }
            if (p == 0L) {
                return new FDBigInt(r, this.nWords);
            }
            r[this.nWords] = (int)p;
            return new FDBigInt(r, this.nWords + 1);
        }

        public FDBigInt mult(FDBigInt other) {
            int i;
            int[] r = new int[this.nWords + other.nWords];
            for (i = 0; i < this.nWords; ++i) {
                long v = (long)this.data[i] & 0xFFFFFFFFL;
                long p = 0L;
                for (int j = 0; j < other.nWords; ++j) {
                    r[i + j] = (int)(p += ((long)r[i + j] & 0xFFFFFFFFL) + v * ((long)other.data[j] & 0xFFFFFFFFL));
                    p >>>= 32;
                }
                r[i + j] = (int)p;
            }
            for (i = r.length - 1; i > 0 && r[i] == 0; --i) {
            }
            return new FDBigInt(r, i + 1);
        }

        public FDBigInt add(FDBigInt other) {
            int i;
            int m;
            int[] b;
            int n;
            int[] a;
            long c = 0L;
            if (this.nWords >= other.nWords) {
                a = this.data;
                n = this.nWords;
                b = other.data;
                m = other.nWords;
            } else {
                a = other.data;
                n = other.nWords;
                b = this.data;
                m = this.nWords;
            }
            int[] r = new int[n];
            for (i = 0; i < n; ++i) {
                c += (long)a[i] & 0xFFFFFFFFL;
                if (i < m) {
                    c += (long)b[i] & 0xFFFFFFFFL;
                }
                r[i] = (int)c;
                c >>= 32;
            }
            if (c != 0L) {
                int[] s = new int[r.length + 1];
                System.arraycopy(r, 0, s, 0, r.length);
                s[i++] = (int)c;
                return new FDBigInt(s, i);
            }
            return new FDBigInt(r, i);
        }

        public FDBigInt sub(FDBigInt other) {
            int i;
            int[] r = new int[this.nWords];
            int n = this.nWords;
            int m = other.nWords;
            int nzeros = 0;
            long c = 0L;
            for (i = 0; i < n; ++i) {
                c += (long)this.data[i] & 0xFFFFFFFFL;
                if (i < m) {
                    c -= (long)other.data[i] & 0xFFFFFFFFL;
                }
                nzeros = (r[i] = (int)c) == 0 ? ++nzeros : 0;
                c >>= 32;
            }
            if (c != 0L) {
                throw new RuntimeException("Assertion botch: borrow out of subtract");
            }
            while (i < m) {
                if (other.data[i++] == 0) continue;
                throw new RuntimeException("Assertion botch: negative result of subtract");
            }
            return new FDBigInt(r, n - nzeros);
        }

        public int cmp(FDBigInt other) {
            int i;
            int j;
            if (this.nWords > other.nWords) {
                j = other.nWords - 1;
                for (i = this.nWords - 1; i > j; --i) {
                    if (this.data[i] == 0) continue;
                    return 1;
                }
            } else if (this.nWords < other.nWords) {
                j = this.nWords - 1;
                for (i = other.nWords - 1; i > j; --i) {
                    if (other.data[i] == 0) continue;
                    return -1;
                }
            } else {
                i = this.nWords - 1;
            }
            while (i > 0 && this.data[i] == other.data[i]) {
                --i;
            }
            int a = this.data[i];
            int b = other.data[i];
            if (a < 0) {
                if (b < 0) {
                    return a - b;
                }
                return 1;
            }
            if (b < 0) {
                return -1;
            }
            return a - b;
        }

        public int quoRemIteration(FDBigInt S) throws IllegalArgumentException {
            int i;
            if (this.nWords != S.nWords) {
                throw new IllegalArgumentException("disparate values");
            }
            int n = this.nWords - 1;
            long q = ((long)this.data[n] & 0xFFFFFFFFL) / (long)S.data[n];
            long diff = 0L;
            for (int i2 = 0; i2 <= n; ++i2) {
                this.data[i2] = (int)(diff += ((long)this.data[i2] & 0xFFFFFFFFL) - q * ((long)S.data[i2] & 0xFFFFFFFFL));
                diff >>= 32;
            }
            if (diff != 0L) {
                long sum = 0L;
                while (sum == 0L) {
                    sum = 0L;
                    for (i = 0; i <= n; ++i) {
                        this.data[i] = (int)(sum += ((long)this.data[i] & 0xFFFFFFFFL) + ((long)S.data[i] & 0xFFFFFFFFL));
                        sum >>= 32;
                    }
                    if (sum != 0L && sum != 1L) {
                        throw new RuntimeException("Assertion botch: " + sum + " carry out of division correction");
                    }
                    --q;
                }
            }
            long p = 0L;
            for (i = 0; i <= n; ++i) {
                this.data[i] = (int)(p += 10L * ((long)this.data[i] & 0xFFFFFFFFL));
                p >>= 32;
            }
            if (p != 0L) {
                throw new RuntimeException("Assertion botch: carry out of *10");
            }
            return (int)q;
        }

        public long longValue() {
            int i;
            for (i = this.nWords - 1; i > 1; --i) {
                if (this.data[i] == 0) continue;
                throw new RuntimeException("Assertion botch: value too big");
            }
            switch (i) {
                case 1: {
                    if (this.data[1] < 0) {
                        throw new RuntimeException("Assertion botch: value too big");
                    }
                    return (long)this.data[1] << 32 | (long)this.data[0] & 0xFFFFFFFFL;
                }
                case 0: {
                    return (long)this.data[0] & 0xFFFFFFFFL;
                }
            }
            throw new RuntimeException("Assertion botch: longValue confused");
        }

        public String toString() {
            StringBuilder r = new StringBuilder(30);
            r.append('[');
            int i = Math.min(this.nWords - 1, this.data.length - 1);
            if (this.nWords > this.data.length) {
                r.append("(" + this.data.length + "<" + this.nWords + "!)");
            }
            while (i > 0) {
                r.append(Integer.toHexString(this.data[i]));
                r.append(' ');
                --i;
            }
            r.append(Integer.toHexString(this.data[0]));
            r.append(']');
            return new String(r);
        }
    }

    static class FloatingDecimal {
        boolean isExceptional;
        boolean isNegative;
        int decExponent;
        char[] digits;
        int nDigits;
        static final long signMask = Long.MIN_VALUE;
        static final long expMask = 0x7FF0000000000000L;
        static final long fractMask = 0xFFFFFFFFFFFFFL;
        static final int expShift = 52;
        static final int expBias = 1023;
        static final long fractHOB = 0x10000000000000L;
        static final long expOne = 0x3FF0000000000000L;
        static final int maxSmallBinExp = 62;
        static final int minSmallBinExp = -21;
        static final long highbyte = -72057594037927936L;
        static final long highbit = Long.MIN_VALUE;
        static final long lowbytes = 0xFFFFFFFFFFFFFFL;
        static final int singleSignMask = Integer.MIN_VALUE;
        static final int singleExpMask = 2139095040;
        static final int singleFractMask = 0x7FFFFF;
        static final int singleExpShift = 23;
        static final int singleFractHOB = 0x800000;
        static final int singleExpBias = 127;
        private static FDBigInt[] b5p;
        private static final int[] small5pow;
        private static final long[] long5pow;
        private static final int[] n5bits;
        private static final char[] infinity;
        private static final char[] notANumber;
        private static final char[] zero;

        private static int countBits(long v) {
            if (v == 0L) {
                return 0;
            }
            while ((v & 0xFF00000000000000L) == 0L) {
                v <<= 8;
            }
            while (v > 0L) {
                v <<= 1;
            }
            int n = 0;
            while ((v & 0xFFFFFFFFFFFFFFL) != 0L) {
                v <<= 8;
                n += 8;
            }
            while (v != 0L) {
                v <<= 1;
                ++n;
            }
            return n;
        }

        private static FDBigInt big5pow(int p) {
            if (p < 0) {
                throw new RuntimeException("Assertion botch: negative power of 5");
            }
            if (b5p == null) {
                b5p = new FDBigInt[p + 1];
            } else if (b5p.length <= p) {
                FDBigInt[] t = new FDBigInt[p + 1];
                System.arraycopy(b5p, 0, t, 0, b5p.length);
                b5p = t;
            }
            if (b5p[p] != null) {
                return b5p[p];
            }
            if (p < small5pow.length) {
                FloatingDecimal.b5p[p] = new FDBigInt(small5pow[p]);
                return FloatingDecimal.b5p[p];
            }
            if (p < long5pow.length) {
                FloatingDecimal.b5p[p] = new FDBigInt(long5pow[p]);
                return FloatingDecimal.b5p[p];
            }
            int q = p >> 1;
            int r = p - q;
            FDBigInt bigq = b5p[q];
            if (bigq == null) {
                bigq = FloatingDecimal.big5pow(q);
            }
            if (r < small5pow.length) {
                FloatingDecimal.b5p[p] = bigq.mult(small5pow[r]);
                return FloatingDecimal.b5p[p];
            }
            FDBigInt bigr = b5p[r];
            if (bigr == null) {
                bigr = FloatingDecimal.big5pow(r);
            }
            FloatingDecimal.b5p[p] = bigq.mult(bigr);
            return FloatingDecimal.b5p[p];
        }

        private void developLongDigits(int decExponent, long lvalue, long insignificant) {
            char[] result;
            int digitno;
            char[] digits;
            int ndigits;
            int i = 0;
            while (insignificant >= 10L) {
                insignificant /= 10L;
                ++i;
            }
            if (i != 0) {
                long pow10 = long5pow[i] << i;
                long residue = lvalue % pow10;
                lvalue /= pow10;
                decExponent += i;
                if (residue >= pow10 >> 1) {
                    ++lvalue;
                }
            }
            if (lvalue <= Integer.MAX_VALUE) {
                if (lvalue <= 0L) {
                    throw new RuntimeException("Assertion botch: value " + lvalue + " <= 0");
                }
                int ivalue = (int)lvalue;
                ndigits = 10;
                digits = new char[10];
                digitno = ndigits - 1;
                int c = ivalue % 10;
                ivalue /= 10;
                while (c == 0) {
                    ++decExponent;
                    c = ivalue % 10;
                    ivalue /= 10;
                }
                while (ivalue != 0) {
                    digits[digitno--] = (char)(c + 48);
                    ++decExponent;
                    c = ivalue % 10;
                    ivalue /= 10;
                }
                digits[digitno] = (char)(c + 48);
            } else {
                ndigits = 20;
                digits = new char[20];
                digitno = ndigits - 1;
                int c = (int)(lvalue % 10L);
                lvalue /= 10L;
                while (c == 0) {
                    ++decExponent;
                    c = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                while (lvalue != 0L) {
                    digits[digitno--] = (char)(c + 48);
                    ++decExponent;
                    c = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                digits[digitno] = (char)(c + 48);
            }
            ndigits -= digitno;
            if (digitno == 0) {
                result = digits;
            } else {
                result = new char[ndigits];
                System.arraycopy(digits, digitno, result, 0, ndigits);
            }
            this.digits = result;
            this.decExponent = decExponent + 1;
            this.nDigits = ndigits;
        }

        private void roundup() {
            int i = this.nDigits - 1;
            char q = this.digits[i];
            if (q == '9') {
                while (q == '9' && i > 0) {
                    this.digits[i] = 48;
                    q = this.digits[--i];
                }
                if (q == '9') {
                    ++this.decExponent;
                    this.digits[0] = 49;
                    return;
                }
            }
            this.digits[i] = (char)(q + '\u0001');
        }

        public FloatingDecimal(double d) {
            int nSignificantBits;
            long dBits = Double.doubleToLongBits(d);
            if ((dBits & Long.MIN_VALUE) != 0L) {
                this.isNegative = true;
                dBits ^= Long.MIN_VALUE;
            } else {
                this.isNegative = false;
            }
            int binExp = (int)((dBits & 0x7FF0000000000000L) >> 52);
            long fractBits = dBits & 0xFFFFFFFFFFFFFL;
            if (binExp == 2047) {
                this.isExceptional = true;
                if (fractBits == 0L) {
                    this.digits = infinity;
                } else {
                    this.digits = notANumber;
                    this.isNegative = false;
                }
                this.nDigits = this.digits.length;
                return;
            }
            this.isExceptional = false;
            if (binExp == 0) {
                if (fractBits == 0L) {
                    this.decExponent = 0;
                    this.digits = zero;
                    this.nDigits = 1;
                    return;
                }
                while ((fractBits & 0x10000000000000L) == 0L) {
                    fractBits <<= 1;
                    --binExp;
                }
                nSignificantBits = 52 + binExp;
                ++binExp;
            } else {
                fractBits |= 0x10000000000000L;
                nSignificantBits = 53;
            }
            this.dtoa(binExp -= 1023, fractBits, nSignificantBits);
        }

        public FloatingDecimal(float f) {
            int nSignificantBits;
            int fBits = Float.floatToIntBits(f);
            if ((fBits & Integer.MIN_VALUE) != 0) {
                this.isNegative = true;
                fBits ^= Integer.MIN_VALUE;
            } else {
                this.isNegative = false;
            }
            int binExp = (fBits & 0x7F800000) >> 23;
            int fractBits = fBits & 0x7FFFFF;
            if (binExp == 255) {
                this.isExceptional = true;
                if ((long)fractBits == 0L) {
                    this.digits = infinity;
                } else {
                    this.digits = notANumber;
                    this.isNegative = false;
                }
                this.nDigits = this.digits.length;
                return;
            }
            this.isExceptional = false;
            if (binExp == 0) {
                if (fractBits == 0) {
                    this.decExponent = 0;
                    this.digits = zero;
                    this.nDigits = 1;
                    return;
                }
                while ((fractBits & 0x800000) == 0) {
                    fractBits <<= 1;
                    --binExp;
                }
                nSignificantBits = 23 + binExp;
                ++binExp;
            } else {
                fractBits |= 0x800000;
                nSignificantBits = 24;
            }
            this.dtoa(binExp -= 127, (long)fractBits << 29, nSignificantBits);
        }

        private void dtoa(int binExp, long fractBits, int nSignificantBits) {
            long lowDigitDifference;
            boolean high;
            boolean low;
            int nFractBits = FloatingDecimal.countBits(fractBits);
            int nTinyBits = Math.max(0, nFractBits - binExp - 1);
            if (binExp <= 62 && binExp >= -21 && nTinyBits < long5pow.length && nFractBits + n5bits[nTinyBits] < 64 && nTinyBits == 0) {
                long halfULP = binExp > nSignificantBits ? 1L << binExp - nSignificantBits - 1 : 0L;
                fractBits = binExp >= 52 ? (fractBits <<= binExp - 52) : (fractBits >>>= 52 - binExp);
                this.developLongDigits(0, fractBits, halfULP);
                return;
            }
            double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFEFFFFFFFFFFFFFL);
            int decExp = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981);
            int B5 = Math.max(0, -decExp);
            int B2 = B5 + nTinyBits + binExp;
            int S5 = Math.max(0, decExp);
            int S2 = S5 + nTinyBits;
            int M5 = B5;
            int M2 = B2 - nSignificantBits;
            fractBits >>>= 53 - nFractBits;
            int common2factor = Math.min(B2 -= nFractBits - 1, S2);
            B2 -= common2factor;
            S2 -= common2factor;
            M2 -= common2factor;
            if (nFractBits == 1) {
                --M2;
            }
            if (M2 < 0) {
                B2 -= M2;
                S2 -= M2;
                M2 = 0;
            }
            this.digits = new char[18];
            char[] digits = this.digits;
            int ndigit = 0;
            int Bbits = nFractBits + B2 + (B5 < n5bits.length ? n5bits[B5] : B5 * 3);
            int tenSbits = S2 + 1 + (S5 + 1 < n5bits.length ? n5bits[S5 + 1] : (S5 + 1) * 3);
            if (Bbits < 64 && tenSbits < 64) {
                if (Bbits < 32 && tenSbits < 32) {
                    int b = (int)fractBits * small5pow[B5] << B2;
                    int s = small5pow[S5] << S2;
                    int m = small5pow[M5] << M2;
                    int tens = s * 10;
                    ndigit = 0;
                    int q = b / s;
                    low = (b = 10 * (b % s)) < (m *= 10);
                    boolean bl = high = b + m > tens;
                    if (q >= 10) {
                        throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                    }
                    if (q == 0 && !high) {
                        --decExp;
                    } else {
                        digits[ndigit++] = (char)(48 + q);
                    }
                    if (decExp <= -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = b / s;
                        b = 10 * (b % s);
                        m *= 10;
                        if (q >= 10) {
                            throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                        }
                        if ((long)m > 0L) {
                            low = b < m;
                            high = b + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        digits[ndigit++] = (char)(48 + q);
                    }
                    lowDigitDifference = (b << 1) - tens;
                } else {
                    long b = fractBits * long5pow[B5] << B2;
                    long s = long5pow[S5] << S2;
                    long m = long5pow[M5] << M2;
                    long tens = s * 10L;
                    ndigit = 0;
                    int q = (int)(b / s);
                    low = (b = 10L * (b % s)) < (m *= 10L);
                    boolean bl = high = b + m > tens;
                    if (q >= 10) {
                        throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                    }
                    if (q == 0 && !high) {
                        --decExp;
                    } else {
                        digits[ndigit++] = (char)(48 + q);
                    }
                    if (decExp <= -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = (int)(b / s);
                        b = 10L * (b % s);
                        m *= 10L;
                        if (q >= 10) {
                            throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                        }
                        if (m > 0L) {
                            low = b < m;
                            high = b + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        digits[ndigit++] = (char)(48 + q);
                    }
                    lowDigitDifference = (b << 1) - tens;
                }
            } else {
                FDBigInt Bval = new FDBigInt(fractBits);
                if (B5 != 0) {
                    Bval = B5 < small5pow.length ? Bval.mult(small5pow[B5]) : Bval.mult(FloatingDecimal.big5pow(B5));
                }
                if (B2 != 0) {
                    Bval.lshiftMe(B2);
                }
                FDBigInt Sval = new FDBigInt(FloatingDecimal.big5pow(S5));
                if (S2 != 0) {
                    Sval.lshiftMe(S2);
                }
                FDBigInt Mval = new FDBigInt(FloatingDecimal.big5pow(M5));
                if (M2 != 0) {
                    Mval.lshiftMe(M2);
                }
                int shiftBias = Sval.normalizeMe();
                Bval.lshiftMe(shiftBias);
                Mval.lshiftMe(shiftBias);
                FDBigInt tenSval = Sval.mult(10);
                ndigit = 0;
                int q = Bval.quoRemIteration(Sval);
                Mval = Mval.mult(10);
                low = Bval.cmp(Mval) < 0;
                boolean bl = high = Bval.add(Mval).cmp(tenSval) > 0;
                if (q >= 10) {
                    throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                }
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q);
                }
                if (decExp <= -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = Bval.quoRemIteration(Sval);
                    Mval = Mval.mult(10);
                    if (q >= 10) {
                        throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                    }
                    low = Bval.cmp(Mval) < 0;
                    high = Bval.add(Mval).cmp(tenSval) > 0;
                    digits[ndigit++] = (char)(48 + q);
                }
                if (high && low) {
                    Bval.lshiftMe(1);
                    lowDigitDifference = Bval.cmp(tenSval);
                } else {
                    lowDigitDifference = 0L;
                }
            }
            this.decExponent = decExp + 1;
            this.digits = digits;
            this.nDigits = ndigit;
            if (high) {
                if (low) {
                    if (lowDigitDifference == 0L) {
                        if ((digits[this.nDigits - 1] & '\u0001') != 0) {
                            this.roundup();
                        }
                    } else if (lowDigitDifference > 0L) {
                        this.roundup();
                    }
                } else {
                    this.roundup();
                }
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.nDigits + 8);
            if (this.isNegative) {
                result.append('-');
            }
            if (this.isExceptional) {
                result.append(this.digits, 0, this.nDigits);
            } else {
                result.append("0.");
                result.append(this.digits, 0, this.nDigits);
                result.append('e');
                result.append(this.decExponent);
            }
            return new String(result);
        }

        public String toJavaFormatString() {
            char[] result = new char[this.nDigits + 10];
            int i = 0;
            if (this.isNegative) {
                result[0] = 45;
                i = 1;
            }
            if (this.isExceptional) {
                System.arraycopy(this.digits, 0, result, i, this.nDigits);
                i += this.nDigits;
            } else if (this.decExponent > 0 && this.decExponent < 8) {
                int charLength = Math.min(this.nDigits, this.decExponent);
                System.arraycopy(this.digits, 0, result, i, charLength);
                i += charLength;
                if (charLength < this.decExponent) {
                    charLength = this.decExponent - charLength;
                    System.arraycopy(zero, 0, result, i, charLength);
                    i += charLength;
                    result[i++] = 46;
                    result[i++] = 48;
                } else {
                    result[i++] = 46;
                    if (charLength < this.nDigits) {
                        int t = this.nDigits - charLength;
                        System.arraycopy(this.digits, charLength, result, i, t);
                        i += t;
                    } else {
                        result[i++] = 48;
                    }
                }
            } else if (this.decExponent <= 0 && this.decExponent > -3) {
                result[i++] = 48;
                result[i++] = 46;
                if (this.decExponent != 0) {
                    System.arraycopy(zero, 0, result, i, -this.decExponent);
                    i -= this.decExponent;
                }
                System.arraycopy(this.digits, 0, result, i, this.nDigits);
                i += this.nDigits;
            } else {
                int e;
                result[i++] = this.digits[0];
                result[i++] = 46;
                if (this.nDigits > 1) {
                    System.arraycopy(this.digits, 1, result, i, this.nDigits - 1);
                    i += this.nDigits - 1;
                } else {
                    result[i++] = 48;
                }
                result[i++] = 69;
                if (this.decExponent <= 0) {
                    result[i++] = 45;
                    e = -this.decExponent + 1;
                } else {
                    e = this.decExponent - 1;
                }
                if (e <= 9) {
                    result[i++] = (char)(e + 48);
                } else if (e <= 99) {
                    result[i++] = (char)(e / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                } else {
                    result[i++] = (char)(e / 100 + 48);
                    result[i++] = (char)((e %= 100) / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                }
            }
            return new String(result, 0, i);
        }

        public FloatingDecimal(long n) {
            this.isExceptional = false;
            if (n < 0L) {
                this.isNegative = true;
                n = -n;
            } else {
                this.isNegative = false;
            }
            if (n == 0L) {
                this.nDigits = 1;
                this.digits = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
                this.decExponent = 0;
            } else {
                this.nDigits = 0;
                for (long m = n; m != 0L; m /= 10L) {
                    ++this.nDigits;
                }
                this.decExponent = this.nDigits;
                this.digits = new char[this.nDigits];
                int i = this.nDigits - 1;
                for (long m = n; m != 0L; m /= 10L) {
                    this.digits[i--] = (char)(48L + m % 10L);
                }
            }
        }

        public void shift(int i) {
            if (!(this.isExceptional || this.nDigits == 1 && this.digits[0] == '0')) {
                this.decExponent += i;
            }
        }

        public String toJavaFormatString(int minDigitsLeftOfDecimal, char decimalChar, int minDigitsRightOfDecimal, int maxDigitsRightOfDecimal, char expChar, boolean expSign, int minExpDigits, char thousandChar) {
            int resultLen = 10 + Math.abs(this.decExponent) * 4 / 3 + maxDigitsRightOfDecimal;
            char[] result = new char[resultLen];
            int i = this.toJavaFormatString(result, 0, minDigitsLeftOfDecimal, decimalChar, minDigitsRightOfDecimal, maxDigitsRightOfDecimal, expChar, expSign, minExpDigits, thousandChar);
            return new String(result, 0, i);
        }

        private synchronized int toJavaFormatString(char[] result, int i, int minDigitsLeftOfDecimal, char decimalChar, int minDigitsRightOfDecimal, int maxDigitsRightOfDecimal, char expChar, boolean expSign, int minExpDigits, char thousandChar) {
            if (this.isNegative) {
                result[i++] = 45;
            }
            if (this.isExceptional) {
                System.arraycopy(this.digits, 0, result, i, this.nDigits);
                i += this.nDigits;
            } else if (expChar == '\u0000') {
                int j;
                int lastDigitToPrint;
                char[] digits2;
                int totalDigits;
                int wholeDigits;
                block31: {
                    int j2;
                    wholeDigits = Math.max(this.decExponent, minDigitsLeftOfDecimal);
                    int fractionDigits = Math.max(this.nDigits - this.decExponent, minDigitsRightOfDecimal);
                    totalDigits = wholeDigits + fractionDigits;
                    digits2 = new char[totalDigits];
                    for (j2 = 0; j2 < totalDigits; ++j2) {
                        digits2[j2] = 48;
                    }
                    for (j2 = 0; j2 < this.nDigits; ++j2) {
                        digits2[wholeDigits - this.decExponent + j2] = this.digits[j2];
                    }
                    int lastDigit = wholeDigits + maxDigitsRightOfDecimal;
                    if (lastDigit < totalDigits) {
                        boolean trailingZeroes = true;
                        int m = totalDigits;
                        while (true) {
                            if (--m < 0) {
                                ++wholeDigits;
                                ++lastDigit;
                                char[] old = digits2;
                                digits2 = new char[++totalDigits];
                                digits2[0] = 49;
                                System.arraycopy(old, 0, digits2, 1, old.length);
                                break block31;
                            }
                            if (m == lastDigit) {
                                char d = digits2[m];
                                digits2[m] = 48;
                                if (d >= '5' && (d != '5' || !trailingZeroes)) continue;
                                break block31;
                            }
                            if (m > lastDigit) {
                                if (digits2[m] > '0') {
                                    trailingZeroes = false;
                                }
                                digits2[m] = 48;
                                continue;
                            }
                            if (digits2[m] != '9') break;
                            digits2[m] = 48;
                        }
                        int n = m;
                        digits2[n] = (char)(digits2[n] + '\u0001');
                    }
                }
                int firstNonZero = wholeDigits;
                int firstTrailingZero = 0;
                for (int j3 = 0; j3 < totalDigits; ++j3) {
                    if (digits2[j3] == '0') continue;
                    if (j3 < firstNonZero) {
                        firstNonZero = j3;
                    }
                    firstTrailingZero = j3 + 1;
                }
                int firstDigitToPrint = firstNonZero;
                if (firstDigitToPrint > wholeDigits - minDigitsLeftOfDecimal) {
                    firstDigitToPrint = wholeDigits - minDigitsLeftOfDecimal;
                }
                if ((lastDigitToPrint = firstTrailingZero) > wholeDigits + maxDigitsRightOfDecimal) {
                    lastDigitToPrint = wholeDigits + maxDigitsRightOfDecimal;
                }
                if (lastDigitToPrint < wholeDigits + minDigitsRightOfDecimal) {
                    lastDigitToPrint = wholeDigits + minDigitsRightOfDecimal;
                }
                for (j = firstDigitToPrint; j < wholeDigits; ++j) {
                    if (thousandChar != '\u0000' && (wholeDigits - j) % 3 == 0 && j > firstDigitToPrint && j < wholeDigits - 1) {
                        result[i++] = thousandChar;
                    }
                    result[i++] = digits2[j];
                }
                for (j = wholeDigits; j < lastDigitToPrint; ++j) {
                    if (j == wholeDigits) {
                        result[i++] = decimalChar;
                    }
                    result[i++] = digits2[j];
                }
            } else {
                int nExpDigits;
                int e;
                int oldExp = this.decExponent;
                this.decExponent = Math.min(minDigitsLeftOfDecimal, this.nDigits);
                boolean oldIsNegative = this.isNegative;
                this.isNegative = false;
                i = this.toJavaFormatString(result, i, minDigitsLeftOfDecimal, decimalChar, minDigitsRightOfDecimal, maxDigitsRightOfDecimal, '\u0000', false, minExpDigits, '\u0000');
                this.decExponent = oldExp;
                this.isNegative = oldIsNegative;
                result[i++] = expChar;
                int de = this.decExponent;
                if (this.nDigits == 1 && this.digits[0] == '0') {
                    de = 1;
                }
                if (de <= 0) {
                    result[i++] = 45;
                    e = -de + 1;
                } else {
                    if (expSign) {
                        result[i++] = 43;
                    }
                    e = de - 1;
                }
                for (int j = nExpDigits = e <= 9 ? 1 : (e <= 99 ? 2 : 3); j < minExpDigits; ++j) {
                    result[i++] = 48;
                }
                if (e <= 9) {
                    result[i++] = (char)(e + 48);
                } else if (e <= 99) {
                    result[i++] = (char)(e / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                } else {
                    result[i++] = (char)(e / 100 + 48);
                    result[i++] = (char)((e %= 100) / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                }
            }
            return i;
        }

        static {
            small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
            long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
            n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
            infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
            notANumber = new char[]{'N', 'a', 'N'};
            zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        }
    }

    public static interface LocaleFormatFactory {
        public FormatLocale get(Locale var1);
    }

    static class MacroToken {
        String name;
        String translation;
        String description;

        MacroToken(String name, String translation, String description) {
            this.name = name;
            this.translation = translation;
            this.description = description;
        }
    }

    private static class StringFormat
    extends BasicFormat {
        int stringCase;

        StringFormat(int stringCase) {
            this.stringCase = stringCase;
        }
    }

    public static class FormatLocale {
        char thousandSeparator;
        char decimalPlaceholder;
        String dateSeparator;
        String timeSeparator;
        String currencySymbol;
        String currencyFormat;
        String[] daysOfWeekShort;
        String[] daysOfWeekLong;
        String[] monthsShort;
        String[] monthsLong;
        private final Locale locale;

        private FormatLocale(char thousandSeparator, char decimalPlaceholder, String dateSeparator, String timeSeparator, String currencySymbol, String currencyFormat, String[] daysOfWeekShort, String[] daysOfWeekLong, String[] monthsShort, String[] monthsLong, Locale locale) {
            this.locale = locale;
            if (thousandSeparator == '\u0000') {
                thousandSeparator = (char)44;
            }
            this.thousandSeparator = thousandSeparator;
            if (decimalPlaceholder == '\u0000') {
                decimalPlaceholder = (char)46;
            }
            this.decimalPlaceholder = decimalPlaceholder;
            if (dateSeparator == null) {
                dateSeparator = Format.dateSeparator_en;
            }
            this.dateSeparator = dateSeparator;
            if (timeSeparator == null) {
                timeSeparator = Format.timeSeparator_en;
            }
            this.timeSeparator = timeSeparator;
            if (currencySymbol == null) {
                currencySymbol = Format.currencySymbol_en;
            }
            this.currencySymbol = currencySymbol;
            if (currencyFormat == null) {
                currencyFormat = Format.currencyFormat_en;
            }
            this.currencyFormat = currencyFormat;
            if (daysOfWeekShort == null) {
                daysOfWeekShort = daysOfWeekShort_en;
            }
            this.daysOfWeekShort = daysOfWeekShort;
            if (daysOfWeekLong == null) {
                daysOfWeekLong = daysOfWeekLong_en;
            }
            this.daysOfWeekLong = daysOfWeekLong;
            if (monthsShort == null) {
                monthsShort = monthsShort_en;
            }
            this.monthsShort = monthsShort;
            if (monthsLong == null) {
                monthsLong = monthsLong_en;
            }
            this.monthsLong = monthsLong;
            if (daysOfWeekShort.length != 8 || daysOfWeekLong.length != 8 || monthsShort.length != 13 || monthsLong.length != 13) {
                throw new IllegalArgumentException("Format: day or month array has incorrect length");
            }
        }
    }

    static class DateFormat
    extends FallbackFormat {
        FormatLocale locale;
        boolean twelveHourClock;

        DateFormat(int code, String s, FormatLocale locale, boolean twelveHourClock) {
            super(code, s);
            this.locale = locale;
            this.twelveHourClock = twelveHourClock;
        }

        void setTwelveHourClock(boolean twelveHourClock) {
            this.twelveHourClock = twelveHourClock;
        }

        void format(Calendar calendar, StringBuilder buf) {
            this.format(this.code, calendar, buf);
        }

        private void format(int code, Calendar calendar, StringBuilder buf) {
            switch (code) {
                case 3: {
                    boolean timeSet;
                    boolean dateSet = calendar.get(6) != 0 || calendar.get(1) != 0;
                    boolean bl = timeSet = calendar.get(13) != 0 || calendar.get(12) != 0 || calendar.get(10) != 0;
                    if (dateSet) {
                        this.format(8, calendar, buf);
                    }
                    if (dateSet && timeSet) {
                        buf.append(' ');
                    }
                    if (!timeSet) break;
                    this.format(26, calendar, buf);
                    break;
                }
                case 4: {
                    int d = calendar.get(5);
                    buf.append(d);
                    break;
                }
                case 5: {
                    int d = calendar.get(5);
                    if (d < 10) {
                        buf.append('0');
                    }
                    buf.append(d);
                    break;
                }
                case 6: {
                    int dow = calendar.get(7);
                    buf.append(this.locale.daysOfWeekShort[dow]);
                    break;
                }
                case 7: {
                    int dow = calendar.get(7);
                    buf.append(this.locale.daysOfWeekLong[dow]);
                    break;
                }
                case 8: {
                    this.format(12, calendar, buf);
                    buf.append(this.locale.dateSeparator);
                    this.format(4, calendar, buf);
                    buf.append(this.locale.dateSeparator);
                    this.format(18, calendar, buf);
                    break;
                }
                case 9: {
                    this.format(15, calendar, buf);
                    buf.append(" ");
                    this.format(5, calendar, buf);
                    buf.append(", ");
                    this.format(19, calendar, buf);
                    break;
                }
                case 10: {
                    int dow = calendar.get(7);
                    buf.append(dow);
                    break;
                }
                case 11: {
                    int woy = calendar.get(3);
                    buf.append(woy);
                    break;
                }
                case 12: {
                    int m = calendar.get(2) + 1;
                    buf.append(m);
                    break;
                }
                case 13: {
                    int mm = calendar.get(2) + 1;
                    if (mm < 10) {
                        buf.append('0');
                    }
                    buf.append(mm);
                    break;
                }
                case 14: 
                case 55: {
                    int m = calendar.get(2);
                    buf.append(this.locale.monthsShort[m]);
                    break;
                }
                case 15: 
                case 56: {
                    int m = calendar.get(2);
                    buf.append(this.locale.monthsLong[m]);
                    break;
                }
                case 16: {
                    int m = calendar.get(2);
                    int q = m / 3 + 1;
                    buf.append(q);
                    break;
                }
                case 17: {
                    int doy = calendar.get(6);
                    buf.append(doy);
                    break;
                }
                case 18: {
                    int y = calendar.get(1) % 100;
                    if (y < 10) {
                        buf.append('0');
                    }
                    buf.append(y);
                    break;
                }
                case 19: {
                    int y = calendar.get(1);
                    buf.append(y);
                    break;
                }
                case 20: {
                    int h = calendar.get(this.twelveHourClock ? 10 : 11);
                    buf.append(h);
                    break;
                }
                case 21: {
                    int h = calendar.get(this.twelveHourClock ? 10 : 11);
                    if (h < 10) {
                        buf.append('0');
                    }
                    buf.append(h);
                    break;
                }
                case 22: {
                    int n = calendar.get(12);
                    buf.append(n);
                    break;
                }
                case 23: {
                    int n = calendar.get(12);
                    if (n < 10) {
                        buf.append('0');
                    }
                    buf.append(n);
                    break;
                }
                case 24: {
                    int s = calendar.get(13);
                    buf.append(s);
                    break;
                }
                case 25: {
                    int s = calendar.get(13);
                    if (s < 10) {
                        buf.append('0');
                    }
                    buf.append(s);
                    break;
                }
                case 26: {
                    this.format(20, calendar, buf);
                    buf.append(this.locale.timeSeparator);
                    this.format(23, calendar, buf);
                    buf.append(this.locale.timeSeparator);
                    this.format(25, calendar, buf);
                    break;
                }
                case 27: 
                case 31: {
                    boolean isAm = calendar.get(9) == 0;
                    buf.append(isAm ? "AM" : "PM");
                    break;
                }
                case 28: {
                    boolean isAm = calendar.get(9) == 0;
                    buf.append(isAm ? "am" : "pm");
                    break;
                }
                case 29: {
                    boolean isAm = calendar.get(9) == 0;
                    buf.append(isAm ? "A" : "P");
                    break;
                }
                case 30: {
                    boolean isAm = calendar.get(9) == 0;
                    buf.append(isAm ? "a" : "p");
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }

    static class NumericFormat
    extends FallbackFormat {
        FormatLocale locale;
        int digitsLeftOfPoint;
        int zeroesLeftOfPoint;
        int digitsRightOfPoint;
        int zeroesRightOfPoint;
        int digitsRightOfExp;
        int zeroesRightOfExp;
        int decimalShift;
        char expChar;
        boolean expSign;
        boolean useDecimal;
        boolean useThouSep;

        NumericFormat(String token, FormatLocale locale, int expFormat, int digitsLeftOfPoint, int zeroesLeftOfPoint, int digitsRightOfPoint, int zeroesRightOfPoint, int digitsRightOfExp, int zeroesRightOfExp, boolean useDecimal, boolean useThouSep) {
            super(0, token);
            this.locale = locale;
            switch (expFormat) {
                case 39: {
                    this.expChar = (char)69;
                    this.expSign = false;
                    break;
                }
                case 40: {
                    this.expChar = (char)69;
                    this.expSign = true;
                    break;
                }
                case 41: {
                    this.expChar = (char)101;
                    this.expSign = false;
                    break;
                }
                case 42: {
                    this.expChar = (char)101;
                    this.expSign = true;
                    break;
                }
                default: {
                    this.expChar = '\u0000';
                    this.expSign = false;
                }
            }
            this.digitsLeftOfPoint = digitsLeftOfPoint;
            this.zeroesLeftOfPoint = zeroesLeftOfPoint;
            this.digitsRightOfPoint = digitsRightOfPoint;
            this.zeroesRightOfPoint = zeroesRightOfPoint;
            this.digitsRightOfExp = digitsRightOfExp;
            this.zeroesRightOfExp = zeroesRightOfExp;
            this.useDecimal = useDecimal;
            this.useThouSep = useThouSep;
            this.decimalShift = 0;
        }

        void format(double n, StringBuilder buf) {
            FloatingDecimal fd = new FloatingDecimal(n);
            fd.shift(this.decimalShift);
            int formatDigitsRightOfPoint = this.zeroesRightOfPoint + this.digitsRightOfPoint;
            if (n < 0.0 && !NumericFormat.shows(fd, formatDigitsRightOfPoint)) {
                n = 0.0;
                fd = new FloatingDecimal(0L);
            }
            String s = fd.toJavaFormatString(this.zeroesLeftOfPoint, this.locale.decimalPlaceholder, this.zeroesRightOfPoint, formatDigitsRightOfPoint, this.expChar, this.expSign, this.zeroesRightOfExp, this.useThouSep ? this.locale.thousandSeparator : (char)'\u0000');
            buf.append(s);
        }

        boolean isApplicableTo(double n) {
            if (n >= 0.0) {
                return true;
            }
            FloatingDecimal fd = new FloatingDecimal(n);
            fd.shift(this.decimalShift);
            int formatDigitsRightOfPoint = this.zeroesRightOfPoint + this.digitsRightOfPoint;
            return NumericFormat.shows(fd, formatDigitsRightOfPoint);
        }

        private static boolean shows(FloatingDecimal fd, int formatDigitsRightOfPoint) {
            int i0 = -fd.decExponent - formatDigitsRightOfPoint;
            if (i0 < 0) {
                return true;
            }
            if (i0 > 0) {
                return false;
            }
            for (int i = i0; i < fd.nDigits; ++i) {
                char digit = fd.digits[i];
                if (i == i0) {
                    if (digit > '5') {
                        return true;
                    }
                    if (digit >= '5') continue;
                    return false;
                }
                if (digit <= '0') continue;
                return true;
            }
            return false;
        }

        void format(long n, StringBuilder buf) {
            FloatingDecimal fd = new FloatingDecimal(n);
            fd.shift(this.decimalShift);
            String s = fd.toJavaFormatString(this.zeroesLeftOfPoint, this.locale.decimalPlaceholder, this.zeroesRightOfPoint, this.zeroesRightOfPoint + this.digitsRightOfPoint, this.expChar, this.expSign, this.zeroesRightOfExp, this.useThouSep ? this.locale.thousandSeparator : (char)'\u0000');
            buf.append(s);
        }
    }

    static abstract class FallbackFormat
    extends BasicFormat {
        String token;

        FallbackFormat(int code, String token) {
            super(code);
            this.token = token;
        }

        void format(double d, StringBuilder buf) {
            buf.append(this.token);
        }

        void format(long n, StringBuilder buf) {
            buf.append(this.token);
        }

        void format(String s, StringBuilder buf) {
            buf.append(this.token);
        }

        void format(Calendar calendar, StringBuilder buf) {
            buf.append(this.token);
        }
    }

    static class JavaFormat
    extends BasicFormat {
        private final NumberFormat numberFormat;
        private final java.text.DateFormat dateFormat;

        JavaFormat(Locale locale) {
            this.numberFormat = NumberFormat.getNumberInstance(locale);
            this.dateFormat = java.text.DateFormat.getDateInstance(3, locale);
        }

        void format(double d, StringBuilder buf) {
            buf.append(this.numberFormat.format(d));
        }

        void format(long n, StringBuilder buf) {
            buf.append(this.numberFormat.format(n));
        }

        void format(String s, StringBuilder buf) {
            buf.append(s);
        }

        void format(Calendar calendar, StringBuilder buf) {
            buf.append(this.dateFormat.format(calendar.getTime()));
        }
    }

    static class CompoundFormat
    extends BasicFormat {
        final BasicFormat[] formats;

        CompoundFormat(BasicFormat[] formats) {
            this.formats = formats;
            assert (formats.length >= 2);
        }

        void formatNull(StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].formatNull(buf);
            }
        }

        void format(double v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        void format(long v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        void format(String v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        void format(Date v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        void format(Calendar v, StringBuilder buf) {
            for (int i = 0; i < this.formats.length; ++i) {
                this.formats[i].format(v, buf);
            }
        }

        boolean isApplicableTo(double n) {
            for (int i = 0; i < this.formats.length; ++i) {
                if (this.formats[i].isApplicableTo(n)) continue;
                return false;
            }
            return true;
        }
    }

    static class LiteralFormat
    extends BasicFormat {
        String s;

        LiteralFormat(String s) {
            this(43, s);
        }

        LiteralFormat(int code, String s) {
            super(code);
            this.s = s;
        }

        void format(double d, StringBuilder buf) {
            buf.append(this.s);
        }

        void format(long n, StringBuilder buf) {
            buf.append(this.s);
        }

        void format(String s, StringBuilder buf) {
            buf.append(s);
        }

        void format(Date date, StringBuilder buf) {
            buf.append(this.s);
        }

        void format(Calendar calendar, StringBuilder buf) {
            buf.append(this.s);
        }
    }

    static class AlternateFormat
    extends BasicFormat {
        final BasicFormat[] formats;

        AlternateFormat(BasicFormat[] formats) {
            this.formats = formats;
            assert (formats.length >= 2);
        }

        void formatNull(StringBuilder buf) {
            if (this.formats.length >= 4) {
                this.formats[3].format(0L, buf);
            } else {
                super.formatNull(buf);
            }
        }

        void format(double n, StringBuilder buf) {
            if (this.formats.length == 0) {
                buf.append(n);
            } else {
                int i;
                if (n == 0.0 && this.formats.length >= 3 && this.formats[2] != null) {
                    i = 2;
                } else if (n < 0.0 && this.formats.length >= 2 && this.formats[1] != null) {
                    if (this.formats[1].isApplicableTo(n)) {
                        n = -n;
                        i = 1;
                    } else {
                        i = 2;
                    }
                } else {
                    i = 0;
                }
                this.formats[i].format(n, buf);
            }
        }

        void format(long n, StringBuilder buf) {
            if (this.formats.length == 0) {
                buf.append(n);
            } else {
                int i;
                if (n == 0L && this.formats.length >= 3 && this.formats[2] != null) {
                    i = 2;
                } else if (n < 0L && this.formats.length >= 2 && this.formats[1] != null && this.formats[1].isApplicableTo(n)) {
                    n = -n;
                    i = 1;
                } else {
                    i = 0;
                }
                this.formats[i].format(n, buf);
            }
        }

        void format(String s, StringBuilder buf) {
            this.formats[0].format(s, buf);
        }

        void format(Date date, StringBuilder buf) {
            this.formats[0].format(date, buf);
        }

        void format(Calendar calendar, StringBuilder buf) {
            this.formats[0].format(calendar, buf);
        }
    }

    static class BasicFormat {
        int code;

        BasicFormat() {
            this(0);
        }

        BasicFormat(int code) {
            this.code = code;
        }

        boolean isNumeric() {
            return false;
        }

        boolean isDate() {
            return false;
        }

        boolean isString() {
            return false;
        }

        void formatNull(StringBuilder buf) {
        }

        void format(double d, StringBuilder buf) {
            throw new Error();
        }

        void format(long n, StringBuilder buf) {
            throw new Error();
        }

        void format(String s, StringBuilder buf) {
            throw new Error();
        }

        void format(Date date, StringBuilder buf) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.format(calendar, buf);
        }

        void format(Calendar calendar, StringBuilder buf) {
            throw new Error();
        }

        boolean isApplicableTo(double n) {
            return true;
        }

        boolean isApplicableTo(long n) {
            return true;
        }
    }

    static class Token {
        int code;
        int flags;
        String token;

        Token(int code, int flags, String token) {
            this.code = code;
            this.flags = flags;
            this.token = token;
        }

        boolean isSpecial() {
            return (this.flags & 8) == 8;
        }

        boolean isNumeric() {
            return (this.flags & 4) == 4;
        }

        boolean isDate() {
            return (this.flags & 3) == 3;
        }

        boolean isString() {
            return (this.flags & 5) == 5;
        }

        BasicFormat makeFormat(FormatLocale locale) {
            if (this.isDate()) {
                return new DateFormat(this.code, this.token, locale, false);
            }
            if (this.isNumeric()) {
                return new LiteralFormat(this.code, this.token);
            }
            if (this.isString()) {
                throw new Error();
            }
            return new LiteralFormat(this.token);
        }
    }
}

