/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlContextConstraint
implements MemberChildrenConstraint,
TupleConstraint {
    List<Object> cacheKey;
    private Evaluator evaluator;
    private boolean strict;

    public static boolean isValidContext(Evaluator context) {
        return SqlContextConstraint.isValidContext(context, true, null);
    }

    public static boolean isValidContext(Evaluator context, boolean disallowVirtualCube, Level[] levels) {
        if (context == null) {
            return false;
        }
        RolapCube cube = (RolapCube)context.getCube();
        if (disallowVirtualCube && cube.isVirtual()) {
            return false;
        }
        if (cube.isVirtual()) {
            HashMap<Map<RolapLevel, RolapStar.Column>, RolapMember> measureMap;
            HashSet<Map<RolapLevel, RolapStar.Column>> baseCubesLevelToColumnMaps;
            Query query = context.getQuery();
            if (!SqlContextConstraint.findVirtualCubeJoinLevels(query, baseCubesLevelToColumnMaps = new HashSet<Map<RolapLevel, RolapStar.Column>>(), measureMap = new HashMap<Map<RolapLevel, RolapStar.Column>, RolapMember>())) {
                return false;
            }
            assert (levels != null);
            for (Map map : baseCubesLevelToColumnMaps) {
                for (Level level : levels) {
                    if (map.get((RolapLevel)level) != null) continue;
                    return false;
                }
            }
            query.setVirtualCubeBaseCubeMaps(baseCubesLevelToColumnMaps);
            query.setLevelMapToMeasureMap(measureMap);
        }
        return true;
    }

    private static boolean findVirtualCubeJoinLevels(Query query, Set<Map<RolapLevel, RolapStar.Column>> baseCubesLevelToColumnMaps, Map<Map<RolapLevel, RolapStar.Column>, RolapMember> measureMap) {
        Set<Member> measureMembers = query.getMeasuresMembers();
        if (measureMembers.isEmpty()) {
            Cube cube = query.getCube();
            Dimension dimension = cube.getDimensions()[0];
            query.addMeasuresMembers(dimension.getHierarchy().getDefaultMember());
        }
        for (Member member : query.getMeasuresMembers()) {
            if (member instanceof RolapStoredMeasure) {
                SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubesLevelToColumnMaps, measureMap);
                continue;
            }
            if (!(member instanceof RolapCalculatedMember)) continue;
            SqlContextConstraint.findMeasures(member.getExpression(), baseCubesLevelToColumnMaps, measureMap);
        }
        return !measureMap.isEmpty();
    }

    private static void addMeasure(RolapStoredMeasure measure, Set<Map<RolapLevel, RolapStar.Column>> baseCubesLevelToColumnMaps, Map<Map<RolapLevel, RolapStar.Column>, RolapMember> measureMap) {
        RolapCube baseCube;
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        RolapStar star = starMeasure.getStar();
        Map<RolapLevel, RolapStar.Column> levelToColumnMap = star.getLevelToColumnMap(baseCube = measure.getCube());
        if (baseCubesLevelToColumnMaps.add(levelToColumnMap)) {
            measureMap.put(levelToColumnMap, (RolapMember)((Object)measure));
        }
    }

    private static void findMeasures(Exp exp, Set<Map<RolapLevel, RolapStar.Column>> baseCubesLevelToColumnMaps, Map<Map<RolapLevel, RolapStar.Column>, RolapMember> measureMap) {
        block4: {
            block2: {
                Member member;
                block3: {
                    if (!(exp instanceof MemberExpr)) break block2;
                    MemberExpr memberExpr = (MemberExpr)exp;
                    member = memberExpr.getMember();
                    if (!(member instanceof RolapStoredMeasure)) break block3;
                    SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubesLevelToColumnMaps, measureMap);
                    break block4;
                }
                if (!(member instanceof RolapCalculatedMember)) break block4;
                SqlContextConstraint.findMeasures(member.getExpression(), baseCubesLevelToColumnMaps, measureMap);
                break block4;
            }
            if (exp instanceof ResolvedFunCall) {
                Exp[] args;
                ResolvedFunCall funCall = (ResolvedFunCall)exp;
                for (Exp arg : args = funCall.getArgs()) {
                    SqlContextConstraint.findMeasures(arg, baseCubesLevelToColumnMaps, measureMap);
                }
            }
        }
    }

    SqlContextConstraint(RolapEvaluator evaluator, boolean strict) {
        this.evaluator = evaluator;
        this.strict = strict;
        this.cacheKey = new ArrayList<Object>();
        this.cacheKey.add(this.getClass());
        this.cacheKey.add(strict);
        this.cacheKey.addAll(Arrays.asList(evaluator.getMembers()));
    }

    @Override
    public void addMemberConstraint(SqlQuery sqlQuery, Map<RolapLevel, RolapStar.Column> levelToColumnMap, AggStar aggStar, RolapMember parent) {
        if (parent.isCalculated()) {
            throw Util.newInternal("cannot restrict SQL to calculated member");
        }
        Evaluator e = this.evaluator.push(parent);
        SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, e, this.strict);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, levelToColumnMap, aggStar, parent, true);
    }

    @Override
    public void addMemberConstraint(SqlQuery sqlQuery, Map<RolapLevel, RolapStar.Column> levelToColumnMap, AggStar aggStar, List<RolapMember> parents) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, this.evaluator, this.strict);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, levelToColumnMap, aggStar, parents, true, false);
    }

    @Override
    public void addConstraint(SqlQuery sqlQuery, Map<RolapLevel, RolapStar.Column> levelToColumnMap) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, null, this.evaluator, this.strict);
    }

    protected boolean isJoinRequired() {
        Member[] members = this.evaluator.getMembers();
        for (int i = 1; i < members.length; ++i) {
            if (members[i].isAll()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addLevelConstraint(SqlQuery sqlQuery, AggStar aggStar, RolapLevel level, Map<RolapLevel, RolapStar.Column> levelToColumnMap) {
        if (!this.isJoinRequired()) {
            return;
        }
        SqlConstraintUtils.joinLevelTableToFactTable(sqlQuery, aggStar, this.evaluator, level, levelToColumnMap);
    }

    @Override
    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return this;
    }

    @Override
    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }
}

