/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.RolapStar;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeFilter
extends RolapNativeSet {
    public RolapNativeFilter() {
        super.setEnabled(MondrianProperties.instance().EnableNativeFilter.get());
    }

    protected boolean isStrict() {
        return true;
    }

    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        if (!FilterConstraint.isValidContext(evaluator)) {
            return null;
        }
        String funName = fun.getName();
        if (!"Filter".equalsIgnoreCase(funName)) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        RolapNativeSet.CrossJoinArg[] cargs = this.checkCrossJoinArg(args[0]);
        if (cargs == null) {
            return null;
        }
        if (this.isPreferInterpreter(cargs)) {
            return null;
        }
        SchemaReader schemaReader = evaluator.getSchemaReader();
        DataSource ds = schemaReader.getDataSource();
        SqlQuery sqlQuery = SqlQuery.newQuery(ds, "NativeFilter");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery);
        String filterExpr = sql.generateFilterCondition(args[1]);
        if (filterExpr == null) {
            return null;
        }
        LOGGER.debug((Object)"using native filter");
        evaluator = this.overrideContext(evaluator, cargs, sql.getStoredMeasure());
        FilterConstraint constraint = new FilterConstraint(cargs, evaluator, filterExpr);
        return new RolapNativeSet.SetEvaluator(this, cargs, schemaReader, constraint);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilterConstraint
    extends RolapNativeSet.SetConstraint {
        String filterExpr;

        public FilterConstraint(RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator, String filterByExpr) {
            super(args, evaluator, true);
            this.filterExpr = filterByExpr;
        }

        @Override
        protected boolean isJoinRequired() {
            return true;
        }

        @Override
        public void addConstraint(SqlQuery sqlQuery, Map<RolapLevel, RolapStar.Column> levelToColumnMap) {
            sqlQuery.addHaving(this.filterExpr);
            super.addConstraint(sqlQuery, levelToColumnMap);
        }

        @Override
        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            key.add(this.filterExpr);
            return key;
        }
    }
}

