/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Level;
import mondrian.olap.LevelBase;
import mondrian.olap.LevelType;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.MondrianDef;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.MemberTuplePredicate;
import mondrian.rolap.agg.RangeColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapLevel
extends LevelBase {
    private static final Logger LOGGER = Logger.getLogger(RolapEvaluator.class);
    static final int ALL = 2;
    static final int UNIQUE = 4;
    private final MondrianDef.Expression keyExp;
    private final MondrianDef.Expression ordinalExp;
    private final MondrianDef.Expression captionExp;
    private final boolean unique;
    private final SqlQuery.Datatype datatype;
    private final int flags;
    private final RolapProperty[] properties;
    private final RolapProperty[] inheritedProperties;
    private final MondrianDef.Expression nameExp;
    private final MondrianDef.Expression parentExp;
    private final String nullParentValue;
    private final HideMemberCondition hideMemberCondition;
    private final MondrianDef.Closure xmlClosure;
    private LevelReader levelReader;

    public static RolapLevel lookupLevel(RolapLevel[] levels, String levelName) {
        for (RolapLevel level : levels) {
            if (!level.getName().equals(levelName)) continue;
            return level;
        }
        return null;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, String name, MondrianDef.Expression keyExp, MondrianDef.Expression nameExp, MondrianDef.Expression captionExp, MondrianDef.Expression ordinalExp, MondrianDef.Expression parentExp, String nullParentValue, MondrianDef.Closure xmlClosure, RolapProperty[] properties, int flags, SqlQuery.Datatype datatype, HideMemberCondition hideMemberCondition, LevelType levelType, String approxRowCount) {
        super(hierarchy, name, depth, levelType);
        Util.assertPrecondition(properties != null, "properties != null");
        Util.assertPrecondition(hideMemberCondition != null, "hideMemberCondition != null");
        Util.assertPrecondition(levelType != null, "levelType != null");
        if (keyExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)keyExp);
        }
        this.approxRowCount = this.loadApproxRowCount(approxRowCount);
        this.flags = flags;
        boolean isAll = (flags & 2) == 2;
        this.unique = (flags & 4) == 4;
        this.datatype = datatype;
        this.keyExp = keyExp;
        if (nameExp != null && nameExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)nameExp);
        }
        this.nameExp = nameExp;
        if (captionExp != null && captionExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)captionExp);
        }
        this.captionExp = captionExp;
        if (ordinalExp != null) {
            if (ordinalExp instanceof MondrianDef.Column) {
                this.checkColumn((MondrianDef.Column)ordinalExp);
            }
            this.ordinalExp = ordinalExp;
        } else {
            this.ordinalExp = this.keyExp;
        }
        this.parentExp = parentExp;
        if (parentExp != null) {
            Util.assertTrue(!isAll, "'All' level '" + this + "' must not be parent-child");
            Util.assertTrue(this.unique, "Parent-child level '" + this + "' must have uniqueMembers=\"true\"");
        }
        this.nullParentValue = nullParentValue;
        Util.assertPrecondition(parentExp != null || nullParentValue == null, "parentExp != null || nullParentValue == null");
        this.xmlClosure = xmlClosure;
        for (RolapProperty property : properties) {
            if (!(property.getExp() instanceof MondrianDef.Column)) continue;
            this.checkColumn((MondrianDef.Column)property.getExp());
        }
        this.properties = properties;
        ArrayList<Property> list = new ArrayList<Property>();
        for (Level level = this; level != null; level = level.getParentLevel()) {
            Property[] levelProperties;
            for (Property levelProperty : levelProperties = level.getProperties()) {
                Property existingProperty = this.lookupProperty(list, levelProperty.getName());
                if (existingProperty == null) {
                    list.add(levelProperty);
                    continue;
                }
                if (existingProperty.getType() == levelProperty.getType()) continue;
                throw Util.newError("Property " + this.getName() + "." + levelProperty.getName() + " overrides a " + "property with the same name but different type");
            }
        }
        this.inheritedProperties = list.toArray(new RolapProperty[list.size()]);
        Dimension dim = hierarchy.getDimension();
        if (dim.getDimensionType() == DimensionType.TimeDimension) {
            if (!levelType.isTime() && !isAll) {
                throw MondrianResource.instance().NonTimeLevelInTimeHierarchy.ex(this.getUniqueName());
            }
        } else if (dim.getDimensionType() != null && levelType.isTime()) {
            throw MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(this.getUniqueName());
        }
        this.hideMemberCondition = hideMemberCondition;
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return (RolapHierarchy)this.hierarchy;
    }

    private int loadApproxRowCount(String approxRowCount) {
        boolean notNullAndNumeric;
        boolean bl = notNullAndNumeric = approxRowCount != null && approxRowCount.matches("^\\d+$");
        if (notNullAndNumeric) {
            return Integer.parseInt(approxRowCount);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    String getTableName() {
        String tableName = null;
        MondrianDef.Expression expr = this.getKeyExp();
        if (expr instanceof MondrianDef.Column) {
            MondrianDef.Column mc = (MondrianDef.Column)expr;
            tableName = mc.getTableAlias();
        }
        return tableName;
    }

    LevelReader getLevelReader() {
        return this.levelReader;
    }

    public MondrianDef.Expression getKeyExp() {
        return this.keyExp;
    }

    MondrianDef.Expression getOrdinalExp() {
        return this.ordinalExp;
    }

    public MondrianDef.Expression getCaptionExp() {
        return this.captionExp;
    }

    public boolean hasCaptionColumn() {
        return this.captionExp != null;
    }

    int getFlags() {
        return this.flags;
    }

    HideMemberCondition getHideMemberCondition() {
        return this.hideMemberCondition;
    }

    public boolean isUnique() {
        return this.unique;
    }

    SqlQuery.Datatype getDatatype() {
        return this.datatype;
    }

    String getNullParentValue() {
        return this.nullParentValue;
    }

    public boolean isParentChild() {
        return this.parentExp != null;
    }

    MondrianDef.Expression getParentExp() {
        return this.parentExp;
    }

    public MondrianDef.Expression getNameExp() {
        return this.nameExp;
    }

    private Property lookupProperty(List<Property> list, String propertyName) {
        for (Property property : list) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, MondrianDef.Level xmlLevel) {
        this(hierarchy, depth, xmlLevel.name, xmlLevel.getKeyExp(), xmlLevel.getNameExp(), xmlLevel.getCaptionExp(), xmlLevel.getOrdinalExp(), xmlLevel.getParentExp(), xmlLevel.nullParentValue, xmlLevel.closure, RolapLevel.createProperties(xmlLevel), xmlLevel.uniqueMembers != false ? 4 : 0, xmlLevel.getDatatype(), HideMemberCondition.valueOf(xmlLevel.hideMemberIf), LevelType.valueOf(xmlLevel.levelType), xmlLevel.approxRowCount);
        if (!Util.isEmpty(xmlLevel.caption)) {
            this.setCaption(xmlLevel.caption);
        }
        if (!Util.isEmpty(xmlLevel.formatter)) {
            try {
                Class<?> clazz = Class.forName(xmlLevel.formatter);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                this.memberFormatter = (MemberFormatter)ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw MondrianResource.instance().MemberFormatterLoadFailed.ex(xmlLevel.formatter, this.getUniqueName(), e);
            }
        }
    }

    private static RolapProperty[] createProperties(MondrianDef.Level xmlLevel) {
        ArrayList<RolapProperty> list = new ArrayList<RolapProperty>();
        MondrianDef.Expression nameExp = xmlLevel.getNameExp();
        if (nameExp != null) {
            list.add(new RolapProperty(Property.NAME.name, Property.Datatype.TYPE_STRING, nameExp, null, null));
        }
        for (int i = 0; i < xmlLevel.properties.length; ++i) {
            MondrianDef.Property property = xmlLevel.properties[i];
            list.add(new RolapProperty(property.name, RolapLevel.convertPropertyTypeNameToCode(property.type), xmlLevel.getPropertyExp(i), property.formatter, property.caption));
        }
        return list.toArray(new RolapProperty[list.size()]);
    }

    private static Property.Datatype convertPropertyTypeNameToCode(String type) {
        if (type.equals("String")) {
            return Property.Datatype.TYPE_STRING;
        }
        if (type.equals("Numeric")) {
            return Property.Datatype.TYPE_NUMERIC;
        }
        if (type.equals("Boolean")) {
            return Property.Datatype.TYPE_BOOLEAN;
        }
        throw Util.newError("Unknown property type '" + type + "'");
    }

    private void checkColumn(MondrianDef.Column nameColumn) {
        RolapHierarchy rolapHierarchy = (RolapHierarchy)this.hierarchy;
        if (nameColumn.table == null) {
            MondrianDef.Relation table = rolapHierarchy.getUniqueTable();
            if (table == null) {
                throw Util.newError("must specify a table for level " + this.getUniqueName() + " because hierarchy has more than one table");
            }
            nameColumn.table = table.getAlias();
        } else {
            Util.assertTrue(rolapHierarchy.tableExists(nameColumn.table));
        }
    }

    void init(RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        if (this.isAll()) {
            this.levelReader = new AllLevelReaderImpl();
        } else if (this.levelType == LevelType.Null) {
            this.levelReader = new NullLevelReader();
        } else if (this.xmlClosure != null) {
            RolapDimension dimension = ((RolapHierarchy)this.hierarchy).createClosedPeerDimension(this, this.xmlClosure, cube, xmlDimension);
            dimension.init(cube, xmlDimension);
            cube.registerDimension(dimension);
            RolapLevel closedPeer = (RolapLevel)dimension.getHierarchies()[0].getLevels()[1];
            this.levelReader = new ParentChildLevelReaderImpl(closedPeer);
        } else {
            this.levelReader = new RegularLevelReader();
        }
    }

    @Override
    public boolean isAll() {
        return this.hierarchy.hasAll() && this.depth == 0;
    }

    @Override
    public boolean areMembersUnique() {
        return this.depth == 0 || this.depth == 1 && this.hierarchy.hasAll();
    }

    public String getTableAlias() {
        return this.keyExp.getTableAlias();
    }

    public RolapProperty[] getProperties() {
        return this.properties;
    }

    @Override
    public Property[] getInheritedProperties() {
        return this.inheritedProperties;
    }

    @Override
    public int getApproxRowCount() {
        return this.approxRowCount;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) {
        return this.lookupChild(schemaReader, name, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name, MatchType matchType) {
        Member[] levelMembers = schemaReader.getLevelMembers((Level)this, true);
        if (levelMembers.length > 0) {
            Member parent = levelMembers[0].getParentMember();
            return RolapUtil.findBestMemberMatch(Arrays.asList(levelMembers), (RolapMember)parent, this, name, matchType, false);
        }
        return null;
    }

    boolean hasClosedPeer() {
        return this.levelReader instanceof ParentChildLevelReaderImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NullLevelReader
    implements LevelReader {
        NullLevelReader() {
        }

        @Override
        public boolean constrainRequest(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
            return true;
        }

        @Override
        public void constrainRegion(StarColumnPredicate predicate, Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapCacheRegion cacheRegion) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AllLevelReaderImpl
    implements LevelReader {
        AllLevelReaderImpl() {
        }

        @Override
        public boolean constrainRequest(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
            return false;
        }

        @Override
        public void constrainRegion(StarColumnPredicate predicate, Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapCacheRegion cacheRegion) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParentChildLevelReaderImpl
    extends RegularLevelReader {
        private final RolapLevel closedPeer;

        ParentChildLevelReaderImpl(RolapLevel closedPeer) {
            this.closedPeer = closedPeer;
        }

        @Override
        public boolean constrainRequest(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
            if (member.getDataMember() == null) {
                return super.constrainRequest(member, levelToColumnMap, request);
            }
            if (request.drillThrough) {
                member = (RolapMember)member.getDataMember();
                return super.constrainRequest(member, levelToColumnMap, request);
            }
            RolapLevel level = this.closedPeer;
            RolapMember allMember = (RolapMember)level.getHierarchy().getDefaultMember();
            assert (allMember.isAll());
            member = new RolapMember(allMember, level, member.getKey());
            return level.getLevelReader().constrainRequest(member, levelToColumnMap, request);
        }

        @Override
        public void constrainRegion(StarColumnPredicate predicate, Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapCacheRegion cacheRegion) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RegularLevelReader
    implements LevelReader {
        RegularLevelReader() {
        }

        @Override
        public boolean constrainRequest(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
            LevelReader levelReader;
            assert (member.getLevel() == RolapLevel.this);
            if (member.getKey() == null) {
                if (member == member.getHierarchy().getNullMember()) {
                    return true;
                }
                throw Util.newInternal("why is key null?");
            }
            RolapStar.Column column = levelToColumnMap.get(RolapLevel.this);
            if (column == null) {
                return member != RolapLevel.this.hierarchy.getDefaultMember() || RolapLevel.this.hierarchy.hasAll();
            }
            ValueColumnPredicate predicate = member.isCalculated() ? null : new ValueColumnPredicate(column, member.getSqlKey());
            request.addConstrainedColumn(column, predicate);
            if (request.extendedContext && RolapLevel.this.getNameExp() != null) {
                RolapStar.Column nameColumn = column.getNameColumn();
                Util.assertTrue(nameColumn != null);
                request.addConstrainedColumn(nameColumn, null);
            }
            if (member.isCalculated()) {
                return false;
            }
            if (RolapLevel.this.unique) {
                return false;
            }
            RolapMember parent = member.getParentMember();
            while (true) {
                if (parent == null) {
                    return false;
                }
                RolapLevel level = parent.getLevel();
                levelReader = level.levelReader;
                if (levelReader != this) break;
                parent = parent.getParentMember();
            }
            return levelReader.constrainRequest(parent, levelToColumnMap, request);
        }

        @Override
        public void constrainRegion(StarColumnPredicate predicate, Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapCacheRegion cacheRegion) {
            RolapStar.Column column = levelToColumnMap.get(RolapLevel.this);
            if (column == null) {
                return;
            }
            if (predicate instanceof MemberColumnPredicate) {
                MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)predicate;
                RolapMember member = memberColumnPredicate.getMember();
                assert (member.getLevel() == RolapLevel.this);
                assert (!member.isCalculated());
                assert (memberColumnPredicate.getMember().getKey() != null);
                assert (!member.isNull());
                MemberTuplePredicate predicate2 = new MemberTuplePredicate(levelToColumnMap, member);
                cacheRegion.addPredicate(column, predicate);
                return;
            }
            if (predicate instanceof RangeColumnPredicate) {
                RolapMember upperMember;
                RolapMember lowerMember;
                RangeColumnPredicate rangeColumnPredicate = (RangeColumnPredicate)predicate;
                ValueColumnPredicate lowerBound = rangeColumnPredicate.getLowerBound();
                if (lowerBound == null) {
                    lowerMember = null;
                } else if (lowerBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)lowerBound;
                    lowerMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                ValueColumnPredicate upperBound = rangeColumnPredicate.getUpperBound();
                if (upperBound == null) {
                    upperMember = null;
                } else if (upperBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)upperBound;
                    upperMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                MemberTuplePredicate predicate2 = new MemberTuplePredicate(levelToColumnMap, lowerMember, !rangeColumnPredicate.getLowerInclusive(), upperMember, !rangeColumnPredicate.getUpperInclusive());
                cacheRegion.addPredicate(predicate2);
                return;
            }
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface LevelReader {
        public boolean constrainRequest(RolapMember var1, Map<RolapLevel, RolapStar.Column> var2, CellRequest var3);

        public void constrainRegion(StarColumnPredicate var1, Map<RolapLevel, RolapStar.Column> var2, RolapCacheRegion var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HideMemberCondition {
        Never,
        IfBlankName,
        IfParentsName;

    }
}

