/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mondrian.olap.Axis;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.util.UnsupportedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapAxis
implements Axis {
    private static final Logger LOGGER = Logger.getLogger(RolapAxis.class);

    public static String toString(Axis axis) {
        List<Position> pl = axis.getPositions();
        return RolapAxis.toString(pl);
    }

    public static String toString(List<Position> pl) {
        StringBuilder buf = new StringBuilder();
        for (Position p : pl) {
            buf.append('{');
            boolean firstTime = true;
            for (Member m : p) {
                if (!firstTime) {
                    buf.append(", ");
                }
                buf.append(m.getUniqueName());
                firstTime = false;
            }
            buf.append('}');
            buf.append('\n');
        }
        return buf.toString();
    }

    protected RolapAxis() {
    }

    @Override
    public abstract List<Position> getPositions();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionListBase
    extends PositionListUnsupported {
        protected PositionListBase() {
        }

        @Override
        public abstract int size();

        @Override
        public abstract Position get(int var1);

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public ListIterator<Position> listIterator() {
            return new UnsupportedList.ListItr(this, 0);
        }

        @Override
        public ListIterator<Position> listIterator(int index) {
            return new UnsupportedList.ListItr(this, index);
        }

        @Override
        public Iterator<Position> iterator() {
            return new UnsupportedList.Itr(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionIterBase
    extends PositionListUnsupported {
        protected PositionIterBase() {
        }

        @Override
        public abstract Iterator<Position> iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionListUnsupported
    extends UnsupportedList<Position> {
        protected PositionListUnsupported() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionBase
    extends PositionUnsupported {
        protected PositionBase() {
        }

        @Override
        public ListIterator<Member> listIterator() {
            return new UnsupportedList.ListItr(this, 0);
        }

        @Override
        public ListIterator<Member> listIterator(int index) {
            return new UnsupportedList.ListItr(this, index);
        }

        @Override
        public Iterator<Member> iterator() {
            return new UnsupportedList.Itr(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionUnsupported
    extends UnsupportedList<Member>
    implements Position {
        protected PositionUnsupported() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberArrayList
    extends RolapAxis {
        private final List<Member[]> list;
        private final int len;

        public MemberArrayList(List<Member[]> list) {
            this.list = list;
            this.len = list.size() == 0 ? 0 : list.get(0).length;
        }

        @Override
        public List<Position> getPositions() {
            return new PositionList();
        }

        class MALPosition
        extends PositionBase {
            protected final int offset;

            MALPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return MemberArrayList.this.len;
            }

            public Member get(int index) {
                if (index > MemberArrayList.this.len) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + MemberArrayList.this.len);
                }
                return ((Member[])MemberArrayList.this.list.get(this.offset))[index];
            }
        }

        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberArrayList.this.list.size();
            }

            public Position get(int index) {
                return new MALPosition(index);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberArrayIterable
    extends RolapAxis {
        private Iterable<Member[]> iter;
        private List<Member[]> list;
        private int len;

        public MemberArrayIterable(Iterable<Member[]> iter) {
            this.iter = iter;
            this.list = null;
            this.len = 0;
        }

        @Override
        public synchronized List<Position> getPositions() {
            return this.list == null ? new PositionWrapper() : new PositionList();
        }

        protected synchronized void materialize() {
            if (this.list == null) {
                Iterator<Member[]> it = this.iter.iterator();
                this.list = new ArrayList<Member[]>();
                while (it.hasNext()) {
                    this.list.add(it.next());
                }
                this.iter = null;
                this.len = this.list.size() == 0 ? 0 : this.list.get(0).length;
            }
        }

        class MALPosition
        extends PositionBase {
            protected final int offset;

            MALPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return MemberArrayIterable.this.len;
            }

            public Member get(int index) {
                if (index > MemberArrayIterable.this.len) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + MemberArrayIterable.this.len);
                }
                return ((Member[])MemberArrayIterable.this.list.get(this.offset))[index];
            }
        }

        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberArrayIterable.this.list.size();
            }

            public Position get(int index) {
                return new MALPosition(index);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MIPosition
        extends PositionBase {
            Member[] members;

            MIPosition(Member[] members) {
                this.members = members;
            }

            @Override
            public int size() {
                return this.members.length;
            }

            @Override
            public Member get(int index) {
                return this.members[index];
            }

            @Override
            public Iterator<Member> iterator() {
                return new Iterator<Member>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MIPosition.this.members.length;
                    }

                    @Override
                    public Member next() {
                        return MIPosition.this.members[this.index++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionIter
        extends PositionIterBase {
            private Iterator<Member[]> it;

            PositionIter() {
                this.it = MemberArrayIterable.this.iter.iterator();
            }

            @Override
            public Iterator<Position> iterator() {
                return new Iterator<Position>(){
                    int nextCnt = 0;

                    @Override
                    public boolean hasNext() {
                        return PositionIter.this.it.hasNext();
                    }

                    @Override
                    public Position next() {
                        ++this.nextCnt;
                        return new MIPosition((Member[])PositionIter.this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionWrapper
        extends PositionListUnsupported {
            List<Position> positionList;

            PositionWrapper() {
                this.positionList = new PositionIter();
            }

            protected synchronized void materialize() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("PositionWrapper.materialize: Member[] iter.class=" + MemberArrayIterable.this.iter.getClass().getName()));
                }
                MemberArrayIterable.this.materialize();
                this.positionList = new PositionList();
            }

            @Override
            public int size() {
                try {
                    return this.positionList.size();
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.size();
                }
            }

            @Override
            public Position get(int index) {
                try {
                    return this.positionList.get(index);
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.get(index);
                }
            }

            @Override
            public Iterator<Position> iterator() {
                return this.positionList.iterator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberList
    extends RolapAxis {
        private final List<Member> list;

        public MemberList(List<Member> list) {
            this.list = list;
        }

        @Override
        public List<Position> getPositions() {
            return new PositionList();
        }

        class MLPosition
        extends PositionBase {
            protected final int offset;

            MLPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return 1;
            }

            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
                }
                return (Member)MemberList.this.list.get(this.offset);
            }
        }

        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberList.this.list.size();
            }

            public Position get(int index) {
                return new MLPosition(index);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberIterable
    extends RolapAxis {
        private Iterable<Member> iter;
        private List<Member> list;

        public MemberIterable(Iterable<Member> iter) {
            this.iter = iter;
            this.list = null;
        }

        @Override
        public synchronized List<Position> getPositions() {
            return this.list == null ? new PositionWrapper() : new PositionList();
        }

        protected synchronized void materialize() {
            if (this.list == null) {
                Iterator<Member> it = this.iter.iterator();
                this.list = new ArrayList<Member>();
                while (it.hasNext()) {
                    this.list.add(it.next());
                }
                this.iter = null;
            }
        }

        class MLPosition
        extends PositionBase {
            protected final int offset;

            MLPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return 1;
            }

            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
                }
                return (Member)MemberIterable.this.list.get(this.offset);
            }
        }

        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberIterable.this.list.size();
            }

            public Position get(int index) {
                return new MLPosition(index);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MIPosition
        extends PositionBase {
            Member member;

            MIPosition(Member member) {
                this.member = member;
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
                }
                return this.member;
            }

            @Override
            public Iterator<Member> iterator() {
                return new Iterator<Member>(){

                    @Override
                    public boolean hasNext() {
                        return MIPosition.this.member != null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Member next() {
                        try {
                            Member member = MIPosition.this.member;
                            return member;
                        }
                        finally {
                            MIPosition.this.member = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionIter
        extends PositionIterBase {
            private Iterator<Member> it;

            PositionIter() {
                this.it = MemberIterable.this.iter.iterator();
            }

            @Override
            public Iterator<Position> iterator() {
                return new Iterator<Position>(){

                    @Override
                    public boolean hasNext() {
                        return PositionIter.this.it.hasNext();
                    }

                    @Override
                    public Position next() {
                        return new MIPosition((Member)PositionIter.this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionWrapper
        extends PositionListUnsupported {
            List<Position> positionList;

            PositionWrapper() {
                this.positionList = new PositionIter();
            }

            protected synchronized void materialize() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("PositionWrapper.materialize: Member iter.class=" + MemberIterable.this.iter.getClass().getName()));
                }
                MemberIterable.this.materialize();
                this.positionList = new PositionList();
            }

            @Override
            public int size() {
                try {
                    return this.positionList.size();
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.size();
                }
            }

            @Override
            public Position get(int index) {
                try {
                    return this.positionList.get(index);
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.get(index);
                }
            }

            @Override
            public Iterator<Position> iterator() {
                return this.positionList.iterator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleEmptyPosition
    extends RolapAxis {
        @Override
        public List<Position> getPositions() {
            return Collections.singletonList(new EmptyPosition());
        }

        static class EmptyPosition
        extends PositionBase {
            EmptyPosition() {
            }

            public int size() {
                return 0;
            }

            public Member get(int index) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PositionList
    extends RolapAxis {
        protected final List<Position> positions;

        public PositionList(List<Position> positions) {
            this.positions = positions;
        }

        @Override
        public List<Position> getPositions() {
            return this.positions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoPosition
    extends RolapAxis {
        @Override
        public List<Position> getPositions() {
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Wrapper
    extends RolapAxis {
        private final Axis axis;

        protected Wrapper(Axis axis) {
            this.axis = axis;
        }

        @Override
        public List<Position> getPositions() {
            return this.axis.getPositions();
        }
    }
}

