/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import javax.olap.OLAPException;
import javax.olap.query.enumerations.DimensionStepType;
import javax.olap.query.enumerations.DimensionStepTypeEnum;
import javax.olap.query.querycoremodel.CompoundDimensionStep;
import javax.olap.query.querycoremodel.DimensionStep;
import javax.olap.query.querycoremodel.DimensionStepManager;
import mondrian.jolap.MondrianAttributeFilter;
import mondrian.jolap.MondrianDimensionStepManager;
import mondrian.jolap.MondrianDrillFilter;
import mondrian.jolap.MondrianExceptionMemberFilter;
import mondrian.jolap.MondrianHierarchyFilter;
import mondrian.jolap.MondrianLevelFilter;
import mondrian.jolap.MondrianRankingMemberFilter;
import mondrian.jolap.QueryObjectSupport;
import mondrian.olap.Exp;
import mondrian.olap.Util;

abstract class MondrianDimensionStep
extends QueryObjectSupport
implements DimensionStep {
    private MondrianDimensionStepManager manager;

    MondrianDimensionStep(MondrianDimensionStepManager manager) {
        super(true);
        this.manager = manager;
    }

    abstract Exp convert(Exp var1) throws OLAPException;

    static DimensionStep create(MondrianDimensionStepManager stepManager, DimensionStepType stepType) {
        if (stepType == DimensionStepTypeEnum.ATTRIBUTE_FILTER) {
            return new MondrianAttributeFilter(stepManager);
        }
        if (stepType == DimensionStepTypeEnum.ATTRIBUTE_SORT) {
            throw new UnsupportedOperationException();
        }
        if (stepType == DimensionStepTypeEnum.COMPOUND_DIMENSION_STEP) {
            throw new UnsupportedOperationException();
        }
        if (stepType == DimensionStepTypeEnum.DATA_BASED_SORT) {
            throw new UnsupportedOperationException();
        }
        if (stepType == DimensionStepTypeEnum.DRILL_FILTER) {
            return new MondrianDrillFilter(stepManager);
        }
        if (stepType == DimensionStepTypeEnum.EXCEPTION_MEMBER_FILTER) {
            return new MondrianExceptionMemberFilter(stepManager);
        }
        if (stepType == DimensionStepTypeEnum.HIERARCHY_MEMBER_FILTER) {
            return new MondrianHierarchyFilter(stepManager);
        }
        if (stepType == DimensionStepTypeEnum.HIERARCHICAL_SORT) {
            return new MondrianHierarchyFilter(stepManager);
        }
        if (stepType == DimensionStepTypeEnum.LEVEL_FILTER) {
            return new MondrianLevelFilter(stepManager);
        }
        if (stepType == DimensionStepTypeEnum.MEMBER_LIST_FILTER) {
            throw new UnsupportedOperationException();
        }
        if (stepType == DimensionStepTypeEnum.RANKING_MEMBER_FILTER) {
            return new MondrianRankingMemberFilter(stepManager);
        }
        if (stepType == DimensionStepTypeEnum.SINGLE_MEMBER_FILTER) {
            throw new UnsupportedOperationException();
        }
        throw Util.newInternal("Unknown DimensionStepType " + stepType);
    }

    public DimensionStepManager getDimensionStepManager() throws OLAPException {
        return this.manager;
    }

    public CompoundDimensionStep getCompoundDimensionStep() throws OLAPException {
        throw new UnsupportedOperationException();
    }
}

