/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import mondrian.gui.JDBCMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.SchemaTreeModel;
import org.eigenbase.xom.ElementDef;

public class SchemaTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final ClassLoader myClassLoader = this.getClass().getClassLoader();
    public boolean invalidFlag;
    private JDBCMetaData jdbcMetaData;

    public SchemaTreeCellRenderer(JDBCMetaData jdbcMetaData) {
        this();
        this.jdbcMetaData = jdbcMetaData;
    }

    public SchemaTreeCellRenderer() {
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ResourceBundle resources = ResourceBundle.getBundle("mondrian.gui.resources.gui");
        this.invalidFlag = this.isInvalid(tree, value, row);
        this.setPreferredSize(null);
        if (value instanceof MondrianGuiDef.Cube) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Cube)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("cube"))));
        } else if (value instanceof MondrianGuiDef.Column) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Column)((Object)value)).name);
        } else if (value instanceof MondrianGuiDef.Dimension) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("dimension"))));
            this.setText(this.invalidFlag, ((MondrianGuiDef.CubeDimension)((Object)value)).name);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.DimensionUsage) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("dimensionUsage"))));
            this.setText(this.invalidFlag, ((MondrianGuiDef.CubeDimension)((Object)value)).name);
        } else if (value instanceof MondrianGuiDef.KeyExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("key"))));
            this.setText("Key Expression");
        } else if (value instanceof MondrianGuiDef.NameExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("name"))));
            this.setText("Name Expression");
        } else if (value instanceof MondrianGuiDef.OrdinalExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("ordinal"))));
            this.setText("Ordinal Expression");
        } else if (value instanceof MondrianGuiDef.ParentExpression) {
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("parent"))));
            this.setText("Parent Expression");
        } else if (value instanceof MondrianGuiDef.Expression) {
            this.setText("Expression");
        } else if (value instanceof MondrianGuiDef.ExpressionView) {
            this.setText("ExpressionView");
        } else if (value instanceof MondrianGuiDef.Hierarchy) {
            this.setText(this.invalidFlag, "Hierarchy");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("hierarchy"))));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.Relation || value instanceof MondrianGuiDef.Table) {
            Object parent;
            TreePath parentpath;
            TreePath tpath = tree.getPathForRow(row);
            String prefix = "";
            if (tpath != null && (parentpath = tpath.getParentPath()) != null && (parent = parentpath.getLastPathComponent()) instanceof MondrianGuiDef.Join) {
                int indexOfChild = tree.getModel().getIndexOfChild(parent, value);
                switch (indexOfChild) {
                    case 0: {
                        prefix = "Left : ";
                        break;
                    }
                    case 1: {
                        prefix = "Right : ";
                    }
                }
            }
            if (value instanceof MondrianGuiDef.Join) {
                this.setText(prefix + "Join");
                super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("join"))));
            } else if (value instanceof MondrianGuiDef.Table) {
                this.setText(prefix + "Table: " + ((MondrianGuiDef.Table)((Object)value)).name);
                super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("table"))));
            }
            this.getPreferredSize();
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 35, 24));
        } else if (value instanceof MondrianGuiDef.Level) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Level)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("level"))));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.Measure) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Measure)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("measure"))));
        } else if (value instanceof MondrianGuiDef.MemberReaderParameter) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.MemberReaderParameter)((Object)value)).name);
        } else if (value instanceof MondrianGuiDef.Property) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Property)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("property"))));
        } else if (value instanceof MondrianGuiDef.Schema) {
            this.setText(this.invalidFlag, "Schema");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("schema"))));
        } else if (value instanceof MondrianGuiDef.NamedSet) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.NamedSet)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("namedSet"))));
        } else if (value instanceof MondrianGuiDef.CalculatedMember) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.CalculatedMember)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("calculatedMember"))));
        } else if (value instanceof MondrianGuiDef.CalculatedMemberProperty) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.CalculatedMemberProperty)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("nopic"))));
        } else if (value instanceof MondrianGuiDef.UserDefinedFunction) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.UserDefinedFunction)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("userDefinedFunction"))));
        } else if (value instanceof MondrianGuiDef.Role) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Role)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("role"))));
        } else if (value instanceof MondrianGuiDef.SchemaGrant) {
            this.setText(this.invalidFlag, "Schema Grant");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("schemaGrant"))));
        } else if (value instanceof MondrianGuiDef.CubeGrant) {
            this.setText(this.invalidFlag, "Cube Grant");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("cubeGrant"))));
        } else if (value instanceof MondrianGuiDef.DimensionGrant) {
            this.setText(this.invalidFlag, "Dimension Grant");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("dimensionGrant"))));
        } else if (value instanceof MondrianGuiDef.HierarchyGrant) {
            this.setText(this.invalidFlag, "Hierarchy Grant");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("hierarchyGrant"))));
        } else if (value instanceof MondrianGuiDef.MemberGrant) {
            this.setText(this.invalidFlag, "Member Grant");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("memberGrant"))));
        } else if (value instanceof MondrianGuiDef.SQL) {
            this.setText("SQL");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("sql"))));
        } else if (value instanceof MondrianGuiDef.View) {
            this.setText("View");
        } else if (value instanceof MondrianGuiDef.VirtualCube) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCube)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("virtualCube"))));
        } else if (value instanceof MondrianGuiDef.VirtualCubeDimension) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCubeDimension)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("virtualCubeDimension"))));
        } else if (value instanceof MondrianGuiDef.VirtualCubeMeasure) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCubeMeasure)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("virtualCubeMeasure"))));
        } else if (value instanceof MondrianGuiDef.AggName) {
            this.setText(this.invalidFlag, "Aggregate Name");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("aggTable"))));
        } else if (value instanceof MondrianGuiDef.AggForeignKey) {
            this.setText(this.invalidFlag, "Aggregate Foreign Key");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("aggForeignKey"))));
        } else if (value instanceof MondrianGuiDef.AggIgnoreColumn) {
            this.setText(this.invalidFlag, "Aggregate Ignore Column");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("aggIgnoreColumn"))));
        } else if (value instanceof MondrianGuiDef.AggLevel) {
            this.setText(this.invalidFlag, "Aggregate Level");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("aggLevel"))));
        } else if (value instanceof MondrianGuiDef.AggMeasure) {
            this.setText(this.invalidFlag, "Aggregate Measure");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("aggMeasure"))));
        } else if (value instanceof MondrianGuiDef.AggPattern) {
            this.setText(this.invalidFlag, "Aggregate Pattern");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("aggPattern"))));
        } else if (value instanceof MondrianGuiDef.AggExclude) {
            this.setText(this.invalidFlag, "Aggregate Exclude");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("aggExclude"))));
        } else if (value instanceof MondrianGuiDef.Closure) {
            this.setText(this.invalidFlag, "Closure");
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("closure"))));
        } else if (value instanceof ElementDef) {
            this.setText(((ElementDef)value).getName());
        } else {
            super.setText("");
        }
        return this;
    }

    public String invalid(JTree tree, TreePath tpath, Object value) {
        return this.invalid(tree, tpath, value, null, null, null, null);
    }

    public String invalid(JTree tree, TreePath tpath, Object value, Object icube, Object iparentDimension, Object iparentHierarchy, Object iparentLevel) {
        String errMsg = null;
        String nameLiteral = "Name";
        String emptyMsg = " must be set";
        MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)icube);
        MondrianGuiDef.Dimension parentDimension = (MondrianGuiDef.Dimension)((Object)iparentDimension);
        MondrianGuiDef.Hierarchy parentHierarchy = (MondrianGuiDef.Hierarchy)((Object)iparentHierarchy);
        MondrianGuiDef.Level parentLevel = (MondrianGuiDef.Level)((Object)iparentLevel);
        if (tpath != null) {
            int pathcount = tpath.getPathCount();
            for (int i = 0; i < pathcount && (cube == null || parentDimension == null || parentHierarchy == null || parentLevel == null); ++i) {
                if (tpath.getPathComponent(i) instanceof MondrianGuiDef.Cube && cube == null) {
                    cube = (MondrianGuiDef.Cube)((Object)tpath.getPathComponent(i));
                }
                if (tpath.getPathComponent(i) instanceof MondrianGuiDef.Dimension && parentDimension == null) {
                    parentDimension = (MondrianGuiDef.Dimension)((Object)tpath.getPathComponent(i));
                }
                if (tpath.getPathComponent(i) instanceof MondrianGuiDef.Hierarchy && parentHierarchy == null) {
                    parentHierarchy = (MondrianGuiDef.Hierarchy)((Object)tpath.getPathComponent(i));
                }
                if (!(tpath.getPathComponent(i) instanceof MondrianGuiDef.Level) || parentLevel != null) continue;
                parentLevel = (MondrianGuiDef.Level)((Object)tpath.getPathComponent(i));
            }
        }
        if (value instanceof MondrianGuiDef.Schema) {
            if (this.isEmpty(((MondrianGuiDef.Schema)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
        } else if (value instanceof MondrianGuiDef.VirtualCube) {
            if (this.isEmpty(((MondrianGuiDef.VirtualCube)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
        } else if (value instanceof MondrianGuiDef.VirtualCubeDimension) {
            if (this.isEmpty(((MondrianGuiDef.VirtualCubeDimension)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
        } else if (value instanceof MondrianGuiDef.VirtualCubeMeasure) {
            if (this.isEmpty(((MondrianGuiDef.VirtualCubeMeasure)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
        } else if (value instanceof MondrianGuiDef.Cube) {
            String factTable;
            String schemaName;
            if (this.isEmpty(((MondrianGuiDef.Cube)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
            if (((MondrianGuiDef.Cube)((Object)value)).fact == null || this.isEmpty(((MondrianGuiDef.Table)((MondrianGuiDef.Cube)((Object)value)).fact).name)) {
                return "Fact name" + emptyMsg;
            }
            if (this.jdbcMetaData.getErrMsg() == null && !this.jdbcMetaData.isTableExists(schemaName = ((MondrianGuiDef.Table)((MondrianGuiDef.Cube)((Object)value)).fact).schema, factTable = ((MondrianGuiDef.Table)((MondrianGuiDef.Cube)((Object)value)).fact).name)) {
                return "Fact table '" + factTable + "' does not exist in database " + (schemaName == null || schemaName.equals("") ? "." : "schema " + schemaName);
            }
        } else if (value instanceof MondrianGuiDef.CubeDimension) {
            String foreignKey;
            if (this.isEmpty(((MondrianGuiDef.CubeDimension)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
            if (value instanceof MondrianGuiDef.DimensionUsage) {
                if (this.isEmpty(((MondrianGuiDef.DimensionUsage)((Object)value)).source)) {
                    return "Source" + emptyMsg;
                }
                MondrianGuiDef.Schema s = (MondrianGuiDef.Schema)((Object)tree.getModel().getRoot());
                MondrianGuiDef.Dimension[] ds = s.dimensions;
                String sourcename = ((MondrianGuiDef.DimensionUsage)((Object)value)).source;
                boolean notfound = true;
                for (int j = 0; j < ds.length; ++j) {
                    if (!ds[j].name.equalsIgnoreCase(sourcename)) continue;
                    notfound = false;
                    break;
                }
                if (notfound) {
                    return "Source '" + sourcename + "' does not exist as Shared Dimension of Schema";
                }
            }
            if (value instanceof MondrianGuiDef.Dimension && cube != null && !this.isEmpty(((MondrianGuiDef.Dimension)((Object)value)).foreignKey) && this.jdbcMetaData.getErrMsg() == null && !this.jdbcMetaData.isColExists(((MondrianGuiDef.Table)cube.fact).schema, ((MondrianGuiDef.Table)cube.fact).name, foreignKey = ((MondrianGuiDef.Dimension)((Object)value)).foreignKey)) {
                return "foreignKey '" + foreignKey + "' does not exist in fact table.";
            }
        } else if (value instanceof MondrianGuiDef.Level) {
            String column;
            MondrianGuiDef.Level l = (MondrianGuiDef.Level)((Object)value);
            if (!this.isEmpty(l.levelType) && parentDimension != null) {
                if ((this.isEmpty(parentDimension.type) || parentDimension.type.equals("StandardDimension")) && !l.levelType.equals(MondrianGuiDef.Level._levelType_values[0])) {
                    return "levelType '" + l.levelType + "' can only be used with a TimeDimension.";
                }
                if (parentDimension.type.equals("TimeDimension") && l.levelType.equals(MondrianGuiDef.Level._levelType_values[0])) {
                    return "levelType '" + l.levelType + "' can only be used with a StandardDimension.";
                }
            }
            if (this.isEmpty(column = l.column)) {
                if (l.properties == null || l.properties.length == 0) {
                    return "column" + emptyMsg;
                }
            } else if (this.jdbcMetaData.getErrMsg() == null) {
                String table = l.table;
                if (this.isEmpty(table)) {
                    if (parentHierarchy != null) {
                        if (parentHierarchy.relation == null && cube != null) {
                            if (!this.jdbcMetaData.isColExists(((MondrianGuiDef.Table)cube.fact).schema, ((MondrianGuiDef.Table)cube.fact).name, column)) {
                                return "Degenerate dimension validation check - Column '" + column + "' does not exist in fact table.";
                            }
                        } else if (parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                            if (!this.jdbcMetaData.isColExists(((MondrianGuiDef.Table)parentHierarchy.relation).schema, ((MondrianGuiDef.Table)parentHierarchy.relation).name, column)) {
                                return "column '" + column + "' does not exist in Dimension table '" + ((MondrianGuiDef.Table)parentHierarchy.relation).name + "'.";
                            }
                        } else if (parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                            return "table" + emptyMsg;
                        }
                    }
                } else if (!this.jdbcMetaData.isColExists(null, table, column)) {
                    return "column '" + column + "' does not exist in table '" + table + "'.";
                }
            }
        } else if (value instanceof MondrianGuiDef.Property) {
            MondrianGuiDef.Property p = (MondrianGuiDef.Property)((Object)value);
            String column = p.column;
            if (this.isEmpty(column)) {
                return "column" + emptyMsg;
            }
            if (this.jdbcMetaData.getErrMsg() == null) {
                String table = null;
                if (parentLevel != null) {
                    table = parentLevel.table;
                }
                if (this.isEmpty(table)) {
                    if (parentHierarchy != null) {
                        if (parentHierarchy.relation == null && cube != null) {
                            if (!this.jdbcMetaData.isColExists(((MondrianGuiDef.Table)cube.fact).schema, ((MondrianGuiDef.Table)cube.fact).name, column)) {
                                return "Degenerate dimension validation check - Column '" + column + "' does not exist in fact table.";
                            }
                        } else if (parentHierarchy.relation instanceof MondrianGuiDef.Table && !this.jdbcMetaData.isColExists(((MondrianGuiDef.Table)parentHierarchy.relation).schema, ((MondrianGuiDef.Table)parentHierarchy.relation).name, column)) {
                            return "column '" + column + "' does not exist in Dimension table '" + ((MondrianGuiDef.Table)parentHierarchy.relation).name + "'.";
                        }
                    }
                } else if (!this.jdbcMetaData.isColExists(null, table, column)) {
                    return "column '" + column + "' does not exist in Level table '" + table + "'.";
                }
            }
        } else if (value instanceof MondrianGuiDef.Measure) {
            String column;
            if (this.isEmpty(((MondrianGuiDef.Measure)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
            if (this.isEmpty(((MondrianGuiDef.Measure)((Object)value)).aggregator)) {
                return "aggregator" + emptyMsg;
            }
            if (this.isEmpty(((MondrianGuiDef.Measure)((Object)value)).column)) {
                return "column" + emptyMsg;
            }
            if (cube != null && cube.fact != null && this.jdbcMetaData.getErrMsg() == null && this.jdbcMetaData.isColExists(((MondrianGuiDef.Table)cube.fact).schema, ((MondrianGuiDef.Table)cube.fact).name, column = ((MondrianGuiDef.Measure)((Object)value)).column)) {
                int colType = this.jdbcMetaData.getColumnDataType(((MondrianGuiDef.Table)cube.fact).schema, ((MondrianGuiDef.Table)cube.fact).name, ((MondrianGuiDef.Measure)((Object)value)).column);
                int agIndex = -1;
                if ("sum".equals(((MondrianGuiDef.Measure)((Object)value)).aggregator) || "avg".equals(((MondrianGuiDef.Measure)((Object)value)).aggregator)) {
                    agIndex = 0;
                }
                if (agIndex != -1 && (colType < 2 || colType > 8)) {
                    return "aggregator '" + ((MondrianGuiDef.Measure)((Object)value)).aggregator + "' is not valid on the data type of the column '" + ((MondrianGuiDef.Measure)((Object)value)).column + "'";
                }
            }
        } else if (value instanceof MondrianGuiDef.Hierarchy) {
            if (((MondrianGuiDef.Hierarchy)((Object)value)).relation instanceof MondrianGuiDef.Join) {
                String returnMsg = "";
                if (this.isEmpty(((MondrianGuiDef.Hierarchy)((Object)value)).primaryKeyTable)) {
                    returnMsg = "primaryKeyTable ";
                }
                if (this.isEmpty(((MondrianGuiDef.Hierarchy)((Object)value)).primaryKey)) {
                    if (returnMsg.length() > 0) {
                        returnMsg = returnMsg + "and";
                    }
                    returnMsg = returnMsg + " primaryKey ";
                }
                if (returnMsg.length() > 0) {
                    return returnMsg + emptyMsg + " for Join";
                }
            }
        } else if (value instanceof MondrianGuiDef.NamedSet) {
            if (this.isEmpty(((MondrianGuiDef.NamedSet)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
            if (this.isEmpty(((MondrianGuiDef.NamedSet)((Object)value)).formula)) {
                return "formula " + emptyMsg;
            }
        } else if (value instanceof MondrianGuiDef.UserDefinedFunction) {
            if (this.isEmpty(((MondrianGuiDef.UserDefinedFunction)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
            if (this.isEmpty(((MondrianGuiDef.UserDefinedFunction)((Object)value)).className)) {
                return "className" + emptyMsg;
            }
        } else if (value instanceof MondrianGuiDef.CalculatedMember) {
            if (this.isEmpty(((MondrianGuiDef.CalculatedMember)((Object)value)).name)) {
                return nameLiteral + emptyMsg;
            }
            if (this.isEmpty(((MondrianGuiDef.CalculatedMember)((Object)value)).dimension)) {
                return "dimension" + emptyMsg;
            }
        } else if (value instanceof MondrianGuiDef.Join) {
            if (this.isEmpty(((MondrianGuiDef.Join)((Object)value)).leftKey)) {
                return "leftKey" + emptyMsg;
            }
            if (this.isEmpty(((MondrianGuiDef.Join)((Object)value)).rightKey)) {
                return "rightKey" + emptyMsg;
            }
        }
        SchemaTreeModel model = (SchemaTreeModel)tree.getModel();
        int childCnt = model.getChildCount(value);
        for (int i = 0; i < childCnt; ++i) {
            String childErrMsg;
            Object child = model.getChild(value, i);
            if (child instanceof MondrianGuiDef.Cube) {
                childErrMsg = this.invalid(tree, tpath, child, child, (Object)parentDimension, (Object)parentHierarchy, (Object)parentLevel);
            } else if (child instanceof MondrianGuiDef.Dimension) {
                childErrMsg = this.invalid(tree, tpath, child, (Object)cube, child, (Object)parentHierarchy, (Object)parentLevel);
            } else if (child instanceof MondrianGuiDef.Hierarchy) {
                if (value instanceof MondrianGuiDef.Dimension && cube != null && ((MondrianGuiDef.Hierarchy)((Object)child)).relation != null && this.isEmpty(((MondrianGuiDef.Dimension)((Object)value)).foreignKey)) {
                    return "foreignKey" + emptyMsg;
                }
                childErrMsg = this.invalid(tree, tpath, child, (Object)cube, (Object)parentDimension, child, (Object)parentLevel);
            } else {
                childErrMsg = child instanceof MondrianGuiDef.Level ? this.invalid(tree, tpath, child, (Object)cube, (Object)parentDimension, (Object)parentHierarchy, child) : this.invalid(tree, tpath, child, (Object)cube, (Object)parentDimension, (Object)parentHierarchy, (Object)parentLevel);
            }
            if (childErrMsg == null) continue;
            String childClassName = child.getClass().getName();
            String[] simpleName = childClassName.split("[$.]", 0);
            try {
                Field f = child.getClass().getField("name");
                String childName = (String)f.get(child);
                childName = childName == null ? "" : " '" + childName + "'";
                childErrMsg = simpleName[simpleName.length - 1] + " " + childName + " is invalid.";
            }
            catch (Exception ex) {
                childErrMsg = simpleName[simpleName.length - 1] + " is invalid.";
            }
            return childErrMsg;
        }
        return errMsg;
    }

    private boolean isEmpty(Object v) {
        return v == null || v.equals("");
    }

    private boolean isInvalid(JTree tree, Object value, int row) {
        return this.invalid(tree, tree.getPathForRow(row), value) != null;
    }

    public void setText(boolean invalidFlag, String myText) {
        if (invalidFlag) {
            myText = "<html><FONT COLOR=RED><b>x</b></FONT><FONT COLOR=" + this.getForeground().hashCode() + ">" + myText + "</FONT></html>";
        }
        this.setText(myText);
    }
}

