/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.StringMap;
import org.netbeans.editor.Utilities;

public class WordMatch
extends FinderFactory.AbstractFinder
implements SettingsChangeListener,
PropertyChangeListener {
    private static final Object NULL_DOC = new Object();
    private static final HashMap staticWordsDocs = new HashMap();
    char[] baseWord;
    char[] word = new char[20];
    String lastWord;
    String previousWord;
    int wordLen;
    StringMap wordsMap = new StringMap();
    ArrayList wordInfoList = new ArrayList();
    int wordsIndex;
    boolean forwardSearch;
    EditorUI editorUI;
    boolean wrapSearch;
    boolean matchCase;
    boolean smartCase;
    boolean realMatchCase;
    boolean matchOneChar;
    int maxSearchLen;
    BaseDocument startDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WordMatch(EditorUI editorUI) {
        this.editorUI = editorUI;
        Settings.addSettingsChangeListener(this);
        Object object = editorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = editorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(editorUI, "component", null, jTextComponent));
            }
            editorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz;
        if (settingsChangeEvent != null) {
            staticWordsDocs.clear();
        }
        if ((clazz = Utilities.getKitClass(this.editorUI.getComponent())) != null) {
            this.maxSearchLen = SettingsUtil.getInteger(clazz, "word-match-search-len", Integer.MAX_VALUE);
            this.wrapSearch = SettingsUtil.getBoolean(clazz, "word-match-wrap-search", true);
            this.matchOneChar = SettingsUtil.getBoolean(clazz, "word-match-match-one-char", true);
            this.matchCase = SettingsUtil.getBoolean(clazz, "word-match-match-case", false);
            this.smartCase = SettingsUtil.getBoolean(clazz, "word-match-smart-case", false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string) && (jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue()) != null) {
            this.settingsChange(null);
        }
    }

    public synchronized void clear() {
        if (this.baseWord != null) {
            this.baseWord = null;
            this.wordsMap.clear();
            this.wordInfoList.clear();
            this.wordsIndex = 0;
        }
    }

    public void reset() {
        super.reset();
        this.wordLen = 0;
    }

    public synchronized String getMatchWord(int n, boolean bl) {
        int n2 = this.wordInfoList.size();
        boolean bl2 = n2 == 0 || this.wordsIndex == (bl ? n2 - 1 : 0);
        this.startDoc = (BaseDocument)this.editorUI.getComponent().getDocument();
        String string = null;
        if (this.baseWord == null) {
            try {
                String string2 = Utilities.getIdentifierBefore(this.startDoc, n);
                if (string2 == null) {
                    string2 = "";
                }
                this.lastWord = string2;
                this.baseWord = string2.toCharArray();
                WordInfo wordInfo = new WordInfo(string2, this.startDoc.createPosition(n - this.baseWord.length), this.startDoc);
                this.wordsMap.put(wordInfo.word, wordInfo);
                this.wordInfoList.add(wordInfo);
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
            if (this.smartCase && !this.matchCase) {
                this.realMatchCase = false;
                for (int i = 0; i < this.baseWord.length; ++i) {
                    if (!Character.isUpperCase(this.baseWord[i])) continue;
                    this.realMatchCase = true;
                }
            } else {
                this.realMatchCase = this.matchCase;
            }
            if (!this.realMatchCase) {
                for (int i = 0; i < this.baseWord.length; ++i) {
                    this.baseWord[i] = Character.toLowerCase(this.baseWord[i]);
                }
            }
        }
        if (bl2) {
            try {
                int n3;
                BaseDocument baseDocument;
                if (n2 > 0) {
                    WordInfo wordInfo = (WordInfo)this.wordInfoList.get(this.wordsIndex);
                    baseDocument = wordInfo.doc;
                    n3 = wordInfo.pos.getOffset();
                    if (bl) {
                        n3 += wordInfo.word.length();
                    }
                } else {
                    baseDocument = this.startDoc;
                    n3 = n;
                }
                while (baseDocument != null) {
                    if (baseDocument.getLength() > 0) {
                        int n4 = baseDocument == this.startDoc ? (bl ? (n3 >= n ? -1 : n) : (n3 == -1 || n3 > n ? n : 0)) : -1;
                        this.forwardSearch = bl || baseDocument != this.startDoc;
                        int n5 = baseDocument.find(this, n3, n4);
                        if (n5 != -1) {
                            if (bl) {
                                ++this.wordsIndex;
                            }
                            WordInfo wordInfo = new WordInfo(new String(this.word, 0, this.wordLen), baseDocument.createPosition(n5), baseDocument);
                            this.wordsMap.put(wordInfo.word, wordInfo);
                            this.wordInfoList.add(this.wordsIndex, wordInfo);
                            this.previousWord = this.lastWord;
                            this.lastWord = wordInfo.word;
                            return this.lastWord;
                        }
                        if (baseDocument == this.startDoc) {
                            if (bl) {
                                n3 = 0;
                                if (n4 == -1 && this.wrapSearch) continue;
                                baseDocument = this.getNextDoc(baseDocument);
                                continue;
                            }
                            if (n3 == -1 || !this.wrapSearch) {
                                baseDocument = this.getNextDoc(baseDocument);
                                n3 = 0;
                                continue;
                            }
                            n3 = -1;
                            continue;
                        }
                        baseDocument = this.getNextDoc(baseDocument);
                        n3 = 0;
                        continue;
                    }
                    baseDocument = this.getNextDoc(baseDocument);
                    n3 = 0;
                }
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
        } else {
            this.wordsIndex += bl ? 1 : -1;
            this.previousWord = this.lastWord;
            string = this.lastWord = ((WordInfo)this.wordInfoList.get((int)this.wordsIndex)).word;
        }
        this.startDoc = null;
        return string;
    }

    public String getPreviousWord() {
        return this.previousWord;
    }

    private void doubleWordSize() {
        char[] cArray = new char[this.word.length * 2];
        System.arraycopy(this.word, 0, cArray, 0, this.word.length);
        this.word = cArray;
    }

    private boolean checkWord() {
        if (!this.matchOneChar && this.wordLen == 1) {
            return false;
        }
        if (this.baseWord.length > 0) {
            if (this.wordLen < this.baseWord.length) {
                return false;
            }
            for (int i = 0; i < this.baseWord.length; ++i) {
                if (!(this.realMatchCase ? this.word[i] != this.baseWord[i] : Character.toLowerCase(this.word[i]) != this.baseWord[i])) continue;
                return false;
            }
        }
        return !this.wordsMap.containsKey(this.word, 0, this.wordLen);
    }

    public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
        int n6;
        if (this.forwardSearch) {
            int n7 = n5 - n - 1;
            for (n6 = n4 - n; n6 < n3; ++n6) {
                char c = cArray[n6];
                boolean bl = this.startDoc.isIdentifierPart(c);
                if (bl) {
                    if (this.wordLen == this.word.length) {
                        this.doubleWordSize();
                    }
                    this.word[this.wordLen++] = c;
                }
                if (!bl) {
                    if (this.wordLen <= 0) continue;
                    if (this.checkWord()) {
                        this.found = true;
                        return n + n6 - this.wordLen;
                    }
                    this.wordLen = 0;
                    continue;
                }
                if (n7 != n6) continue;
                if (this.checkWord()) {
                    this.found = true;
                    return n + n6 - this.wordLen + 1;
                }
                this.wordLen = 0;
            }
        } else {
            int n8 = n5 - n;
            while (n6 >= n2) {
                char c = cArray[n6];
                boolean bl = this.startDoc.isIdentifierPart(c);
                if (bl) {
                    if (this.wordLen == this.word.length) {
                        this.doubleWordSize();
                    }
                    this.word[this.wordLen++] = c;
                }
                if (!(bl && n8 != n6 || this.wordLen <= 0)) {
                    Analyzer.reverse(this.word, this.wordLen);
                    if (this.checkWord()) {
                        this.found = true;
                        return bl ? n + n6 + 1 : n + n6;
                    }
                    this.wordLen = 0;
                }
                --n6;
            }
        }
        return n + n6;
    }

    private BaseDocument getNextDoc(BaseDocument baseDocument) {
        if (baseDocument == this.getStaticWordsDoc()) {
            return null;
        }
        BaseDocument baseDocument2 = Registry.getLessActiveDocument(baseDocument);
        if (baseDocument2 == null) {
            baseDocument2 = this.getStaticWordsDoc();
        }
        return baseDocument2;
    }

    private BaseDocument getStaticWordsDoc() {
        Class clazz = Utilities.getKitClass(this.editorUI.getComponent());
        Object v = staticWordsDocs.get(clazz);
        if (v == NULL_DOC) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)v;
        if (baseDocument == null) {
            String string = (String)Settings.getValue(clazz, "word-match-static-words");
            if (string != null) {
                baseDocument = new BaseDocument(BaseKit.class, false);
                try {
                    baseDocument.insertString(0, string, null);
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
                staticWordsDocs.put(clazz, baseDocument);
            } else {
                staticWordsDocs.put(clazz, NULL_DOC);
            }
        }
        return baseDocument;
    }

    public String toString() {
        return "baseWord=" + (this.baseWord != null ? "'" + this.baseWord.toString() + "'" : "null") + ", wrapSearch=" + this.wrapSearch + ", matchCase=" + this.matchCase + ", smartCase=" + this.smartCase + ", matchOneChar=" + this.matchOneChar + ", maxSearchLen=" + this.maxSearchLen + ", wordsMap=" + this.wordsMap + "\nwordInfoList=" + this.wordInfoList + "\nwordsIndex=" + this.wordsIndex;
    }

    private static final class WordInfo {
        String word;
        Position pos;
        BaseDocument doc;

        public WordInfo(String string, Position position, BaseDocument baseDocument) {
            this.word = string;
            this.pos = position;
            this.doc = baseDocument;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof WordMatch) {
                WordMatch wordMatch = (WordMatch)object;
                return Analyzer.equals(this.word, wordMatch.word, 0, wordMatch.wordLen);
            }
            if (object instanceof WordInfo) {
                return this.word.equals(((WordInfo)object).word);
            }
            if (object instanceof String) {
                return this.word.equals(object);
            }
            return false;
        }

        public int hashCode() {
            return this.word.hashCode();
        }

        public String toString() {
            return "{word='" + this.word + "', pos=" + this.pos.getOffset() + ", doc=" + Registry.getID(this.doc) + "}";
        }
    }
}

