/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;

public class MarkChain {
    protected MarkFactory.ChainDrawMark chain;
    protected MarkFactory.ChainDrawMark curMark;
    protected BaseDocument doc;
    protected String layerName;
    private MarkFactory.ChainDrawMark recentlyAddedMark;

    public MarkChain(BaseDocument baseDocument, String string) {
        this.doc = baseDocument;
        this.layerName = string;
    }

    public final MarkFactory.ChainDrawMark getChain() {
        return this.chain;
    }

    public final MarkFactory.ChainDrawMark getCurMark() {
        return this.curMark;
    }

    public int compareMark(int n) {
        try {
            int n2;
            if (this.curMark == null) {
                this.curMark = this.chain;
                if (this.curMark == null) {
                    return -1;
                }
            }
            boolean bl = false;
            boolean bl2 = false;
            while ((n2 = this.curMark.compare(n)) != 0) {
                if (n2 > 0) {
                    if (bl2) {
                        return n2;
                    }
                    if (this.curMark.prev != null) {
                        bl = true;
                        this.curMark = this.curMark.prev;
                        continue;
                    }
                    return n2;
                }
                if (bl) {
                    return n2;
                }
                if (this.curMark.next != null) {
                    bl2 = true;
                    this.curMark = this.curMark.next;
                    continue;
                }
                return n2;
            }
            return 0;
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
            return -1;
        }
    }

    protected MarkFactory.ChainDrawMark createAndInsertNewMark(int n) throws BadLocationException {
        MarkFactory.ChainDrawMark chainDrawMark = this.createMark();
        try {
            chainDrawMark.insert(this.doc, n);
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
        }
        return chainDrawMark;
    }

    protected MarkFactory.ChainDrawMark createMark() {
        MarkFactory.ChainDrawMark chainDrawMark = new MarkFactory.ChainDrawMark(this.layerName, null, Position.Bias.Backward);
        chainDrawMark.activateLayer = true;
        return chainDrawMark;
    }

    public boolean addMark(int n) throws BadLocationException {
        return this.addMark(n, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addMark(int n, boolean bl) throws BadLocationException {
        MarkFactory.ChainDrawMark chainDrawMark;
        int n2 = this.compareMark(n);
        if (n2 == 0) {
            MarkFactory.ChainDrawMark chainDrawMark2;
            if (!bl) {
                this.recentlyAddedMark = this.curMark;
                return false;
            }
            this.recentlyAddedMark = chainDrawMark2 = this.createAndInsertNewMark(n);
            if (this.curMark == this.chain) {
                this.chain = this.curMark.insertChain(chainDrawMark2);
                return true;
            }
            this.curMark.insertChain(chainDrawMark2);
            return true;
        }
        if (n2 > 0) {
            MarkFactory.ChainDrawMark chainDrawMark3;
            this.recentlyAddedMark = chainDrawMark3 = this.createAndInsertNewMark(n);
            if (this.curMark == null) {
                this.chain = chainDrawMark3;
                return true;
            }
            if (this.curMark == this.chain) {
                this.chain = this.curMark.insertChain(chainDrawMark3);
                return true;
            }
            this.curMark.insertChain(chainDrawMark3);
            return true;
        }
        this.recentlyAddedMark = chainDrawMark = this.createAndInsertNewMark(n);
        if (this.curMark == null) {
            this.chain = chainDrawMark;
            return true;
        }
        if (this.curMark.next != null) {
            this.curMark.next.insertChain(chainDrawMark);
            return true;
        }
        this.curMark.setNextChain(chainDrawMark);
        return true;
    }

    public MarkFactory.ChainDrawMark getAddedMark() {
        return this.recentlyAddedMark;
    }

    public boolean removeMark(int n) {
        int n2 = this.compareMark(n);
        if (n2 == 0) {
            boolean bl = this.curMark == this.chain;
            this.curMark = this.curMark.removeChain();
            if (bl) {
                this.chain = this.curMark;
            }
            return true;
        }
        return false;
    }

    public boolean removeMark(MarkFactory.ChainDrawMark chainDrawMark) {
        if (chainDrawMark == null) {
            throw new NullPointerException();
        }
        if (this.curMark != chainDrawMark) {
            this.curMark = this.chain;
            while (this.curMark != null && this.curMark != chainDrawMark) {
                this.curMark = this.curMark.next;
            }
        }
        if (this.curMark != null) {
            boolean bl = this.curMark == this.chain;
            this.curMark = this.curMark.removeChain();
            if (bl) {
                this.chain = this.curMark;
            }
            return true;
        }
        return false;
    }

    public boolean isMark(int n) {
        return this.compareMark(n) == 0;
    }

    public boolean toggleMark(int n) throws BadLocationException {
        int n2 = this.compareMark(n);
        if (n2 == 0) {
            this.removeMark(n);
            return false;
        }
        this.addMark(n);
        return true;
    }

    public String toString() {
        return "MarkChain: curMark=" + this.curMark + ", mark chain: " + (this.chain != null ? "\n" + this.chain.toStringChain() : "Empty");
    }
}

