/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;

public class AnnotationType {
    private static final Logger LOG = Logger.getLogger(AnnotationType.class.getName());
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_VISIBLE = "visible";
    public static final String PROP_GLYPH_URL = "glyph";
    public static final String PROP_HIGHLIGHT_COLOR = "highlight";
    public static final String PROP_FOREGROUND_COLOR = "foreground";
    public static final String PROP_WAVEUNDERLINE_COLOR = "waveunderline";
    public static final String PROP_WHOLE_LINE = "wholeline";
    public static final String PROP_CONTENT_TYPE = "contenttype";
    public static final String PROP_ACTIONS = "actions";
    public static final String PROP_TOOLTIP_TEXT = "tooltipText";
    public static final String PROP_INHERIT_FOREGROUND_COLOR = "inheritForegroundColor";
    public static final String PROP_USE_HIGHLIGHT_COLOR = "useHighlightColor";
    public static final String PROP_USE_WAVEUNDERLINE_COLOR = "useWaveUnderlineColor";
    public static final String PROP_USE_CUSTOM_SIDEBAR_COLOR = "useCustomSidebarColor";
    public static final String PROP_CUSTOM_SIDEBAR_COLOR = "customSidebarColor";
    public static final String PROP_SEVERITY = "severity";
    public static final String PROP_BROWSEABLE = "browseable";
    public static final String PROP_PRIORITY = "priority";
    public static final String PROP_COMBINATIONS = "combinations";
    public static final String PROP_COMBINATION_ORDER = "combinationOrder";
    public static final String PROP_COMBINATION_MINIMUM_OPTIONALS = "combinationMinimumOptionals";
    public static final String PROP_FILE = "file";
    public static final String PROP_LOCALIZING_BUNDLE = "bundle";
    public static final String PROP_DESCRIPTION_KEY = "desciptionKey";
    public static final String PROP_ACTIONS_FOLDER = "actionsFolder";
    public static final String PROP_COMBINATION_TOOLTIP_TEXT_KEY = "tooltipTextKey";
    private Map properties = new HashMap(20);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Image img = null;
    private Coloring col;

    public URL getGlyph() {
        URL uRL = (URL)this.getProp(PROP_GLYPH_URL);
        if (uRL == null) {
            uRL = AnnotationTypes.getDefaultGlyphURL();
        }
        return uRL;
    }

    public void setGlyph(URL uRL) {
        this.putProp(PROP_GLYPH_URL, uRL);
    }

    public Image getGlyphImage() {
        if (this.img == null) {
            this.img = Toolkit.getDefaultToolkit().createImage(this.getGlyph());
            final boolean[] blArray = new boolean[]{true};
            if (!Toolkit.getDefaultToolkit().prepareImage(this.img, -1, -1, new ImageObserver(){

                public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                    if ((n & 0x20) == 32) {
                        blArray[0] = false;
                        return false;
                    }
                    return true;
                }
            })) {
                long l = System.currentTimeMillis();
                while (blArray[0] && System.currentTimeMillis() - l < 1000L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.img;
    }

    public boolean isDefaultGlyph() {
        return this.getProp(PROP_GLYPH_URL) == null;
    }

    public Color getHighlight() {
        return (Color)this.getProp(PROP_HIGHLIGHT_COLOR);
    }

    public void setHighlight(Color color) {
        this.col = null;
        this.putProp(PROP_HIGHLIGHT_COLOR, color);
        this.firePropertyChange(PROP_HIGHLIGHT_COLOR, null, null);
        this.processChange();
    }

    public boolean isUseHighlightColor() {
        Boolean bl = (Boolean)this.getProp(PROP_USE_HIGHLIGHT_COLOR);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setUseHighlightColor(boolean bl) {
        if (this.isUseHighlightColor() != bl) {
            this.col = null;
            this.putProp(PROP_USE_HIGHLIGHT_COLOR, bl ? Boolean.TRUE : Boolean.FALSE);
            this.firePropertyChange(PROP_USE_HIGHLIGHT_COLOR, null, null);
            this.processChange();
        }
    }

    public Color getForegroundColor() {
        return (Color)this.getProp(PROP_FOREGROUND_COLOR);
    }

    public void setForegroundColor(Color color) {
        this.col = null;
        this.putProp(PROP_FOREGROUND_COLOR, color);
        this.firePropertyChange(PROP_FOREGROUND_COLOR, null, null);
        this.processChange();
    }

    public boolean isInheritForegroundColor() {
        Boolean bl = (Boolean)this.getProp(PROP_INHERIT_FOREGROUND_COLOR);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setInheritForegroundColor(boolean bl) {
        if (this.isInheritForegroundColor() != bl) {
            this.col = null;
            this.putProp(PROP_INHERIT_FOREGROUND_COLOR, bl ? Boolean.TRUE : Boolean.FALSE);
            this.firePropertyChange(PROP_INHERIT_FOREGROUND_COLOR, null, null);
            this.processChange();
        }
    }

    public Color getWaveUnderlineColor() {
        return (Color)this.getProp(PROP_WAVEUNDERLINE_COLOR);
    }

    public void setWaveUnderlineColor(Color color) {
        this.col = null;
        this.putProp(PROP_WAVEUNDERLINE_COLOR, color);
        this.firePropertyChange(PROP_WAVEUNDERLINE_COLOR, null, null);
        this.processChange();
    }

    public boolean isUseWaveUnderlineColor() {
        Boolean bl = (Boolean)this.getProp(PROP_USE_WAVEUNDERLINE_COLOR);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setUseWaveUnderlineColor(boolean bl) {
        if (this.isUseWaveUnderlineColor() != bl) {
            this.col = null;
            this.putProp(PROP_USE_WAVEUNDERLINE_COLOR, bl ? Boolean.TRUE : Boolean.FALSE);
            this.firePropertyChange(PROP_USE_WAVEUNDERLINE_COLOR, null, null);
            this.processChange();
        }
    }

    private void processChange() {
        if (this.getProp(PROP_FILE) == null) {
            return;
        }
        Settings.touchValue(null, null);
        AnnotationTypes.getTypes().saveType(this);
    }

    public Coloring getColoring() {
        if (this.col == null) {
            this.col = new Coloring(null, 7, this.isInheritForegroundColor() ? null : this.getForegroundColor(), this.isUseHighlightColor() ? this.getHighlight() : null, null, null, this.isUseWaveUnderlineColor() ? this.getWaveUnderlineColor() : null);
        }
        return this.col;
    }

    public Action[] getActions() {
        return (Action[])this.getProp(PROP_ACTIONS);
    }

    public void setActions(Action[] actionArray) {
        this.putProp(PROP_ACTIONS, actionArray);
    }

    public CombinationMember[] getCombinations() {
        return (CombinationMember[])this.getProp(PROP_COMBINATIONS);
    }

    public void setCombinations(CombinationMember[] combinationMemberArray) {
        this.putProp(PROP_COMBINATIONS, combinationMemberArray);
    }

    public String getName() {
        return (String)this.getProp(PROP_NAME);
    }

    public void setName(String string) {
        this.putProp(PROP_NAME, string);
    }

    public String getDescription() {
        String string = (String)this.getProp(PROP_DESCRIPTION);
        if (string == null) {
            String string2 = (String)this.getProp(PROP_LOCALIZING_BUNDLE);
            String string3 = (String)this.getProp(PROP_DESCRIPTION_KEY);
            try {
                ResourceBundle resourceBundle = ImplementationProvider.getDefault().getResourceBundle(string2);
                string = resourceBundle.getString(string3);
            }
            catch (MissingResourceException missingResourceException) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Can't find '" + string3 + "' in " + string2 + " for AnnotationType '" + this.getName() + "'.");
                }
                string = string3;
            }
            this.setDescription(string);
        }
        return string;
    }

    public void setDescription(String string) {
        this.putProp(PROP_DESCRIPTION, string);
    }

    public String getTooltipText() {
        String string = (String)this.getProp(PROP_TOOLTIP_TEXT);
        if (string == null) {
            String string2 = (String)this.getProp(PROP_LOCALIZING_BUNDLE);
            String string3 = (String)this.getProp(PROP_COMBINATION_TOOLTIP_TEXT_KEY);
            ResourceBundle resourceBundle = ImplementationProvider.getDefault().getResourceBundle(string2);
            string = resourceBundle.getString(string3);
            this.setTooltipText(string);
        }
        return string;
    }

    public void setTooltipText(String string) {
        this.putProp(PROP_TOOLTIP_TEXT, string);
    }

    public int getCombinationOrder() {
        if (this.getProp(PROP_COMBINATION_ORDER) == null) {
            return 0;
        }
        return (Integer)this.getProp(PROP_COMBINATION_ORDER);
    }

    public void setCombinationOrder(int n) {
        this.putProp(PROP_COMBINATION_ORDER, new Integer(n));
    }

    public void setCombinationOrder(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Utilities.annotateLoggable(numberFormatException);
            return;
        }
        this.putProp(PROP_COMBINATION_ORDER, new Integer(n));
    }

    public int getMinimumOptionals() {
        if (this.getProp(PROP_COMBINATION_MINIMUM_OPTIONALS) == null) {
            return 0;
        }
        return (Integer)this.getProp(PROP_COMBINATION_MINIMUM_OPTIONALS);
    }

    public void setMinimumOptionals(int n) {
        this.putProp(PROP_COMBINATION_MINIMUM_OPTIONALS, new Integer(n));
    }

    public void setMinimumOptionals(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Utilities.annotateLoggable(numberFormatException);
            return;
        }
        this.putProp(PROP_COMBINATION_MINIMUM_OPTIONALS, new Integer(n));
    }

    public boolean isVisible() {
        Boolean bl = (Boolean)this.getProp(PROP_VISIBLE);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        this.putProp(PROP_VISIBLE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setVisible(String string) {
        this.putProp(PROP_VISIBLE, Boolean.valueOf(string));
    }

    public boolean isWholeLine() {
        Boolean bl = (Boolean)this.getProp(PROP_WHOLE_LINE);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setWholeLine(boolean bl) {
        this.putProp(PROP_WHOLE_LINE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setWholeLine(String string) {
        this.putProp(PROP_WHOLE_LINE, Boolean.valueOf(string));
    }

    public String getContentType() {
        return (String)this.getProp(PROP_CONTENT_TYPE);
    }

    public void setContentType(String string) {
        this.putProp(PROP_CONTENT_TYPE, string);
    }

    public boolean isUseCustomSidebarColor() {
        return (Boolean)this.getProp(PROP_USE_CUSTOM_SIDEBAR_COLOR);
    }

    public void setUseCustomSidebarColor(boolean bl) {
        this.putProp(PROP_USE_CUSTOM_SIDEBAR_COLOR, bl);
    }

    public Color getCustomSidebarColor() {
        return (Color)this.getProp(PROP_CUSTOM_SIDEBAR_COLOR);
    }

    public void setCustomSidebarColor(Color color) {
        this.putProp(PROP_CUSTOM_SIDEBAR_COLOR, color);
    }

    public Severity getSeverity() {
        return (Severity)this.getProp(PROP_SEVERITY);
    }

    public void setSeverity(Severity severity) {
        this.putProp(PROP_SEVERITY, severity);
    }

    public int getPriority() {
        return (Integer)this.getProp(PROP_PRIORITY);
    }

    public void setPriority(int n) {
        this.putProp(PROP_PRIORITY, new Integer(n));
    }

    public boolean isBrowseable() {
        return (Boolean)this.getProp(PROP_BROWSEABLE);
    }

    public void setBrowseable(boolean bl) {
        this.putProp(PROP_BROWSEABLE, bl);
    }

    public Object getProp(String string) {
        return this.properties.get(string);
    }

    public void putProp(Object object, Object object2) {
        if (object2 == null) {
            this.properties.remove(object);
            return;
        }
        this.properties.put(object, object2);
    }

    public String toString() {
        return "AnnotationType: name='" + this.getName() + "', description='" + this.getDescription() + "', visible=" + this.isVisible() + ", wholeline=" + this.isWholeLine() + ", glyph=" + this.getGlyph() + ", highlight=" + this.getHighlight() + ", foreground=" + this.getForegroundColor() + "', inheritForeground=" + this.isInheritForegroundColor() + ", contenttype=" + this.getContentType();
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    public static final class Severity
    implements Comparable {
        private static final int STATUS_NONE_NUMBER = 0;
        private static final int STATUS_OK_NUMBER = 1;
        private static final int STATUS_WARNING_NUMBER = 2;
        private static final int STATUS_ERROR_NUMBER = 3;
        public static final Severity STATUS_NONE = new Severity(0);
        public static final Severity STATUS_OK = new Severity(1);
        public static final Severity STATUS_WARNING = new Severity(2);
        public static final Severity STATUS_ERROR = new Severity(3);
        private static final Severity[] VALUES = new Severity[]{STATUS_NONE, STATUS_OK, STATUS_WARNING, STATUS_ERROR};
        private static final Color[] DEFAULT_STATUS_COLORS = new Color[]{Color.WHITE, Color.GREEN, Color.YELLOW, Color.RED};
        private int status;
        private static String[] STATUS_NAMES = new String[]{"none", "ok", "warning", "error"};

        private Severity(int n) throws IllegalArgumentException {
            if (n != 0 && n != 3 && n != 2 && n != 1) {
                throw new IllegalArgumentException("Invalid status provided: " + n);
            }
            this.status = n;
        }

        private int getStatus() {
            return this.status;
        }

        public int compareTo(Object object) {
            Severity severity = (Severity)object;
            if (this.status > severity.status) {
                return 1;
            }
            if (this.status < severity.status) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Severity)) {
                return false;
            }
            Severity severity = (Severity)object;
            return this.status == severity.status;
        }

        public int hashCode() {
            return 0x2B ^ this.status;
        }

        public String toString() {
            return "[Status: " + STATUS_NAMES[this.getStatus()] + "]";
        }

        public static Severity getCompoundStatus(Severity severity, Severity severity2) throws IllegalArgumentException {
            if (severity != STATUS_ERROR && severity != STATUS_WARNING && severity != STATUS_OK) {
                throw new IllegalArgumentException("Invalid status provided: " + severity);
            }
            if (severity2 != STATUS_ERROR && severity2 != STATUS_WARNING && severity2 != STATUS_OK) {
                throw new IllegalArgumentException("Invalid status provided: " + severity2);
            }
            return VALUES[Math.max(severity.getStatus(), severity2.getStatus())];
        }

        public static Color getDefaultColor(Severity severity) {
            return DEFAULT_STATUS_COLORS[severity.getStatus()];
        }

        public static Severity valueOf(String string) {
            Severity severity = STATUS_NONE;
            if (string != null) {
                if ("ok".equals(string)) {
                    severity = STATUS_OK;
                } else if ("warning".equals(string)) {
                    severity = STATUS_WARNING;
                } else if ("error".equals(string)) {
                    severity = STATUS_ERROR;
                }
            }
            return severity;
        }

        public String getName() {
            return STATUS_NAMES[this.status];
        }
    }

    public static final class CombinationMember {
        private String type;
        private boolean absorbAll;
        private boolean optional;
        private int minimumCount;

        public CombinationMember(String string, boolean bl, boolean bl2, int n) {
            this.type = string;
            this.absorbAll = bl;
            this.optional = bl2;
            this.minimumCount = n;
        }

        public CombinationMember(String string, boolean bl, boolean bl2, String string2) {
            this.type = string;
            this.absorbAll = bl;
            this.optional = bl2;
            if (string2 != null && string2.length() > 0) {
                try {
                    this.minimumCount = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    Utilities.annotateLoggable(numberFormatException);
                    this.minimumCount = 0;
                }
            } else {
                this.minimumCount = 0;
            }
        }

        public String getName() {
            return this.type;
        }

        public boolean isAbsorbAll() {
            return this.absorbAll;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public int getMinimumCount() {
            return this.minimumCount;
        }
    }
}

