/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.templates;

import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.templates.AbstractReportGenerator;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;

public class DefaultReportGenerator
extends AbstractReportGenerator {
    public FileObject generateReport(WizardDescriptor wizard) {
        Misc.msg("Inside generateReport");
        try {
            Misc.msg("Generating design ...");
            JasperDesign jasperDesign = this.generateDesign(wizard);
            Misc.msg("Generating design OK ...");
            File f = this.getFile(wizard);
            Misc.msg("get the file ...");
            Misc.msg("The file store the generated report is " + f);
            if (!f.exists()) {
                f.createNewFile();
            }
            JasperCompileManager.writeReportToXmlFile((JRReport)jasperDesign, (String)f.getPath());
            return FileUtil.toFileObject((File)f);
        }
        catch (Exception ex) {
            Misc.msg("Exception generating the file ...", ex);
            return null;
        }
    }

    protected File getFile(WizardDescriptor wizard) throws Exception {
        File f = null;
        String fname = null;
        String directory = null;
        if (wizard.getProperty("filename") != null) {
            f = new File("" + wizard.getProperty("filename"));
            if (wizard instanceof TemplateWizard) {
                DataFolder df = ((TemplateWizard)wizard).getTargetFolder();
                if (df == null || df.getPrimaryFile() == null || !Misc.getDataFolderPath(df).equals(f.getParent())) {
                    directory = f.getParent();
                }
                if (((TemplateWizard)wizard).getTargetName() == null || !((TemplateWizard)wizard).getTargetName().equals(f.getName())) {
                    fname = f.getName();
                }
            }
        }
        if (wizard instanceof TemplateWizard && ((TemplateWizard)wizard).getTargetFolder() != null) {
            if (fname == null) {
                fname = ((TemplateWizard)wizard).getTargetName();
            }
            if (directory == null) {
                directory = Misc.getDataFolderPath(((TemplateWizard)wizard).getTargetFolder());
            }
            if (fname == null) {
                fname = "Report.jrxml";
                f = new File(directory, fname);
                int i = 1;
                while (f.exists()) {
                    fname = "Report_" + i + ".jrxml";
                    f = new File(directory, fname);
                    ++i;
                }
            } else {
                f = new File(directory, fname);
            }
            if (((TemplateWizard)wizard).getTargetName() == null || !((TemplateWizard)wizard).getTargetName().equals(fname)) {
                // empty if block
            }
        }
        if (f == null) {
            throw new Exception("Filename not specified");
        }
        return f;
    }

    protected JasperDesign generateDesign(WizardDescriptor wizard) throws Exception {
        FileObject reportTemplate = (FileObject)wizard.getProperty("reportTemplate");
        String reportType = (String)wizard.getProperty("reportType");
        ArrayList selectedFields = (ArrayList)wizard.getProperty("selectedFields");
        ArrayList groupFields = (ArrayList)wizard.getProperty("groupFields");
        String query = (String)wizard.getProperty("query");
        String queryLanguage = (String)wizard.getProperty("queryLanguage");
        JasperDesign jasperDesign = JRXmlLoader.load((InputStream)reportTemplate.getInputStream());
        jasperDesign.setName("" + wizard.getProperty("reportname"));
        if (selectedFields == null) {
            selectedFields = new ArrayList();
        }
        if (groupFields == null) {
            groupFields = new ArrayList();
        }
        for (JRDesignField f : selectedFields) {
            jasperDesign.addField((JRField)f);
        }
        if (query != null) {
            JRDesignQuery designQuery = new JRDesignQuery();
            designQuery.setText(query);
            if (queryLanguage != null) {
                designQuery.setLanguage(queryLanguage);
            }
            jasperDesign.setQuery(designQuery);
        }
        for (int i = 0; i < 4; ++i) {
            String gname = "Group" + (i + 1);
            if (!jasperDesign.getGroupsMap().containsKey(gname)) continue;
            JRDesignGroup group = (JRDesignGroup)jasperDesign.getGroupsMap().get(gname);
            if (groupFields.size() > i) {
                JRDesignTextField tf;
                group.setName(((JRDesignField)groupFields.get(i)).getName());
                group.setExpression((JRExpression)Misc.createExpression("java.lang.Object", "$F{" + ((JRDesignField)groupFields.get(i)).getName() + "}"));
                if (group.getGroupHeader() == null) continue;
                JRDesignStaticText st = DefaultReportGenerator.findStaticTextElement(group.getGroupHeader(), "G" + (i + 1) + "Label");
                if (st != null) {
                    st.setText(((JRDesignField)groupFields.get(i)).getName());
                }
                if ((tf = DefaultReportGenerator.findTextFieldElement(group.getGroupHeader(), "G" + (i + 1) + "Field")) == null) continue;
                JRDesignExpression expression = Misc.createExpression(((JRDesignField)groupFields.get(i)).getValueClassName(), "$F{" + ((JRDesignField)groupFields.get(i)).getName() + "}");
                CreateTextFieldAction.setMatchingClassExpression(expression, ((JRDesignField)groupFields.get(i)).getValueClassName(), true);
                tf.setExpression((JRExpression)expression);
                continue;
            }
            jasperDesign.removeGroup((JRGroup)group);
        }
        if (reportType != null && reportType.equals("tabular")) {
            JRDesignBand columnHeaderBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JRDesignStaticText labelElement = DefaultReportGenerator.findStaticTextElement((JRBand)columnHeaderBand, "DetailLabel");
            JRDesignTextField fieldElement = DefaultReportGenerator.findTextFieldElement((JRBand)detailBand, "DetailField");
            if (labelElement != null) {
                columnHeaderBand.removeElement((JRDesignElement)labelElement);
            }
            if (fieldElement != null) {
                detailBand.removeElement((JRDesignElement)fieldElement);
            }
            int width = jasperDesign.getPageWidth() - jasperDesign.getRightMargin() - jasperDesign.getLeftMargin();
            int cols = selectedFields.size() - groupFields.size();
            if (cols > 0) {
                width /= cols;
                int currentX = 0;
                for (JRDesignField f : selectedFields) {
                    if (groupFields.contains(f)) continue;
                    if (labelElement != null) {
                        JRDesignStaticText newLabel = (JRDesignStaticText)labelElement.clone();
                        newLabel.setText(f.getName());
                        newLabel.setX(currentX);
                        newLabel.setWidth(width);
                        columnHeaderBand.addElement((JRDesignElement)newLabel);
                    }
                    if (fieldElement != null) {
                        JRDesignTextField newTextField = (JRDesignTextField)fieldElement.clone();
                        JRDesignExpression expression = Misc.createExpression(f.getValueClassName(), "$F{" + f.getName() + "}");
                        CreateTextFieldAction.setMatchingClassExpression(expression, f.getValueClassName(), true);
                        newTextField.setExpression((JRExpression)expression);
                        newTextField.setX(currentX);
                        newTextField.setWidth(width);
                        detailBand.addElement((JRDesignElement)newTextField);
                    }
                    currentX += width;
                }
            }
        } else if (reportType != null && reportType.equals("columnar")) {
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JRDesignStaticText labelElement = DefaultReportGenerator.findStaticTextElement((JRBand)detailBand, "DetailLabel");
            JRDesignTextField fieldElement = DefaultReportGenerator.findTextFieldElement((JRBand)detailBand, "DetailField");
            if (labelElement != null) {
                detailBand.removeElement((JRDesignElement)labelElement);
            }
            if (fieldElement != null) {
                detailBand.removeElement((JRDesignElement)fieldElement);
            }
            int currentY = 0;
            int rowHeight = 0;
            if (labelElement != null) {
                rowHeight = labelElement.getHeight();
            }
            if (fieldElement != null) {
                rowHeight = Math.max(rowHeight, fieldElement.getHeight());
            }
            for (JRDesignField f : selectedFields) {
                if (groupFields.contains(f)) continue;
                if (labelElement != null) {
                    JRDesignStaticText newLabel = (JRDesignStaticText)labelElement.clone();
                    newLabel.setText(f.getName());
                    newLabel.setY(currentY);
                    detailBand.addElement((JRDesignElement)newLabel);
                }
                if (fieldElement != null) {
                    JRDesignTextField newTextField = (JRDesignTextField)fieldElement.clone();
                    JRDesignExpression expression = Misc.createExpression(f.getValueClassName(), "$F{" + f.getName() + "}");
                    CreateTextFieldAction.setMatchingClassExpression(expression, f.getValueClassName(), true);
                    newTextField.setExpression((JRExpression)expression);
                    newTextField.setY(currentY);
                    detailBand.addElement((JRDesignElement)newTextField);
                }
                currentY += rowHeight;
            }
            detailBand.setHeight(currentY);
        }
        return jasperDesign;
    }
}

