/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.sheet.JRPropertiesMapProperty;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class FieldNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignField field = null;

    public FieldNode(JasperDesign jd, JRDesignField field, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, field})}));
        this.jd = jd;
        this.field = field;
        this.setDisplayName(field.getName());
        super.setName(field.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/field-16.png");
        field.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        return this.field.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        set.put((Node.Property)new NameProperty(this.getField(), dataset));
        set.put((Node.Property)new ValueClassNameProperty(this.getField()));
        set.put((Node.Property)new DescriptionProperty(this.getField()));
        set.put((Node.Property)new JRPropertiesMapProperty((JRPropertiesHolder)this.getField()));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public void destroy() throws IOException {
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        dataset.removeField((JRField)this.getField());
        super.destroy();
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldFromFieldAction", this.getField()));
        return tras;
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException(I18n.getString("FieldNode.Property.FieldInvalid"));
        }
        List currentFields = null;
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        currentFields = dataset.getFieldsList();
        for (JRDesignField p : currentFields) {
            if (p == this.getField() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException(I18n.getString("FieldNode.Property.FieldInUse"));
        }
        String oldName = this.getField().getName();
        this.getField().setName(s);
        dataset.getFieldsMap().remove(oldName);
        dataset.getFieldsMap().put(s, this.getField());
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getField(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public JRDesignField getField() {
        return this.field;
    }

    public void setField(JRDesignField field) {
        this.field = field;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getField().getName());
            this.setDisplayName(this.getField().getName());
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public class DescriptionProperty
    extends PropertySupport.ReadWrite {
        JRDesignField field;

        public DescriptionProperty(JRDesignField field) {
            super("description", String.class, I18n.getString("FieldNode.Property.Description"), I18n.getString("FieldNode.Property.Description"));
            this.field = null;
            this.field = field;
        }

        public boolean canWrite() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.field.getDescription() == null ? "" : this.field.getDescription();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String oldValue = this.getField().getDescription();
            String newValue = val == null ? null : "" + val.toString();
            this.getField().setDescription(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getField(), "Description", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public JRDesignField getField() {
            return this.field;
        }

        public void setField(JRDesignField field) {
            this.field = field;
        }

        public boolean isDefaultValue() {
            return this.getField().getDescription() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public class ValueClassNameProperty
    extends PropertySupport.ReadWrite {
        JRDesignField field;
        PropertyEditor editor;

        public ValueClassNameProperty(JRDesignField field) {
            super("valueClassName", String.class, I18n.getString("FieldNode.Property.FieldClass"), I18n.getString("FieldNode.Property.FieldClass"));
            this.field = null;
            this.editor = null;
            this.field = field;
        }

        public boolean canWrite() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getField().getValueClassName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null) {
                return;
            }
            if (val instanceof String) {
                String s = ((String)val).trim();
                if (s.length() == 0) {
                    s = "java.lang.String";
                }
                String oldValue = this.getField().getValueClassName();
                String newValue = s;
                this.getField().setValueClassName(s);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getField(), "ValueClassName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.getField().getValueClassName().equals("java.lang.String");
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.setValue("java.lang.String");
            this.editor.setValue("java.lang.String");
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public JRDesignField getField() {
            return this.field;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                classes.add(new Tag("java.lang.Boolean"));
                classes.add(new Tag("java.lang.Byte"));
                classes.add(new Tag("java.util.Date"));
                classes.add(new Tag("java.sql.Timestamp"));
                classes.add(new Tag("java.sql.Time"));
                classes.add(new Tag("java.lang.Double"));
                classes.add(new Tag("java.lang.Float"));
                classes.add(new Tag("java.lang.Integer"));
                classes.add(new Tag("java.lang.Long"));
                classes.add(new Tag("java.lang.Short"));
                classes.add(new Tag("java.math.BigDecimal"));
                classes.add(new Tag("java.lang.Number"));
                classes.add(new Tag("java.lang.String"));
                classes.add(new Tag("java.util.Collection"));
                classes.add(new Tag("java.util.List"));
                classes.add(new Tag("java.lang.Object"));
                classes.add(new Tag("java.io.InputStream"));
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }

        public Object getValue(String attributeName) {
            if ("canEditAsText".equals(attributeName)) {
                return true;
            }
            if ("oneline".equals(attributeName)) {
                return true;
            }
            if ("suppressCustomEditor".equals(attributeName)) {
                return false;
            }
            return super.getValue(attributeName);
        }
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignField field = null;
        JRDesignDataset dataset = null;

        public NameProperty(JRDesignField field, JRDesignDataset dataset) {
            super("name", String.class, I18n.getString("FieldNode.Property.Name"), I18n.getString("FieldNode.Property.Namedetail"));
            this.field = field;
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getField().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("FieldNode.Property.FieldInvalid"));
                throw iae;
            }
            String s = val + "";
            List currentFields = null;
            currentFields = this.getDataset().getFieldsList();
            for (JRDesignField p : currentFields) {
                if (p == this.getField() || !p.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException(I18n.getString("FieldNode.Property.FieldInUse"));
                throw iae;
            }
            String oldName = this.getField().getName();
            this.getField().setName(s);
            this.dataset.getFieldsMap().remove(oldName);
            this.dataset.getFieldsMap().put(s, this.getField());
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getField(), "Name", String.class, oldName, this.getField().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JRDesignDataset getDataset() {
            return this.dataset;
        }

        public void setDataset(JRDesignDataset dataset) {
            this.dataset = dataset;
        }

        public JRDesignField getField() {
            return this.field;
        }

        public void setField(JRDesignField field) {
            this.field = field;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

