/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.formatting.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.undo.ElementTransformationUndoableEdit;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormattingToolAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        int minElements = this.requiresMultipleObjects() ? 2 : 1;
        return this.getSelectedElements(nodes).size() >= minElements;
    }

    public List<JRDesignElement> getSelectedElements() {
        return this.getSelectedElements(this.getActivatedNodes());
    }

    public List<JRDesignElement> getSelectedElements(Node[] nodes) {
        ArrayList<JRDesignElement> elements = new ArrayList<JRDesignElement>();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof ElementNode)) continue;
            elements.add(((ElementNode)nodes[i]).getElement());
        }
        return elements;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean requiresMultipleObjects() {
        return false;
    }

    public Rectangle getElementBounds(JRDesignElement element) {
        return new Rectangle(element.getX(), element.getY(), element.getWidth(), element.getHeight());
    }

    public boolean addTransformationUndo(JRDesignElement element, Rectangle oldBounds, boolean aggregate) {
        if (element.getX() != oldBounds.x || element.getY() != oldBounds.y || element.getWidth() != oldBounds.width || element.getHeight() != oldBounds.height) {
            ElementTransformationUndoableEdit edit = new ElementTransformationUndoableEdit(element, oldBounds);
            IReportManager.getInstance();
            IReportManager.getInstance().addUndoableEdit(edit, aggregate);
            return true;
        }
        return aggregate;
    }

    public List<JRDesignElement> sortXY(List<JRDesignElement> elements) {
        return this.sortXY(elements, false);
    }

    public List<JRDesignElement> sortXY(List<JRDesignElement> elements, final boolean reverse) {
        JRDesignElement[] elements_array = new JRDesignElement[elements.size()];
        elements_array = elements.toArray(elements_array);
        Arrays.sort(elements_array, new Comparator<JRDesignElement>(){

            @Override
            public int compare(JRDesignElement e1, JRDesignElement e2) {
                int mul;
                int x1 = reverse ? e1.getX() + e1.getWidth() : e1.getX();
                int x2 = reverse ? e2.getX() + e2.getWidth() : e2.getX();
                int y1 = reverse ? e1.getY() + e1.getHeight() : e1.getY();
                int y2 = reverse ? e2.getY() + e2.getHeight() : e2.getY();
                int n = mul = reverse ? -1 : 1;
                if (x1 > x2) {
                    return 1 * mul;
                }
                if (x1 < x2) {
                    return -1 * mul;
                }
                if (y1 > y2) {
                    return 1 * mul;
                }
                if (y1 < y2) {
                    return -1 * mul;
                }
                return 0;
            }
        });
        return Arrays.asList(elements_array);
    }

    public List<JRDesignElement> sortYX(List<JRDesignElement> elements, final boolean reverse) {
        JRDesignElement[] elements_array = new JRDesignElement[elements.size()];
        elements_array = elements.toArray(elements_array);
        Arrays.sort(elements_array, new Comparator<JRDesignElement>(){

            @Override
            public int compare(JRDesignElement e1, JRDesignElement e2) {
                int mul;
                int x1 = reverse ? e1.getX() + e1.getWidth() : e1.getX();
                int x2 = reverse ? e2.getX() + e2.getWidth() : e2.getX();
                int y1 = reverse ? e1.getY() + e1.getHeight() : e1.getY();
                int y2 = reverse ? e2.getY() + e2.getHeight() : e2.getY();
                int n = mul = reverse ? -1 : 1;
                if (y1 > y2) {
                    return 1 * mul;
                }
                if (y1 < y2) {
                    return -1 * mul;
                }
                if (x1 > x2) {
                    return 1 * mul;
                }
                if (x1 < x2) {
                    return -1 * mul;
                }
                return 0;
            }
        });
        return Arrays.asList(elements_array);
    }

    public List<JRDesignElement> sortYX(List<JRDesignElement> elements) {
        return this.sortYX(elements, false);
    }
}

