/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.xml;

import com.jaspersoft.ireport.designer.data.fieldsproviders.xml.XMLFieldMappingEditor;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.w3c.dom.Node;

public class XMLDocumentTreeCellRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon tagIcon;
    static ImageIcon attributeIcon;
    static ImageIcon errorIcon;
    XMLFieldMappingEditor mappingEditor = null;

    public XMLFieldMappingEditor getMappingEditor() {
        return this.mappingEditor;
    }

    public void setMappingEditor(XMLFieldMappingEditor mappingEditor) {
        this.mappingEditor = mappingEditor;
    }

    public XMLDocumentTreeCellRenderer(XMLFieldMappingEditor mappingEditor) {
        this.mappingEditor = mappingEditor;
        if (tagIcon == null) {
            tagIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/fieldsproviders/xml/tag.png"));
        }
        if (attributeIcon == null) {
            attributeIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/fieldsproviders/xml/attribute.png"));
        }
        if (errorIcon == null) {
            errorIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/fieldsproviders/xml/error.png"));
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        try {
            if (value != null && value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)value;
                if (dmtn.getUserObject() != null && dmtn.getUserObject() instanceof Node) {
                    Font f;
                    Node node = (Node)dmtn.getUserObject();
                    String s = node.getNodeName();
                    if (node.getNodeValue() != null) {
                        s = s + " (" + node.getNodeValue() + ")";
                    }
                    if (node.getNodeType() == 1) {
                        this.setIcon(tagIcon);
                    }
                    if (node.getNodeType() == 2) {
                        this.setIcon(attributeIcon);
                    }
                    boolean needBold = false;
                    if (this.getMappingEditor() != null && this.getMappingEditor().getRecordNodes().contains(node)) {
                        needBold = true;
                    }
                    if ((f = this.getFont()).isBold() && !needBold) {
                        this.setFont(f.deriveFont(0));
                    } else if (!f.isBold() && needBold) {
                        this.setFont(f.deriveFont(1));
                    }
                    this.setText(s);
                } else {
                    this.setIcon(errorIcon);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this;
    }
}

