/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.openide.util.lookup.AbstractLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceContent
extends AbstractLookup.Content {
    public final void add(Object object) {
        this.addPair(new SimpleItem<Object>(object));
    }

    public final <T, R> void add(T t, Convertor<T, R> convertor) {
        this.addPair(new ConvertingItem<T, R>(t, convertor));
    }

    public final void remove(Object object) {
        this.removePair(new SimpleItem<Object>(object));
    }

    public final <T, R> void remove(T t, Convertor<T, R> convertor) {
        this.removePair(new ConvertingItem<T, R>(t, convertor));
    }

    public final <T, R> void set(Collection<T> collection, Convertor<T, R> convertor) {
        ArrayList<AbstractLookup.Pair> arrayList = new ArrayList<AbstractLookup.Pair>(collection.size());
        Iterator<T> iterator = collection.iterator();
        if (convertor == null) {
            while (iterator.hasNext()) {
                arrayList.add(new SimpleItem<T>(iterator.next()));
            }
        } else {
            while (iterator.hasNext()) {
                arrayList.add(new ConvertingItem<T, R>(iterator.next(), convertor));
            }
        }
        this.setPairs(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConvertingItem<T, R>
    extends AbstractLookup.Pair<R> {
        private T obj;
        private WeakReference<R> ref;
        private Convertor<? super T, R> conv;

        public ConvertingItem(T t, Convertor<? super T, R> convertor) {
            this.obj = t;
            this.conv = convertor;
        }

        @Override
        public boolean instanceOf(Class<?> clazz) {
            return clazz.isAssignableFrom(this.getType());
        }

        private R getConverted() {
            if (this.ref == null) {
                return null;
            }
            return (R)this.ref.get();
        }

        @Override
        public synchronized R getInstance() {
            R r = this.getConverted();
            if (r == null) {
                r = this.conv.convert(this.obj);
                this.ref = new WeakReference<R>(r);
            }
            return r;
        }

        public boolean equals(Object object) {
            if (object instanceof ConvertingItem) {
                return this.obj.equals(((ConvertingItem)object).obj);
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        @Override
        public String getId() {
            return this.conv.id(this.obj);
        }

        @Override
        public String getDisplayName() {
            return this.conv.displayName(this.obj);
        }

        @Override
        protected boolean creatorOf(Object object) {
            if (this.conv == null) {
                return object == this.obj;
            }
            return object == this.getConverted();
        }

        @Override
        public Class<? extends R> getType() {
            R r = this.getConverted();
            if (r == null) {
                return this.conv.type(this.obj);
            }
            return r.getClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SimpleItem<T>
    extends AbstractLookup.Pair<T> {
        private T obj;

        public SimpleItem(T t) {
            if (t == null) {
                throw new NullPointerException();
            }
            this.obj = t;
        }

        @Override
        public boolean instanceOf(Class<?> clazz) {
            return clazz.isInstance(this.obj);
        }

        @Override
        public T getInstance() {
            return this.obj;
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleItem) {
                return this.obj.equals(((SimpleItem)object).obj);
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        @Override
        public String getId() {
            return "IL[" + this.obj.toString();
        }

        @Override
        public String getDisplayName() {
            return this.obj.toString();
        }

        @Override
        protected boolean creatorOf(Object object) {
            return object == this.obj;
        }

        @Override
        public Class<? extends T> getType() {
            return this.obj.getClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Convertor<T, R> {
        public R convert(T var1);

        public Class<? extends R> type(T var1);

        public String id(T var1);

        public String displayName(T var1);
    }
}

