/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openidex.search.FileObjectFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleSearchIterator
implements Iterator<DataObject> {
    private Enumeration<DataObject> childrenEnum;
    private List<FileObjectFilter> filters;
    private List<FileObjectFilter> filtersCopy;
    private final boolean recursive;
    private final List<Enumeration<DataObject>> enums = new ArrayList<Enumeration<DataObject>>();
    private final List<List<FileObjectFilter>> filterLists = new ArrayList<List<FileObjectFilter>>();
    private boolean upToDate = false;
    private DataObject nextObject;

    SimpleSearchIterator(DataFolder dataFolder, boolean bl, List<FileObjectFilter> list) {
        this.childrenEnum = dataFolder.children(false);
        this.recursive = bl;
        this.filters = list != null ? new ArrayList<FileObjectFilter>(list) : null;
    }

    @Override
    public boolean hasNext() {
        if (!this.upToDate) {
            this.update();
        }
        return this.nextObject != null;
    }

    @Override
    public DataObject next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.upToDate = false;
        return this.nextObject;
    }

    private void update() {
        assert (!this.upToDate);
        assert (this.childrenEnum != null);
        do {
            if (this.childrenEnum.hasMoreElements()) {
                DataObject dataObject = this.childrenEnum.nextElement();
                FileObject fileObject = dataObject.getPrimaryFile();
                if (fileObject.isFolder()) {
                    if (!this.recursive) continue;
                    if (this.filters != null) {
                        List<FileObjectFilter> list = this.checkFolderFilters(fileObject);
                        if (list == null) continue;
                        this.filterLists.add(this.filters);
                        if (list.size() != this.filters.size()) {
                            this.filters = !list.isEmpty() ? list : null;
                        }
                    } else {
                        this.filterLists.add(null);
                    }
                    this.enums.add(this.childrenEnum);
                    this.childrenEnum = ((DataFolder)dataObject).children(false);
                    continue;
                }
                if (this.filters != null && !this.checkFileFilters(fileObject)) continue;
                this.nextObject = dataObject;
                break;
            }
            assert (this.enums.isEmpty() == this.filterLists.isEmpty());
            this.nextObject = null;
            if (this.enums.isEmpty()) {
                this.childrenEnum = null;
                continue;
            }
            this.childrenEnum = this.enums.remove(this.enums.size() - 1);
            this.filters = this.filterLists.remove(this.filterLists.size() - 1);
            if (this.filtersCopy == null || this.filtersCopy.size() == this.filters.size()) continue;
            this.filtersCopy = null;
        } while (this.childrenEnum != null);
        this.upToDate = true;
    }

    private List<FileObjectFilter> checkFolderFilters(FileObject fileObject) {
        assert (fileObject.isFolder());
        assert (this.filters != null);
        if (this.filtersCopy == null) {
            this.filtersCopy = new ArrayList<FileObjectFilter>(this.filters);
        }
        List<FileObjectFilter> list = this.filtersCopy;
        Iterator<FileObjectFilter> iterator = list.iterator();
        block5: while (iterator.hasNext()) {
            FileObjectFilter fileObjectFilter = iterator.next();
            int n = fileObjectFilter.traverseFolder(fileObject);
            switch (n) {
                case 1: {
                    continue block5;
                }
                case 0: {
                    list = null;
                    break block5;
                }
                case 2: {
                    iterator.remove();
                    this.filtersCopy = null;
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        return list;
    }

    private boolean checkFileFilters(FileObject fileObject) {
        assert (!fileObject.isFolder());
        assert (this.filters != null);
        for (FileObjectFilter fileObjectFilter : this.filters) {
            if (fileObjectFilter.searchFile(fileObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

