/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharacterEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;

public class PropertyEditorRegistrySupport
implements PropertyEditorRegistry {
    private Map defaultEditors;
    private Map customEditors;
    private Map customEditorCache;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class array$Lorg$springframework$core$io$Resource;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    protected void registerDefaultEditors() {
        this.defaultEditors = new HashMap(32);
        this.defaultEditors.put(array$B == null ? (array$B = PropertyEditorRegistrySupport.class$("[B")) : array$B, new ByteArrayPropertyEditor());
        this.defaultEditors.put(class$java$lang$Class == null ? (class$java$lang$Class = PropertyEditorRegistrySupport.class$("java.lang.Class")) : class$java$lang$Class, new ClassEditor());
        this.defaultEditors.put(class$java$io$File == null ? (class$java$io$File = PropertyEditorRegistrySupport.class$("java.io.File")) : class$java$io$File, new FileEditor());
        this.defaultEditors.put(class$java$io$InputStream == null ? (class$java$io$InputStream = PropertyEditorRegistrySupport.class$("java.io.InputStream")) : class$java$io$InputStream, new InputStreamEditor());
        this.defaultEditors.put(class$java$util$Locale == null ? (class$java$util$Locale = PropertyEditorRegistrySupport.class$("java.util.Locale")) : class$java$util$Locale, new LocaleEditor());
        this.defaultEditors.put(class$java$util$Properties == null ? (class$java$util$Properties = PropertyEditorRegistrySupport.class$("java.util.Properties")) : class$java$util$Properties, new PropertiesEditor());
        this.defaultEditors.put(array$Lorg$springframework$core$io$Resource == null ? (array$Lorg$springframework$core$io$Resource = PropertyEditorRegistrySupport.class$("[Lorg.springframework.core.io.Resource;")) : array$Lorg$springframework$core$io$Resource, new ResourceArrayPropertyEditor());
        this.defaultEditors.put(array$Ljava$lang$String == null ? (array$Ljava$lang$String = PropertyEditorRegistrySupport.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, new StringArrayPropertyEditor());
        this.defaultEditors.put(class$java$net$URL == null ? (class$java$net$URL = PropertyEditorRegistrySupport.class$("java.net.URL")) : class$java$net$URL, new URLEditor());
        this.defaultEditors.put(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection, new CustomCollectionEditor(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection));
        this.defaultEditors.put(class$java$util$Set == null ? (class$java$util$Set = PropertyEditorRegistrySupport.class$("java.util.Set")) : class$java$util$Set, new CustomCollectionEditor(class$java$util$Set == null ? (class$java$util$Set = PropertyEditorRegistrySupport.class$("java.util.Set")) : class$java$util$Set));
        this.defaultEditors.put(class$java$util$SortedSet == null ? (class$java$util$SortedSet = PropertyEditorRegistrySupport.class$("java.util.SortedSet")) : class$java$util$SortedSet, new CustomCollectionEditor(class$java$util$SortedSet == null ? (class$java$util$SortedSet = PropertyEditorRegistrySupport.class$("java.util.SortedSet")) : class$java$util$SortedSet));
        this.defaultEditors.put(class$java$util$List == null ? (class$java$util$List = PropertyEditorRegistrySupport.class$("java.util.List")) : class$java$util$List, new CustomCollectionEditor(class$java$util$List == null ? (class$java$util$List = PropertyEditorRegistrySupport.class$("java.util.List")) : class$java$util$List));
        CharacterEditor characterEditor = new CharacterEditor(false);
        CustomBooleanEditor booleanEditor = new CustomBooleanEditor(false);
        this.defaultEditors.put(Character.TYPE, characterEditor);
        this.defaultEditors.put(class$java$lang$Character == null ? (class$java$lang$Character = PropertyEditorRegistrySupport.class$("java.lang.Character")) : class$java$lang$Character, characterEditor);
        this.defaultEditors.put(Boolean.TYPE, booleanEditor);
        this.defaultEditors.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyEditorRegistrySupport.class$("java.lang.Boolean")) : class$java$lang$Boolean, booleanEditor);
        CustomNumberEditor byteEditor = new CustomNumberEditor(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyEditorRegistrySupport.class$("java.lang.Byte")) : class$java$lang$Byte, false);
        CustomNumberEditor shortEditor = new CustomNumberEditor(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistrySupport.class$("java.lang.Short")) : class$java$lang$Short, false);
        CustomNumberEditor integerEditor = new CustomNumberEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistrySupport.class$("java.lang.Integer")) : class$java$lang$Integer, false);
        CustomNumberEditor longEditor = new CustomNumberEditor(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistrySupport.class$("java.lang.Long")) : class$java$lang$Long, false);
        CustomNumberEditor floatEditor = new CustomNumberEditor(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistrySupport.class$("java.lang.Float")) : class$java$lang$Float, false);
        CustomNumberEditor doubleEditor = new CustomNumberEditor(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistrySupport.class$("java.lang.Double")) : class$java$lang$Double, false);
        this.defaultEditors.put(Byte.TYPE, byteEditor);
        this.defaultEditors.put(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyEditorRegistrySupport.class$("java.lang.Byte")) : class$java$lang$Byte, byteEditor);
        this.defaultEditors.put(Short.TYPE, shortEditor);
        this.defaultEditors.put(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistrySupport.class$("java.lang.Short")) : class$java$lang$Short, shortEditor);
        this.defaultEditors.put(Integer.TYPE, integerEditor);
        this.defaultEditors.put(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistrySupport.class$("java.lang.Integer")) : class$java$lang$Integer, integerEditor);
        this.defaultEditors.put(Long.TYPE, longEditor);
        this.defaultEditors.put(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistrySupport.class$("java.lang.Long")) : class$java$lang$Long, longEditor);
        this.defaultEditors.put(Float.TYPE, floatEditor);
        this.defaultEditors.put(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistrySupport.class$("java.lang.Float")) : class$java$lang$Float, floatEditor);
        this.defaultEditors.put(Double.TYPE, doubleEditor);
        this.defaultEditors.put(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistrySupport.class$("java.lang.Double")) : class$java$lang$Double, doubleEditor);
        this.defaultEditors.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyEditorRegistrySupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new CustomNumberEditor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyEditorRegistrySupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, false));
        this.defaultEditors.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyEditorRegistrySupport.class$("java.math.BigInteger")) : class$java$math$BigInteger, new CustomNumberEditor(class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyEditorRegistrySupport.class$("java.math.BigInteger")) : class$java$math$BigInteger, false));
    }

    protected PropertyEditor getDefaultEditor(Class requiredType) {
        if (this.defaultEditors == null) {
            return null;
        }
        return (PropertyEditor)this.defaultEditors.get(requiredType);
    }

    protected void copyDefaultEditorsTo(PropertyEditorRegistrySupport target) {
        target.defaultEditors = this.defaultEditors;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String propertyPath, PropertyEditor propertyEditor) {
        if (requiredType == null && propertyPath == null) {
            throw new IllegalArgumentException("Either requiredType or propertyPath is required");
        }
        if (this.customEditors == null) {
            this.customEditors = CollectionFactory.createLinkedMapIfPossible(16);
        }
        if (propertyPath != null) {
            this.customEditors.put(propertyPath, new CustomEditorHolder(propertyEditor, requiredType));
        } else {
            this.customEditors.put(requiredType, propertyEditor);
            this.customEditorCache = null;
        }
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        if (this.customEditors == null) {
            return null;
        }
        if (propertyPath != null) {
            PropertyEditor editor = this.getCustomEditor(propertyPath, requiredType);
            if (editor == null) {
                LinkedList strippedPaths = new LinkedList();
                this.addStrippedPropertyPaths(strippedPaths, "", propertyPath);
                Iterator it = strippedPaths.iterator();
                while (it.hasNext() && editor == null) {
                    String strippedPath = (String)it.next();
                    editor = this.getCustomEditor(strippedPath, requiredType);
                }
            }
            if (editor != null) {
                return editor;
            }
            if (requiredType == null) {
                requiredType = this.getPropertyType(propertyPath);
            }
        }
        return this.getCustomEditor(requiredType);
    }

    protected Class getPropertyType(String propertyPath) {
        return null;
    }

    private PropertyEditor getCustomEditor(String propertyName, Class requiredType) {
        CustomEditorHolder holder = (CustomEditorHolder)this.customEditors.get(propertyName);
        return holder != null ? holder.getPropertyEditor(requiredType) : null;
    }

    private PropertyEditor getCustomEditor(Class requiredType) {
        if (requiredType == null) {
            return null;
        }
        PropertyEditor editor = (PropertyEditor)this.customEditors.get(requiredType);
        if (editor == null) {
            if (this.customEditorCache != null) {
                editor = (PropertyEditor)this.customEditorCache.get(requiredType);
            }
            if (editor == null) {
                Iterator it = this.customEditors.keySet().iterator();
                while (it.hasNext() && editor == null) {
                    Object key = it.next();
                    if (!(key instanceof Class) || !((Class)key).isAssignableFrom(requiredType)) continue;
                    editor = (PropertyEditor)this.customEditors.get(key);
                    if (this.customEditorCache == null) {
                        this.customEditorCache = new HashMap();
                    }
                    this.customEditorCache.put(requiredType, editor);
                }
            }
        }
        return editor;
    }

    protected Class guessPropertyTypeFromEditors(String propertyName) {
        if (this.customEditors != null) {
            CustomEditorHolder editorHolder = (CustomEditorHolder)this.customEditors.get(propertyName);
            if (editorHolder == null) {
                LinkedList strippedPaths = new LinkedList();
                this.addStrippedPropertyPaths(strippedPaths, "", propertyName);
                Iterator it = strippedPaths.iterator();
                while (it.hasNext() && editorHolder == null) {
                    String strippedName = (String)it.next();
                    editorHolder = (CustomEditorHolder)this.customEditors.get(strippedName);
                }
            }
            if (editorHolder != null) {
                return editorHolder.getRegisteredType();
            }
        }
        return null;
    }

    protected void copyCustomEditorsTo(PropertyEditorRegistry target, String nestedProperty) {
        String actualPropertyName;
        String string = actualPropertyName = nestedProperty != null ? PropertyAccessorUtils.getPropertyName(nestedProperty) : null;
        if (this.customEditors != null) {
            Iterator it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                String editorPath;
                int pos;
                Map.Entry entry = it.next();
                if (entry.getKey() instanceof Class) {
                    Class requiredType = (Class)entry.getKey();
                    PropertyEditor editor = (PropertyEditor)entry.getValue();
                    target.registerCustomEditor(requiredType, editor);
                    continue;
                }
                if (!(entry.getKey() instanceof String & nestedProperty != null) || (pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(editorPath = (String)entry.getKey())) == -1) continue;
                String editorNestedProperty = editorPath.substring(0, pos);
                String editorNestedPath = editorPath.substring(pos + 1);
                if (!editorNestedProperty.equals(nestedProperty) && !editorNestedProperty.equals(actualPropertyName)) continue;
                CustomEditorHolder editorHolder = (CustomEditorHolder)entry.getValue();
                target.registerCustomEditor(editorHolder.getRegisteredType(), editorNestedPath, editorHolder.getPropertyEditor());
            }
        }
    }

    private void addStrippedPropertyPaths(List strippedPaths, String nestedPath, String propertyPath) {
        int endIndex;
        int startIndex = propertyPath.indexOf(91);
        if (startIndex != -1 && (endIndex = propertyPath.indexOf(93)) != -1) {
            String prefix = propertyPath.substring(0, startIndex);
            String key = propertyPath.substring(startIndex, endIndex + 1);
            String suffix = propertyPath.substring(endIndex + 1, propertyPath.length());
            strippedPaths.add(nestedPath + prefix + suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix, suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix + key, suffix);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CustomEditorHolder {
        private final PropertyEditor propertyEditor;
        private final Class registeredType;

        private CustomEditorHolder(PropertyEditor propertyEditor, Class registeredType) {
            this.propertyEditor = propertyEditor;
            this.registeredType = registeredType;
        }

        private PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        private Class getRegisteredType() {
            return this.registeredType;
        }

        private PropertyEditor getPropertyEditor(Class requiredType) {
            if (this.registeredType == null || requiredType != null && (BeanUtils.isAssignable(this.registeredType, requiredType) || BeanUtils.isAssignable(requiredType, this.registeredType)) || requiredType == null && !(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.registeredType) && !this.registeredType.isArray()) {
                return this.propertyEditor;
            }
            return null;
        }
    }
}

