/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;

public class ExposeInvocationInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = -9148187649646413932L;
    public static final ExposeInvocationInterceptor INSTANCE = new ExposeInvocationInterceptor();
    public static final Advisor ADVISOR = new DefaultPointcutAdvisor(INSTANCE){

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public String toString() {
            return "ExposeInvocationInterceptor.ADVISOR";
        }
    };
    private static ThreadLocal invocation = new ThreadLocal();

    public static MethodInvocation currentInvocation() throws AspectException {
        MethodInvocation mi = (MethodInvocation)invocation.get();
        String mesg = "No MethodInvocation found: check that an AOP invocation is in progress, and that the ExposeInvocationInterceptor is in the interceptor chain";
        if (mi == null) {
            throw new AspectException(mesg, new Throwable(mesg));
        }
        return mi;
    }

    private ExposeInvocationInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object old = invocation.get();
        invocation.set(mi);
        try {
            Object object = mi.proceed();
            return object;
        }
        finally {
            invocation.set(old);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

