/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogProvider;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AutoupdateCatalogFactory {
    private static Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.updateproviders.AutoupdateCatalogFactory");
    private static final String UPDATE_VERSION_PROP = "netbeans.autoupdate.version";
    private static final String UPDATE_VERSION = "1.23";
    private static final String IDE_HASH_CODE = "netbeans.hash.code";
    private static final String SYSPROP_COUNTRY = "netbeans.autoupdate.country";
    private static final String SYSPROP_LANGUAGE = "netbeans.autoupdate.language";
    private static final String SYSPROP_VARIANT = "netbeans.autoupdate.variant";
    public static final String ORIGINAL_URL = "originalUrl";
    public static final String ORIGINAL_DISPLAY_NAME = "originalDisplayName";
    public static final String ORIGINAL_ENABLED = "originalEnabled";
    public static final String ORIGINAL_CATEGORY_NAME = "originalCategoryName";

    private AutoupdateCatalogFactory() {
    }

    public static UpdateProvider createUpdateProvider(FileObject fileObject) {
        Object object;
        String string = (String)fileObject.getAttribute("url_key");
        String string2 = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
        assert (string2 != null) : "remoteBundleName should found in fo: " + fileObject;
        ResourceBundle resourceBundle = NbBundle.getBundle((String)string2);
        URL uRL = null;
        if (string != null) {
            object = null;
            try {
                object = resourceBundle.getString(string);
                uRL = new URL((String)object);
            }
            catch (MissingResourceException missingResourceException) {
                assert (false) : resourceBundle + " should contain key " + string;
            }
            catch (MalformedURLException malformedURLException) {
                assert (false) : "MalformedURLException when parsing name " + (String)object;
            }
        } else {
            assert (false) : "url attrib ute is not supported.";
            object = fileObject.getAttribute("url");
            try {
                uRL = object instanceof String ? new URL((String)object) : (URL)object;
            }
            catch (MalformedURLException malformedURLException) {
                err.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
            }
        }
        uRL = AutoupdateCatalogFactory.modifyURL(uRL);
        object = (String)fileObject.getAttribute("category");
        UpdateUnitProvider.CATEGORY cATEGORY = object != null ? UpdateUnitProvider.CATEGORY.valueOf((String)object) : UpdateUnitProvider.CATEGORY.COMMUNITY;
        AutoupdateCatalogProvider autoupdateCatalogProvider = new AutoupdateCatalogProvider(string, AutoupdateCatalogFactory.displayName(fileObject), uRL, cATEGORY);
        Preferences preferences = AutoupdateCatalogFactory.getPreferences().node(string);
        preferences.put(ORIGINAL_URL, uRL.toExternalForm());
        preferences.put(ORIGINAL_DISPLAY_NAME, autoupdateCatalogProvider.getDisplayName());
        preferences.put(ORIGINAL_CATEGORY_NAME, autoupdateCatalogProvider.getCategory().name());
        Boolean bl = (Boolean)fileObject.getAttribute("enabled");
        if (bl != null) {
            preferences.putBoolean(ORIGINAL_ENABLED, bl);
        }
        return autoupdateCatalogProvider;
    }

    @Deprecated
    public static Object createXMLAutoupdateType(FileObject fileObject) throws IOException {
        return AutoupdateCatalogFactory.createUpdateProvider(fileObject);
    }

    private static String displayName(FileObject fileObject) {
        String string = null;
        if (fileObject != null) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                FileSystem.Status status = fileSystem.getStatus();
                String string2 = status.annotateName("", Collections.singleton(fileObject));
                if (!string2.equals("")) {
                    string = string2;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = NbBundle.getBundle(AutoupdateCatalogFactory.class).getString("CTL_CatalogUpdatesProviderFactory_DefaultName");
        }
        return string;
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    private static URL modifyURL(URL uRL) {
        URL uRL2 = null;
        if (System.getProperty(UPDATE_VERSION_PROP) == null) {
            System.setProperty(UPDATE_VERSION_PROP, UPDATE_VERSION);
        }
        if (System.getProperty(IDE_HASH_CODE) == null) {
            String string = AutoupdateCatalogFactory.getPreferences().get("ideIdentity", null);
            if (string == null) {
                Logger.getLogger(AutoupdateCatalogFactory.class.getName()).warning("Property PROP_IDE_IDENTITY hasn't been initialized yet.");
                string = "";
            }
            String string2 = NbBundle.getBundle(AutoupdateCatalogFactory.class).getString("URL_Prefix_Hash_Code");
            System.setProperty(IDE_HASH_CODE, "".equals(string) ? string2 + "0" : string2 + string);
        }
        try {
            uRL2 = new URL(AutoupdateCatalogFactory.encode(AutoupdateCatalogFactory.replace(uRL.toString())));
        }
        catch (MalformedURLException malformedURLException) {
            err.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
        }
        return uRL2;
    }

    private static String encode(String string) {
        String string2 = string;
        int n = string.indexOf(63);
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n + 1));
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    int n2 = string3.indexOf(61);
                    if (n2 < 0) {
                        stringBuffer.append(URLEncoder.encode(string3, "UTF-8"));
                    } else {
                        stringBuffer.append(URLEncoder.encode(string3.substring(0, n2), "UTF-8"));
                        stringBuffer.append('=');
                        String string4 = string3.substring(n2 + 1);
                        int n3 = string4.indexOf("%");
                        if (n3 < 0) {
                            stringBuffer.append(URLEncoder.encode(string4, "UTF-8"));
                        } else {
                            stringBuffer.append(URLEncoder.encode(string4.substring(0, n3), "UTF-8"));
                            stringBuffer.append('%');
                            stringBuffer.append(URLEncoder.encode(string4.substring(n3 + 1), "UTF-8"));
                        }
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logger.getLogger(AutoupdateCatalogFactory.class.getName()).log(Level.INFO, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append('&');
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static String replace(String string) {
        AutoupdateCatalogFactory.setSystemProperties();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("{", n2)) != -1 && n2 < string.length() - 1) {
            if (string.charAt(n2 + 1) == '{' || string.charAt(n2 + 1) != '$') {
                ++n2;
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
            int n3 = string.indexOf("}", n2);
            if (n3 != -1) {
                String string2 = string.substring(n2 + 2, n3);
                stringBuffer.append(AutoupdateCatalogFactory.getReplacement(string2));
            }
            n = n3 == -1 ? n2 + 2 : n3 + 1;
            ++n2;
        }
        if (n < string.length() - 1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private static void setSystemProperties() {
        if (System.getProperty(SYSPROP_COUNTRY, null) == null) {
            System.setProperty(SYSPROP_COUNTRY, Locale.getDefault().getCountry());
        }
        if (System.getProperty(SYSPROP_LANGUAGE, null) == null) {
            System.setProperty(SYSPROP_LANGUAGE, Locale.getDefault().getLanguage());
        }
        if (System.getProperty(SYSPROP_VARIANT, null) == null) {
            System.setProperty(SYSPROP_VARIANT, Locale.getDefault().getVariant());
        }
    }

    private static String getReplacement(String string) {
        return System.getProperty(string, "");
    }
}

