/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DependencyChecker {
    private static final Logger err = Logger.getLogger(DependencyChecker.class.getName());

    DependencyChecker() {
    }

    public static Set<Dependency> findBrokenDependencies(Set<Dependency> set, Collection<ModuleInfo> collection) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (Dependency dependency : set) {
            err.log(Level.FINE, "Dependency[" + dependency.getType() + "]: " + dependency);
            switch (dependency.getType()) {
                case 5: {
                    if (DependencyChecker.findModuleMatchesDependencyRequires(dependency, collection) != null) break;
                    hashSet.add(dependency);
                    break;
                }
                case 6: {
                    if (DependencyChecker.findModuleMatchesDependencyRequires(dependency, collection) != null) break;
                    hashSet.add(dependency);
                    break;
                }
                case 7: {
                    if (DependencyChecker.findModuleMatchesDependencyRequires(dependency, collection) != null) break;
                    hashSet.add(dependency);
                    break;
                }
                case 1: {
                    if (DependencyChecker.matchDependencyModule(dependency, collection) != null) break;
                    hashSet.add(dependency);
                    break;
                }
                case 3: {
                    err.log(Level.FINE, "Check dependency on Java platform. Dependency: " + dependency);
                    break;
                }
                default: {
                    err.log(Level.FINE, "Uncovered Dependency " + dependency);
                }
            }
        }
        return hashSet;
    }

    public static Set<Dependency> findBrokenDependenciesTransitive(ModuleInfo moduleInfo, Collection<ModuleInfo> collection, Set<ModuleInfo> set) {
        if (set.contains(moduleInfo)) {
            return Collections.emptySet();
        }
        set.add(moduleInfo);
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        block7: for (Dependency dependency : DependencyChecker.filterTypeRecommends(moduleInfo.getDependencies())) {
            err.log(Level.FINE, "Dependency[" + dependency.getType() + "]: " + dependency);
            ModuleInfo moduleInfo2 = null;
            switch (dependency.getType()) {
                case 5: {
                    moduleInfo2 = DependencyChecker.findModuleMatchesDependencyRequires(dependency, collection);
                    if (moduleInfo2 != null) {
                        hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(moduleInfo2, collection, set));
                        continue block7;
                    }
                    hashSet.add(dependency);
                    continue block7;
                }
                case 6: {
                    moduleInfo2 = DependencyChecker.findModuleMatchesDependencyRequires(dependency, collection);
                    if (moduleInfo2 != null) {
                        hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(moduleInfo2, collection, set));
                        continue block7;
                    }
                    hashSet.add(dependency);
                    continue block7;
                }
                case 7: {
                    moduleInfo2 = DependencyChecker.findModuleMatchesDependencyRequires(dependency, collection);
                    if (moduleInfo2 != null) {
                        hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(moduleInfo2, collection, set));
                        continue block7;
                    }
                    hashSet.add(dependency);
                    continue block7;
                }
                case 1: {
                    moduleInfo2 = DependencyChecker.matchDependencyModule(dependency, collection);
                    if (moduleInfo2 != null) {
                        hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(moduleInfo2, collection, set));
                        continue block7;
                    }
                    hashSet.add(dependency);
                    continue block7;
                }
                case 3: {
                    err.log(Level.FINE, "Check dependency on Java platform. Dependency: " + dependency);
                    continue block7;
                }
            }
            err.log(Level.FINE, "Uncovered Dependency " + dependency);
        }
        return hashSet;
    }

    private static Set<Dependency> filterTypeRecommends(Collection<Dependency> collection) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (Dependency dependency : collection) {
            if (7 == dependency.getType()) continue;
            hashSet.add(dependency);
        }
        return hashSet;
    }

    static ModuleInfo findModuleMatchesDependencyRequires(Dependency dependency, Collection<ModuleInfo> collection) {
        for (ModuleInfo moduleInfo : collection) {
            if (!Arrays.asList(moduleInfo.getProvides()).contains(dependency.getName())) continue;
            return moduleInfo;
        }
        return null;
    }

    private static ModuleInfo matchDependencyModule(Dependency dependency, Collection<ModuleInfo> collection) {
        for (ModuleInfo moduleInfo : collection) {
            if (!DependencyChecker.checkDependencyModule(dependency, moduleInfo)) continue;
            return moduleInfo;
        }
        return null;
    }

    static boolean checkDependencyModuleAllowEqual(Dependency dependency, ModuleInfo moduleInfo) {
        return DependencyChecker.checkDependencyModule(dependency, moduleInfo, true);
    }

    static boolean checkDependencyModule(Dependency dependency, ModuleInfo moduleInfo) {
        return DependencyChecker.checkDependencyModule(dependency, moduleInfo, false);
    }

    private static boolean checkDependencyModule(Dependency dependency, ModuleInfo moduleInfo, boolean bl) {
        boolean bl2 = false;
        if (dependency.getName().equals(moduleInfo.getCodeNameBase()) || dependency.getName().equals(moduleInfo.getCodeName())) {
            bl2 = dependency.getComparison() == 3 ? true : (dependency.getComparison() == 1 ? (moduleInfo.getSpecificationVersion() == null ? false : (new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) > 0 ? false : (bl && new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) == 0 ? true : true))) : (moduleInfo.getImplementationVersion() == null ? false : moduleInfo.getImplementationVersion().equals(dependency.getVersion())));
        } else {
            String string;
            int n = dependency.getName().indexOf(45);
            if (n != -1) {
                int n2 = dependency.getName().indexOf(47);
                String string2 = dependency.getName().substring(0, n2);
                int n3 = Integer.parseInt(dependency.getName().substring(n2 + 1, n));
                int n4 = Integer.parseInt(dependency.getName().substring(n + 1));
                if (string2.equals(moduleInfo.getCodeNameBase()) && n3 <= moduleInfo.getCodeNameRelease() && n4 >= moduleInfo.getCodeNameRelease()) {
                    bl2 = dependency.getComparison() == 3 ? true : (moduleInfo.getCodeNameRelease() > n3 ? true : (moduleInfo.getSpecificationVersion() == null ? false : (new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) > 0 ? false : (bl && new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) > 0 ? true : true))));
                }
            } else if (dependency.getName().indexOf(47) != -1 && (string = dependency.getName().substring(0, dependency.getName().indexOf(47))).equals(moduleInfo.getCodeNameBase())) {
                err.log(Level.FINE, "Unmatched major versions. Dependency " + dependency + " doesn't match with module " + moduleInfo);
                bl2 = false;
            }
        }
        return bl2;
    }
}

