/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.ListView;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment.ctrl.content.AbstractActionContent;
import nickyb.sqleonardo.environment.ctrl.content.TableMetaData;
import nickyb.sqleonardo.environment.ctrl.editor.DialogCommand;
import nickyb.sqleonardo.environment.ctrl.explorer.UoLinks;
import nickyb.sqleonardo.environment.mdi.ClientCommandEditor;
import nickyb.sqleonardo.environment.mdi.ClientContent;
import nickyb.sqleonardo.environment.mdi.ClientDefinition;
import nickyb.sqleonardo.environment.mdi.ClientMetadataExplorer;
import nickyb.sqleonardo.environment.mdi.ClientQueryBuilder;
import nickyb.sqleonardo.environment.mdi.MDIActions;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public abstract class AbstractListTaskSource
extends ListView
implements MouseListener {
    private JLabel info;
    private JLabel counter;

    protected AbstractListTaskSource() {
        this.addMouseListener(this);
        BorderLayoutPanel statusbar = new BorderLayoutPanel(3, 0);
        this.setComponentSouth(statusbar);
        this.info = new JLabel("...");
        statusbar.setComponentCenter(this.info);
        this.info.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 4, 2, 4)));
        this.counter = new JLabel("objects : 0");
        statusbar.setComponentEast(this.counter);
        this.counter.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 4, 2, 4)));
    }

    public void addRow(Object[] rowdata) {
        super.addRow(rowdata);
        this.counter.setText("objects : " + this.getRowCount());
    }

    public void reset() {
        super.reset();
        if (this.counter != null) {
            this.counter.setText("objects : 0");
        }
    }

    protected void setInfo(String s) {
        this.info.setText(s);
    }

    protected abstract String getHandlerKey();

    protected Connection getConnection() {
        return ConnectionAssistant.hasHandler(this.getHandlerKey()) ? ConnectionAssistant.getHandler(this.getHandlerKey()).get() : null;
    }

    private int findColumn(String name) {
        for (int i = 0; i < this.getJavaComponent().getColumnModel().getColumnCount(); ++i) {
            if (!this.getJavaComponent().getColumnModel().getColumn(i).getHeaderValue().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static DefaultMutableTreeNode findChild(DefaultMutableTreeNode parent, String label, boolean like) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (like && child.getUserObject().toString().startsWith(label)) {
                return child;
            }
            if (like || !child.getUserObject().toString().equals(label)) continue;
            return child;
        }
        return null;
    }

    protected String getTableSchema() {
        int idx = this.findColumn("TABLE_SCHEM");
        if (idx == -1) {
            return null;
        }
        Object schema = this.getValueAt(this.getSelectedRow(), idx);
        return schema == null ? null : schema.toString();
    }

    protected String getTableName() {
        int idx = this.findColumn("TABLE_NAME");
        if (idx == -1) {
            return null;
        }
        Object name = this.getValueAt(this.getSelectedRow(), idx);
        return name == null ? null : name.toString();
    }

    protected String getTableType() {
        int idx = this.findColumn("TABLE_TYPE");
        if (idx == -1) {
            return null;
        }
        Object type = this.getValueAt(this.getSelectedRow(), idx);
        return type == null ? null : type.toString();
    }

    public void mouseClicked(MouseEvent me) {
        if (me.getClickCount() == 2) {
            if (this.getSelectedRow() == -1) {
                return;
            }
            if (this.getConnection() == null) {
                Application.alert("SQLeonardo", "No connection!");
            } else {
                new ActionShowContent().actionPerformed(null);
            }
        }
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me)) {
            int row = this.getJavaComponent().rowAtPoint(me.getPoint());
            this.getJavaComponent().setRowSelectionInterval(row, row);
            JPopupMenu popup = new JPopupMenu();
            popup.add(new ActionQuery());
            popup.add(new ActionAddLink());
            popup.addSeparator();
            popup.add(new ActionCommand());
            popup.addSeparator();
            popup.add(new ActionDeleteContent());
            popup.add(new ActionDropObject());
            popup.addSeparator();
            popup.add(new ActionShowContent());
            popup.add(new ActionShowDefinition());
            popup.show(this.getJavaComponent(), me.getX(), me.getY());
        }
    }

    protected class ActionCommand
    extends MDIActions.ShowCommandEditor {
        ActionCommand() {
            this.setText("new command...");
            this.setAccelerator(null);
            this.setIcon(null);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            String schema = AbstractListTaskSource.this.getTableSchema();
            String name = AbstractListTaskSource.this.getTableName();
            String keycah = AbstractListTaskSource.this.getHandlerKey();
            ((ClientCommandEditor)Application.window.getClient("command editor")).setActiveConnection(keycah);
            new DialogCommand(AbstractListTaskSource.this.getHandlerKey(), new QueryTokens.Table(schema, name)).show();
        }
    }

    protected class ActionShowDefinition
    extends AbstractAction {
        ActionShowDefinition() {
            super("show definition");
        }

        public void actionPerformed(ActionEvent e) {
            String type = AbstractListTaskSource.this.getTableType();
            String schema = AbstractListTaskSource.this.getTableSchema();
            String name = AbstractListTaskSource.this.getTableName();
            Application.window.add(new ClientDefinition(AbstractListTaskSource.this.getHandlerKey(), new QueryTokens.Table(schema, name), type));
        }
    }

    protected class ActionShowContent
    extends AbstractActionContent {
        ActionShowContent() {
            this.putValue("Name", "show content");
        }

        protected TableMetaData getTableMetaData() {
            return new TableMetaData(AbstractListTaskSource.this.getHandlerKey(), AbstractListTaskSource.this.getTableSchema(), AbstractListTaskSource.this.getTableName(), AbstractListTaskSource.this.getTableType());
        }

        protected void onActionPerformed(int records, int option) {
            if (option == 2 || records == 0 && option == 1) {
                return;
            }
            boolean retrieve = records > 0 && option == 0;
            String title = "CONTENT : " + this.getTableMetaData().getIdentifier() + " : " + this.getTableMetaData().getHandlerKey();
            Application.window.add(new ClientContent(title, this.getTableMetaData(), !this.getTableMetaData().getType().equals("TABLE"), retrieve));
        }

        protected int showConfirmDialog(int records) {
            if (records == 0) {
                String message = this.getDefaultMessage(records) + "\ndo you want continue?";
                return JOptionPane.showConfirmDialog(Application.window, message, "show content", 0);
            }
            String message = this.getDefaultMessage(records) + "\ndo you want retrieve?";
            return JOptionPane.showConfirmDialog(Application.window, message, "show content", 1);
        }
    }

    protected class ActionDropObject
    extends AbstractActionContent {
        ActionDropObject() {
            this.putValue("Name", "drop <object>");
        }

        protected TableMetaData getTableMetaData() {
            return new TableMetaData(AbstractListTaskSource.this.getHandlerKey(), AbstractListTaskSource.this.getTableSchema(), AbstractListTaskSource.this.getTableName(), AbstractListTaskSource.this.getTableType());
        }

        protected void onActionPerformed(int records, int option) {
            if (option == 1) {
                return;
            }
            try {
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.getTableMetaData().getHandlerKey());
                Statement stmt = ch.get().createStatement();
                stmt.execute("DROP " + this.getTableMetaData().getType() + " " + this.getTableMetaData());
                stmt.close();
                AbstractListTaskSource.this.removeSelectedRow();
            }
            catch (SQLException sqle) {
                Application.println(sqle, true);
            }
        }
    }

    protected class ActionDeleteContent
    extends AbstractActionContent {
        ActionDeleteContent() {
            this.putValue("Name", "delete content");
        }

        protected TableMetaData getTableMetaData() {
            return new TableMetaData(AbstractListTaskSource.this.getHandlerKey(), AbstractListTaskSource.this.getTableSchema(), AbstractListTaskSource.this.getTableName(), AbstractListTaskSource.this.getTableType());
        }

        protected void onActionPerformed(int records, int option) {
            if (option == 1) {
                return;
            }
            try {
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.getTableMetaData().getHandlerKey());
                Statement stmt = ch.get().createStatement();
                stmt.executeUpdate("DELETE FROM " + this.getTableMetaData());
                stmt.close();
            }
            catch (SQLException sqle) {
                Application.println(sqle, true);
            }
        }
    }

    protected class ActionAddLink
    extends AbstractAction {
        ActionAddLink() {
            super("add to group...");
        }

        public void actionPerformed(ActionEvent e) {
            int iDot = AbstractListTaskSource.this.getHandlerKey().indexOf(46);
            int iAt = AbstractListTaskSource.this.getHandlerKey().indexOf(64);
            String driver = AbstractListTaskSource.this.getHandlerKey().substring(0, iDot);
            String datasource = AbstractListTaskSource.this.getHandlerKey().substring(iDot + 1, iAt);
            ClientMetadataExplorer cme = (ClientMetadataExplorer)Application.window.getClient("metadata explorer");
            DefaultMutableTreeNode parent = cme.getControl().getNavigator().getRootNode();
            DefaultMutableTreeNode node = AbstractListTaskSource.findChild(parent = AbstractListTaskSource.findChild(parent, driver, false), datasource, false);
            if (node == null) {
                node = AbstractListTaskSource.findChild(parent, datasource, true);
            }
            UoLinks uoLk = (UoLinks)node.getLastLeaf().getUserObject();
            Object group = null;
            group = uoLk.getGroups().size() == 0 ? Application.input("SQLeonardo", "group name:") : JOptionPane.showInputDialog(Application.window, "choose group:", "SQLeonardo", -1, null, uoLk.getGroups().toArray(), null);
            if (group != null) {
                uoLk.add(group.toString(), AbstractListTaskSource.this.getTableSchema(), AbstractListTaskSource.this.getTableName(), AbstractListTaskSource.this.getTableType());
            }
        }
    }

    protected class ActionQuery
    extends AbstractAction
    implements Runnable {
        ActionQuery() {
            super("add to new query");
        }

        public void run() {
            AbstractListTaskSource.this.setCursor(new Cursor(3));
            String schema = AbstractListTaskSource.this.getTableSchema();
            String name = AbstractListTaskSource.this.getTableName();
            QueryModel model = new QueryModel(Preferences.getBoolean("querybuilder.use-schema") ? null : schema);
            QueryTokens.Table table = new QueryTokens.Table(Preferences.getBoolean("querybuilder.use-schema") ? schema : null, name);
            model.getQueryExpression().getQuerySpecification().addFromClause(table);
            ClientQueryBuilder client = new ClientQueryBuilder(AbstractListTaskSource.this.getHandlerKey());
            Application.window.add(client);
            client.setModel(model);
            AbstractListTaskSource.this.setCursor(new Cursor(0));
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(this).start();
        }
    }
}

