/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.plugins.FileCopyPlugin;
import org.netbeans.modules.refactoring.plugins.FileDeletePlugin;
import org.netbeans.modules.refactoring.plugins.FileMovePlugin;
import org.netbeans.modules.refactoring.plugins.FileRenamePlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class FileHandlingFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        Collection collection = abstractRefactoring.getRefactoringSource().lookupAll(FileObject.class);
        if (abstractRefactoring instanceof RenameRefactoring) {
            if (!collection.isEmpty()) {
                return new FileRenamePlugin((RenameRefactoring)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof MoveRefactoring) {
            if (!collection.isEmpty()) {
                return new FileMovePlugin((MoveRefactoring)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof SafeDeleteRefactoring) {
            if (!collection.isEmpty()) {
                return new FileDeletePlugin((SafeDeleteRefactoring)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof SingleCopyRefactoring && !collection.isEmpty()) {
            return new FileCopyPlugin((SingleCopyRefactoring)abstractRefactoring);
        }
        return null;
    }

    static FileObject getOrCreateFolder(URL uRL) throws IOException {
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                return fileObject;
            }
            File file = new File(uRL.toURI());
            fileObject = FileUtil.createFolder((File)file);
            return fileObject;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException().initCause(uRISyntaxException);
        }
    }
}

