/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.logpane.IRConsoleTopComponent;
import com.jaspersoft.ireport.designer.logpane.LogTextArea;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ReportRunner;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.ReportUnitRunDialog;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public final class RunReportUnitAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(RunReportUnitAction.class, (String)"CTL_RunReportUnitAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        this.runReportUnit(activatedNodes[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReportUnit(Node reportUnitNode) {
        if (!(reportUnitNode instanceof ResourceNode)) {
            return;
        }
        RepositoryFolder rf = ((ResourceNode)reportUnitNode).getRepositoryObject();
        RepositoryReportUnit reportUnit = null;
        ResourceDescriptor optionsRd = null;
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        if (rf.getDescriptor().getWsType().equals("ReportOptionsResource")) {
            try {
                optionsRd = rf.getDescriptor();
                String ruURI = optionsRd.getResourcePropertyValue("PROP_RU_URI");
                ResourceDescriptor reportRd = new ResourceDescriptor();
                reportRd.setUriString(ruURI);
                reportRd = rf.getServer().getWSClient().get(reportRd, null);
                reportUnit = new RepositoryReportUnit(rf.getServer(), reportRd);
                reportUnit.setLoaded(false);
                ResourceProperty rp = optionsRd.getResourceProperty("PROP_VALUES");
                List list = rp.getProperties();
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        String value;
                        ResourceProperty li = (ResourceProperty)list.get(i);
                        String string = value = li.getValue() == null ? "" : li.getValue();
                        if (li.getProperties().size() > 0) {
                            ArrayList<String> listVal = new ArrayList<String>();
                            for (int k = 0; k < li.getProperties().size(); ++k) {
                                ResourceProperty sli = (ResourceProperty)li.getProperties().get(k);
                                listVal.add(sli.getValue());
                            }
                            defaultValues.put(li.getName(), listVal);
                            continue;
                        }
                        defaultValues.put(li.getName(), value);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (reportUnit == null) {
            reportUnit = this.getParentReportUnit(reportUnitNode);
        }
        if (reportUnit != null) {
            JServer server = reportUnit.getServer();
            LogTextArea lta = IRConsoleTopComponent.getDefault().createNewLog();
            lta.setTitle(JasperServerManager.getFormattedString("repositoryExplorer.message.runningReport", "Running {0}", new Object[]{reportUnit.getDescriptor().getName()}));
            IRConsoleTopComponent.getDefault().setActiveLog(lta);
            try {
                int i;
                List list = server.getWSClient().list(reportUnit.getDescriptor());
                String dsUri = null;
                ArrayList<ResourceDescriptor> inputcontrols = new ArrayList<ResourceDescriptor>();
                for (i = 0; i < list.size(); ++i) {
                    ResourceDescriptor sub_rd = (ResourceDescriptor)list.get(i);
                    if (sub_rd.getWsType().equals("inputControl")) {
                        inputcontrols.add(sub_rd);
                        continue;
                    }
                    if (sub_rd.getWsType().equals("datasource")) {
                        dsUri = sub_rd.getReferenceUri();
                        continue;
                    }
                    if (!RepositoryFolder.isDataSource(sub_rd)) continue;
                    dsUri = sub_rd.getUriString();
                }
                for (i = 0; i < inputcontrols.size(); ++i) {
                    ResourceDescriptor ic = (ResourceDescriptor)inputcontrols.get(i);
                    if (ic.getControlType() != 4 && ic.getControlType() != 9 && ic.getControlType() != 7 && ic.getControlType() != 11) continue;
                    String dsUriQuery = null;
                    inputcontrols.remove(ic);
                    System.out.println("Looking for the right ds...");
                    ArrayList<Argument> args = new ArrayList<Argument>();
                    block12: for (int k = 0; dsUriQuery == null && k < ic.getChildren().size(); ++k) {
                        ResourceDescriptor sub_ic = (ResourceDescriptor)ic.getChildren().get(k);
                        System.out.println("Found child..." + sub_ic.getName() + " (" + sub_ic.getWsType() + ")");
                        if (!sub_ic.getWsType().equals("query")) continue;
                        System.out.println("Found the query child...");
                        for (int k2 = 0; k2 < sub_ic.getChildren().size(); ++k2) {
                            ResourceDescriptor sub_sub_ic = (ResourceDescriptor)sub_ic.getChildren().get(k2);
                            if (!RepositoryFolder.isDataSource(sub_sub_ic)) continue;
                            System.out.println("Found the ds child...");
                            dsUriQuery = sub_sub_ic.getUriString();
                            continue block12;
                        }
                    }
                    if (dsUriQuery == null) {
                        dsUriQuery = dsUri;
                    }
                    ic.setResourceProperty("PROP_QUERY_DATA", null);
                    args.add(new Argument("IC_GET_QUERY_DATA", dsUriQuery));
                    ic = server.getWSClient().get(ic, null, args);
                    inputcontrols.add(i, ic);
                }
                Map map = null;
                if (inputcontrols.size() > 0) {
                    ReportUnitRunDialog rurd = new ReportUnitRunDialog(Misc.getMainFrame(), true);
                    rurd.setServer(server);
                    rurd.setInputControls(inputcontrols, defaultValues);
                    rurd.setVisible(true);
                    if (rurd.getDialogResult() != 0) {
                        return;
                    }
                    map = rurd.getParametersValues();
                } else {
                    map = new HashMap();
                }
                ReportRunner rr = new ReportRunner();
                rr.setLta(lta);
                rr.setMap(map);
                rr.setReportUnit(reportUnit);
                rr.setServer(server);
                RequestProcessor.getDefault().post((Runnable)rr);
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                sw.flush();
                lta.logOnConsole(sw.toString(), false);
                ex.printStackTrace();
            }
            finally {
                lta.setRemovable(true);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof ResourceNode && ((ResourceNode)activatedNodes[0]).getResourceDescriptor().getWsType().equals("ReportOptionsResource") || this.getParentReportUnit(activatedNodes[0]) != null;
    }

    public RepositoryReportUnit getParentReportUnit(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ResourceNode && ((ResourceNode)node).getRepositoryObject() instanceof RepositoryReportUnit) {
            return (RepositoryReportUnit)((ResourceNode)node).getRepositoryObject();
        }
        return this.getParentReportUnit(node.getParentNode());
    }
}

