/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyLookup
extends Lookup {
    private static final Lookup[] EMPTY_ARR = new Lookup[0];
    private Object lookups;
    private HashMap<Lookup.Template<?>, Reference<R>> results;

    public ProxyLookup(Lookup ... lookupArray) {
        this.setLookupsNoFire(lookupArray);
    }

    protected ProxyLookup() {
        this(EMPTY_ARR);
    }

    public String toString() {
        return "ProxyLookup(class=" + this.getClass() + ")->" + Arrays.asList(this.getLookups(false));
    }

    protected final Lookup[] getLookups() {
        return this.getLookups(true);
    }

    private final Lookup[] getLookups(boolean bl) {
        Object object = this.lookups;
        if (object instanceof Lookup) {
            return new Lookup[]{(Lookup)object};
        }
        Lookup[] lookupArray = (Lookup[])object;
        if (bl) {
            lookupArray = (Lookup[])lookupArray.clone();
        }
        return lookupArray;
    }

    private Set<Lookup> identityHashSet(Collection<Lookup> collection) {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        for (Lookup lookup : collection) {
            identityHashMap.put(lookup, null);
        }
        return identityHashMap.keySet();
    }

    private void setLookupsNoFire(Lookup[] lookupArray) {
        if (lookupArray.length == 1) {
            this.lookups = lookupArray[0];
            assert (this.lookups != null) : "Cannot assign null delegate";
        } else {
            this.lookups = lookupArray.length == 0 ? EMPTY_ARR : lookupArray.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLookups(Lookup ... lookupArray) {
        ArrayList<Reference<R>> arrayList;
        IdentityHashMap<Lookup.Result, LookupListener> identityHashMap = new IdentityHashMap<Lookup.Result, LookupListener>();
        IdentityHashMap<Lookup.Result, LookupListener> identityHashMap2 = new IdentityHashMap<Lookup.Result, LookupListener>();
        Object object2 = this;
        synchronized (object2) {
            Lookup[] lookupArray2 = this.getLookups(false);
            Set<Lookup> set = this.identityHashSet(Arrays.asList(lookupArray2));
            Set<Lookup> set2 = this.identityHashSet(Arrays.asList(lookupArray));
            this.setLookupsNoFire(lookupArray);
            if (this.results == null || this.results.isEmpty()) {
                return;
            }
            arrayList = new ArrayList<Reference<R>>(this.results.values());
            Set<Lookup> iterator2 = this.identityHashSet(set);
            iterator2.removeAll(set2);
            set2.removeAll(set);
            if (iterator2.isEmpty() && set2.isEmpty()) {
                return;
            }
            for (Reference reference : arrayList) {
                R r = (R)reference.get();
                if (r == null) continue;
                r.lookupChange(set2, iterator2, lookupArray2, lookupArray, identityHashMap2, identityHashMap);
            }
        }
        for (Map.Entry entry : identityHashMap.entrySet()) {
            ((Lookup.Result)entry.getKey()).removeLookupListener((LookupListener)entry.getValue());
        }
        for (Map.Entry entry : identityHashMap2.entrySet()) {
            ((Lookup.Result)entry.getKey()).addLookupListener((LookupListener)entry.getValue());
        }
        object2 = new ArrayList();
        for (Reference reference : arrayList) {
            R r = (R)reference.get();
            if (r == null) continue;
            r.collectFires((Collection<Object>)object2);
        }
        Iterator iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            LookupEvent lookupEvent = (LookupEvent)iterator.next();
            LookupListener lookupListener = (LookupListener)iterator.next();
            lookupListener.resultChanged(lookupEvent);
        }
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    @Override
    public final <T> T lookup(Class<T> clazz) {
        this.beforeLookup(new Lookup.Template<T>(clazz));
        Lookup[] lookupArray = this.getLookups(false);
        for (int i = 0; i < lookupArray.length; ++i) {
            T t = lookupArray[i].lookup(clazz);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        this.beforeLookup(template);
        Lookup[] lookupArray = this.getLookups(false);
        for (int i = 0; i < lookupArray.length; ++i) {
            Lookup.Item<T> item = lookupArray[i].lookupItem(template);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private static <T> R<T> convertResult(R r) {
        return r;
    }

    @Override
    public final synchronized <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        Reference<R> reference;
        if (this.results != null) {
            R r;
            reference = this.results.get(template);
            R r2 = r = reference == null ? null : reference.get();
            if (r != null) {
                return ProxyLookup.convertResult(r);
            }
        } else {
            this.results = new HashMap();
        }
        reference = new R<T>(template);
        this.results.put(template, new SoftReference<Object>(reference));
        return reference;
    }

    private final synchronized void unregisterTemplate(Lookup.Template<?> template) {
        if (this.results == null) {
            return;
        }
        Reference<R> reference = this.results.remove(template);
        if (reference != null && reference.get() != null) {
            this.results.put(template, reference);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class R<T>
    extends WaitableResult<T> {
        private EventListenerList listeners;
        private Lookup.Template<T> template;
        private Collection[] cache;
        private WeakResult<T> weakL;

        public R(Lookup.Template<T> template) {
            this.template = template;
            this.weakL = new WeakResult(this);
        }

        protected void finalize() {
            ProxyLookup.this.unregisterTemplate(this.template);
        }

        private Lookup.Result<T>[] newResults(int n) {
            return new Lookup.Result[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup.Result<T>[] initResults() {
            Lookup[] lookupArray = this;
            synchronized (this) {
                if (((WeakResult)this.weakL).results != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return ((WeakResult)this.weakL).results;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                lookupArray = ProxyLookup.this.getLookups(false);
                Lookup.Result[] resultArray = super.newResults(lookupArray.length);
                for (int i = 0; i < resultArray.length; ++i) {
                    resultArray[i] = lookupArray[i].lookup(this.template);
                }
                Lookup[] lookupArray2 = this;
                synchronized (this) {
                    if (((WeakResult)this.weakL).results != null) {
                        // ** MonitorExit[var3_5] (shouldn't be in output)
                        return ((WeakResult)this.weakL).results;
                    }
                    for (int i = 0; i < resultArray.length; ++i) {
                        resultArray[i].addLookupListener(this.weakL);
                    }
                    WeakResult.access$102(this.weakL, resultArray);
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return resultArray;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void lookupChange(Set<Lookup> set, Set<Lookup> set2, Lookup[] lookupArray, Lookup[] lookupArray2, Map<Lookup.Result, LookupListener> map, Map<Lookup.Result, LookupListener> map2) {
            R r = this;
            synchronized (r) {
                if (((WeakResult)this.weakL).results == null) {
                    return;
                }
                IdentityHashMap<Lookup, Lookup.Result> identityHashMap = new IdentityHashMap<Lookup, Lookup.Result>(lookupArray.length * 2);
                for (int i = 0; i < lookupArray.length; ++i) {
                    if (set2.contains(lookupArray[i])) {
                        map2.put(((WeakResult)this.weakL).results[i], this.weakL);
                        continue;
                    }
                    identityHashMap.put(lookupArray[i], ((WeakResult)this.weakL).results[i]);
                }
                Lookup.Result[] resultArray = this.newResults(lookupArray2.length);
                for (int i = 0; i < lookupArray2.length; ++i) {
                    if (set.contains(lookupArray2[i])) {
                        resultArray[i] = lookupArray2[i].lookup(this.template);
                        map.put(resultArray[i], this.weakL);
                        continue;
                    }
                    resultArray[i] = (Lookup.Result)identityHashMap.get(lookupArray2[i]);
                    if (resultArray[i] != null) continue;
                    throw new IllegalStateException();
                }
                WeakResult.access$102(this.weakL, resultArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener lookupListener) {
            R r = this;
            synchronized (r) {
                if (this.listeners == null) {
                    this.listeners = new EventListenerList();
                }
            }
            this.listeners.add(LookupListener.class, lookupListener);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, lookupListener);
            }
        }

        @Override
        public Collection<T> allInstances() {
            return this.computeResult(0);
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return (Set)this.computeResult(1);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.computeResult(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeResult(int n) {
            AbstractCollection abstractCollection;
            Collection collection;
            Lookup.Result<T>[] resultArray = this.myBeforeLookup();
            AbstractCollection abstractCollection2 = this;
            synchronized (abstractCollection2) {
                if (this.cache != null && (collection = this.cache[n]) != null) {
                    return collection;
                }
            }
            if (n == 1) {
                abstractCollection2 = abstractCollection = new HashSet();
                collection = Collections.unmodifiableSet(abstractCollection);
            } else {
                abstractCollection2 = abstractCollection = new ArrayList(resultArray.length * 2);
                collection = Collections.unmodifiableList(abstractCollection);
            }
            block11: for (int i = 0; i < resultArray.length; ++i) {
                switch (n) {
                    case 0: {
                        abstractCollection2.addAll(resultArray[i].allInstances());
                        continue block11;
                    }
                    case 1: {
                        abstractCollection2.addAll(resultArray[i].allClasses());
                        continue block11;
                    }
                    case 2: {
                        abstractCollection2.addAll(resultArray[i].allItems());
                        continue block11;
                    }
                    default: {
                        assert (false) : "Wrong index: " + n;
                        continue block11;
                    }
                }
            }
            R r = this;
            synchronized (r) {
                if (this.cache == null) {
                    this.cache = new Collection[3];
                }
                if (resultArray == ((WeakResult)this.weakL).results) {
                    this.cache[n] = collection;
                }
            }
            return collection;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.collectFires(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> collection) {
            Collection<Lookup.Item<T>> collection2;
            Collection collection3;
            Collection collection4;
            R r = this;
            synchronized (r) {
                if (this.cache == null) {
                    return;
                }
                collection4 = this.cache[0];
                collection3 = this.cache[2];
                if (this.listeners == null || this.listeners.getListenerCount() == 0) {
                    this.cache = new Collection[3];
                    return;
                }
                this.cache = null;
            }
            boolean bl = true;
            if (collection3 != null) {
                collection2 = this.allItems();
                if (((Object)collection3).equals(collection2)) {
                    bl = false;
                }
            } else if (collection4 != null) {
                collection2 = this.allInstances();
                if (((Object)collection4).equals(collection2)) {
                    bl = false;
                }
            } else {
                collection2 = this;
                synchronized (collection2) {
                    if (this.cache == null) {
                        this.cache = new Collection[3];
                    }
                }
            }
            if (bl) {
                collection2 = new LookupEvent(this);
                AbstractLookup.notifyListeners(this.listeners.getListenerList(), (LookupEvent)((Object)collection2), collection);
            }
        }

        private Lookup.Result<T>[] myBeforeLookup() {
            ProxyLookup.this.beforeLookup(this.template);
            Lookup.Result<T>[] resultArray = this.initResults();
            for (int i = 0; i < resultArray.length; ++i) {
                if (!(resultArray[i] instanceof WaitableResult)) continue;
                WaitableResult waitableResult = (WaitableResult)resultArray[i];
                waitableResult.beforeLookup(this.template);
            }
            return resultArray;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            if (template.getType() == this.template.getType()) {
                this.myBeforeLookup();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result<T>[] results;
        private Reference<R> result;

        public WeakResult(R r) {
            this.result = new WeakReference<R>(r);
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            R r = this.result.get();
            if (r != null) {
                r.beforeLookup(template);
            } else {
                this.removeListeners();
            }
        }

        private void removeListeners() {
            Lookup.Result<T>[] resultArray = this.results;
            if (resultArray == null) {
                return;
            }
            for (int i = 0; i < resultArray.length; ++i) {
                resultArray[i].removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> collection) {
            R r = this.result.get();
            if (r != null) {
                r.collectFires(collection);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            R r = this.result.get();
            if (r != null) {
                r.resultChanged(lookupEvent);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        static /* synthetic */ Lookup.Result[] access$102(WeakResult weakResult, Lookup.Result[] resultArray) {
            weakResult.results = resultArray;
            return resultArray;
        }
    }
}

