/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.modules.diff.builtin.visualizer.editable.DecoratedEditorPane;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffViewManager;
import org.netbeans.modules.diff.builtin.visualizer.editable.HotSpot;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class LineNumbersActionsBar
extends JPanel
implements Scrollable,
MouseMotionListener,
MouseListener,
PropertyChangeListener {
    private static final int ACTIONS_BAR_WIDTH = 16;
    private static final int LINES_BORDER_WIDTH = 4;
    private static final Point POINT_ZERO = new Point(0, 0);
    private final Image insertImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/insert.png");
    private final Image removeImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/remove.png");
    private final Image insertActiveImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/insert_active.png");
    private final Image removeActiveImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/remove_active.png");
    private final DiffContentPanel master;
    private final boolean actionsEnabled;
    private final int actionIconsHeight;
    private final int actionIconsWidth;
    private final String lineNumberPadding = "        ";
    private Map renderingHints;
    private int linesWidth;
    private int actionsWidth;
    private Color linesColor;
    private int linesCount;
    private int maxNumberCount;
    private Point lastMousePosition = POINT_ZERO;
    private HotSpot lastHotSpot = null;
    private List<HotSpot> hotspots = new ArrayList<HotSpot>(0);
    private int oldLinesWidth;

    public LineNumbersActionsBar(DiffContentPanel diffContentPanel, boolean bl) {
        this.master = diffContentPanel;
        this.actionsEnabled = bl;
        this.actionsWidth = bl ? 16 : 0;
        this.actionIconsHeight = this.insertImage.getHeight(this);
        this.actionIconsWidth = this.insertImage.getWidth(this);
        this.setOpaque(true);
        this.setToolTipText("");
        diffContentPanel.getMaster().addPropertyChangeListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.initUI();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaint();
    }

    private Font getLinesFont() {
        Map map = EditorUIHelper.getSharedColoringMapFor(this.master.getEditorPane().getEditorKit().getClass());
        Object v = map.get("line-number");
        Coloring coloring = null;
        coloring = v != null && v instanceof Coloring ? (Coloring)v : SettingsDefaults.defaultLineNumberColoring;
        Font font = coloring.getFont();
        if (font == null) {
            font = ((Coloring)map.get("default")).getFont();
        }
        return font;
    }

    private void initUI() {
        Color color;
        Map map = EditorUIHelper.getSharedColoringMapFor(this.master.getEditorPane().getEditorKit().getClass());
        Object v = map.get("line-number");
        Coloring coloring = null;
        coloring = v != null && v instanceof Coloring ? (Coloring)v : SettingsDefaults.defaultLineNumberColoring;
        this.linesColor = coloring.getForeColor();
        if (this.linesColor == null) {
            this.linesColor = ((Coloring)map.get("default")).getForeColor();
        }
        if ((color = coloring.getBackColor()) == null) {
            color = ((Coloring)map.get("default")).getBackColor();
        }
        this.setBackground(color);
        this.updateStateOnDocumentChange();
    }

    private HotSpot getHotspotAt(Point point) {
        for (HotSpot hotSpot : this.hotspots) {
            if (!hotSpot.getRect().contains(point)) continue;
            return hotSpot;
        }
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        HotSpot hotSpot = this.getHotspotAt(point);
        if (hotSpot == null) {
            return null;
        }
        Difference difference = hotSpot.getDiff();
        if (difference.getType() == 1) {
            return NbBundle.getMessage(LineNumbersActionsBar.class, (String)"TT_DiffPanel_Remove");
        }
        if (difference.getType() == 2) {
            return NbBundle.getMessage(LineNumbersActionsBar.class, (String)"TT_DiffPanel_Replace");
        }
        return NbBundle.getMessage(LineNumbersActionsBar.class, (String)"TT_DiffPanel_Insert");
    }

    private void performAction(HotSpot hotSpot) {
        this.master.getMaster().rollback(hotSpot.getDiff());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        HotSpot hotSpot;
        if (!mouseEvent.isPopupTrigger() && (hotSpot = this.getHotspotAt(mouseEvent.getPoint())) != null) {
            this.performAction(hotSpot);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.lastMousePosition = POINT_ZERO;
        if (this.lastHotSpot != null) {
            this.repaint(this.lastHotSpot.getRect());
        }
        this.lastHotSpot = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point;
        this.lastMousePosition = point = mouseEvent.getPoint();
        HotSpot hotSpot = this.getHotspotAt(point);
        if (this.lastHotSpot != hotSpot) {
            this.repaint(this.lastHotSpot == null ? hotSpot.getRect() : this.lastHotSpot.getRect());
        }
        this.lastHotSpot = hotSpot;
        this.setCursor(hotSpot != null ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    void onUISettingsChanged() {
        this.initUI();
        this.updateStateOnDocumentChange();
        this.repaint();
    }

    private void updateStateOnDocumentChange() {
        assert (SwingUtilities.isEventDispatchThread());
        StyledDocument styledDocument = (StyledDocument)this.master.getEditorPane().getDocument();
        int n = styledDocument.getEndPosition().getOffset();
        this.linesCount = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.checkLinesWidth(graphics);
        }
        this.maxNumberCount = this.getNumberCount(this.linesCount);
        this.revalidate();
    }

    private boolean checkLinesWidth(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getLinesFont());
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(Integer.toString(this.linesCount), graphics);
        this.linesWidth = (int)rectangle2D.getWidth() + 8;
        if (this.linesWidth != this.oldLinesWidth) {
            this.oldLinesWidth = this.linesWidth;
            this.revalidate();
            this.repaint();
            return true;
        }
        return false;
    }

    private int getNumberCount(int n) {
        int n2 = 0;
        while (n > 0) {
            n /= 10;
            ++n2;
        }
        return n2;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.master.getEditorPane().getPreferredScrollableViewportSize();
        return new Dimension(this.getBarWidth(), dimension.height);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.master.getEditorPane().getScrollableUnitIncrement(rectangle, n, n2);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.master.getEditorPane().getScrollableBlockIncrement(rectangle, n, n2);
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getBarWidth(), 0x1FFFFFFF);
    }

    private int getBarWidth() {
        return this.actionsWidth + this.linesWidth;
    }

    public void onDiffSetChanged() {
        this.updateStateOnDocumentChange();
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle;
        int n;
        DecoratedEditorPane decoratedEditorPane;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle2 = graphics2D.getClipBounds();
        Stroke stroke = graphics2D.getStroke();
        if (this.checkLinesWidth(graphics)) {
            return;
        }
        if (this.renderingHints == null) {
            decoratedEditorPane = this.master.getEditorPane();
            Class<?> clazz = decoratedEditorPane.getEditorKit().getClass();
            Object object = Settings.getValue(clazz, (String)"rendering-hints");
            Map map = this.renderingHints = object instanceof Map && ((Map)object).size() > 0 ? (Map)object : null;
        }
        if (this.renderingHints != null) {
            graphics2D.addRenderingHints(this.renderingHints);
        }
        decoratedEditorPane = org.netbeans.editor.Utilities.getEditorUI((JTextComponent)this.master.getEditorPane());
        int n2 = decoratedEditorPane.getLineHeight();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics2D.setColor(Color.LIGHT_GRAY);
        int n3 = this.master.isFirst() ? 0 : this.getBarWidth() - 1;
        graphics2D.drawLine(n3, rectangle2.y, n3, rectangle2.y + rectangle2.height - 1);
        DiffViewManager.DecoratedDifference[] decoratedDifferenceArray = this.master.getMaster().getManager().getDecorations();
        int n4 = (n2 - this.actionIconsHeight) / 2;
        int n5 = this.linesWidth;
        int n6 = this.master.getMaster().getCurrentDifference();
        ArrayList<HotSpot> arrayList = new ArrayList<HotSpot>();
        if (this.master.isFirst()) {
            n = 0;
            for (DiffViewManager.DecoratedDifference decoratedDifference : decoratedDifferenceArray) {
                graphics2D.setColor(this.master.getMaster().getColorLines());
                graphics2D.setStroke(n6 == n ? this.master.getMaster().getBoldStroke() : stroke);
                graphics2D.drawLine(0, decoratedDifference.getTopLeft(), rectangle2.width, decoratedDifference.getTopLeft());
                if (decoratedDifference.getBottomLeft() != -1) {
                    graphics2D.drawLine(0, decoratedDifference.getBottomLeft(), rectangle2.width, decoratedDifference.getBottomLeft());
                }
                if (this.actionsEnabled && decoratedDifference.canRollback() && decoratedDifference.getDiff().getType() != 1) {
                    rectangle = new Rectangle(1, decoratedDifference.getTopLeft() + n4, this.actionIconsWidth, this.actionIconsHeight);
                    if (rectangle.contains(this.lastMousePosition) || n == n6) {
                        graphics2D.drawImage(this.insertActiveImage, rectangle.x, rectangle.y, this);
                    } else {
                        graphics2D.drawImage(this.insertImage, rectangle.x, rectangle.y, this);
                    }
                    arrayList.add(new HotSpot(rectangle, decoratedDifference.getDiff()));
                }
                ++n;
            }
        } else {
            n = 0;
            for (DiffViewManager.DecoratedDifference decoratedDifference : decoratedDifferenceArray) {
                graphics2D.setColor(this.master.getMaster().getColorLines());
                graphics2D.setStroke(n6 == n ? this.master.getMaster().getBoldStroke() : stroke);
                graphics2D.drawLine(rectangle2.x, decoratedDifference.getTopRight(), rectangle2.x + rectangle2.width, decoratedDifference.getTopRight());
                if (decoratedDifference.getBottomRight() != -1) {
                    graphics2D.drawLine(rectangle2.x, decoratedDifference.getBottomRight(), rectangle2.x + rectangle2.width, decoratedDifference.getBottomRight());
                }
                if (this.actionsEnabled && decoratedDifference.canRollback() && decoratedDifference.getDiff().getType() == 1) {
                    rectangle = new Rectangle(n5 + 1, decoratedDifference.getTopRight() + n4, this.actionIconsWidth, this.actionIconsHeight);
                    if (rectangle.contains(this.lastMousePosition) || n == n6) {
                        graphics2D.drawImage(this.removeActiveImage, rectangle.x, rectangle.y, this);
                    } else {
                        graphics2D.drawImage(this.removeImage, rectangle.x, rectangle.y, this);
                    }
                    arrayList.add(new HotSpot(rectangle, decoratedDifference.getDiff()));
                }
                ++n;
            }
        }
        this.hotspots = arrayList;
        n = this.master.isFirst() ? this.actionsWidth : 0;
        n += 4;
        graphics2D.setFont(this.getLinesFont());
        graphics2D.setColor(this.linesColor);
        int n7 = rectangle2.y / n2;
        int n8 = n7 * n2;
        n8 -= n2 / 4;
        int n9 = rectangle2.height / n2 + 3;
        int n10 = org.netbeans.editor.Utilities.getRowCount((BaseDocument)((BaseDocument)this.master.getEditorPane().getDocument()));
        if (n7 + n9 - 1 > n10) {
            n9 = n10 - n7 + 1;
        }
        for (int i = 0; i < n9; ++i) {
            graphics2D.drawString(this.formatLineNumber(n7), n, n8);
            ++n7;
            n8 += n2;
        }
    }

    private String formatLineNumber(int n) {
        String string = Integer.toString(n);
        int n2 = this.getNumberCount(n);
        if (n2 < this.maxNumberCount) {
            StringBuilder stringBuilder = new StringBuilder(10);
            stringBuilder.append("        ", 0, this.maxNumberCount - n2);
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
        return string;
    }

    private static class EditorUIHelper
    extends EditorUI {
        private EditorUIHelper() {
        }

        public static Map getSharedColoringMapFor(Class clazz) {
            return EditorUIHelper.getSharedColoringMap((Class)clazz);
        }
    }
}

