/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.diff.DiffAction;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.netbeans.modules.diff.builtin.ContextualPatch;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchAction
extends NodeAction {
    private static final String PREF_RECENT_PATCH_PATH = "patch.recentPatchDir";

    public PatchAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(PatchAction.class, (String)"CTL_PatchActionName");
    }

    public boolean enable(Node[] nodeArray) {
        FileObject fileObject;
        if (nodeArray.length == 1 && (fileObject = DiffAction.getFileFromNode(nodeArray[0])) != null) {
            try {
                return fileObject.getURL().getProtocol().equals("file");
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return false;
            }
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        final FileObject fileObject = DiffAction.getFileFromNode(nodeArray[0]);
        if (fileObject != null) {
            final File file = this.getPatchFor(fileObject);
            if (file == null) {
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ContextualPatch contextualPatch = ContextualPatch.create(file, FileUtil.toFile((FileObject)fileObject));
                    try {
                        List<ContextualPatch.PatchReport> list = contextualPatch.patch(false);
                        PatchAction.this.displayPatchReport(list);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().annotate((Throwable)exception, NbBundle.getMessage(PatchAction.class, (String)"EXC_PatchParsingFailed", (Object)exception.getLocalizedMessage()));
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                        ErrorManager.getDefault().notify(256, (Throwable)exception);
                        return;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayPatchReport(List<ContextualPatch.PatchReport> list) {
        ContextualPatch.PatchReport patchReport22;
        ArrayList<ContextualPatch.PatchReport> arrayList = new ArrayList<ContextualPatch.PatchReport>();
        ArrayList<ContextualPatch.PatchReport> arrayList2 = new ArrayList<ContextualPatch.PatchReport>();
        for (ContextualPatch.PatchReport patchReport22 : list) {
            switch (patchReport22.getStatus()) {
                case Patched: {
                    arrayList.add(patchReport22);
                    break;
                }
                case Failure: 
                case Missing: {
                    arrayList2.add(patchReport22);
                }
            }
        }
        InputOutput inputOutput = IOProvider.getDefault().getIO("Patch Report", false);
        patchReport22 = inputOutput.getOut();
        try {
            patchReport22.print(DateFormat.getDateTimeInstance().format(new Date()));
            patchReport22.println("  ===========================================================================");
            patchReport22.println("--- Successfully Patched ---");
            if (arrayList.size() > 0) {
                for (ContextualPatch.PatchReport object2 : arrayList) {
                    patchReport22.println(object2.getFile().getAbsolutePath());
                }
            } else {
                patchReport22.println("<none>");
            }
            patchReport22.println("--- Failed ---");
            if (arrayList2.size() > 0) {
                for (ContextualPatch.PatchReport patchReport : arrayList2) {
                    patchReport22.print(patchReport.getFile().getAbsolutePath());
                    patchReport22.print(" (");
                    patchReport22.print(patchReport.getFailure().getLocalizedMessage());
                    patchReport22.println(" )");
                }
            } else {
                patchReport22.println("<none>");
            }
        }
        finally {
            patchReport22.close();
        }
        if (arrayList.size() > 0) {
            ArrayList arrayList3 = new ArrayList();
            ArrayList<FileObject> arrayList4 = new ArrayList<FileObject>();
            HashMap<FileObject, FileObject> hashMap = new HashMap<FileObject, FileObject>();
            for (ContextualPatch.PatchReport patchReport : arrayList) {
                FileObject fileObject = FileUtil.toFileObject((File)patchReport.getFile());
                FileObject fileObject2 = FileUtil.toFileObject((File)patchReport.getOriginalBackupFile());
                if (patchReport.isBinary()) {
                    arrayList3.add(fileObject);
                }
                arrayList4.add(fileObject);
                hashMap.put(fileObject, fileObject2);
            }
            String string = arrayList2.size() > 0 ? NbBundle.getMessage(PatchAction.class, (String)"MSG_PatchAppliedPartially") : NbBundle.getMessage(PatchAction.class, (String)"MSG_PatchAppliedSuccessfully");
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string, 0));
            if (NotifyDescriptor.YES_OPTION.equals(object)) {
                this.showDiffs(arrayList4, arrayList3, hashMap);
            }
            PatchAction.removeBackups(arrayList4, hashMap);
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PatchAction.class, (String)"MSG_WrongPatch")));
        }
    }

    private File getPatchFor(FileObject fileObject) {
        JFileChooser jFileChooser = new JFileChooser();
        String string = DiffModuleConfig.getDefault().getPreferences().get(PREF_RECENT_PATCH_PATH, System.getProperty("user.home"));
        File file = new File(string);
        while (!file.isDirectory()) {
            if ((file = file.getParentFile()) != null) continue;
            file = new File(System.getProperty("user.home"));
            break;
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, (File)file);
        jFileChooser.setFileSelectionMode(0);
        String string2 = NbBundle.getMessage(PatchAction.class, (String)(fileObject.isData() ? "TITLE_SelectPatchForFile" : "TITLE_SelectPatchForFolder"), (Object)fileObject.getNameExt());
        jFileChooser.setDialogTitle(string2);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith("diff") || file.getName().endsWith("patch") || file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(PatchAction.class, (String)"CTL_PatchDialog_FileFilter");
            }
        };
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setApproveButtonText(NbBundle.getMessage(PatchAction.class, (String)"BTN_Patch"));
        jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(PatchAction.class, (String)"BTN_Patch_mnc").charAt(0));
        jFileChooser.setApproveButtonToolTipText(NbBundle.getMessage(PatchAction.class, (String)"BTN_Patch_tooltip"));
        HelpCtx helpCtx = new HelpCtx(PatchAction.class.getName());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jFileChooser, string2, true, new Object[0], null, 0, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PatchAction.class, (String)"ACSD_PatchDialog"));
        ChooserListener chooserListener = new ChooserListener(dialog, jFileChooser);
        jFileChooser.addActionListener(chooserListener);
        dialog.setVisible(true);
        File file2 = chooserListener.getFile();
        if (file2 != null) {
            DiffModuleConfig.getDefault().getPreferences().put(PREF_RECENT_PATCH_PATH, file2.getParentFile().getAbsolutePath());
        }
        return file2;
    }

    private void showDiffs(List<FileObject> list, List<FileObject> list2, Map<FileObject, FileObject> map) {
        for (int i = 0; i < list.size(); ++i) {
            FileObject fileObject = list.get(i);
            FileObject fileObject2 = map.get(fileObject);
            if (list2.contains(fileObject)) continue;
            if (fileObject2 == null) {
                try {
                    fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)File.createTempFile("diff-empty-backup", "")));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            DiffAction.performAction(fileObject2, fileObject, fileObject);
        }
    }

    private static void removeBackups(List<FileObject> list, Map<FileObject, FileObject> map) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            FileObject fileObject = list.get(i);
            FileObject fileObject2 = map.get(fileObject);
            if (fileObject != null && fileObject.getSize() == 0L && fileObject2 != null && fileObject2.isValid() && fileObject2.getSize() > 0L) {
                try {
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)iOException, "Patch can not delete file, skipping...");
                    errorManager.notify(1, (Throwable)iOException);
                }
            }
            if (fileObject2 == null || !fileObject2.isValid()) continue;
            try {
                fileObject2.delete();
                continue;
            }
            catch (IOException iOException) {
                stringBuffer.append(FileUtil.getFileDisplayName((FileObject)fileObject2));
                stringBuffer.append('\n');
                stringBuffer2.append(iOException.getLocalizedMessage());
                stringBuffer2.append('\n');
            }
        }
        if (stringBuffer.length() > 0) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)new IOException(), NbBundle.getMessage(PatchAction.class, (String)"EXC_CannotRemoveBackup", (Object)stringBuffer, (Object)stringBuffer2)));
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PatchAction.class);
    }

    class ChooserListener
    implements ActionListener {
        private Dialog dialog;
        private JFileChooser chooser;
        private File file = null;

        public ChooserListener(Dialog dialog, JFileChooser jFileChooser) {
            this.dialog = dialog;
            this.chooser = jFileChooser;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "ApproveSelection") {
                if (this.dialog != null) {
                    this.file = this.chooser.getSelectedFile();
                    this.dialog.setVisible(false);
                }
            } else if (this.dialog != null) {
                this.file = null;
                this.dialog.setVisible(false);
            }
        }

        public File getFile() {
            return this.file;
        }
    }
}

