/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.core.startup.layers.FixedFileSystem;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class SystemFileSystem
extends MultiFileSystem
implements FileSystem.Status {
    static final long serialVersionUID = -7761052280240991668L;
    private static final String SYSTEM_NAME = "SystemFileSystem";
    private static final String ATTR_BUNDLE = "SystemFileSystem.localizingBundle";
    private static final String ATTR_ICON_16 = "SystemFileSystem.icon";
    private static final String ATTR_ICON_32 = "SystemFileSystem.icon32";
    private ModuleLayeredFileSystem user;
    private ModuleLayeredFileSystem home;

    private SystemFileSystem(FileSystem[] fileSystemArray) throws PropertyVetoException {
        super(fileSystemArray);
        this.user = (ModuleLayeredFileSystem)fileSystemArray[0];
        this.home = fileSystemArray.length > 2 ? (ModuleLayeredFileSystem)fileSystemArray[1] : null;
        this.setSystemName(SYSTEM_NAME);
        this.setHidden(true);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SystemFileSystem.class, (String)"CTL_SystemFileSystem");
    }

    public ModuleLayeredFileSystem getInstallationLayer() {
        return this.home;
    }

    public ModuleLayeredFileSystem getUserLayer() {
        return this.user;
    }

    public final void setLayers(FileSystem[] fileSystemArray) throws IllegalArgumentException {
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (hashSet.contains(fileSystemArray[i])) {
                throw new IllegalArgumentException("Overlap in filesystem layers");
            }
            hashSet.add(fileSystemArray[i]);
        }
        this.setDelegates((FileSystem[])fileSystemArray.clone());
        this.firePropertyChange("layers", null, null);
    }

    public FileSystem[] getLayers() {
        return (FileSystem[])this.getDelegates().clone();
    }

    protected FileSystem createWritableOnForRename(String string, String string2) throws IOException {
        return this.createWritableOn(string);
    }

    protected FileSystem createWritableOn(String string) throws IOException {
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i].isReadOnly()) continue;
            return fileSystemArray[i];
        }
        throw new IOException("No writable filesystems in our delegates");
    }

    protected Set createLocksOn(String string) throws IOException {
        LocalFileSystemEx.potentialLock(string);
        return super.createLocksOn(string);
    }

    @Deprecated
    public boolean isPersistent() {
        return true;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String string, Set set) {
        for (FileObject fileObject : set) {
            Object object;
            String string2 = (String)fileObject.getAttribute(ATTR_BUNDLE);
            if (string2 != null) {
                try {
                    string2 = Utilities.translate((String)string2);
                    object = NbBundle.getBundle((String)string2);
                    try {
                        return ((ResourceBundle)object).getString(fileObject.getPath());
                    }
                    catch (MissingResourceException missingResourceException) {
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    ModuleLayeredFileSystem.err.log(Level.WARNING, "Computing display name for " + fileObject, missingResourceException);
                }
            }
            if ((object = FixedFileSystem.deflt.annotateName(fileObject.getPath())) == null) continue;
            return object;
        }
        return string;
    }

    public Image annotateIcon(Image image, int n, Set set) {
        String string;
        if (n == 1) {
            string = ATTR_ICON_16;
        } else if (n == 2) {
            string = ATTR_ICON_32;
        } else {
            return image;
        }
        for (FileObject fileObject : set) {
            Image image2;
            Object object = fileObject.getAttribute(string);
            if (object != null) {
                if (object instanceof URL) {
                    return Toolkit.getDefaultToolkit().getImage((URL)object);
                }
                if (object instanceof Image) {
                    return (Image)object;
                }
                ModuleLayeredFileSystem.err.warning("Attribute " + string + " on " + fileObject + " expected to be a URL or Image; was: " + object);
            }
            if ((image2 = FixedFileSystem.deflt.annotateIcon(fileObject.getPath())) == null) continue;
            return image2;
        }
        return image;
    }

    static SystemFileSystem create(File file, File file2, File[] fileArray) throws PropertyVetoException, IOException {
        LocalFileSystemEx localFileSystemEx;
        Object object;
        Object object2;
        Object object3;
        if (file != null) {
            if (!file.exists()) {
                file.mkdirs();
            }
            object3 = new LocalFileSystemEx(true);
            object3.setRootDirectory(file);
            object2 = object3;
        } else {
            object3 = System.getProperty("org.netbeans.core.systemfilesystem.custom");
            if (object3 != null) {
                try {
                    Class<?> clazz = Class.forName((String)object3);
                    object = clazz.newInstance();
                    object2 = (FileSystem)object;
                }
                catch (Exception exception) {
                    ModuleLayeredFileSystem.err.log(Level.WARNING, "Custom system file system writable layer init failed ", exception);
                    object2 = FileUtil.createMemoryFileSystem();
                }
            } else {
                object2 = FileUtil.createMemoryFileSystem();
            }
        }
        if (file2 == null) {
            localFileSystemEx = null;
        } else {
            localFileSystemEx = new LocalFileSystemEx();
            localFileSystemEx.setRootDirectory(file2);
            localFileSystemEx.setReadOnly(true);
        }
        object3 = new LocalFileSystem[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            object3[i] = new LocalFileSystemEx();
            object3[i].setRootDirectory(fileArray[i]);
            object3[i].setReadOnly(true);
        }
        FileSystem[] fileSystemArray = new FileSystem[localFileSystemEx == null ? 2 : 3];
        fileSystemArray[0] = new ModuleLayeredFileSystem((FileSystem)object2, true, new FileSystem[0], null);
        if (localFileSystemEx != null) {
            object = new File(new File(file.getParentFile(), "var"), "cache");
            fileSystemArray[1] = new ModuleLayeredFileSystem((FileSystem)localFileSystemEx, false, (FileSystem[])object3, (File)object);
        }
        FixedFileSystem.deflt = new FixedFileSystem("org.netbeans.core.projects.FixedFileSystem", "Automatic Manifest Installation");
        fileSystemArray[localFileSystemEx == null ? 1 : 2] = FixedFileSystem.deflt;
        return new SystemFileSystem(fileSystemArray);
    }

    protected void notifyMigration(FileObject fileObject) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fileObject, false, true));
    }

    private Object writeReplace() throws ObjectStreamException {
        new NotSerializableException("WARNING - SystemFileSystem is not designed to be serialized").printStackTrace();
        return new SingletonSerializer();
    }

    private static final class SingletonSerializer
    implements Serializable {
        private static final long serialVersionUID = 6436781994611L;

        SingletonSerializer() {
        }

        private Object readResolve() throws ObjectStreamException {
            return Repository.getDefault().getDefaultFileSystem();
        }
    }
}

