/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.util.HashMap;

public class FontMetricsCache {
    private static HashMap font2FM = new HashMap();
    private static HashMap font2Info = new HashMap();

    public static synchronized FontMetrics getFontMetrics(Font font, Component component) {
        Object object = font2FM.get(font);
        if (object == null) {
            object = component.getFontMetrics(font);
            font2FM.put(font, object);
        }
        return (FontMetrics)object;
    }

    public static synchronized FontMetrics getFontMetrics(Font font, Graphics graphics) {
        Object object = font2FM.get(font);
        if (object == null) {
            object = graphics.getFontMetrics(font);
            font2FM.put(font, object);
        }
        return (FontMetrics)object;
    }

    public static synchronized Info getInfo(Font font) {
        Info info = (Info)font2Info.get(font);
        if (info == null) {
            info = new InfoImpl(font);
            font2Info.put(font, info);
        }
        return info;
    }

    public static synchronized void clear() {
        font2FM.clear();
        font2Info.clear();
    }

    public static interface Info {
        public int getSpaceWidth(Graphics var1);

        public int getSpaceWidth(Component var1);

        public float getStrikethroughOffset(Graphics var1);

        public float getStrikethroughOffset(Component var1);

        public float getStrikethroughThickness(Graphics var1);

        public float getStrikethroughThickness(Component var1);

        public float getUnderlineOffset(Graphics var1);

        public float getUnderlineOffset(Component var1);

        public float getUnderlineThickness(Graphics var1);

        public float getUnderlineThickness(Component var1);
    }

    private static class InfoImpl
    implements Info {
        private static final int SW_INITED = 1;
        private static final int ST_INITED = 2;
        private static final int UL_INITED = 4;
        private Font font;
        private int inited;
        private int spaceWidth;
        private float strikethroughOffset;
        private float strikethroughThickness;
        private float underlineOffset;
        private float underlineThickness;

        InfoImpl(Font font) {
            this.font = font;
        }

        private synchronized void initSpaceWidth(Graphics graphics, Component component) {
            FontMetrics fontMetrics = graphics != null ? FontMetricsCache.getFontMetrics(this.font, graphics) : FontMetricsCache.getFontMetrics(this.font, component);
            this.spaceWidth = fontMetrics.stringWidth(" ");
            if (this.spaceWidth <= 0) {
                this.spaceWidth = fontMetrics.stringWidth("A") / 3;
            }
            this.inited |= 1;
        }

        private synchronized void initStrikethrough(Graphics graphics) {
            LineMetrics lineMetrics = this.font.getLineMetrics("aAyY", ((Graphics2D)graphics).getFontRenderContext());
            this.strikethroughOffset = lineMetrics.getStrikethroughOffset();
            this.strikethroughThickness = lineMetrics.getStrikethroughThickness();
            this.inited |= 2;
        }

        private synchronized void initUnderline(Graphics graphics) {
            LineMetrics lineMetrics = this.font.getLineMetrics("aAyY", ((Graphics2D)graphics).getFontRenderContext());
            this.underlineOffset = lineMetrics.getUnderlineOffset();
            this.underlineThickness = lineMetrics.getUnderlineThickness();
            this.inited |= 4;
        }

        public int getSpaceWidth(Graphics graphics) {
            if ((this.inited & 1) == 0) {
                this.initSpaceWidth(graphics, null);
            }
            return this.spaceWidth;
        }

        public int getSpaceWidth(Component component) {
            if ((this.inited & 1) == 0) {
                this.initSpaceWidth(null, component);
            }
            return this.spaceWidth;
        }

        public float getStrikethroughOffset(Graphics graphics) {
            if ((this.inited & 2) == 0) {
                this.initStrikethrough(graphics);
            }
            return this.strikethroughOffset;
        }

        public float getStrikethroughOffset(Component component) {
            if ((this.inited & 2) == 0) {
                this.initStrikethrough(component.getGraphics());
            }
            return this.strikethroughOffset;
        }

        public float getStrikethroughThickness(Graphics graphics) {
            if ((this.inited & 2) == 0) {
                this.initStrikethrough(graphics);
            }
            return this.strikethroughThickness;
        }

        public float getStrikethroughThickness(Component component) {
            if ((this.inited & 2) == 0) {
                this.initStrikethrough(component.getGraphics());
            }
            return this.strikethroughThickness;
        }

        public float getUnderlineOffset(Graphics graphics) {
            if ((this.inited & 4) == 0) {
                this.initUnderline(graphics);
            }
            return this.underlineOffset;
        }

        public float getUnderlineOffset(Component component) {
            if ((this.inited & 4) == 0) {
                this.initUnderline(component.getGraphics());
            }
            return this.underlineOffset;
        }

        public float getUnderlineThickness(Graphics graphics) {
            if ((this.inited & 4) == 0) {
                this.initUnderline(graphics);
            }
            return this.underlineThickness;
        }

        public float getUnderlineThickness(Component component) {
            if ((this.inited & 4) == 0) {
                this.initUnderline(component.getGraphics());
            }
            return this.underlineThickness;
        }
    }
}

