/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.util.Vector;
import org.eigenbase.xom.XOMUtil;

public class StringEscaper
implements Cloneable {
    private Vector translationVector = new Vector();
    private String[] translationTable;
    public static StringEscaper xmlEscaper;
    public static StringEscaper xmlNumericEscaper;
    public static StringEscaper htmlEscaper;
    public static StringEscaper urlArgEscaper;
    public static StringEscaper urlEscaper;

    public void defineEscape(char c, String string) {
        char c2 = c;
        if (c2 >= this.translationVector.size()) {
            this.translationVector.setSize(c2 + '\u0001');
        }
        this.translationVector.setElementAt(string, c2);
    }

    public void makeImmutable() {
        this.translationTable = new String[this.translationVector.size()];
        this.translationVector.copyInto(this.translationTable);
        this.translationVector = null;
    }

    public String escapeString(String string) {
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            String string2 = c > '\u007f' ? "&#" + Integer.toString(c) + ";" : (c >= this.translationTable.length ? null : this.translationTable[c]);
            if (string2 == null) {
                if (stringBuffer == null) continue;
                stringBuffer.append(c);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n * 2);
                stringBuffer.append(string.substring(0, i));
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    public void appendEscapedString(String string, StringBuffer stringBuffer) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            String string2 = c >= this.translationTable.length ? null : this.translationTable[c];
            if (string2 == null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string2);
        }
    }

    protected Object clone() {
        StringEscaper stringEscaper = new StringEscaper();
        if (this.translationVector != null) {
            stringEscaper.translationVector = (Vector)this.translationVector.clone();
        }
        if (this.translationTable != null) {
            stringEscaper.translationTable = (String[])this.translationTable.clone();
        }
        return stringEscaper;
    }

    public StringEscaper getMutableClone() {
        StringEscaper stringEscaper = (StringEscaper)this.clone();
        if (stringEscaper.translationVector == null) {
            stringEscaper.translationVector = XOMUtil.toVector(stringEscaper.translationTable);
            stringEscaper.translationTable = null;
        }
        return stringEscaper;
    }

    static {
        htmlEscaper = new StringEscaper();
        htmlEscaper.defineEscape('&', "&amp;");
        htmlEscaper.defineEscape('\"', "&quot;");
        htmlEscaper.defineEscape('\'', "&#39;");
        htmlEscaper.defineEscape('<', "&lt;");
        htmlEscaper.defineEscape('>', "&gt;");
        xmlNumericEscaper = new StringEscaper();
        xmlNumericEscaper.defineEscape('&', "&#38;");
        xmlNumericEscaper.defineEscape('\"', "&#34;");
        xmlNumericEscaper.defineEscape('\'', "&#39;");
        xmlNumericEscaper.defineEscape('<', "&#60;");
        xmlNumericEscaper.defineEscape('>', "&#62;");
        urlArgEscaper = new StringEscaper();
        urlArgEscaper.defineEscape('?', "%3f");
        urlArgEscaper.defineEscape('&', "%26");
        urlEscaper = urlArgEscaper.getMutableClone();
        urlEscaper.defineEscape('%', "%%");
        urlEscaper.defineEscape('\"', "%22");
        urlEscaper.defineEscape('\r', "+");
        urlEscaper.defineEscape('\n', "+");
        urlEscaper.defineEscape(' ', "+");
        urlEscaper.defineEscape('#', "%23");
        htmlEscaper.makeImmutable();
        xmlEscaper = htmlEscaper;
        xmlNumericEscaper.makeImmutable();
        urlArgEscaper.makeImmutable();
        urlEscaper.makeImmutable();
    }
}

