/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.crosstab.CrosstabDataAction;
import com.jaspersoft.ireport.designer.outline.nodes.CrosstabChildren;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.BooleanProperty;
import com.jaspersoft.ireport.designer.sheet.properties.ByteProperty;
import com.jaspersoft.ireport.designer.sheet.properties.IntegerProperty;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public class CrosstabNode
extends ElementNode {
    private JRDesignCrosstab crosstab = null;

    public JRDesignCrosstab getCrosstab() {
        return this.crosstab;
    }

    public CrosstabNode(JasperDesign jd, JRDesignCrosstab crosstab, Lookup doLkp) {
        this(jd, crosstab, new CrosstabChildren(jd, crosstab, doLkp), doLkp);
    }

    public CrosstabNode(JasperDesign jd, JRDesignCrosstab crosstab, CrosstabChildren children, Lookup doLkp) {
        super(jd, (JRDesignElement)crosstab, (Children)children, children.getIndex(), doLkp);
        this.crosstab = crosstab;
        this.crosstab.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
            }
        });
    }

    public Action[] getActions(boolean popup) {
        Action[] actions = super.getActions(popup);
        ArrayList<Action> list = new ArrayList<Action>(Arrays.asList(actions));
        list.add(0, (Action)SystemAction.get(CrosstabDataAction.class));
        list.add(1, null);
        return list.toArray(new Action[list.size()]);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set propertySet = Sheet.createPropertiesSet();
        propertySet.setName("CROSSTAB_PROPERTIES");
        propertySet.setDisplayName("Crosstab properties");
        propertySet.put((Node.Property)new RepeatColumnHeadersProperty(this.getCrosstab()));
        propertySet.put((Node.Property)new RepeatRowHeadersProperty(this.getCrosstab()));
        propertySet.put((Node.Property)new ColumnBreakOffsetProperty(this.getCrosstab()));
        propertySet.put((Node.Property)new RunDirectionProperty(this.getCrosstab()));
        sheet.put(propertySet);
        return sheet;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("cells") || evt.getPropertyName().equals("headerCell") || evt.getPropertyName().equals("rowGroups") || evt.getPropertyName().equals("columnGroups") || evt.getPropertyName().equals("whenNoDataCell")) {
            ((CrosstabChildren)this.getChildren()).recalculateKeys();
        }
    }

    public boolean canPaste() {
        return false;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public static final class RunDirectionProperty
    extends ByteProperty {
        private final JRDesignCrosstab crosstab;

        public RunDirectionProperty(JRDesignCrosstab crosstab) {
            super(crosstab);
            this.crosstab = crosstab;
        }

        public String getName() {
            return "runDirection";
        }

        public String getDisplayName() {
            return "Run Direction";
        }

        public String getShortDescription() {
            return "Run Direction.";
        }

        public List getTagList() {
            ArrayList<Tag> list = new ArrayList<Tag>();
            list.add(new Tag(new Byte(0), "Left to Right"));
            list.add(new Tag(new Byte(1), "Right to Left"));
            return list;
        }

        public Byte getByte() {
            return this.crosstab.getRunDirection();
        }

        public Byte getOwnByte() {
            return this.crosstab.getRunDirection();
        }

        public Byte getDefaultByte() {
            return (byte)0;
        }

        public void setByte(Byte value) {
            this.crosstab.setRunDirection(value.byteValue());
        }
    }

    public static final class ColumnBreakOffsetProperty
    extends IntegerProperty {
        private final JRDesignCrosstab crosstab;

        public ColumnBreakOffsetProperty(JRDesignCrosstab crosstab) {
            super(crosstab);
            this.crosstab = crosstab;
        }

        public String getName() {
            return "columnBreakOffset";
        }

        public String getDisplayName() {
            return "Column Break Offset";
        }

        public String getShortDescription() {
            return "Column Break Offset.";
        }

        public Integer getInteger() {
            return this.crosstab.getColumnBreakOffset();
        }

        public Integer getOwnInteger() {
            return this.crosstab.getColumnBreakOffset();
        }

        public Integer getDefaultInteger() {
            return 10;
        }

        public void validateInteger(Integer value) {
        }

        public void setInteger(Integer value) {
            if (value != null) {
                this.crosstab.setColumnBreakOffset(value.intValue());
            }
        }
    }

    public static final class RepeatRowHeadersProperty
    extends BooleanProperty {
        private final JRDesignCrosstab crosstab;

        public RepeatRowHeadersProperty(JRDesignCrosstab crosstab) {
            super(crosstab);
            this.crosstab = crosstab;
        }

        public String getName() {
            return "repeatRowHeaders";
        }

        public String getDisplayName() {
            return "Repeat Row Headers";
        }

        public String getShortDescription() {
            return "Repeat Row Headers.";
        }

        public Boolean getBoolean() {
            return this.crosstab.isRepeatRowHeaders();
        }

        public Boolean getOwnBoolean() {
            return this.crosstab.isRepeatRowHeaders();
        }

        public Boolean getDefaultBoolean() {
            return Boolean.TRUE;
        }

        public void setBoolean(Boolean b) {
            this.crosstab.setRepeatRowHeaders(b.booleanValue());
        }
    }

    public static final class RepeatColumnHeadersProperty
    extends BooleanProperty {
        private final JRDesignCrosstab crosstab;

        public RepeatColumnHeadersProperty(JRDesignCrosstab crosstab) {
            super(crosstab);
            this.crosstab = crosstab;
        }

        public String getName() {
            return "repeatColumnHeaders";
        }

        public String getDisplayName() {
            return "Repeat Colunm Headers";
        }

        public String getShortDescription() {
            return "Repeat Colunm Headers.";
        }

        public Boolean getBoolean() {
            return this.crosstab.isRepeatColumnHeaders();
        }

        public Boolean getOwnBoolean() {
            return this.crosstab.isRepeatColumnHeaders();
        }

        public Boolean getDefaultBoolean() {
            return Boolean.TRUE;
        }

        public void setBoolean(Boolean b) {
            this.crosstab.setRepeatColumnHeaders(b.booleanValue());
        }
    }
}

