/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.olap;

import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.WalkableWrapper;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import mondrian.olap.QueryAxis;

public class OlapTreeCellRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon measureIcon;
    static ImageIcon dimensionIcon;
    static ImageIcon hierarchyIcon;

    public OlapTreeCellRenderer() {
        if (measureIcon == null) {
            measureIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/olap/measure.png"));
        }
        if (dimensionIcon == null) {
            dimensionIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/olap/axis.png"));
        }
        if (hierarchyIcon == null) {
            hierarchyIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/olap/hierarchy.png"));
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setForeground(Color.BLACK);
        ImageIcon icon = this.getElementIcon(value);
        this.setIcon(icon);
        this.setToolTipText(null);
        return this;
    }

    protected ImageIcon getElementIcon(Object value) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        try {
            WalkableWrapper ww = (WalkableWrapper)node.getUserObject();
            if (node.getParent() != null && node.getParent() instanceof DefaultMutableTreeNode) {
                if (ww.isMeasure()) {
                    return measureIcon;
                }
                if (ww.getWalkable() instanceof QueryAxis) {
                    return dimensionIcon;
                }
                return hierarchyIcon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

