/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.SQLParser;

public class QueryBuilderDialog
extends JDialog {
    private String query = null;
    private int dialogResult = 2;
    private boolean init = false;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JPanel jPanel1;
    private JEditorPane jEditorPaneSQL;
    private JTabbedPane jTabbedPane1;
    private QueryBuilder queryBuilder1;

    public QueryBuilderDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public QueryBuilderDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void applyI18n() {
        this.jTabbedPane1.setTitleAt(0, "Builder");
        this.jTabbedPane1.setTitleAt(1, "SQL");
        this.jButtonOk.setText("Ok");
        this.jButtonCancel.setText("Cancel");
    }

    private void initAll() {
        this.setInit(true);
        this.initComponents();
        this.applyI18n();
        this.setInit(false);
        this.setLocationRelativeTo(null);
    }

    public void setConnection(Connection c) {
        this.queryBuilder1.setConnection(c);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.queryBuilder1 = new QueryBuilder();
        this.jEditorPaneSQL = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jTabbedPane1.setTabPlacement(3);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                QueryBuilderDialog.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.queryBuilder1.setPreferredSize(new Dimension(600, 483));
        this.jTabbedPane1.addTab("Design", (Component)this.queryBuilder1);
        this.jEditorPaneSQL.setBorder(BorderFactory.createEtchedBorder());
        this.jEditorPaneSQL.setMinimumSize(new Dimension(50, 200));
        this.jEditorPaneSQL.setPreferredSize(new Dimension(661, 340));
        this.jTabbedPane1.addTab("SQL", this.jEditorPaneSQL);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            String msql = this.queryBuilder1.getModel().toString(true);
            String tsql = this.jEditorPaneSQL.getText();
            if (!tsql.equals(msql) && JOptionPane.showConfirmDialog(this, "syntax changed!\ndo you want to apply changes (builder need to reload)?") == 0) {
                new Thread(new Runnable(){

                    public void run() {
                        while (!QueryBuilderDialog.this.queryBuilder1.isVisible()) {
                        }
                        try {
                            QueryModel qm = SQLParser.toQueryModel((String)QueryBuilderDialog.this.jEditorPaneSQL.getText());
                            QueryBuilderDialog.this.queryBuilder1.setModel(qm);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(QueryBuilderDialog.this, "I'm sorry, I'm unable to parse the query...");
                            QueryBuilderDialog.this.jTabbedPane1.setSelectedIndex(0);
                        }
                    }
                }).start();
            }
        } else {
            try {
                this.jEditorPaneSQL.setText(this.queryBuilder1.getModel().toString(true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.query = this.jTabbedPane1.getSelectedIndex() == 0 ? this.queryBuilder1.getModel().toString(true) : this.jEditorPaneSQL.getText();
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) throws Exception {
        final QueryModel qm = SQLParser.toQueryModel((String)query);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (QueryBuilderDialog.this.isVisible()) {
                    QueryBuilderDialog.this.queryBuilder1.setModel(qm);
                }
            }
        });
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}

