/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compiler.prompt;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.compiler.prompt.PromptDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;

public class Prompter {
    public static HashMap promptForParameters(final JasperDesign report) {
        final HashMap hm = new HashMap();
        Runnable runner = new Runnable(){

            public void run() {
                List params = report.getParametersList();
                for (JRDesignParameter param : params) {
                    Date time;
                    Date d;
                    if (!param.isForPrompting() || param.getValueClassName() == null || param.isSystemDefined()) continue;
                    PromptDialog pd = new PromptDialog(Misc.getMainFrame(), true);
                    pd.setParameter((JRParameter)param);
                    pd.setVisible(true);
                    boolean isCollection = false;
                    if (pd.getDialogResult() != 0) continue;
                    ArrayList value = pd.getValue();
                    if (param.getValueClassName().equals("java.lang.String")) {
                        hm.put(param.getName(), value);
                    } else if (param.getValueClassName().equals("java.lang.Integer")) {
                        try {
                            hm.put(param.getName(), new Integer("" + value));
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else if (param.getValueClassName().equals("java.lang.Long")) {
                        try {
                            hm.put(param.getName(), new Long("" + value));
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else if (param.getValueClassName().equals("java.lang.Double")) {
                        try {
                            hm.put(param.getName(), new Double("" + value));
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else if (param.getValueClassName().equals("java.lang.Float")) {
                        try {
                            hm.put(param.getName(), new Float("" + value));
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else if (param.getValueClassName().equals("java.lang.Boolean")) {
                        try {
                            hm.put(param.getName(), new Boolean("" + value));
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else if (param.getValueClassName().equals("java.util.Date")) {
                        try {
                            if (value != null) {
                                hm.put(param.getName(), value);
                            }
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else if (param.getValueClassName().equals("java.sql.Time")) {
                        try {
                            d = (Date)((Object)value);
                            time = new Time(d.getTime());
                            hm.put(param.getName(), time);
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else if (param.getValueClassName().equals("java.sql.Timestamp")) {
                        try {
                            d = (Date)((Object)value);
                            time = new Timestamp(d.getTime());
                            hm.put(param.getName(), time);
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else {
                        try {
                            Class clazz = param.getValueClass();
                            if (Collection.class.isAssignableFrom(clazz)) {
                                isCollection = true;
                                ArrayList collection = null;
                                collection = new ArrayList();
                                if (value != null) {
                                    Prompter.fillCollection(collection, "" + value);
                                    IReportManager.getInstance().setLastParameterValue((JRParameter)param, "" + value);
                                    value = collection;
                                    try {
                                        hm.put(param.getName(), collection);
                                    }
                                    catch (Exception ex) {
                                        System.out.println(ex.getMessage());
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (value == null || isCollection) continue;
                    IReportManager.getInstance().setLastParameterValue((JRParameter)param, value);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return hm;
    }

    public static void fillCollection(Collection collection, String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(str, ",", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            s = s.trim();
            collection.add(s);
        }
    }
}

