/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.datasets;

import com.jaspersoft.ireport.designer.charts.datasets.CategorySeriesDialog;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.tools.HyperlinkPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;

public class XYSeriesDialog
extends JDialog {
    private JRDesignExpression seriesExpression = null;
    private JRDesignExpression xValueExpression = null;
    private JRDesignExpression yValueExpression = null;
    private JRDesignExpression labelExpression = null;
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabelLabelExpression;
    private JLabel jLabelSeriesExpression;
    private JLabel jLabelXValueExpression;
    private JLabel jLabelYValueExpression;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private ExpressionEditorArea jRTextExpressionLabel;
    private ExpressionEditorArea jRTextExpressionSeries;
    private ExpressionEditorArea jRTextExpressionXValue;
    private ExpressionEditorArea jRTextExpressionYValue;
    private JTabbedPane jTabbedPane1;
    private HyperlinkPanel sectionItemHyperlinkPanel1;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_SERIES_EXPRESSION = 1;
    public static final int COMPONENT_X_EXPRESSION = 2;
    public static final int COMPONENT_Y_EXPRESSION = 3;
    public static final int COMPONENT_LABEL_EXPRESSION = 4;
    public static final int COMPONENT_HYPERLINK = 100;

    public XYSeriesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(500, 500);
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                XYSeriesDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.jRTextExpressionLabel.setExpressionContext(ec);
        this.jRTextExpressionSeries.setExpressionContext(ec);
        this.jRTextExpressionXValue.setExpressionContext(ec);
        this.jRTextExpressionYValue.setExpressionContext(ec);
        this.sectionItemHyperlinkPanel1.setExpressionContext(ec);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabelSeriesExpression = new JLabel();
        this.jLabelXValueExpression = new JLabel();
        this.jLabelYValueExpression = new JLabel();
        this.jLabelLabelExpression = new JLabel();
        this.jRTextExpressionSeries = new ExpressionEditorArea();
        this.jRTextExpressionXValue = new ExpressionEditorArea();
        this.jRTextExpressionYValue = new ExpressionEditorArea();
        this.jRTextExpressionLabel = new ExpressionEditorArea();
        this.sectionItemHyperlinkPanel1 = new HyperlinkPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("XY series");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                XYSeriesDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelSeriesExpression.setText("Series expression (required)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelSeriesExpression, gridBagConstraints);
        this.jLabelXValueExpression.setText("X value expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelXValueExpression, gridBagConstraints);
        this.jLabelYValueExpression.setText("Y value expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelYValueExpression, gridBagConstraints);
        this.jLabelLabelExpression.setText("Label expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelLabelExpression, gridBagConstraints);
        this.jRTextExpressionSeries.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionSeries.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionSeries.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionSeries, gridBagConstraints);
        this.jRTextExpressionXValue.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionXValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionXValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionXValue, gridBagConstraints);
        this.jRTextExpressionYValue.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionYValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionYValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionYValue, gridBagConstraints);
        this.jRTextExpressionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionLabel.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionLabel.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionLabel, gridBagConstraints);
        this.jTabbedPane1.addTab("Data", this.jPanel1);
        this.jTabbedPane1.addTab("Item hyperlink", this.sectionItemHyperlinkPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYSeriesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYSeriesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.sectionItemHyperlinkPanel1.openExtraWindows();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.seriesExpression = Misc.createExpression(null, this.jRTextExpressionSeries.getText());
        this.xValueExpression = Misc.createExpression("java.lang.Number", this.jRTextExpressionXValue.getText());
        this.yValueExpression = Misc.createExpression("java.lang.Number", this.jRTextExpressionYValue.getText());
        this.labelExpression = Misc.createExpression("java.lang.String", this.jRTextExpressionLabel.getText());
        MessageFormat formatter = new MessageFormat("{0} cannot be blank!");
        if (this.seriesExpression == null) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{"Series expression"}), "Invalid expression", 0);
            return;
        }
        if (this.xValueExpression == null) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{"X Value expression"}), "Invalid expression", 0);
            return;
        }
        if (this.yValueExpression == null) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{"Y Value expression"}), "Invalid expression", 0);
            return;
        }
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CategorySeriesDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public JRDesignExpression getSeriesExpression() {
        return this.seriesExpression;
    }

    public void setSeriesExpression(JRDesignExpression exp) {
        this.seriesExpression = null;
        if (exp != null) {
            try {
                this.seriesExpression = (JRDesignExpression)exp.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jRTextExpressionSeries.setText(Misc.getExpressionText((JRExpression)exp));
    }

    public JRDesignExpression getLabelExpression() {
        return this.labelExpression;
    }

    public void setLabelExpression(JRDesignExpression exp) {
        this.labelExpression = null;
        if (exp != null) {
            try {
                this.labelExpression = (JRDesignExpression)exp.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jRTextExpressionLabel.setText(Misc.getExpressionText((JRExpression)exp));
    }

    public void setSectionItemHyperlink(JRDesignHyperlink sectionItemHyperlink) {
        this.sectionItemHyperlinkPanel1.setHyperlink((JRHyperlink)sectionItemHyperlink);
    }

    public JRHyperlink getSectionItemHyperlink() {
        return this.sectionItemHyperlinkPanel1.getHyperlink();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JRDesignExpression getXValueExpression() {
        return this.xValueExpression;
    }

    public void setXValueExpression(JRDesignExpression exp) {
        this.xValueExpression = null;
        if (exp != null) {
            try {
                this.xValueExpression = (JRDesignExpression)exp.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jRTextExpressionXValue.setText(Misc.getExpressionText((JRExpression)exp));
    }

    public JRDesignExpression getYValueExpression() {
        return this.yValueExpression;
    }

    public void setYValueExpression(JRDesignExpression exp) {
        this.yValueExpression = null;
        if (exp != null) {
            try {
                this.yValueExpression = (JRDesignExpression)exp.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jRTextExpressionYValue.setText(Misc.getExpressionText((JRExpression)exp));
    }

    public void setFocusedExpression(Object[] expressionInfo) {
        if (expressionInfo == null) {
            return;
        }
        int expID = (Integer)expressionInfo[0];
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionSeries);
                break;
            }
            case 2: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionXValue);
                break;
            }
            case 3: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionYValue);
                break;
            }
            case 4: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionLabel);
                break;
            }
            case 100: {
                this.jTabbedPane1.setSelectedComponent(this.sectionItemHyperlinkPanel1);
                Object[] newInfo = new Object[expressionInfo.length - 1];
                for (int i = 1; i < expressionInfo.length; ++i) {
                    newInfo[i - 1] = expressionInfo[i];
                }
                this.sectionItemHyperlinkPanel1.setFocusedExpression(newInfo);
            }
        }
    }
}

