/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.BandNode;
import com.jaspersoft.ireport.designer.undo.DeleteGroupUndoableEdit;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class DeleteGroupAction
extends NodeAction {
    private static DeleteGroupAction instance = null;

    public static synchronized DeleteGroupAction getInstance() {
        if (instance == null) {
            instance = new DeleteGroupAction();
        }
        return instance;
    }

    private DeleteGroupAction() {
    }

    public String getName() {
        return NbBundle.getMessage(DeleteGroupAction.class, (String)"CTL_DeleteGroupAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        BandNode bandNode = (BandNode)activatedNodes[0];
        String groupName = bandNode.getBand().getOrigin().getGroupName();
        JRDesignGroup grp = (JRDesignGroup)bandNode.getJasperDesign().getGroupsMap().get(groupName);
        int index = bandNode.getJasperDesign().getGroupsList().indexOf(grp);
        bandNode.getJasperDesign().removeGroup((JRGroup)grp);
        DeleteGroupUndoableEdit edit = new DeleteGroupUndoableEdit(grp, bandNode.getJasperDesign().getMainDesignDataset(), index);
        IReportManager.getInstance().addUndoableEdit(edit);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof BandNode && (((BandNode)activatedNodes[0]).getBand().getOrigin().getBandType() == 7 || ((BandNode)activatedNodes[0]).getBand().getOrigin().getBandType() == 5);
    }
}

