/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactMap<K, V>
implements Map<K, V> {
    private static int EXPAND_THRESHOLD = 4;
    private MapEntry<K, V>[] table;
    private int size;

    public CompactMap() {
        this.table = this.allocateTableArray(1);
    }

    public CompactMap(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.table = this.allocateTableArray(n2);
    }

    @Override
    public V get(Object object) {
        MapEntry<K, V> mapEntry = this.findEntry(object);
        return mapEntry != null ? (V)mapEntry.getValue() : null;
    }

    public MapEntry<K, V> getFirstEntry(int n) {
        return this.table[n & this.table.length - 1];
    }

    @Override
    public boolean containsKey(Object object) {
        MapEntry<K, V> mapEntry = this.findEntry(object);
        return mapEntry != null;
    }

    @Override
    public boolean containsValue(Object object) {
        for (int i = this.table.length - 1; i >= 0; --i) {
            for (MapEntry<K, V> mapEntry = this.table[i]; mapEntry != null; mapEntry = mapEntry.nextMapEntry()) {
                if ((object != null || mapEntry.getValue() != null) && (object == null || !object.equals(mapEntry.getValue()))) continue;
                return true;
            }
        }
        return false;
    }

    public MapEntry<K, V> putEntry(MapEntry<K, V> mapEntry) {
        K k = mapEntry.getKey();
        int n = k.hashCode();
        int n2 = n & this.table.length - 1;
        mapEntry.setKeyHashCode(n);
        MapEntry mapEntry2 = null;
        for (MapEntry mapEntry3 = this.table[n2]; mapEntry3 != null; mapEntry3 = mapEntry3.nextMapEntry()) {
            if (mapEntry3 == mapEntry) {
                return mapEntry;
            }
            if (n == mapEntry3.keyHashCode() && (k == mapEntry3.getKey() || k.equals(mapEntry3.getKey()))) {
                if (mapEntry2 == null) {
                    this.table[n2] = mapEntry;
                } else {
                    mapEntry2.setNextMapEntry(mapEntry);
                }
                mapEntry.setNextMapEntry(mapEntry3.nextMapEntry());
                mapEntry3.setNextMapEntry(null);
                return mapEntry3;
            }
            mapEntry2 = mapEntry3;
        }
        this.addEntry(mapEntry, n2);
        return null;
    }

    @Override
    public V put(K k, V v) {
        MapEntry<K, V> mapEntry;
        int n = k.hashCode();
        int n2 = n & this.table.length - 1;
        for (mapEntry = this.table[n2]; mapEntry != null; mapEntry = mapEntry.nextMapEntry()) {
            if (n != mapEntry.keyHashCode() || k != mapEntry.getKey() && !k.equals(mapEntry.getKey())) continue;
            V v2 = mapEntry.getValue();
            mapEntry.setValue(v);
            return v2;
        }
        mapEntry = new DefaultMapEntry(k);
        mapEntry.setValue(v);
        mapEntry.setKeyHashCode(n);
        this.addEntry(mapEntry, n2);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        MapEntry<K, V> mapEntry = this.removeEntryForKey(object);
        return mapEntry != null ? (V)mapEntry.getValue() : null;
    }

    public MapEntry<K, V> removeEntry(MapEntry<K, V> mapEntry) {
        int n = mapEntry.keyHashCode();
        int n2 = n & this.table.length - 1;
        MapEntry<K, V> mapEntry2 = this.table[n2];
        MapEntry<K, V> mapEntry3 = null;
        while (mapEntry2 != null) {
            if (mapEntry2 == mapEntry) {
                if (mapEntry3 == null) {
                    this.table[n2] = mapEntry2.nextMapEntry();
                } else {
                    mapEntry3.setNextMapEntry(mapEntry2.nextMapEntry());
                }
                mapEntry.setNextMapEntry(null);
                --this.size;
                return mapEntry;
            }
            mapEntry3 = mapEntry;
            mapEntry = mapEntry.nextMapEntry();
        }
        return null;
    }

    @Override
    public void clear() {
        for (int i = this.table.length - 1; i >= 0; --i) {
            MapEntry mapEntry = this.table[i];
            this.table[i] = null;
            while (mapEntry != null) {
                MapEntry<K, V> mapEntry2 = mapEntry.nextMapEntry();
                mapEntry.setNextMapEntry(null);
                mapEntry = mapEntry2;
            }
        }
        this.size = 0;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Collection<V> values() {
        throw new IllegalStateException("Not yet implemented");
    }

    @Override
    public Set<K> keySet() {
        throw new IllegalStateException("Not yet implemented");
    }

    private MapEntry<K, V> findEntry(Object object) {
        int n = object.hashCode();
        int n2 = n & this.table.length - 1;
        for (MapEntry<K, V> mapEntry = this.table[n2]; mapEntry != null; mapEntry = mapEntry.nextMapEntry()) {
            if (n != mapEntry.keyHashCode() || object != mapEntry.getKey() && !object.equals(mapEntry.getKey())) continue;
            return mapEntry;
        }
        return null;
    }

    private void addEntry(MapEntry<K, V> mapEntry, int n) {
        mapEntry.setNextMapEntry(this.table[n]);
        this.table[n] = mapEntry;
        ++this.size;
        if (this.size > this.table.length) {
            MapEntry<K, V>[] mapEntryArray = this.allocateTableArray(Math.max(this.table.length << 1, 4));
            for (int i = this.table.length - 1; i >= 0; --i) {
                mapEntry = this.table[i];
                while (mapEntry != null) {
                    MapEntry<K, V> mapEntry2 = mapEntry.nextMapEntry();
                    int n2 = mapEntry.keyHashCode() & mapEntryArray.length - 1;
                    mapEntry.setNextMapEntry(mapEntryArray[n2]);
                    mapEntryArray[n2] = mapEntry;
                    mapEntry = mapEntry2;
                }
            }
            this.table = mapEntryArray;
        }
    }

    private MapEntry<K, V> removeEntryForKey(Object object) {
        int n = object.hashCode();
        int n2 = n & this.table.length - 1;
        MapEntry mapEntry = null;
        for (MapEntry mapEntry2 = this.table[n2]; mapEntry2 != null; mapEntry2 = mapEntry2.nextMapEntry()) {
            if (n == mapEntry2.keyHashCode() && (object == mapEntry2.getKey() || object.equals(mapEntry2.getKey()))) {
                if (mapEntry == null) {
                    this.table[n2] = mapEntry2.nextMapEntry();
                } else {
                    mapEntry.setNextMapEntry(mapEntry2.nextMapEntry());
                }
                mapEntry2.setNextMapEntry(null);
                --this.size;
                return mapEntry2;
            }
            mapEntry = mapEntry2;
        }
        return null;
    }

    private MapEntry<K, V>[] allocateTableArray(int n) {
        return new MapEntry[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            Map.Entry<K, V> entry = iterator.next();
            K k = entry.getKey();
            V v = entry.getValue();
            if (k == this) {
                stringBuffer.append("(this Map)");
            } else {
                stringBuffer.append(k);
            }
            stringBuffer.append("=");
            if (v == this) {
                stringBuffer.append("(this Map)");
            } else {
                stringBuffer.append(v);
            }
            if (!(bl = iterator.hasNext())) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultMapEntry<K, V>
    extends MapEntry<K, V> {
        private K key;
        private V value;

        public DefaultMapEntry(K k) {
            this.key = k;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v;
        }

        @Override
        protected final int valueHashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        @Override
        protected final boolean valueEquals(Object object) {
            return this.value == object || this.value != null && this.value.equals(object);
        }

        public String toString() {
            return "key=" + this.getKey() + ", value=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            MapEntry mapEntry = CompactMap.this.findEntry(entry.getKey());
            return mapEntry != null && mapEntry.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            MapEntry mapEntry = (MapEntry)object;
            return CompactMap.this.removeEntry(mapEntry) != null;
        }

        @Override
        public int size() {
            return CompactMap.this.size();
        }

        @Override
        public void clear() {
            CompactMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator {
        MapEntry<K, V> next;
        int index;
        MapEntry<K, V> current;

        HashIterator() {
            MapEntry[] mapEntryArray = CompactMap.this.table;
            int n = mapEntryArray.length;
            MapEntry mapEntry = null;
            if (CompactMap.this.size != 0) {
                while (n > 0 && (mapEntry = mapEntryArray[--n]) == null) {
                }
            }
            this.next = mapEntry;
            this.index = n;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        MapEntry<K, V> nextEntry() {
            MapEntry mapEntry = this.next;
            if (mapEntry == null) {
                throw new NoSuchElementException();
            }
            MapEntry mapEntry2 = mapEntry.nextMapEntry();
            MapEntry[] mapEntryArray = CompactMap.this.table;
            int n = this.index;
            while (mapEntry2 == null && n > 0) {
                mapEntry2 = mapEntryArray[--n];
            }
            this.index = n;
            this.next = mapEntry2;
            this.current = mapEntry;
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.getKey();
            this.current = null;
            CompactMap.this.removeEntryForKey(k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private MapEntry<K, V> nextMapEntry;
        private int keyHashCode;

        @Override
        public abstract K getKey();

        @Override
        public abstract V getValue();

        @Override
        public abstract V setValue(V var1);

        protected abstract int valueHashCode();

        protected abstract boolean valueEquals(Object var1);

        public final MapEntry<K, V> nextMapEntry() {
            return this.nextMapEntry;
        }

        final void setNextMapEntry(MapEntry<K, V> mapEntry) {
            this.nextMapEntry = mapEntry;
        }

        public final int keyHashCode() {
            return this.keyHashCode;
        }

        final void setKeyHashCode(int n) {
            this.keyHashCode = n;
        }

        @Override
        public final int hashCode() {
            int n = this.keyHashCode != 0 ? this.keyHashCode : this.getKey().hashCode();
            return n ^ this.valueHashCode();
        }

        @Override
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Object k;
                Map.Entry entry = (Map.Entry)object;
                K k2 = this.getKey();
                if (k2 == (k = entry.getKey()) || k2.equals(k)) {
                    return this.valueEquals(entry.getValue());
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }
}

