/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.codetemplates;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.options.codetemplates.CodeTemplatesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

public class CodeTemplatesPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
KeyListener {
    private CodeTemplatesModel model;
    private int lastIndex = -1;
    private JButton bNew;
    private JButton bRemove;
    private JComboBox cbExpandTemplateOn;
    private JComboBox cbLanguage;
    private JEditorPane epDescription;
    private JEditorPane epExpandedText;
    private JLabel lExplandTemplateOn;
    private JLabel lLanguage;
    private JLabel lTemplates;
    private JScrollPane spDescription;
    private JScrollPane spExpandedText;
    private JScrollPane spTemplates;
    private JTable tTemplates;
    private JTabbedPane tabPane;

    public CodeTemplatesPanel() {
        this.initComponents();
        this.setName(CodeTemplatesPanel.loc("Code_Templates_Tab"));
        CodeTemplatesPanel.loc(this.lLanguage, "Language");
        CodeTemplatesPanel.loc(this.lTemplates, "Templates");
        CodeTemplatesPanel.loc(this.bNew, "New");
        CodeTemplatesPanel.loc(this.bRemove, "Remove");
        CodeTemplatesPanel.loc(this.lExplandTemplateOn, "ExpandTemplateOn");
        CodeTemplatesPanel.loc(this.tabPane, 0, "Expanded_Text", this.epExpandedText);
        CodeTemplatesPanel.loc(this.tabPane, 1, "Description", this.epDescription);
        this.tabPane.getAccessibleContext().setAccessibleName(CodeTemplatesPanel.loc("AN_tabPane"));
        this.tabPane.getAccessibleContext().setAccessibleDescription(CodeTemplatesPanel.loc("AD_tabPane"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("SPACE"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("S-SPACE"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("TAB"));
        this.cbExpandTemplateOn.addItem(CodeTemplatesPanel.loc("ENTER"));
        this.bRemove.setEnabled(false);
        this.tTemplates.getTableHeader().setReorderingAllowed(false);
        this.tTemplates.getSelectionModel().setSelectionMode(0);
        this.epExpandedText.addKeyListener(this);
        this.epDescription.addKeyListener(this);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(CodeTemplatesPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(CodeTemplatesPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(CodeTemplatesPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)CodeTemplatesPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)CodeTemplatesPanel.loc("CTL_" + string));
        }
    }

    private static void loc(JTabbedPane jTabbedPane, int n, String string, JEditorPane jEditorPane) {
        JLabel jLabel = new JLabel();
        String string2 = CodeTemplatesPanel.loc("CTL_" + string);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)string2);
        jTabbedPane.setTitleAt(n, jLabel.getText());
        int n2 = Mnemonics.findMnemonicAmpersand((String)string2);
        if (n2 != -1 && n2 + 1 < string2.length()) {
            char c = Character.toUpperCase(string2.charAt(n2 + 1));
            jTabbedPane.setMnemonicAt(n, c);
            jEditorPane.setFocusAccelerator(c);
        }
    }

    void update() {
        String string;
        String string22;
        this.model = new CodeTemplatesModel();
        this.cbLanguage.removeActionListener(this);
        this.bNew.removeActionListener(this);
        this.bRemove.removeActionListener(this);
        this.cbExpandTemplateOn.removeActionListener(this);
        this.tTemplates.getSelectionModel().removeListSelectionListener(this);
        this.cbLanguage.removeAllItems();
        ArrayList<String> arrayList = new ArrayList<String>(this.model.getLanguages());
        Collections.sort(arrayList);
        for (String string22 : arrayList) {
            this.cbLanguage.addItem(string22);
        }
        KeyStroke keyStroke = this.model.getExpander();
        if (KeyStroke.getKeyStroke(32, 1).equals(keyStroke)) {
            this.cbExpandTemplateOn.setSelectedIndex(1);
        } else if (KeyStroke.getKeyStroke(9, 0).equals(keyStroke)) {
            this.cbExpandTemplateOn.setSelectedIndex(2);
        } else if (KeyStroke.getKeyStroke(10, 0).equals(keyStroke)) {
            this.cbExpandTemplateOn.setSelectedIndex(3);
        } else {
            this.cbExpandTemplateOn.setSelectedIndex(0);
        }
        this.cbLanguage.addActionListener(this);
        this.bNew.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.cbExpandTemplateOn.addActionListener(this);
        this.tTemplates.getSelectionModel().addListSelectionListener(this);
        string22 = null;
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent != null && (string = (String)jTextComponent.getDocument().getProperty("mimeType")) != null) {
            string22 = this.model.findLanguage(string);
        }
        if (string22 == null) {
            string22 = this.model.findLanguage("text/x-java");
        }
        if (string22 == null) {
            string22 = this.model.findLanguage("text/x-ruby");
        }
        if (string22 == null) {
            string22 = this.model.findLanguage("text/x-c++");
        }
        if (string22 == null && this.model.getLanguages().size() > 0) {
            string22 = this.model.getLanguages().get(0);
        }
        if (string22 != null) {
            this.cbLanguage.setSelectedItem(string22);
        }
    }

    void applyChanges() {
        if (this.model != null) {
            this.saveCurrentTemplate();
            this.model.saveChanges();
        }
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cbLanguage) {
            this.saveCurrentTemplate();
            final String string = (String)this.cbLanguage.getSelectedItem();
            final CodeTemplatesModel.TM tM = this.model.getTableModel(string);
            this.tTemplates.setModel(tM);
            TableColumn tableColumn = this.tTemplates.getTableHeader().getColumnModel().getColumn(0);
            tableColumn.setMinWidth(80);
            tableColumn.setPreferredWidth(100);
            tableColumn.setResizable(true);
            TableColumn tableColumn2 = this.tTemplates.getTableHeader().getColumnModel().getColumn(1);
            tableColumn2.setMinWidth(180);
            tableColumn2.setPreferredWidth(250);
            tableColumn2.setResizable(true);
            TableColumn tableColumn3 = this.tTemplates.getTableHeader().getColumnModel().getColumn(2);
            tableColumn3.setMinWidth(180);
            tableColumn3.setPreferredWidth(250);
            tableColumn3.setResizable(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epDescription.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/html"));
                    CodeTemplatesPanel.this.epExpandedText.setEditorKit(CloneableEditorSupport.getEditorKit((String)CodeTemplatesPanel.this.model.getMimeType(string)));
                    if (tM.getRowCount() > 0) {
                        CodeTemplatesPanel.this.lastIndex = -1;
                        CodeTemplatesPanel.this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        CodeTemplatesPanel.this.lastIndex = 0;
                    } else {
                        CodeTemplatesPanel.this.lastIndex = -1;
                    }
                }
            });
        } else if (actionEvent.getSource() == this.bNew) {
            this.saveCurrentTemplate();
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(CodeTemplatesPanel.loc("CTL_Enter_template_name"), CodeTemplatesPanel.loc("CTL_New_template_dialog_title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.InputLine.OK_OPTION) {
                String string = inputLine.getInputText().trim();
                if (string.length() == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Empty_template_name"), 0));
                } else {
                    int n;
                    CodeTemplatesModel.TM tM = (CodeTemplatesModel.TM)this.tTemplates.getModel();
                    int n2 = tM.getRowCount();
                    for (n = 0; n < n2; ++n) {
                        String string2 = tM.getAbbreviation(n);
                        if (!string.equals(string2)) continue;
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Duplicate_template_name"), 0));
                        break;
                    }
                    if (n == n2) {
                        this.lastIndex = -1;
                        int n3 = tM.addCodeTemplate(string);
                        this.tTemplates.getSelectionModel().setSelectionInterval(n3, n3);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CodeTemplatesPanel.this.spTemplates.getVerticalScrollBar().setValue(CodeTemplatesPanel.this.spTemplates.getVerticalScrollBar().getMaximum());
                        CodeTemplatesPanel.this.tabPane.setSelectedIndex(0);
                        CodeTemplatesPanel.this.epExpandedText.requestFocus();
                    }
                });
            }
        } else if (actionEvent.getSource() == this.bRemove) {
            CodeTemplatesModel.TM tM = (CodeTemplatesModel.TM)this.tTemplates.getModel();
            int n = this.tTemplates.getSelectedRow();
            tM.removeCodeTemplate(n);
            this.lastIndex = -1;
            if (n < this.tTemplates.getModel().getRowCount()) {
                this.tTemplates.getSelectionModel().setSelectionInterval(n, n);
            } else if (this.tTemplates.getModel().getRowCount() > 0) {
                this.tTemplates.getSelectionModel().setSelectionInterval(this.tTemplates.getModel().getRowCount() - 1, this.tTemplates.getModel().getRowCount() - 1);
            } else {
                this.bRemove.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.cbExpandTemplateOn) {
            switch (this.cbExpandTemplateOn.getSelectedIndex()) {
                case 0: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 0));
                    break;
                }
                case 1: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 1));
                    break;
                }
                case 2: {
                    this.model.setExpander(KeyStroke.getKeyStroke(9, 0));
                    break;
                }
                case 3: {
                    this.model.setExpander(KeyStroke.getKeyStroke(10, 0));
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tTemplates.getSelectedRow();
        if (n < 0) {
            this.epDescription.setText("");
            this.epExpandedText.setText("");
            this.bRemove.setEnabled(false);
            this.lastIndex = -1;
            return;
        }
        this.saveCurrentTemplate();
        CodeTemplatesModel.TM tM = (CodeTemplatesModel.TM)this.tTemplates.getModel();
        this.epDescription.setText(tM.getDescription(n));
        this.epExpandedText.setText(tM.getText(n));
        this.bRemove.setEnabled(true);
        this.lastIndex = n;
    }

    private void saveCurrentTemplate() {
        if (this.lastIndex < 0) {
            return;
        }
        CodeTemplatesModel.TM tM = (CodeTemplatesModel.TM)this.tTemplates.getModel();
        tM.setDescription(this.lastIndex, this.epDescription.getText());
        tM.setText(this.lastIndex, this.epExpandedText.getText());
        this.firePropertyChange("changed", null, null);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private void initComponents() {
        this.lLanguage = new JLabel();
        this.cbLanguage = new JComboBox();
        this.lTemplates = new JLabel();
        this.spTemplates = new JScrollPane();
        this.tTemplates = new JTable();
        this.bNew = new JButton();
        this.bRemove = new JButton();
        this.lExplandTemplateOn = new JLabel();
        this.cbExpandTemplateOn = new JComboBox();
        this.tabPane = new JTabbedPane();
        this.spExpandedText = new JScrollPane();
        this.epExpandedText = new JEditorPane();
        this.spDescription = new JScrollPane();
        this.epDescription = new JEditorPane();
        this.lLanguage.setLabelFor(this.cbLanguage);
        this.lLanguage.setText("Language:");
        this.cbLanguage.setNextFocusableComponent(this.tTemplates);
        this.lTemplates.setLabelFor(this.tTemplates);
        this.lTemplates.setText("Templates:");
        this.tTemplates.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Abbreviation", "Expanded Text", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.tTemplates.setFocusCycleRoot(true);
        this.spTemplates.setViewportView(this.tTemplates);
        this.bNew.setText("New");
        this.bNew.setNextFocusableComponent(this.bRemove);
        this.bRemove.setText("Remove");
        this.lExplandTemplateOn.setLabelFor(this.cbExpandTemplateOn);
        this.lExplandTemplateOn.setText("Expand Template on:");
        this.cbExpandTemplateOn.setNextFocusableComponent(this.bNew);
        this.tabPane.setTabLayoutPolicy(1);
        this.tabPane.setFocusCycleRoot(true);
        this.tabPane.setNextFocusableComponent(this.cbExpandTemplateOn);
        this.spExpandedText.setViewportView(this.epExpandedText);
        this.tabPane.addTab("tab1", this.spExpandedText);
        this.spDescription.setViewportView(this.epDescription);
        this.tabPane.addTab("tab2", this.spDescription);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lLanguage).addPreferredGap(0).add((Component)this.cbLanguage, -2, -1, -2)).add((Component)this.lTemplates).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lExplandTemplateOn).addPreferredGap(0).add((Component)this.cbExpandTemplateOn, -2, -1, -2)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.tabPane, -1, 335, Short.MAX_VALUE).add((Component)this.spTemplates, -1, 335, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.bRemove, -1, -1, Short.MAX_VALUE).add((Component)this.bNew, -1, 122, Short.MAX_VALUE)).add(10, 10, 10))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lLanguage).add((Component)this.cbLanguage, -2, -1, -2)).addPreferredGap(0).add((Component)this.lTemplates).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bNew).addPreferredGap(0).add((Component)this.bRemove)).add((Component)this.spTemplates, -2, 109, -2)).addPreferredGap(1).add((Component)this.tabPane, -1, 218, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lExplandTemplateOn).add((Component)this.cbExpandTemplateOn, -2, -1, -2))));
    }
}

