/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.NBSLanguageReader;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.features.ActionCreator;
import org.netbeans.modules.languages.features.ColorsManager;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

public class LanguagesManager
extends org.netbeans.api.languages.LanguagesManager {
    private static LanguagesManager languagesManager;
    private Language parsingLanguage = Language.create("parsing...");
    private Map<String, Language> mimeTypeToLanguage = new HashMap<String, Language>();
    private Vector<LanguagesManagerListener> listeners = new Vector();
    private Set<FileObject> listeningOn = new HashSet<FileObject>();
    private Listener listener;

    public static LanguagesManager getDefault() {
        if (languagesManager == null) {
            languagesManager = new LanguagesManager();
        }
        return languagesManager;
    }

    public boolean isSupported(String string) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        return fileSystem.findResource("Editors/" + string + "/language.nbs") != null;
    }

    public boolean createDataObjectFor(String string) {
        if (!this.isSupported(string)) {
            return false;
        }
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors/" + string);
        if (fileObject == null) {
            return false;
        }
        Boolean bl = (Boolean)fileObject.getAttribute("createDataObject");
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public static String normalizeMimeType(String string) {
        int n;
        if (string.startsWith("test") && (n = string.indexOf(95)) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public synchronized Language getLanguage(String string) throws LanguageDefinitionNotFoundException {
        if (!this.mimeTypeToLanguage.containsKey(string = LanguagesManager.normalizeMimeType(string))) {
            this.mimeTypeToLanguage.put(string, this.parsingLanguage);
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("Editors/" + string + "/language.nbs");
            if (fileObject == null) {
                this.mimeTypeToLanguage.remove(string);
                throw new LanguageDefinitionNotFoundException("Language definition for " + string + " not found.");
            }
            this.addListener(fileObject);
            Language language = null;
            try {
                Object object3;
                Object object2;
                NBSLanguageReader nBSLanguageReader = NBSLanguageReader.create(fileObject, string);
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                List<TokenType> list2 = nBSLanguageReader.getTokenTypes();
                Parser parser = null;
                if (list2.isEmpty()) {
                    object2 = org.netbeans.api.lexer.Language.find((String)string);
                    for (Object object3 : object2.tokenIds()) {
                        hashMap.put(object3.ordinal(), object3.name());
                    }
                } else {
                    for (TokenType tokenType : list2) {
                        hashMap.put(tokenType.getTypeID(), tokenType.getType());
                    }
                    parser = Parser.create(list2);
                }
                object2 = nBSLanguageReader.getFeatures();
                language = Language.create(string, hashMap, (List<Feature>)object2, parser);
                List<Rule> list = nBSLanguageReader.getRules(language);
                object3 = new HashSet();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    if (!feature.getFeatureName().equals("SKIP")) continue;
                    object3.add(language.getTokenID(feature.getSelector().toString()));
                }
                language.setAnalyser(LLSyntaxAnalyser.create(language, list, (Set<Integer>)object3));
                this.initLanguage(language);
            }
            catch (ParseException parseException) {
                language = Language.create(string);
                Utils.message(parseException.getMessage());
            }
            catch (IOException iOException) {
                language = Language.create(string);
                Utils.message("Editors/" + string + "/language.nbs: " + iOException.getMessage());
            }
            this.mimeTypeToLanguage.put(string, language);
        }
        if (this.parsingLanguage == this.mimeTypeToLanguage.get(string)) {
            throw new IllegalArgumentException();
        }
        return this.mimeTypeToLanguage.get(string);
    }

    public void addLanguage(Language language) {
        this.mimeTypeToLanguage.put(language.getMimeType(), language);
    }

    public void addLanguagesManagerListener(LanguagesManagerListener languagesManagerListener) {
        this.listeners.add(languagesManagerListener);
    }

    public void removeLanguagesManagerListener(LanguagesManagerListener languagesManagerListener) {
        this.listeners.remove(languagesManagerListener);
    }

    private void languageChanged(String string) {
        this.mimeTypeToLanguage.remove(string);
        Vector<LanguagesManagerListener> vector = new Vector<LanguagesManagerListener>(this.listeners);
        for (LanguagesManagerListener languagesManagerListener : vector) {
            languagesManagerListener.languageChanged(string);
        }
    }

    private void addListener(FileObject fileObject) {
        if (!this.listeningOn.contains(fileObject)) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            fileObject.addFileChangeListener((FileChangeListener)this.listener);
            this.listeningOn.add(fileObject);
        }
    }

    private void initLanguage(Language language) {
        try {
            String string;
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            final FileObject fileObject = fileSystem.findResource("Editors/" + language.getMimeType());
            if (fileObject.getFileObject("Settings.settings") == null) {
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/languages/resources/LanguagesOptions.settings");
                            try {
                                FileObject fileObject2 = fileObject.createData("Settings.settings");
                                OutputStream outputStream = fileObject2.getOutputStream();
                                try {
                                    FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            Utils.notify(iOException);
                        }
                    }
                });
            }
            if (fileObject.getFileObject("SideBar/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance") == null && language.getFeatures("FOLD").size() > 0) {
                FileUtil.createData((FileObject)fileObject, (String)"FoldManager/org-netbeans-modules-languages-features-LanguagesFoldManager$Factory.instance");
                FileUtil.createData((FileObject)fileObject, (String)"SideBar/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance").setAttribute("position", (Object)1000);
            }
            if (fileObject.getFileObject("UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance") == null) {
                FileUtil.createData((FileObject)fileObject, (String)"UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance");
            }
            LanguagesManager.initPopupMenu(fileObject, language);
            if (language.getFeatures("NAVIGATOR").size() > 0 && fileSystem.findResource(string = "Navigator/Panels/" + language.getMimeType() + "/org-netbeans-modules-languages-features-LanguagesNavigator.instance") == null) {
                FileUtil.createData((FileObject)fileSystem.getRoot(), (String)string);
            }
            if (language.getFeatures("TOOLTIP").size() > 0) {
                FileUtil.createData((FileObject)fileObject, (String)"ToolTips/org-netbeans-modules-languages-features-ToolTipAnnotation.instance");
            }
            if (language.getFeature("COMMENT_LINE") != null) {
                string = FileUtil.createFolder((FileObject)fileObject, (String)"Toolbars/Default");
                LanguagesManager.createSeparator((FileObject)string, "Separator-before-comment", 3000);
                FileUtil.createData((FileObject)string, (String)"comment").setAttribute("position", (Object)3100);
                FileUtil.createData((FileObject)string, (String)"uncomment").setAttribute("position", (Object)3200);
                if (fileObject.getFileObject("Keybindings/NetBeans/Defaults/keybindings.xml") == null) {
                    fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/languages/resources/DefaultKeyBindings.xml");
                                try {
                                    FileObject fileObject3 = fileObject.getFileObject("Keybindings/NetBeans/Defaults");
                                    if (fileObject3 == null) {
                                        fileObject3 = fileObject.createFolder("Keybindings");
                                        fileObject3 = fileObject3.createFolder("NetBeans");
                                        fileObject3 = fileObject3.createFolder("Defaults");
                                    }
                                    FileObject fileObject2 = fileObject3.createData("keybindings.xml");
                                    OutputStream outputStream = fileObject2.getOutputStream();
                                    try {
                                        FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                                    }
                                    finally {
                                        outputStream.close();
                                    }
                                }
                                finally {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException) {
                                Utils.notify(iOException);
                            }
                        }
                    });
                }
            }
        }
        catch (IOException iOException) {
            Utils.notify(iOException);
        }
        ColorsManager.initColorings(language);
    }

    private static void initPopupMenu(FileObject fileObject, Language language) throws IOException {
        List<Feature> list = language.getFeatures("ACTION");
        int n = LanguagesManager.findPositionOfDefaultPopupAction("org-netbeans-modules-editor-NbSelectInPopupAction.instance", 1000);
        int n2 = (LanguagesManager.findPositionOfDefaultPopupAction("org-openide-actions-CutAction.instance", 2000) - n) / (list.size() + 3);
        FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)"Popup");
        int n3 = n + n2;
        LanguagesManager.createSeparator(fileObject2, "SeparatorAfterSelectInPopupAction", n3);
        boolean bl = false;
        if (language.getFeatures("SEMANTIC_USAGE").size() > 0) {
            bl = true;
            FileUtil.createData((FileObject)fileObject2, (String)"org-netbeans-modules-languages-features-GoToDeclarationAction.instance").setAttribute("position", (Object)(n3 += n2));
        }
        if (language.getFeatures("INDENT").size() > 0) {
            bl = true;
            FileUtil.createData((FileObject)fileObject2, (String)"format").setAttribute("position", (Object)(n3 += n2));
        }
        for (Feature feature : list) {
            if (feature.getBoolean("explorer", false)) continue;
            bl = true;
            n3 += n2;
            String string = feature.getSelector().getAsString();
            String string2 = language.localize((String)feature.getValue("name"));
            String string3 = feature.getMethodName("performer");
            String string4 = feature.getMethodName("enabled");
            boolean bl2 = feature.getBoolean("separator_before", false);
            boolean bl3 = feature.getBoolean("separator_after", false);
            FileObject fileObject3 = FileUtil.createData((FileObject)fileObject2, (String)(string + ".instance"));
            fileObject3.setAttribute("instanceCreate", (Object)new ActionCreator(new Object[]{string2, string3, string4}));
            fileObject3.setAttribute("instanceClass", (Object)"org.netbeans.modules.languages.features.GenericAction");
            fileObject3.setAttribute("position", (Object)n3);
            if (bl2) {
                LanguagesManager.createSeparator(fileObject2, string + "_separator_before", n3 - n2 / 3);
            }
            if (!bl3) continue;
            LanguagesManager.createSeparator(fileObject2, string + "_separator_after", n3 + n2 / 3);
        }
        if (bl) {
            LanguagesManager.createSeparator(fileObject2, "SeparatorBeforeCut", n3 + n2);
        }
        if (language.getFeatures("FOLD").size() > 0) {
            FileUtil.createData((FileObject)fileObject2, (String)"generate-fold-popup").setAttribute("position", (Object)(LanguagesManager.findPositionOfDefaultPopupAction("org-openide-actions-PasteAction.instance", 3000) + 50));
        }
    }

    private static int findPositionOfDefaultPopupAction(String string, int n) {
        Object object;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors/Popup/" + string);
        if (fileObject != null && (object = fileObject.getAttribute("position")) instanceof Integer) {
            return (Integer)object;
        }
        return n;
    }

    private static void createSeparator(FileObject fileObject, String string, int n) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)(string + ".instance"));
        fileObject2.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
        fileObject2.setAttribute("position", (Object)n);
    }

    public static interface LanguagesManagerListener {
        public void languageChanged(String var1);
    }

    private class Listener
    implements FileChangeListener {
        private Listener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            String string = fileObject.getParent().getParent().getName() + '/' + fileObject.getParent().getName();
            LanguagesManager.this.languageChanged(string);
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            String string = fileObject.getParent().getName();
            LanguagesManager.this.languageChanged(string);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }
    }
}

