/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import mondrian.gui.JDBCMetaData;
import mondrian.gui.JTreeUpdater;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaPropertyCellEditor;
import mondrian.gui.SchemaPropertyCellRenderer;
import mondrian.gui.SchemaTreeCellEditor;
import mondrian.gui.SchemaTreeCellRenderer;
import mondrian.gui.SchemaTreeModel;
import mondrian.gui.Workbench;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public class SchemaExplorer
extends JPanel
implements TreeSelectionListener,
CellEditorListener {
    private MondrianGuiDef.Schema schema;
    private SchemaTreeModel model;
    private SchemaTreeCellRenderer renderer;
    private SchemaTreeCellEditor editor;
    private File schemaFile;
    private JTreeUpdater updater;
    private final ClassLoader myClassLoader = this.getClass().getClassLoader();
    private boolean newFile;
    private boolean dirty = false;
    private boolean dirtyFlag = false;
    private JInternalFrame parentIFrame;
    private JDBCMetaData jdbcMetaData;
    private boolean editModeXML = false;
    private String errMsg = null;
    public Object lastSelected;
    public static final String[] DEF_DEFAULT = new String[0];
    public static final String[] DEF_VIRTUAL_CUBE = new String[]{"name", "caption", "enabled"};
    public static final String[] DEF_VIRTUAL_CUBE_MEASURE = new String[]{"name", "cubeName", "visible"};
    public static final String[] DEF_VIRTUAL_CUBE_DIMENSION = new String[]{"name", "cubeName", "caption", "foreignKey"};
    public static final String[] DEF_VIEW = new String[]{"alias"};
    public static final String[] DEF_TABLE = new String[]{"schema", "name", "alias"};
    public static final String[] DEF_AGG_FACT_COUNT = new String[]{"column"};
    public static final String[] DEF_AGG_NAME = new String[]{"name", "ignorecase"};
    public static final String[] DEF_AGG_PATTERN = new String[]{"pattern", "ignorecase"};
    public static final String[] DEF_AGG_EXCLUDE = new String[]{"pattern", "name", "ignorecase"};
    public static final String[] DEF_AGG_IGNORE_COLUMN = new String[]{"column"};
    public static final String[] DEF_AGG_FOREIGN_KEY = new String[]{"factColumn", "aggColumn"};
    public static final String[] DEF_AGG_MEASURE = new String[]{"column", "name"};
    public static final String[] DEF_AGG_LEVEL = new String[]{"column", "name"};
    public static final String[] DEF_CLOSURE = new String[]{"parentColumn", "childColumn"};
    public static final String[] DEF_RELATION = new String[]{"name"};
    public static final String[] DEF_SQL = new String[]{"cdata", "dialect"};
    public static final String[] DEF_SCHEMA = new String[]{"name", "measuresCaption", "defaultRole"};
    public static final String[] DEF_PROPERTY = new String[]{"name", "column", "type", "formatter", "caption"};
    public static final String[] DEF_PARAMETER = new String[]{"name", "value"};
    public static final String[] DEF_MEASURE = new String[]{"name", "aggregator", "column", "formatString", "visible", "datatype", "formatter", "caption"};
    public static final String[] DEF_CALCULATED_MEMBER = new String[]{"name", "caption", "dimension", "visible", "formula | formulaElement.cdata", "formatString"};
    public static final String[] DEF_FORMULA = new String[]{"cdata"};
    public static final String[] DEF_CALCULATED_MEMBER_PROPERTY = new String[]{"name", "caption", "expression", "value"};
    public static final String[] DEF_NAMED_SET = new String[]{"name", "formula"};
    public static final String[] DEF_USER_DEFINED_FUNCTION = new String[]{"name", "className"};
    public static final String[] DEF_LEVEL = new String[]{"name", "table", "column", "nameColumn", "parentColumn", "nullParentValue", "ordinalColumn", "type", "uniqueMembers", "levelType", "hideMemberIf", "approxRowCount", "caption", "captionColumn", "formatter"};
    public static final String[] DEF_JOIN = new String[]{"leftAlias", "leftKey", "rightAlias", "rightKey"};
    public static final String[] DEF_HIERARCHY = new String[]{"name", "hasAll", "allMemberName", "allMemberCaption", "allLevelName", "defaultMember", "memberReaderClass", "primaryKeyTable", "primaryKey", "caption"};
    public static final String[] DEF_EXPRESSION_VIEW = new String[0];
    public static final String[] DEF_DIMENSION_USAGE = new String[]{"name", "foreignKey", "source", "level", "usagePrefix", "caption"};
    public static final String[] DEF_DIMENSION = new String[]{"name", "foreignKey", "type", "usagePrefix", "caption"};
    public static final String[] DEF_CUBE = new String[]{"name", "caption", "cache", "enabled"};
    public static final String[] DEF_ROLE = new String[]{"name"};
    public static final String[] DEF_SCHEMA_GRANT = new String[]{"access"};
    public static final String[] DEF_CUBE_GRANT = new String[]{"access", "cube"};
    public static final String[] DEF_DIMENSION_GRANT = new String[]{"access", "dimension"};
    public static final String[] DEF_HIERARCHY_GRANT = new String[]{"access", "hierarchy", "topLevel", "bottomLevel"};
    public static final String[] DEF_MEMBER_GRANT = new String[]{"access", "member"};
    public static final String[] DEF_COLUMN = new String[]{"name", "table"};
    private static final String LBL_COLUMN = "Column";
    private static final String LBL_CUBE = "Cube";
    private static final String LBL_ROLE = "Role";
    private static final String LBL_SCHEMA_GRANT = "Schema Grant";
    private static final String LBL_CUBE_GRANT = "Cube Grant";
    private static final String LBL_DIMENSION_GRANT = "Dimension Grant";
    private static final String LBL_HIERARCHY_GRANT = "Hierarchy Grant";
    private static final String LBL_MEMBER_GRANT = "Member Grant";
    private static final String LBL_DIMENSION = "Dimension";
    private static final String LBL_DIMENSION_USAGE = "Dimension Usage";
    private static final String LBL_EXPRESSION_VIEW = "Expression View";
    private static final String LBL_KEY_EXPRESSION = "Key Expression";
    private static final String LBL_NAME_EXPRESSION = "Name Expression";
    private static final String LBL_ORDINAL_EXPRESSION = "Ordinal Expression";
    private static final String LBL_PARENT_EXPRESSION = "Parent Expression";
    private static final String LBL_MEASURE_EXPRESSION = "Measure Expression";
    private static final String LBL_HIERARCHY = "Hierarchy";
    private static final String LBL_JOIN = "Join";
    private static final String LBL_LEVEL = "Level";
    private static final String LBL_MEASURE = "Measure";
    private static final String LBL_CALCULATED_MEMBER = "Calculated Member";
    private static final String LBL_CALCULATED_MEMBER_PROPERTY = "Calculated Member Property";
    private static final String LBL_NAMED_SET = "Named Set";
    private static final String LBL_USER_DEFINED_FUNCTION = "User Defined Function";
    private static final String LBL_PARAMETER = "Parameter";
    private static final String LBL_PROPERTY = "Property";
    private static final String LBL_SCHEMA = "Schema";
    private static final String LBL_SQL = "SQL";
    private static final String LBL_TABLE = "Table";
    private static final String LBL_CLOSURE = "Closure";
    private static final String LBL_AGG_NAME = "Aggregate Name";
    private static final String LBL_AGG_IGNORE_COLUMN = "Aggregate Ignore Column";
    private static final String LBL_AGG_FOREIGN_KEY = "Aggregate Foreign Key";
    private static final String LBL_AGG_MEASURE = "Aggregate Measure";
    private static final String LBL_AGG_LEVEL = "Aggregate Level";
    private static final String LBL_AGG_PATTERN = "Aggregate Pattern";
    private static final String LBL_AGG_EXCLUDE = "Aggregate Exclude";
    private static final String LBL_AGG_FACT_COUNT = "Aggregate Fact Count";
    private static final String LBL_VIEW = "View";
    private static final String LBL_VIRTUAL_CUBE = "Virtual Cube";
    private static final String LBL_VIRTUAL_CUBE_DIMENSION = "Virtual Cube Dimension";
    private static final String LBL_VIRTUAL_CUBE_MEASURE = "Virtual Cube Measure";
    private static final String LBL_UNKNOWN_TYPE = "Unknown Type";
    private static final String alert = "Alert";
    private AbstractAction arrowButtonUpAction;
    private AbstractAction arrowButtonDownAction;
    private AbstractAction addCube;
    private AbstractAction addRole;
    private AbstractAction addSchemaGrant;
    private AbstractAction addCubeGrant;
    private AbstractAction addDimensionGrant;
    private AbstractAction addHierarchyGrant;
    private AbstractAction addMemberGrant;
    private AbstractAction addDimension;
    private AbstractAction addDimensionUsage;
    private AbstractAction addHierarchy;
    private AbstractAction addNamedSet;
    private AbstractAction addUserDefinedFunction;
    private AbstractAction addCalculatedMember;
    private AbstractAction addMeasure;
    private AbstractAction addMeasureExp;
    private AbstractAction addLevel;
    private AbstractAction addSQL;
    private AbstractAction addKeyExp;
    private AbstractAction addNameExp;
    private AbstractAction addOrdinalExp;
    private AbstractAction addParentExp;
    private AbstractAction addRelation;
    private AbstractAction addProperty;
    private AbstractAction addClosure;
    private AbstractAction addAggName;
    private AbstractAction addAggIgnoreColumn;
    private AbstractAction addAggForeignKey;
    private AbstractAction addAggMeasure;
    private AbstractAction addAggLevel;
    private AbstractAction addAggPattern;
    private AbstractAction addAggExclude;
    private AbstractAction addAggFactCount;
    private AbstractAction addVirtualCube;
    private AbstractAction addVirtualCubeDimension;
    private AbstractAction addVirtualCubeMeasure;
    private AbstractAction delete;
    private AbstractAction editMode;
    private JTable propertyTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton addLevelButton;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane1;
    private JButton addPropertyButton;
    private JButton pasteButton;
    private JLabel targetLabel;
    private JLabel validStatusLabel;
    private JLabel targetLabel2;
    private JLabel validStatusLabel2;
    private JTree tree;
    private JSplitPane jSplitPane1;
    private JButton addDimensionButton;
    private JButton addDimensionUsageButton;
    private JButton addHierarchyButton;
    private JButton addNamedSetButton;
    private JButton addUserDefinedFunctionButton;
    private JButton addCalculatedMemberButton;
    private JButton cutButton;
    private JButton addMeasureButton;
    private JButton addCubeButton;
    private JButton addRoleButton;
    private JButton addVirtualCubeButton;
    private JButton addVirtualCubeDimensionButton;
    private JButton addVirtualCubeMeasureButton;
    private JButton deleteButton;
    private JToggleButton editModeButton;
    private JButton copyButton;
    private JToolBar jToolBar1;
    private JPopupMenu jPopupMenu;
    private JSeparator jSeparator1;
    private JPanel footer;
    private JLabel databaseLabel;
    private JPanel jPanelXML;
    private JScrollPane jScrollPaneXML;
    private JEditorPane jEditorPaneXML;

    public SchemaExplorer() {
        this.initComponents();
    }

    public SchemaExplorer(File f, JDBCMetaData jdbcMetaData, boolean newFile, JInternalFrame parentIFrame) {
        this();
        try {
            this.jEditorPaneXML = new JEditorPane();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jEditorPaneXML.setLayout(new BorderLayout());
        this.jEditorPaneXML.setEditable(false);
        this.jScrollPaneXML = new JScrollPane(this.jEditorPaneXML);
        this.jPanelXML.setLayout(new BorderLayout());
        this.jPanelXML.add((Component)this.jScrollPaneXML, "Center");
        this.jPanelXML.add((Component)this.targetLabel2, "North");
        this.jPanelXML.add((Component)this.validStatusLabel2, "South");
        this.jPanelXML.setMaximumSize(this.jPanel1.getMaximumSize());
        this.jPanelXML.setPreferredSize(this.jPanel1.getPreferredSize());
        this.databaseLabel.setText("Database -  " + jdbcMetaData.getDbCatalogName() + "  (" + jdbcMetaData.getDatabaseProductName() + ")");
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            this.schemaFile = f;
            this.setNewFile(newFile);
            this.parentIFrame = parentIFrame;
            this.jdbcMetaData = jdbcMetaData;
            if (newFile) {
                this.schema = new MondrianGuiDef.Schema();
                this.schema.cubes = new MondrianGuiDef.Cube[0];
                this.schema.dimensions = new MondrianGuiDef.Dimension[0];
                this.schema.namedSets = new MondrianGuiDef.NamedSet[0];
                this.schema.roles = new MondrianGuiDef.Role[0];
                this.schema.userDefinedFunctions = new MondrianGuiDef.UserDefinedFunction[0];
                this.schema.virtualCubes = new MondrianGuiDef.VirtualCube[0];
                String sname = this.schemaFile.getName();
                int ext = sname.indexOf(".");
                if (ext != -1) {
                    this.schema.name = "New " + sname.substring(0, ext);
                }
            } else {
                try {
                    this.schema = new MondrianGuiDef.Schema(xmlParser.parse(this.schemaFile.toURL()));
                }
                catch (XOMException ex) {
                    this.schema = new MondrianGuiDef.Schema();
                    this.schema.cubes = new MondrianGuiDef.Cube[0];
                    this.schema.dimensions = new MondrianGuiDef.Dimension[0];
                    this.schema.namedSets = new MondrianGuiDef.NamedSet[0];
                    this.schema.roles = new MondrianGuiDef.Role[0];
                    this.schema.userDefinedFunctions = new MondrianGuiDef.UserDefinedFunction[0];
                    this.schema.virtualCubes = new MondrianGuiDef.VirtualCube[0];
                    System.out.println("Exception  : Schema file parsing failed." + ex.getMessage());
                    this.errMsg = "Parsing Error: Could not open file\n" + this.schemaFile + ".\n" + ex.getMessage();
                }
            }
            this.setTitle();
            this.renderer = new SchemaTreeCellRenderer(jdbcMetaData);
            this.model = new SchemaTreeModel(this.schema);
            this.tree.setModel(this.model);
            this.tree.setCellRenderer(this.renderer);
            this.tree.addTreeSelectionListener(this);
            JComboBox<String> listEditor = new JComboBox<String>(new String[]{LBL_JOIN, LBL_TABLE});
            listEditor.setToolTipText("select Join or Table Hierarchy");
            listEditor.setPreferredSize(new Dimension(listEditor.getPreferredSize().width, 24));
            listEditor.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TreePath parentpath;
                    SchemaExplorer.this.tree.stopEditing();
                    TreePath tpath = SchemaExplorer.this.tree.getSelectionPath();
                    if (tpath != null && (parentpath = tpath.getParentPath()) != null) {
                        SchemaExplorer.this.refreshTree(parentpath);
                    }
                }
            });
            DefaultCellEditor comboEditor = new DefaultCellEditor(listEditor);
            this.editor = new SchemaTreeCellEditor(this.tree, this.renderer, comboEditor);
            this.tree.setCellEditor(this.editor);
            this.tree.setEditable(true);
            SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(jdbcMetaData);
            spce.addCellEditorListener(this);
            this.propertyTable.setDefaultEditor(Object.class, spce);
            SchemaPropertyCellRenderer.attributeBackground = this.jScrollPane2.getBackground();
            SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
            this.propertyTable.setDefaultRenderer(Object.class, spcr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        ResourceBundle resources = ResourceBundle.getBundle("mondrian.gui.resources.gui");
        this.jPanelXML = new JPanel();
        this.jScrollPaneXML = new JScrollPane();
        this.footer = new JPanel();
        this.databaseLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.propertyTable = new JTable(){

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                KeyEvent ke;
                int kcode;
                AWTEvent currentEvent;
                if (columnIndex == 0 && (currentEvent = EventQueue.getCurrentEvent()) instanceof KeyEvent && (kcode = (ke = (KeyEvent)currentEvent).getKeyCode()) == 9) {
                    if ((ke.getModifiersEx() & 0x40) == 64 && --rowIndex < 0) {
                        rowIndex = SchemaExplorer.this.propertyTable.getRowCount() - 1;
                    }
                    SchemaExplorer.this.setTableCellFocus(rowIndex);
                    return;
                }
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }

            public void processKeyEvent(KeyEvent e) {
                int kcode = e.getKeyCode();
                if (kcode == 38 || kcode == 40) {
                    int row = SchemaExplorer.this.propertyTable.getSelectedRow();
                    SchemaExplorer.this.setTableCellFocus(row);
                    return;
                }
                super.processKeyEvent(e);
            }
        };
        this.targetLabel = new JLabel();
        this.validStatusLabel = new JLabel();
        this.targetLabel2 = new JLabel();
        this.validStatusLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree(){

            public String getToolTipText(MouseEvent evt) {
                String toggleMsg = "Double click to display Join/Table selection";
                if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
                    return null;
                }
                TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
                Object o = curPath.getLastPathComponent();
                if (o instanceof MondrianGuiDef.Join) {
                    return toggleMsg;
                }
                TreePath parentPath = curPath.getParentPath();
                if (parentPath != null) {
                    Object po = parentPath.getLastPathComponent();
                    if (o instanceof MondrianGuiDef.Table && (po instanceof MondrianGuiDef.Hierarchy || po instanceof MondrianGuiDef.Join)) {
                        return toggleMsg;
                    }
                }
                return null;
            }
        };
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.jToolBar1 = new JToolBar();
        this.addCubeButton = new JButton();
        this.addDimensionButton = new JButton();
        this.addDimensionUsageButton = new JButton();
        this.addHierarchyButton = new JButton();
        this.addNamedSetButton = new JButton();
        this.addUserDefinedFunctionButton = new JButton();
        this.addRoleButton = new JButton();
        this.addMeasureButton = new JButton();
        this.addCalculatedMemberButton = new JButton();
        this.addLevelButton = new JButton();
        this.addPropertyButton = new JButton();
        this.addVirtualCubeButton = new JButton();
        this.addVirtualCubeDimensionButton = new JButton();
        this.addVirtualCubeMeasureButton = new JButton();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.deleteButton = new JButton();
        this.editModeButton = new JToggleButton();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.jPanel1.setLayout(new BorderLayout());
        this.propertyTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Attribute", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.propertyTable.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.jScrollPane2.setViewportView(this.propertyTable);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.targetLabel.setFont(new Font("Dialog", 1, 14));
        this.targetLabel.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.targetLabel.setHorizontalAlignment(0);
        this.targetLabel.setText(LBL_SCHEMA);
        this.targetLabel.setBorder(new EtchedBorder());
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(new BorderLayout());
        BasicArrowButton arrowButtonUp = new BasicArrowButton(1);
        BasicArrowButton arrowButtonDown = new BasicArrowButton(5);
        arrowButtonUp.setToolTipText("move to parent element");
        arrowButtonDown.setToolTipText("move to child element");
        this.arrowButtonUpAction = new AbstractAction("Arrow button up"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.arrowButtonUpAction(e);
            }
        };
        this.arrowButtonDownAction = new AbstractAction("Arrow button down"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.arrowButtonDownAction(e);
            }
        };
        arrowButtonUp.addActionListener(this.arrowButtonUpAction);
        arrowButtonDown.addActionListener(this.arrowButtonDownAction);
        this.jPanel3.add((Component)arrowButtonDown, "East");
        this.jPanel3.add((Component)arrowButtonUp, "West");
        this.jPanel3.add((Component)this.targetLabel, "Center");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.validStatusLabel.setFont(new Font("Dialog", 0, 12));
        this.validStatusLabel.setForeground(Color.RED);
        this.validStatusLabel.setHorizontalAlignment(0);
        this.jPanel1.add((Component)this.validStatusLabel, "South");
        this.targetLabel2.setFont(new Font("Dialog", 1, 14));
        this.targetLabel2.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.targetLabel2.setHorizontalAlignment(0);
        this.targetLabel2.setText(LBL_SCHEMA);
        this.targetLabel2.setBorder(new EtchedBorder());
        this.validStatusLabel2.setFont(new Font("Dialog", 0, 12));
        this.validStatusLabel2.setForeground(Color.RED);
        this.validStatusLabel2.setHorizontalAlignment(0);
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.tree);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.addCube = new AbstractAction("Add cube"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCube(e);
            }
        };
        this.addDimension = new AbstractAction("Add Dimension"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimension(e);
            }
        };
        this.addDimensionUsage = new AbstractAction("Add Dimension Usage"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimensionUsage(e);
            }
        };
        this.addHierarchy = new AbstractAction("Add Hierarchy"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addHierarchy(e);
            }
        };
        this.addNamedSet = new AbstractAction("Add Named Set"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addNamedSet(e);
            }
        };
        this.addMeasure = new AbstractAction("Add Measure"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMeasure(e);
            }
        };
        this.addCalculatedMember = new AbstractAction("Add Calculated Measure"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCalculatedMember(e);
            }
        };
        this.addUserDefinedFunction = new AbstractAction("Add User Defined Function"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addUserDefinedFunction(e);
            }
        };
        this.addRole = new AbstractAction("Add Role"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addRole(e);
            }
        };
        this.addSchemaGrant = new AbstractAction("Add Schema Grant"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addSchemaGrant(e);
            }
        };
        this.addCubeGrant = new AbstractAction("Add Cube Grant"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCubeGrant(e);
            }
        };
        this.addDimensionGrant = new AbstractAction("Add Dimension Grant"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimensionGrant(e);
            }
        };
        this.addHierarchyGrant = new AbstractAction("Add Hierarchy Grant"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addHierarchyGrant(e);
            }
        };
        this.addMemberGrant = new AbstractAction("Add Member Grant"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMemberGrant(e);
            }
        };
        this.addLevel = new AbstractAction("Add Level"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addLevel(e);
            }
        };
        this.addClosure = new AbstractAction("Add Closure"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addClosure(e);
            }
        };
        this.addKeyExp = new AbstractAction("Add Key Expression"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addKeyExp(e);
            }
        };
        this.addNameExp = new AbstractAction("Add Name Expression"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addNameExp(e);
            }
        };
        this.addOrdinalExp = new AbstractAction("Add Ordinal Expression"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addOrdinalExp(e);
            }
        };
        this.addParentExp = new AbstractAction("Add Parent Expression"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addParentExp(e);
            }
        };
        this.addMeasureExp = new AbstractAction("Add Measure Expression"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMeasureExp(e);
            }
        };
        this.addSQL = new AbstractAction("Add SQL"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addSQL(e);
            }
        };
        this.addRelation = new AbstractAction("Add Relation"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addRelation(e);
            }
        };
        this.addProperty = new AbstractAction("Add Property"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addProperty(e);
            }
        };
        this.addVirtualCube = new AbstractAction("Add Virtual Cube"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCube(e);
            }
        };
        this.addVirtualCubeDimension = new AbstractAction("Add Virtual Cube Dimension"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCubeDimension(e);
            }
        };
        this.addVirtualCubeMeasure = new AbstractAction("Add Virtual Cube Measure"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCubeMeasure(e);
            }
        };
        this.addAggPattern = new AbstractAction("Add Aggregate Pattern"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggPattern(e);
            }
        };
        this.addAggExclude = new AbstractAction("Add Aggregate Exclude Table"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggExclude(e);
            }
        };
        this.addAggName = new AbstractAction("Add Aggregate Name"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggName(e);
            }
        };
        this.addAggIgnoreColumn = new AbstractAction("Add Aggregate Ignore Column"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggIgnoreColumn(e);
            }
        };
        this.addAggForeignKey = new AbstractAction("Add Aggregate Foreign Key"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggForeignKey(e);
            }
        };
        this.addAggMeasure = new AbstractAction("Add Aggregate Measure"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggMeasure(e);
            }
        };
        this.addAggLevel = new AbstractAction("Add Aggregate Level"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggLevel(e);
            }
        };
        this.addAggFactCount = new AbstractAction("Add Aggregate Fact Count"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggFactCount(e);
            }
        };
        this.delete = new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.delete(e);
            }
        };
        this.editMode = new AbstractAction("EditMode"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.editMode(e);
            }
        };
        this.addCubeButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addCube"))));
        this.addCubeButton.setToolTipText("Add Cube");
        this.addCubeButton.addActionListener(this.addCube);
        this.addDimensionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addDimension"))));
        this.addDimensionButton.setToolTipText("Add Dimension");
        this.addDimensionButton.addActionListener(this.addDimension);
        this.addDimensionUsageButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addDimensionUsage"))));
        this.addDimensionUsageButton.setToolTipText("Add Dimension Usage");
        this.addDimensionUsageButton.addActionListener(this.addDimensionUsage);
        this.addHierarchyButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addHierarchy"))));
        this.addHierarchyButton.setToolTipText("Add Hierarchy");
        this.addHierarchyButton.addActionListener(this.addHierarchy);
        this.addNamedSetButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addNamedSet"))));
        this.addNamedSetButton.setToolTipText("Add Named Set");
        this.addNamedSetButton.addActionListener(this.addNamedSet);
        this.addUserDefinedFunctionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addUserDefinedFunction"))));
        this.addUserDefinedFunctionButton.setToolTipText("Add User defined Function");
        this.addUserDefinedFunctionButton.addActionListener(this.addUserDefinedFunction);
        this.addCalculatedMemberButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addCalculatedMember"))));
        this.addCalculatedMemberButton.setToolTipText("Add Calculated Member");
        this.addCalculatedMemberButton.addActionListener(this.addCalculatedMember);
        this.addMeasureButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addMeasure"))));
        this.addMeasureButton.setToolTipText("Add Measure");
        this.addMeasureButton.addActionListener(this.addMeasure);
        this.addLevelButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addLevel"))));
        this.addLevelButton.setToolTipText("Add Level");
        this.addLevelButton.addActionListener(this.addLevel);
        this.addPropertyButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addProperty"))));
        this.addPropertyButton.setToolTipText("Add Property");
        this.addPropertyButton.addActionListener(this.addProperty);
        this.addVirtualCubeButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addVirtualCube"))));
        this.addVirtualCubeButton.setToolTipText("Add Virtual Cube");
        this.addVirtualCubeButton.addActionListener(this.addVirtualCube);
        this.addVirtualCubeDimensionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addVirtualCubeDimension"))));
        this.addVirtualCubeDimensionButton.setToolTipText("Add Virtual Dimension");
        this.addVirtualCubeDimensionButton.addActionListener(this.addVirtualCubeDimension);
        this.addVirtualCubeMeasureButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addVirtualCubeMeasure"))));
        this.addVirtualCubeMeasureButton.setToolTipText("Add Virtual Measure");
        this.addVirtualCubeMeasureButton.addActionListener(this.addVirtualCubeMeasure);
        this.addRoleButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addRole"))));
        this.addRoleButton.setToolTipText("Add Role");
        this.addRoleButton.addActionListener(this.addRole);
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut24.gif")));
        this.cutButton.setToolTipText("Cut");
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy24.gif")));
        this.copyButton.setToolTipText("Copy");
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste24.gif")));
        this.pasteButton.setToolTipText("Paste");
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete24.gif")));
        this.deleteButton.setToolTipText("Delete");
        this.deleteButton.addActionListener(this.delete);
        this.editModeButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit24.gif")));
        this.editModeButton.setToolTipText("View XML");
        this.editModeButton.addActionListener(this.editMode);
        this.databaseLabel.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/development/Server24.gif")));
        this.jToolBar1.add(this.addCubeButton);
        this.jToolBar1.add(this.addDimensionButton);
        this.jToolBar1.add(this.addDimensionUsageButton);
        this.jToolBar1.add(this.addHierarchyButton);
        this.jToolBar1.add(this.addNamedSetButton);
        this.jToolBar1.add(this.addUserDefinedFunctionButton);
        this.jToolBar1.add(this.addCalculatedMemberButton);
        this.jToolBar1.add(this.addMeasureButton);
        this.jToolBar1.add(this.addLevelButton);
        this.jToolBar1.add(this.addPropertyButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.addVirtualCubeButton);
        this.jToolBar1.add(this.addVirtualCubeDimensionButton);
        this.jToolBar1.add(this.addVirtualCubeMeasureButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.addRoleButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.cutButton);
        this.jToolBar1.add(this.copyButton);
        this.jToolBar1.add(this.pasteButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.deleteButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.editModeButton);
        this.jPopupMenu = new JPopupMenu();
        this.tree.addMouseListener(new PopupTrigger());
        this.tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int kcode = e.getKeyCode();
                if (kcode == 127 || kcode == 110) {
                    SchemaExplorer.this.delete(e);
                }
            }
        });
        this.footer.setLayout(new BorderLayout());
        this.footer.add((Component)this.databaseLabel, "Center");
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jToolBar1, "North");
        this.add((Component)this.footer, "South");
        this.updater = new JTreeUpdater(this.tree);
    }

    protected void arrowButtonUpAction(ActionEvent evt) {
        TreePath parentpath;
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath != null && (parentpath = tpath.getParentPath()) != null) {
            this.tree.setSelectionPath(parentpath);
            this.refreshTree(parentpath);
        }
    }

    protected void arrowButtonDownAction(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath != null) {
            Object current = tpath.getLastPathComponent();
            Object child = this.tree.getModel().getChild(current, 0);
            if (child != null) {
                Object[] treeObjs = new Object[30];
                treeObjs[0] = child;
                treeObjs[1] = current;
                int objCnt = 2;
                for (TreePath parentpath = tpath.getParentPath(); parentpath != null; parentpath = parentpath.getParentPath()) {
                    Object po;
                    treeObjs[objCnt] = po = parentpath.getLastPathComponent();
                    ++objCnt;
                }
                Object[] nodes = new Object[objCnt];
                int loopCnt = objCnt - 1;
                for (int j = 0; j < objCnt; ++j) {
                    nodes[j] = treeObjs[loopCnt];
                    --loopCnt;
                }
                TreePath childPath = new TreePath(nodes);
                this.tree.setSelectionPath(childPath);
                this.refreshTree(childPath);
            }
        }
    }

    protected void setTableCellFocus(int row) {
        this.propertyTable.editCellAt(row, 1);
        TableCellEditor editor = this.propertyTable.getCellEditor(row, 1);
        Component comp = editor.getTableCellEditorComponent(this.propertyTable, this.propertyTable.getValueAt(row, 1), true, row, 1);
    }

    protected void addCube(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.Cube cube = new MondrianGuiDef.Cube();
        cube.name = "";
        cube.dimensions = new MondrianGuiDef.Dimension[0];
        cube.measures = new MondrianGuiDef.Measure[0];
        MondrianGuiDef.Table cfact = new MondrianGuiDef.Table("", LBL_TABLE, "");
        cfact.aggExcludes = new MondrianGuiDef.AggExclude[0];
        cfact.aggTables = new MondrianGuiDef.AggTable[0];
        cube.fact = cfact;
        cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[0];
        cube.namedSets = new MondrianGuiDef.NamedSet[0];
        cube.name = this.getNewName("New Cube ", (Object[])schema.cubes);
        cube.cache = Boolean.TRUE;
        cube.enabled = Boolean.TRUE;
        MondrianGuiDef.Cube[] temp = schema.cubes;
        schema.cubes = new MondrianGuiDef.Cube[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.cubes[_i] = temp[_i];
        }
        schema.cubes[schema.cubes.length - 1] = cube;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)cube));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addRole(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.Role role = new MondrianGuiDef.Role();
        role.name = "";
        role.schemaGrants = new MondrianGuiDef.SchemaGrant[0];
        role.name = this.getNewName("New Role ", (Object[])schema.roles);
        MondrianGuiDef.Role[] temp = schema.roles;
        schema.roles = new MondrianGuiDef.Role[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.roles[_i] = temp[_i];
        }
        schema.roles[schema.roles.length - 1] = role;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)role));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCube(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.VirtualCube cube = new MondrianGuiDef.VirtualCube();
        cube.name = "";
        cube.dimensions = new MondrianGuiDef.VirtualCubeDimension[0];
        cube.measures = new MondrianGuiDef.VirtualCubeMeasure[0];
        cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[0];
        cube.enabled = Boolean.TRUE;
        cube.name = this.getNewName("New Virtual Cube ", (Object[])schema.virtualCubes);
        MondrianGuiDef.VirtualCube[] temp = schema.virtualCubes;
        schema.virtualCubes = new MondrianGuiDef.VirtualCube[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.virtualCubes[_i] = temp[_i];
        }
        schema.virtualCubes[schema.virtualCubes.length - 1] = cube;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)cube));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addUserDefinedFunction(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.UserDefinedFunction udf = new MondrianGuiDef.UserDefinedFunction();
        udf.name = "";
        udf.name = this.getNewName("New Udf ", (Object[])schema.userDefinedFunctions);
        MondrianGuiDef.UserDefinedFunction[] temp = schema.userDefinedFunctions;
        schema.userDefinedFunctions = new MondrianGuiDef.UserDefinedFunction[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.userDefinedFunctions[_i] = temp[_i];
        }
        schema.userDefinedFunctions[schema.userDefinedFunctions.length - 1] = udf;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)udf));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    private void refreshTree(TreePath path) {
        this.setDirty(true);
        if (!this.dirtyFlag) {
            this.setDirtyFlag(true);
            this.setTitle();
        }
        this.updater.update();
        this.tree.scrollPathToVisible(path);
    }

    protected void addMeasure(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Cube)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube)) {
            JOptionPane.showMessageDialog(this, "Cube not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)path);
        MondrianGuiDef.Measure measure = new MondrianGuiDef.Measure();
        measure.name = "";
        measure.name = this.getNewName("New Measure ", (Object[])cube.measures);
        measure.visible = Boolean.TRUE;
        MondrianGuiDef.Measure[] temp = cube.measures;
        cube.measures = new MondrianGuiDef.Measure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.measures[i] = temp[i];
        }
        cube.measures[cube.measures.length - 1] = measure;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)measure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggPattern(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Table) || parentIndex - 1 < 0 || !(tpath.getPathComponent(parentIndex - 1) instanceof MondrianGuiDef.Cube)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Table)) {
            JOptionPane.showMessageDialog(this, "Cube Fact Table not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)((Object)path);
        MondrianGuiDef.AggPattern aggname = new MondrianGuiDef.AggPattern();
        aggname.pattern = "";
        aggname.ignorecase = Boolean.TRUE;
        aggname.factcount = null;
        aggname.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[0];
        aggname.foreignKeys = new MondrianGuiDef.AggForeignKey[0];
        aggname.measures = new MondrianGuiDef.AggMeasure[0];
        aggname.levels = new MondrianGuiDef.AggLevel[0];
        aggname.excludes = new MondrianGuiDef.AggExclude[0];
        MondrianGuiDef.AggTable[] temp = factTable.aggTables;
        factTable.aggTables = new MondrianGuiDef.AggTable[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            factTable.aggTables[i] = temp[i];
        }
        factTable.aggTables[factTable.aggTables.length - 1] = aggname;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggname));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggName(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Table) || parentIndex - 1 < 0 || !(tpath.getPathComponent(parentIndex - 1) instanceof MondrianGuiDef.Cube)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Table)) {
            JOptionPane.showMessageDialog(this, "Table not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)((Object)path);
        MondrianGuiDef.AggName aggname = new MondrianGuiDef.AggName();
        aggname.name = "";
        aggname.ignorecase = Boolean.TRUE;
        aggname.factcount = null;
        aggname.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[0];
        aggname.foreignKeys = new MondrianGuiDef.AggForeignKey[0];
        aggname.measures = new MondrianGuiDef.AggMeasure[0];
        aggname.levels = new MondrianGuiDef.AggLevel[0];
        MondrianGuiDef.AggTable[] temp = factTable.aggTables;
        factTable.aggTables = new MondrianGuiDef.AggTable[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            factTable.aggTables[i] = temp[i];
        }
        factTable.aggTables[factTable.aggTables.length - 1] = aggname;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggname));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggExclude(ActionEvent evt) {
        int i;
        MondrianGuiDef.AggExclude[] temp;
        ElementDef parent;
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Table) {
                    if (parentIndex - 1 < 0 || !(tpath.getPathComponent(parentIndex - 1) instanceof MondrianGuiDef.Cube)) continue;
                    path = tpath.getPathComponent(parentIndex);
                    break;
                }
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.AggPattern)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Table) && !(path instanceof MondrianGuiDef.AggPattern)) {
            JOptionPane.showMessageDialog(this, "Cube Fact Table or Aggregate Pattern not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.AggExclude aggexclude = new MondrianGuiDef.AggExclude();
        aggexclude.pattern = "";
        aggexclude.ignorecase = Boolean.TRUE;
        if (path instanceof MondrianGuiDef.Table) {
            parent = (MondrianGuiDef.Table)((Object)path);
            temp = parent.aggExcludes;
            parent.aggExcludes = new MondrianGuiDef.AggExclude[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                parent.aggExcludes[i] = temp[i];
            }
            parent.aggExcludes[parent.aggExcludes.length - 1] = aggexclude;
        } else {
            parent = (MondrianGuiDef.AggPattern)((Object)path);
            temp = parent.excludes;
            parent.excludes = new MondrianGuiDef.AggExclude[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                parent.excludes[i] = temp[i];
            }
            parent.excludes[parent.excludes.length - 1] = aggexclude;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i2 = 0; i2 <= parentIndex; ++i2) {
            parentPathObjs[i2] = tpath.getPathComponent(i2);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggexclude));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggIgnoreColumn(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.AggTable)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, "Aggregate Table not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggIgnoreColumn aggicol = new MondrianGuiDef.AggIgnoreColumn();
        aggicol.column = "";
        MondrianGuiDef.AggIgnoreColumn[] temp = aggTable.ignoreColumns;
        aggTable.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.ignoreColumns[i] = temp[i];
        }
        aggTable.ignoreColumns[aggTable.ignoreColumns.length - 1] = aggicol;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggicol));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggForeignKey(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.AggTable)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, "Aggregate Table not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggForeignKey aggfkey = new MondrianGuiDef.AggForeignKey();
        MondrianGuiDef.AggForeignKey[] temp = aggTable.foreignKeys;
        aggTable.foreignKeys = new MondrianGuiDef.AggForeignKey[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.foreignKeys[i] = temp[i];
        }
        aggTable.foreignKeys[aggTable.foreignKeys.length - 1] = aggfkey;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggfkey));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggMeasure(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.AggTable)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, "Aggregate Table not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggMeasure aggmeasure = new MondrianGuiDef.AggMeasure();
        MondrianGuiDef.AggMeasure[] temp = aggTable.measures;
        aggTable.measures = new MondrianGuiDef.AggMeasure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.measures[i] = temp[i];
        }
        aggTable.measures[aggTable.measures.length - 1] = aggmeasure;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggmeasure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggLevel(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.AggTable)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, "Aggregate Table not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggLevel agglevel = new MondrianGuiDef.AggLevel();
        MondrianGuiDef.AggLevel[] temp = aggTable.levels;
        aggTable.levels = new MondrianGuiDef.AggLevel[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.levels[i] = temp[i];
        }
        aggTable.levels[aggTable.levels.length - 1] = agglevel;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)agglevel));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggFactCount(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.AggTable)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggName) && !(path instanceof MondrianGuiDef.AggPattern)) {
            JOptionPane.showMessageDialog(this, "Aggregate Table or Aggregate Pattern not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.AggFactCount aggFactCount = new MondrianGuiDef.AggFactCount();
        MondrianGuiDef.AggName aggName = null;
        MondrianGuiDef.AggPattern aggPattern = null;
        if (path instanceof MondrianGuiDef.AggName) {
            aggName = (MondrianGuiDef.AggName)((Object)path);
            aggName.factcount = new MondrianGuiDef.AggFactCount();
        } else {
            aggPattern = (MondrianGuiDef.AggPattern)((Object)path);
            aggPattern.factcount = new MondrianGuiDef.AggFactCount();
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggFactCount));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCubeMeasure(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.VirtualCube)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, "Virtual Cube not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.VirtualCube cube = (MondrianGuiDef.VirtualCube)((Object)path);
        MondrianGuiDef.VirtualCubeMeasure measure = new MondrianGuiDef.VirtualCubeMeasure();
        measure.name = "";
        measure.name = this.getNewName("New Virtual Measure ", (Object[])cube.measures);
        measure.visible = Boolean.TRUE;
        MondrianGuiDef.VirtualCubeMeasure[] temp = cube.measures;
        cube.measures = new MondrianGuiDef.VirtualCubeMeasure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.measures[i] = temp[i];
        }
        cube.measures[cube.measures.length - 1] = measure;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)measure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCalculatedMember(ActionEvent evt) {
        int i;
        MondrianGuiDef.CalculatedMember[] temp;
        TreePath tpath = this.tree.getSelectionPath();
        Object path = null;
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Cube) && !(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.VirtualCube)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube) && !(path instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, "Cube or Virtual Cube not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.VirtualCube vcube = null;
        if (path instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)path);
        } else {
            vcube = (MondrianGuiDef.VirtualCube)((Object)path);
        }
        MondrianGuiDef.CalculatedMember calcmember = new MondrianGuiDef.CalculatedMember();
        calcmember.name = "";
        calcmember.dimension = "Measures";
        calcmember.visible = Boolean.TRUE;
        calcmember.formatString = "";
        calcmember.formula = "";
        calcmember.formulaElement = new MondrianGuiDef.Formula();
        calcmember.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[0];
        if (cube != null) {
            calcmember.name = this.getNewName("New Calculated Measure ", (Object[])cube.calculatedMembers);
            temp = cube.calculatedMembers;
            cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                cube.calculatedMembers[i] = temp[i];
            }
            cube.calculatedMembers[cube.calculatedMembers.length - 1] = calcmember;
        } else {
            calcmember.name = this.getNewName("New Calculated Measure ", (Object[])vcube.calculatedMembers);
            temp = vcube.calculatedMembers;
            vcube.calculatedMembers = new MondrianGuiDef.CalculatedMember[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                vcube.calculatedMembers[i] = temp[i];
            }
            vcube.calculatedMembers[vcube.calculatedMembers.length - 1] = calcmember;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)calcmember));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected boolean editMode(EventObject evt) {
        this.editModeXML = !this.isEditModeXML();
        this.editModeButton.setSelected(this.isEditModeXML());
        if (this.isEditModeXML()) {
            this.jSplitPane1.setRightComponent(this.jPanelXML);
        } else {
            this.jSplitPane1.setRightComponent(this.jPanel1);
        }
        for (Container o = this.parentIFrame.getDesktopPane().getParent(); o != null; o = o.getParent()) {
            if (o.getClass() != Workbench.class) continue;
            ((Workbench)o).getViewXMLMenuItem().setSelected(this.editModeXML);
            break;
        }
        return this.isEditModeXML();
    }

    protected void delete(EventObject evt) {
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath == null) {
            JOptionPane.showMessageDialog(this, "Select an object in Schema to delete.", alert, 2);
            return;
        }
        Object child = tpath.getLastPathComponent();
        Object nextSibling = null;
        Object prevSibling = null;
        Object parent = null;
        Object grandparent = null;
        boolean grandparentAsSibling = false;
        int i = tpath.getPathCount() - 1 - 1;
        if (i >= 0) {
            parent = tpath.getPathComponent(i);
            if (tpath.getPathCount() - 3 > 0) {
                grandparent = tpath.getPathComponent(i - 1);
            }
        }
        if (parent == null) {
            JOptionPane.showMessageDialog(this, "Schema object cannot be deleted.", alert, 2);
            return;
        }
        boolean tofind = true;
        Field[] fs = parent.getClass().getFields();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            if (fs[i2].getType().isArray() && fs[i2].getType().getComponentType().isInstance(child)) {
                try {
                    Object parentArr = fs[i2].get(parent);
                    int parentArrLen = Array.getLength(parentArr);
                    Object newArr = Array.newInstance(fs[i2].getType().getComponentType(), parentArrLen - 1);
                    tofind = true;
                    int m = 0;
                    for (int k = 0; k < parentArrLen; ++k) {
                        Object match = Array.get(parentArr, k);
                        if (tofind && match.equals(child)) {
                            if (child instanceof MondrianGuiDef.CubeDimension) {
                                MondrianGuiDef.CubeDimension matchDim = (MondrianGuiDef.CubeDimension)((Object)match);
                                MondrianGuiDef.CubeDimension childDim = (MondrianGuiDef.CubeDimension)((Object)child);
                                if ((matchDim.name == null && childDim.name == null || matchDim.name != null && matchDim.name.equals(childDim.name)) && (matchDim.caption == null && childDim.caption == null || matchDim.caption != null && matchDim.caption.equals(childDim.caption)) && (matchDim.foreignKey == null && childDim.foreignKey == null || matchDim.foreignKey != null && matchDim.foreignKey.equals(childDim.foreignKey))) {
                                    tofind = false;
                                    if (k + 1 < parentArrLen) {
                                        nextSibling = Array.get(parentArr, k + 1);
                                    }
                                    if (k - 1 < 0) continue;
                                    prevSibling = Array.get(parentArr, k - 1);
                                    continue;
                                }
                            } else {
                                tofind = false;
                                if (k + 1 < parentArrLen) {
                                    nextSibling = Array.get(parentArr, k + 1);
                                }
                                if (k - 1 < 0) continue;
                                prevSibling = Array.get(parentArr, k - 1);
                                continue;
                            }
                        }
                        Array.set(newArr, m++, match);
                    }
                    if (child instanceof MondrianGuiDef.SQL && parent instanceof MondrianGuiDef.ExpressionView && Array.getLength(newArr) < 1) {
                        if (parent instanceof MondrianGuiDef.KeyExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).keyExp = null;
                        } else if (parent instanceof MondrianGuiDef.NameExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).nameExp = null;
                        } else if (parent instanceof MondrianGuiDef.OrdinalExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).ordinalExp = null;
                        } else if (parent instanceof MondrianGuiDef.ParentExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).parentExp = null;
                        } else if (parent instanceof MondrianGuiDef.MeasureExpression) {
                            ((MondrianGuiDef.Measure)((Object)grandparent)).measureExp = null;
                        }
                        grandparentAsSibling = true;
                        break;
                    }
                    fs[i2].set(parent, newArr);
                }
                catch (Exception ex) {}
                break;
            }
            if (!fs[i2].getType().isInstance(child)) continue;
            try {
                if (parent instanceof MondrianGuiDef.Join || parent instanceof MondrianGuiDef.Cube && child instanceof MondrianGuiDef.Relation || parent instanceof MondrianGuiDef.Closure && child instanceof MondrianGuiDef.Relation || fs[i2].get(parent) != child) continue;
                fs[i2].set(parent, null);
                break;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        TreeExpansionEvent e = null;
        e = new TreeExpansionEvent(this.tree, tpath);
        this.updater.treeCollapsed(e);
        if (nextSibling != null) {
            this.tree.setSelectionPath(tpath.getParentPath().pathByAddingChild(nextSibling));
        } else if (prevSibling != null) {
            this.tree.setSelectionPath(tpath.getParentPath().pathByAddingChild(prevSibling));
        } else if (grandparentAsSibling) {
            this.tree.setSelectionPath(tpath.getParentPath().getParentPath());
        } else {
            this.tree.setSelectionPath(tpath.getParentPath());
        }
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addDimension(ActionEvent evt) {
        int i;
        MondrianGuiDef.CubeDimension[] temp;
        TreePath tpath = this.tree.getSelectionPath();
        Object path = null;
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Cube) && !(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Schema)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube) && !(path instanceof MondrianGuiDef.Schema)) {
            JOptionPane.showMessageDialog(this, "Cube or Schema not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.Schema schema = null;
        if (path instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)path);
        } else {
            schema = (MondrianGuiDef.Schema)((Object)path);
        }
        MondrianGuiDef.Dimension dimension = new MondrianGuiDef.Dimension();
        dimension.name = "";
        dimension.type = "StandardDimension";
        dimension.hierarchies = new MondrianGuiDef.Hierarchy[1];
        dimension.hierarchies[0] = new MondrianGuiDef.Hierarchy();
        dimension.hierarchies[0].name = "New Hierarchy 0";
        dimension.hierarchies[0].hasAll = true;
        dimension.hierarchies[0].levels = new MondrianGuiDef.Level[0];
        dimension.hierarchies[0].memberReaderParameters = new MondrianGuiDef.MemberReaderParameter[0];
        dimension.hierarchies[0].relation = new MondrianGuiDef.Table("", LBL_TABLE, "");
        if (cube != null) {
            dimension.name = this.getNewName("New Dimension ", (Object[])cube.dimensions);
            temp = cube.dimensions;
            cube.dimensions = new MondrianGuiDef.CubeDimension[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                cube.dimensions[i] = temp[i];
            }
            cube.dimensions[cube.dimensions.length - 1] = dimension;
        } else {
            dimension.name = this.getNewName("New Dimension ", (Object[])schema.dimensions);
            temp = schema.dimensions;
            schema.dimensions = new MondrianGuiDef.Dimension[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                schema.dimensions[i] = (MondrianGuiDef.Dimension)temp[i];
            }
            schema.dimensions[schema.dimensions.length - 1] = dimension;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCubeDimension(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        Object path = null;
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.VirtualCube)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, "Virtual Cube not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.VirtualCube cube = (MondrianGuiDef.VirtualCube)((Object)path);
        MondrianGuiDef.VirtualCubeDimension dimension = new MondrianGuiDef.VirtualCubeDimension();
        dimension.name = "";
        dimension.name = this.getNewName("New Virtual Dimension ", (Object[])cube.dimensions);
        MondrianGuiDef.VirtualCubeDimension[] temp = cube.dimensions;
        cube.dimensions = new MondrianGuiDef.VirtualCubeDimension[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.dimensions[i] = temp[i];
        }
        cube.dimensions[cube.dimensions.length - 1] = dimension;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    private String getNewName(String preName, Object[] objs) {
        boolean exists = true;
        String newName = "";
        String objName = "";
        if (objs != null) {
            int objNo = objs.length;
            try {
                Field f = objs.getClass().getComponentType().getField("name");
                block2: while (exists) {
                    newName = preName + objNo++;
                    exists = false;
                    for (int i = 0; i < objs.length; ++i) {
                        objName = (String)f.get(objs[i]);
                        if (!newName.equals(objName)) continue;
                        exists = true;
                        continue block2;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            newName = preName + 0;
        }
        return newName;
    }

    protected void addNamedSet(ActionEvent evt) {
        int i;
        MondrianGuiDef.NamedSet[] temp;
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Cube) && !(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Schema)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube) && !(path instanceof MondrianGuiDef.Schema)) {
            JOptionPane.showMessageDialog(this, "Cube or Schema not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.Schema schema = null;
        if (path instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)path);
        } else {
            schema = (MondrianGuiDef.Schema)((Object)path);
        }
        MondrianGuiDef.NamedSet namedset = new MondrianGuiDef.NamedSet();
        namedset.name = "";
        namedset.formula = "";
        namedset.formulaElement = new MondrianGuiDef.Formula();
        if (cube != null) {
            namedset.name = this.getNewName("New Named Set ", (Object[])cube.namedSets);
            temp = cube.namedSets;
            cube.namedSets = new MondrianGuiDef.NamedSet[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                cube.namedSets[i] = temp[i];
            }
            cube.namedSets[cube.namedSets.length - 1] = namedset;
        } else {
            namedset.name = this.getNewName("New Named Set ", (Object[])schema.namedSets);
            temp = schema.namedSets;
            schema.namedSets = new MondrianGuiDef.NamedSet[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                schema.namedSets[i] = temp[i];
            }
            schema.namedSets[schema.namedSets.length - 1] = namedset;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)namedset));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addDimensionUsage(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Cube)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube)) {
            JOptionPane.showMessageDialog(this, "Cube not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)path);
        MondrianGuiDef.DimensionUsage dimension = new MondrianGuiDef.DimensionUsage();
        dimension.name = "";
        dimension.name = this.getNewName("New Dimension Usage ", (Object[])cube.dimensions);
        MondrianGuiDef.CubeDimension[] temp = cube.dimensions;
        cube.dimensions = new MondrianGuiDef.CubeDimension[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.dimensions[i] = temp[i];
        }
        cube.dimensions[cube.dimensions.length - 1] = dimension;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addSchemaGrant(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Role)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Role)) {
            JOptionPane.showMessageDialog(this, "Role not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Role role = (MondrianGuiDef.Role)((Object)path);
        MondrianGuiDef.SchemaGrant schemaGrant = new MondrianGuiDef.SchemaGrant();
        schemaGrant.access = "";
        schemaGrant.cubeGrants = new MondrianGuiDef.CubeGrant[0];
        MondrianGuiDef.SchemaGrant[] temp = role.schemaGrants;
        role.schemaGrants = new MondrianGuiDef.SchemaGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            role.schemaGrants[i] = temp[i];
        }
        role.schemaGrants[role.schemaGrants.length - 1] = schemaGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)schemaGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCubeGrant(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.SchemaGrant)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.SchemaGrant)) {
            JOptionPane.showMessageDialog(this, "Schema Grant not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.SchemaGrant schemaGrant = (MondrianGuiDef.SchemaGrant)((Object)path);
        MondrianGuiDef.CubeGrant cubeGrant = new MondrianGuiDef.CubeGrant();
        cubeGrant.access = "";
        cubeGrant.dimensionGrants = new MondrianGuiDef.DimensionGrant[0];
        cubeGrant.hierarchyGrants = new MondrianGuiDef.HierarchyGrant[0];
        MondrianGuiDef.CubeGrant[] temp = schemaGrant.cubeGrants;
        schemaGrant.cubeGrants = new MondrianGuiDef.CubeGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            schemaGrant.cubeGrants[i] = temp[i];
        }
        schemaGrant.cubeGrants[schemaGrant.cubeGrants.length - 1] = cubeGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)cubeGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addDimensionGrant(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.CubeGrant)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.CubeGrant)) {
            JOptionPane.showMessageDialog(this, "Cube Grant not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.CubeGrant cubeGrant = (MondrianGuiDef.CubeGrant)((Object)path);
        MondrianGuiDef.DimensionGrant dimeGrant = new MondrianGuiDef.DimensionGrant();
        dimeGrant.access = "";
        MondrianGuiDef.DimensionGrant[] temp = cubeGrant.dimensionGrants;
        cubeGrant.dimensionGrants = new MondrianGuiDef.DimensionGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cubeGrant.dimensionGrants[i] = temp[i];
        }
        cubeGrant.dimensionGrants[cubeGrant.dimensionGrants.length - 1] = dimeGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)dimeGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addHierarchyGrant(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.CubeGrant)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.CubeGrant)) {
            JOptionPane.showMessageDialog(this, "Cube Grant not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.CubeGrant cubeGrant = (MondrianGuiDef.CubeGrant)((Object)path);
        MondrianGuiDef.HierarchyGrant hieGrant = new MondrianGuiDef.HierarchyGrant();
        hieGrant.access = "";
        hieGrant.memberGrants = new MondrianGuiDef.MemberGrant[0];
        MondrianGuiDef.HierarchyGrant[] temp = cubeGrant.hierarchyGrants;
        cubeGrant.hierarchyGrants = new MondrianGuiDef.HierarchyGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cubeGrant.hierarchyGrants[i] = temp[i];
        }
        cubeGrant.hierarchyGrants[cubeGrant.hierarchyGrants.length - 1] = hieGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)hieGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addMemberGrant(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.HierarchyGrant)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.HierarchyGrant)) {
            JOptionPane.showMessageDialog(this, "Hierarchy Grant not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.HierarchyGrant hieGrant = (MondrianGuiDef.HierarchyGrant)((Object)path);
        MondrianGuiDef.MemberGrant memberGrant = new MondrianGuiDef.MemberGrant();
        memberGrant.access = "";
        MondrianGuiDef.MemberGrant[] temp = hieGrant.memberGrants;
        hieGrant.memberGrants = new MondrianGuiDef.MemberGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            hieGrant.memberGrants[i] = temp[i];
        }
        hieGrant.memberGrants[hieGrant.memberGrants.length - 1] = memberGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)memberGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addLevel(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Hierarchy)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Hierarchy)) {
            JOptionPane.showMessageDialog(this, "Hierarchy not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Hierarchy hierarchy = (MondrianGuiDef.Hierarchy)((Object)path);
        MondrianGuiDef.Level level = new MondrianGuiDef.Level();
        level.uniqueMembers = false;
        level.name = "";
        level.properties = new MondrianGuiDef.Property[0];
        level.name = this.getNewName("New Level ", (Object[])hierarchy.levels);
        MondrianGuiDef.Level[] temp = hierarchy.levels;
        hierarchy.levels = new MondrianGuiDef.Level[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            hierarchy.levels[i] = temp[i];
        }
        hierarchy.levels[hierarchy.levels.length - 1] = level;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)level));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addSQL(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.ExpressionView)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.ExpressionView)) {
            JOptionPane.showMessageDialog(this, "Expression not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.ExpressionView expview = (MondrianGuiDef.ExpressionView)((Object)path);
        MondrianGuiDef.SQL sql = new MondrianGuiDef.SQL();
        sql.dialect = "generic";
        MondrianGuiDef.SQL[] temp = expview.expressions;
        expview.expressions = new MondrianGuiDef.SQL[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            expview.expressions[i] = temp[i];
        }
        expview.expressions[expview.expressions.length - 1] = sql;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)sql));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addKeyExp(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Level)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, "Level not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)path);
        MondrianGuiDef.KeyExpression keyExp = new MondrianGuiDef.KeyExpression();
        keyExp.expressions = new MondrianGuiDef.SQL[1];
        keyExp.expressions[0] = new MondrianGuiDef.SQL();
        keyExp.expressions[0].dialect = "generic";
        keyExp.expressions[0].cdata = "";
        level.keyExp = keyExp;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)keyExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addNameExp(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Level)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, "Level not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)path);
        MondrianGuiDef.NameExpression nameExp = new MondrianGuiDef.NameExpression();
        nameExp.expressions = new MondrianGuiDef.SQL[1];
        nameExp.expressions[0] = new MondrianGuiDef.SQL();
        nameExp.expressions[0].dialect = "generic";
        nameExp.expressions[0].cdata = "";
        level.nameExp = nameExp;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)nameExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addOrdinalExp(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Level)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, "Level not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)path);
        MondrianGuiDef.OrdinalExpression ordinalExp = new MondrianGuiDef.OrdinalExpression();
        ordinalExp.expressions = new MondrianGuiDef.SQL[1];
        ordinalExp.expressions[0] = new MondrianGuiDef.SQL();
        ordinalExp.expressions[0].dialect = "generic";
        ordinalExp.expressions[0].cdata = "";
        level.ordinalExp = ordinalExp;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)ordinalExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addParentExp(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Level)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, "Level not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)path);
        MondrianGuiDef.ParentExpression parentExp = new MondrianGuiDef.ParentExpression();
        parentExp.expressions = new MondrianGuiDef.SQL[1];
        parentExp.expressions[0] = new MondrianGuiDef.SQL();
        parentExp.expressions[0].dialect = "generic";
        parentExp.expressions[0].cdata = "";
        level.parentExp = parentExp;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)parentExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addMeasureExp(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Measure)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Measure)) {
            JOptionPane.showMessageDialog(this, "Measure not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Measure measure = (MondrianGuiDef.Measure)((Object)path);
        MondrianGuiDef.MeasureExpression measureExp = new MondrianGuiDef.MeasureExpression();
        measureExp.expressions = new MondrianGuiDef.SQL[1];
        measureExp.expressions[0] = new MondrianGuiDef.SQL();
        measureExp.expressions[0].dialect = "generic";
        measureExp.expressions[0].cdata = "";
        measure.measureExp = measureExp;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)measureExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addRelation(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Hierarchy)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Hierarchy)) {
            JOptionPane.showMessageDialog(this, "Hierarchy not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Hierarchy hierarchy = (MondrianGuiDef.Hierarchy)((Object)path);
        MondrianGuiDef.Table relation = new MondrianGuiDef.Table("", LBL_TABLE, "");
        hierarchy.relation = relation;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)relation));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addHierarchy(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Dimension)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Dimension)) {
            JOptionPane.showMessageDialog(this, "Dimension not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Dimension dimension = (MondrianGuiDef.Dimension)((Object)path);
        MondrianGuiDef.Hierarchy hierarchy = new MondrianGuiDef.Hierarchy();
        hierarchy.name = "";
        hierarchy.hasAll = Boolean.TRUE;
        hierarchy.levels = new MondrianGuiDef.Level[0];
        hierarchy.memberReaderParameters = new MondrianGuiDef.MemberReaderParameter[0];
        hierarchy.relation = new MondrianGuiDef.Table("", LBL_TABLE, "");
        hierarchy.name = this.getNewName("New Hierarchy ", (Object[])dimension.hierarchies);
        MondrianGuiDef.Hierarchy[] temp = dimension.hierarchies;
        dimension.hierarchies = new MondrianGuiDef.Hierarchy[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            dimension.hierarchies[i] = temp[i];
        }
        dimension.hierarchies[dimension.hierarchies.length - 1] = hierarchy;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)hierarchy));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addProperty(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Level)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, "Level not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)path);
        MondrianGuiDef.Property property = new MondrianGuiDef.Property();
        property.name = "";
        if (level.properties == null) {
            level.properties = new MondrianGuiDef.Property[0];
        }
        property.name = this.getNewName("New Property ", (Object[])level.properties);
        MondrianGuiDef.Property[] temp = level.properties;
        level.properties = new MondrianGuiDef.Property[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            level.properties[i] = temp[i];
        }
        level.properties[level.properties.length - 1] = property;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)property));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addClosure(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        int parentIndex = -1;
        Object path = null;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                if (!(tpath.getPathComponent(parentIndex) instanceof MondrianGuiDef.Level)) continue;
                path = tpath.getPathComponent(parentIndex);
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, "Level not selected.", alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)path);
        MondrianGuiDef.Closure closure = new MondrianGuiDef.Closure();
        closure.parentColumn = "";
        closure.childColumn = "";
        closure.table = new MondrianGuiDef.Table("", LBL_TABLE, "");
        if (level.closure == null) {
            level.closure = closure;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)closure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    public MondrianGuiDef.Schema getSchema() {
        return this.schema;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File f) {
        this.schemaFile = f;
    }

    public void valueChanged(TreeSelectionEvent e) {
        SchemaPropertyCellEditor sce;
        if (this.propertyTable.isEditing() && this.lastSelected != e.getPath().getLastPathComponent() && (sce = (SchemaPropertyCellEditor)this.propertyTable.getCellEditor()) != null) {
            TreeSelectionEvent e2 = e;
            sce.stopCellEditing();
            e = e2;
        }
        this.lastSelected = e.getPath().getLastPathComponent();
        String selectedFactTable = null;
        String selectedFactTableSchema = null;
        for (int i = e.getPath().getPathCount() - 1; i >= 0; --i) {
            Object comp = e.getPath().getPathComponent(i);
            if (!(comp instanceof MondrianGuiDef.Cube) || ((MondrianGuiDef.Cube)((Object)comp)).fact == null) continue;
            selectedFactTable = ((MondrianGuiDef.Table)((MondrianGuiDef.Cube)((Object)comp)).fact).name;
            selectedFactTableSchema = ((MondrianGuiDef.Table)((MondrianGuiDef.Cube)((Object)comp)).fact).schema;
        }
        TreePath tpath = e.getPath();
        Object o = tpath.getLastPathComponent();
        Object po = null;
        TreePath parentTpath = tpath.getParentPath();
        String parentName = "";
        String elementName = "";
        if (parentTpath != null) {
            po = parentTpath.getLastPathComponent();
            Class<?> parentClassName = po.getClass();
            try {
                Field nameField = po.getClass().getField("name");
                elementName = (String)nameField.get(po);
                elementName = elementName == null ? "" : "'" + elementName + "'";
            }
            catch (Exception ex) {
                elementName = "";
            }
            int pos = parentClassName.toString().lastIndexOf("$");
            if (pos > 0) {
                parentName = parentClassName.toString().substring(pos + 1);
            }
        }
        StringWriter sxml = new StringWriter();
        XMLOutput pxml = new XMLOutput((Writer)sxml);
        pxml.setIndentString("        ");
        String[] pNames = DEF_DEFAULT;
        this.validStatusLabel.setText(this.renderer.invalid(this.tree, e.getPath(), o));
        this.validStatusLabel2.setText(this.validStatusLabel.getText());
        if (o instanceof MondrianGuiDef.Column) {
            pNames = DEF_COLUMN;
            this.targetLabel.setText(LBL_COLUMN);
        } else if (o instanceof MondrianGuiDef.Cube) {
            pNames = DEF_CUBE;
            this.targetLabel.setText(LBL_CUBE);
            ((MondrianGuiDef.Cube)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Dimension) {
            pNames = DEF_DIMENSION;
            if (po instanceof MondrianGuiDef.Schema) {
                this.targetLabel.setText("Shared Dimension");
            } else {
                this.targetLabel.setText("Dimension for " + elementName + " " + parentName);
            }
            ((MondrianGuiDef.Dimension)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.DimensionUsage) {
            pNames = DEF_DIMENSION_USAGE;
            this.targetLabel.setText("Dimension Usage for " + elementName + " " + parentName);
            ((MondrianGuiDef.DimensionUsage)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.KeyExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(LBL_KEY_EXPRESSION);
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.NameExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(LBL_NAME_EXPRESSION);
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.OrdinalExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(LBL_ORDINAL_EXPRESSION);
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.ParentExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(LBL_PARENT_EXPRESSION);
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.ExpressionView) {
            pNames = DEF_EXPRESSION_VIEW;
            this.targetLabel.setText(LBL_EXPRESSION_VIEW);
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MeasureExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(LBL_MEASURE_EXPRESSION);
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Hierarchy) {
            pNames = DEF_HIERARCHY;
            this.targetLabel.setText("Hierarchy for " + elementName + " " + parentName);
            ((MondrianGuiDef.Hierarchy)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Join) {
            pNames = DEF_JOIN;
            if (parentName.equalsIgnoreCase(LBL_JOIN)) {
                Object parentJoin = parentTpath.getLastPathComponent();
                int indexOfChild = this.tree.getModel().getIndexOfChild(parentJoin, o);
                switch (indexOfChild) {
                    case 0: {
                        this.targetLabel.setText("Left : Join");
                        break;
                    }
                    case 1: {
                        this.targetLabel.setText("Right : Join");
                    }
                }
            } else {
                this.targetLabel.setText("Join for " + elementName + " " + parentName);
            }
            ((MondrianGuiDef.Join)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Level) {
            pNames = DEF_LEVEL;
            this.targetLabel.setText("Level for " + elementName + " " + parentName);
            ((MondrianGuiDef.Level)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Measure) {
            pNames = DEF_MEASURE;
            this.targetLabel.setText("Measure for " + elementName + " " + parentName);
            ((MondrianGuiDef.Measure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CalculatedMember) {
            pNames = DEF_CALCULATED_MEMBER;
            this.targetLabel.setText("Calculated Member for " + elementName + " " + parentName);
            ((MondrianGuiDef.CalculatedMember)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CalculatedMemberProperty) {
            pNames = DEF_CALCULATED_MEMBER_PROPERTY;
            this.targetLabel.setText(LBL_CALCULATED_MEMBER_PROPERTY);
        } else if (o instanceof MondrianGuiDef.NamedSet) {
            pNames = DEF_NAMED_SET;
            this.targetLabel.setText("Named Set for " + elementName + " " + parentName);
            ((MondrianGuiDef.NamedSet)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.UserDefinedFunction) {
            pNames = DEF_USER_DEFINED_FUNCTION;
            this.targetLabel.setText("User Defined Function for " + elementName + " " + parentName);
            ((MondrianGuiDef.UserDefinedFunction)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MemberReaderParameter) {
            pNames = DEF_PARAMETER;
            this.targetLabel.setText(LBL_PARAMETER);
        } else if (o instanceof MondrianGuiDef.Property) {
            pNames = DEF_PROPERTY;
            this.targetLabel.setText(LBL_PROPERTY);
            ((MondrianGuiDef.Property)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Closure) {
            pNames = DEF_CLOSURE;
            this.targetLabel.setText(LBL_CLOSURE);
            ((MondrianGuiDef.Closure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Schema) {
            pNames = DEF_SCHEMA;
            this.targetLabel.setText(LBL_SCHEMA);
            ((MondrianGuiDef.Schema)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.SQL) {
            pNames = DEF_SQL;
            this.targetLabel.setText(LBL_SQL);
            ((MondrianGuiDef.SQL)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Table) {
            pNames = DEF_TABLE;
            this.targetLabel.setText("Table for " + elementName + " " + parentName);
            ((MondrianGuiDef.Table)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggName) {
            pNames = DEF_AGG_NAME;
            this.targetLabel.setText(LBL_AGG_NAME);
            ((MondrianGuiDef.AggName)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggIgnoreColumn) {
            pNames = DEF_AGG_IGNORE_COLUMN;
            this.targetLabel.setText(LBL_AGG_IGNORE_COLUMN);
            ((MondrianGuiDef.AggIgnoreColumn)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggForeignKey) {
            pNames = DEF_AGG_FOREIGN_KEY;
            this.targetLabel.setText(LBL_AGG_FOREIGN_KEY);
            ((MondrianGuiDef.AggForeignKey)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggMeasure) {
            pNames = DEF_AGG_MEASURE;
            this.targetLabel.setText(LBL_AGG_MEASURE);
            ((MondrianGuiDef.AggMeasure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggLevel) {
            pNames = DEF_AGG_LEVEL;
            this.targetLabel.setText(LBL_AGG_LEVEL);
            ((MondrianGuiDef.AggLevel)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggExclude) {
            pNames = DEF_AGG_EXCLUDE;
            this.targetLabel.setText(LBL_AGG_EXCLUDE);
            ((MondrianGuiDef.AggExclude)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggPattern) {
            pNames = DEF_AGG_PATTERN;
            this.targetLabel.setText(LBL_AGG_PATTERN);
            ((MondrianGuiDef.AggPattern)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggFactCount) {
            pNames = DEF_AGG_FACT_COUNT;
            this.targetLabel.setText(LBL_AGG_FACT_COUNT);
            ((MondrianGuiDef.AggFactCount)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.View) {
            pNames = DEF_VIEW;
            this.targetLabel.setText(LBL_VIEW);
        } else if (o instanceof MondrianGuiDef.Role) {
            pNames = DEF_ROLE;
            this.targetLabel.setText("Role for " + elementName + " " + parentName);
            ((MondrianGuiDef.Role)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.SchemaGrant) {
            pNames = DEF_SCHEMA_GRANT;
            this.targetLabel.setText(LBL_SCHEMA_GRANT);
            ((MondrianGuiDef.SchemaGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CubeGrant) {
            pNames = DEF_CUBE_GRANT;
            this.targetLabel.setText(LBL_CUBE_GRANT);
            ((MondrianGuiDef.CubeGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.DimensionGrant) {
            pNames = DEF_DIMENSION_GRANT;
            this.targetLabel.setText(LBL_DIMENSION_GRANT);
            ((MondrianGuiDef.DimensionGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.HierarchyGrant) {
            pNames = DEF_HIERARCHY_GRANT;
            this.targetLabel.setText(LBL_HIERARCHY_GRANT);
            ((MondrianGuiDef.HierarchyGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MemberGrant) {
            pNames = DEF_MEMBER_GRANT;
            this.targetLabel.setText(LBL_MEMBER_GRANT);
            ((MondrianGuiDef.MemberGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCube) {
            pNames = DEF_VIRTUAL_CUBE;
            this.targetLabel.setText("Virtual Cube for " + elementName + " " + parentName);
            ((MondrianGuiDef.VirtualCube)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCubeDimension) {
            pNames = DEF_VIRTUAL_CUBE_DIMENSION;
            this.targetLabel.setText("Virtual Cube Dimension for " + elementName + " " + parentName);
            ((MondrianGuiDef.VirtualCubeDimension)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCubeMeasure) {
            pNames = DEF_VIRTUAL_CUBE_MEASURE;
            this.targetLabel.setText(LBL_VIRTUAL_CUBE_MEASURE);
            ((MondrianGuiDef.VirtualCubeMeasure)((Object)o)).displayXML(pxml, 0);
        } else {
            this.targetLabel.setText(LBL_UNKNOWN_TYPE);
        }
        try {
            this.jEditorPaneXML.read(new StringReader(sxml.toString()), null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.targetLabel2.setText(this.targetLabel.getText());
        PropertyTableModel ptm = new PropertyTableModel(o, pNames);
        ptm.setFactTable(selectedFactTable);
        ptm.setFactTableSchema(selectedFactTableSchema);
        Object parent = null;
        int i = e.getPath().getPathCount() - 1 - 1;
        if (i >= 0) {
            parent = e.getPath().getPathComponent(i);
        }
        if (parent != null) {
            Field[] fs = parent.getClass().getFields();
            ArrayList<Object> names = new ArrayList<Object>();
            for (int i2 = 0; i2 < fs.length; ++i2) {
                if (!fs[i2].getType().isArray() || !fs[i2].getType().getComponentType().isInstance(o)) continue;
                try {
                    Field fname = fs[i2].getType().getComponentType().getField("name");
                    Object objs = fs[i2].get(parent);
                    for (int j = 0; j < Array.getLength(objs); ++j) {
                        Object child = Array.get(objs, j);
                        Object vname = fname.get(child);
                        names.add(vname);
                    }
                    ptm.setNames(names);
                }
                catch (Exception ex) {}
                break;
            }
        }
        this.propertyTable.setModel(ptm);
        this.propertyTable.getColumnModel().getColumn(0).setMaxWidth(150);
        this.propertyTable.getColumnModel().getColumn(0).setMinWidth(150);
        for (i = 0; i < this.propertyTable.getRowCount(); ++i) {
            TableCellRenderer renderer = this.propertyTable.getCellRenderer(i, 1);
            Component comp = renderer.getTableCellRendererComponent(this.propertyTable, this.propertyTable.getValueAt(i, 1), false, false, i, 1);
            try {
                int height = comp.getMaximumSize().height;
                this.propertyTable.setRowHeight(i, height);
                continue;
            }
            catch (Exception ea) {
                // empty catch block
            }
        }
    }

    public void editingCanceled(ChangeEvent e) {
        this.updater.update();
    }

    public void editingStopped(ChangeEvent e) {
        String emsg;
        this.setDirty(true);
        if (!this.dirtyFlag || ((PropertyTableModel)this.propertyTable.getModel()).target instanceof MondrianGuiDef.Schema) {
            this.setDirtyFlag(true);
            this.setTitle();
        }
        if ((emsg = ((PropertyTableModel)this.propertyTable.getModel()).getErrorMsg()) != null) {
            JOptionPane.showMessageDialog(this, emsg, "Error", 0);
            ((PropertyTableModel)this.propertyTable.getModel()).setErrorMsg(null);
        }
        this.updater.update();
    }

    public boolean isNewFile() {
        return this.newFile;
    }

    public void setNewFile(boolean newFile) {
        this.newFile = newFile;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setTitle() {
        this.parentIFrame.setTitle("Schema -  " + this.schema.name + "  " + "(" + this.schemaFile.getName() + ")" + (this.isDirty() ? "*" : ""));
        this.parentIFrame.setToolTipText(this.schemaFile.toString());
    }

    public void setDirtyFlag(boolean dirtyFlag) {
        this.dirtyFlag = dirtyFlag;
    }

    public Object getParentObject() {
        TreePath tPath = this.tree.getSelectionPath();
        if (tPath != null && tPath.getParentPath() != null) {
            return tPath.getParentPath().getLastPathComponent();
        }
        return null;
    }

    public String getJdbcConnectionUrl() {
        return this.jdbcMetaData.jdbcConnectionUrl;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public boolean isEditModeXML() {
        return this.editModeXML;
    }

    class PopupTrigger
    extends MouseAdapter {
        PopupTrigger() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void mouseReleased(MouseEvent e) {
            if (!e.isPopupTrigger()) return;
            int x = e.getX();
            int y = e.getY();
            TreePath path = SchemaExplorer.this.tree.getPathForLocation(x, y);
            if (path == null) return;
            SchemaExplorer.this.jPopupMenu.removeAll();
            Object pathSelected = path.getLastPathComponent();
            if (pathSelected instanceof MondrianGuiDef.Schema) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCube);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimension);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNamedSet);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addUserDefinedFunction);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCube);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addRole);
            } else if (pathSelected instanceof MondrianGuiDef.Cube) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimension);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimensionUsage);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMeasure);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMember);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNamedSet);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Dimension) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addHierarchy);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Hierarchy) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addLevel);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addRelation);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                if (((MondrianGuiDef.Hierarchy)((Object)pathSelected)).relation == null) {
                    SchemaExplorer.this.addRelation.setEnabled(true);
                } else {
                    SchemaExplorer.this.addRelation.setEnabled(false);
                }
            } else if (pathSelected instanceof MondrianGuiDef.Level) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addProperty);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addKeyExp);
                if (((MondrianGuiDef.Level)((Object)pathSelected)).keyExp == null) {
                    SchemaExplorer.this.addKeyExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addKeyExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNameExp);
                if (((MondrianGuiDef.Level)((Object)pathSelected)).nameExp == null) {
                    SchemaExplorer.this.addNameExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addNameExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addOrdinalExp);
                if (((MondrianGuiDef.Level)((Object)pathSelected)).ordinalExp == null) {
                    SchemaExplorer.this.addOrdinalExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addOrdinalExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addParentExp);
                if (((MondrianGuiDef.Level)((Object)pathSelected)).parentExp == null) {
                    SchemaExplorer.this.addParentExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addParentExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addClosure);
                if (((MondrianGuiDef.Level)((Object)pathSelected)).closure == null) {
                    SchemaExplorer.this.addClosure.setEnabled(true);
                } else {
                    SchemaExplorer.this.addClosure.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.KeyExpression || pathSelected instanceof MondrianGuiDef.NameExpression || pathSelected instanceof MondrianGuiDef.OrdinalExpression || pathSelected instanceof MondrianGuiDef.ParentExpression) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addSQL);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Relation) {
                Object po = path.getParentPath().getLastPathComponent();
                if (po instanceof MondrianGuiDef.Relation || po instanceof MondrianGuiDef.Closure) return;
                if (po instanceof MondrianGuiDef.Cube) {
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggName);
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggPattern);
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggExclude);
                } else {
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                }
            } else if (pathSelected instanceof MondrianGuiDef.Measure) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMeasureExp);
                if (((MondrianGuiDef.Measure)((Object)pathSelected)).measureExp == null) {
                    SchemaExplorer.this.addMeasureExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addMeasureExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Closure) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.AggName || pathSelected instanceof MondrianGuiDef.AggPattern) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggFactCount);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggIgnoreColumn);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggForeignKey);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggMeasure);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggLevel);
                if (pathSelected instanceof MondrianGuiDef.AggPattern) {
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggExclude);
                    if (((MondrianGuiDef.AggPattern)((Object)pathSelected)).factcount == null) {
                        SchemaExplorer.this.addAggFactCount.setEnabled(true);
                    } else {
                        SchemaExplorer.this.addAggFactCount.setEnabled(false);
                    }
                } else if (((MondrianGuiDef.AggName)((Object)pathSelected)).factcount == null) {
                    SchemaExplorer.this.addAggFactCount.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAggFactCount.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.VirtualCube) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCubeDimension);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCubeMeasure);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMember);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Role) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addSchemaGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.SchemaGrant) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCubeGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.CubeGrant) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimensionGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addHierarchyGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.HierarchyGrant) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMemberGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            }
            SchemaExplorer.this.jPopupMenu.show(SchemaExplorer.this.tree, x, y);
        }
    }
}

