/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import mondrian.calc.Calc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;

public class MemberValueCalc
extends GenericCalc {
    private final MemberCalc[] memberCalcs;
    private final Member[] savedMembers;

    public MemberValueCalc(Exp exp, MemberCalc[] memberCalcs) {
        super(exp);
        Type type = exp.getType();
        assert (type instanceof ScalarType) : exp;
        this.memberCalcs = memberCalcs;
        this.savedMembers = new Member[memberCalcs.length];
    }

    public Object evaluate(Evaluator evaluator) {
        for (int i = 0; i < this.memberCalcs.length; ++i) {
            MemberCalc memberCalc = this.memberCalcs[i];
            Member member = memberCalc.evaluateMember(evaluator);
            if (member == null || member.isNull()) {
                for (int j = 0; j < i; ++j) {
                    evaluator.setContext(this.savedMembers[j]);
                }
                return null;
            }
            this.savedMembers[i] = evaluator.setContext(member);
        }
        Object o = evaluator.evaluateCurrent();
        evaluator.setContext(this.savedMembers);
        return o;
    }

    public Calc[] getCalcs() {
        return this.memberCalcs;
    }

    public boolean dependsOn(Dimension dimension) {
        if (super.dependsOn(dimension)) {
            return true;
        }
        for (MemberCalc memberCalc : this.memberCalcs) {
            if (!memberCalc.getType().usesDimension(dimension, true)) continue;
            return false;
        }
        return true;
    }
}

