/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.windows.WindowManager;

public class ToolbarLayout
implements LayoutManager2,
Serializable {
    public static final int HGAP = 1;
    public static final int VGAP = 1;
    static final long serialVersionUID = 7489472539255790677L;
    ToolbarConfiguration toolbarConfig;
    HashMap<Component, Object> componentMap;

    public ToolbarLayout(ToolbarConfiguration toolbarConfiguration) {
        this.toolbarConfig = toolbarConfiguration;
        this.componentMap = new HashMap();
    }

    public void addLayoutComponent(String string, Component component) {
        throw new IllegalArgumentException();
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof ToolbarConstraints)) {
            throw new IllegalArgumentException(ToolbarConfiguration.getBundleString("EXC_wrongConstraints"));
        }
        this.componentMap.put(component, object);
        ToolbarConstraints toolbarConstraints = (ToolbarConstraints)object;
        toolbarConstraints.setPreferredSize(component.getPreferredSize());
        component.setVisible(toolbarConstraints.isVisible());
    }

    public void removeLayoutComponent(Component component) {
        this.componentMap.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(insets.left + this.toolbarConfig.getPrefWidth() + insets.right, insets.top + this.toolbarConfig.getPrefHeight() + insets.bottom);
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = WindowManager.getDefault().getMainWindow().getInsets();
            Frame frame = WindowManager.getDefault().getMainWindow();
            int n = (frame.getExtendedState() & 6) == 6 ? frame.getWidth() - 1 : frame.getWidth() - (insets.left + insets.right) - 1;
            Iterator<Component> iterator = this.componentMap.keySet().iterator();
            while (iterator.hasNext()) {
                Component component = iterator.next();
                ToolbarConstraints toolbarConstraints = (ToolbarConstraints)this.componentMap.get(component);
                toolbarConstraints.updatePreferredSize(component.getPreferredSize());
            }
            HashSet<ToolbarConstraints> hashSet = new HashSet<ToolbarConstraints>(this.componentMap.size() * 2);
            for (int i = 0; i < this.toolbarConfig.getRowCount(); ++i) {
                ToolbarConstraints toolbarConstraints = this.processRow(this.toolbarConfig.getRow(i), hashSet, n);
                Iterator<ToolbarConstraints> iterator2 = this.toolbarConfig.getRow(i).iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator2.next());
                }
            }
            container.repaint();
        }
    }

    private ToolbarConstraints processRow(ToolbarRow toolbarRow, Collection collection, int n) {
        ArrayList<ToolbarConstraints> arrayList = new ArrayList<ToolbarConstraints>(5);
        Iterator<ToolbarConstraints> iterator = toolbarRow.iterator();
        while (iterator.hasNext()) {
            ToolbarConstraints toolbarConstraints = iterator.next();
            if (collection.contains(toolbarConstraints)) continue;
            Toolbar toolbar = ToolbarPool.getDefault().findToolbar(toolbarConstraints.getName());
            Rectangle rectangle = toolbarConstraints.getBounds();
            if (rectangle.x < n && rectangle.x + rectangle.width > n) {
                rectangle.width = n - rectangle.x;
                toolbar.setBounds(rectangle);
                continue;
            }
            if (n == 0 || n == 1) {
                rectangle.width = n;
                toolbar.setBounds(rectangle);
                continue;
            }
            if (toolbarConstraints.getPosition() > n + 1) {
                if (toolbarConstraints.isAlone() || toolbarRow.toolbarCount() - arrayList.size() <= 1) continue;
                arrayList.add(toolbarConstraints);
                continue;
            }
            toolbar.setBounds(rectangle);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.moveToolbarDown(iterator.next());
        }
        return null;
    }

    private void moveToolbarDown(ToolbarConstraints toolbarConstraints) {
        int n = toolbarConstraints.rowIndex() + 1;
        toolbarConstraints.destroy();
        for (int i = n; i < n + toolbarConstraints.getRowCount(); ++i) {
            this.toolbarConfig.getRow(i).addToolbar(toolbarConstraints, 0);
        }
        toolbarConstraints.setPosition(0);
        toolbarConstraints.updatePosition();
    }
}

