/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ui.MultiSplitCell;
import org.netbeans.core.windows.view.ui.MultiSplitDivider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSplitPane
extends JPanel
implements MouseMotionListener,
MouseListener {
    private MultiSplitDivider draggingDivider;
    private ArrayList<MultiSplitDivider> dividers = new ArrayList();
    private boolean dirty = true;
    private ArrayList<MultiSplitCell> cells = new ArrayList();
    private int orientation;
    private int dividerSize;
    private boolean userMovedSplit = false;

    public MultiSplitPane() {
        this.setLayout(new MultiSplitLayout());
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.dividerSize = UIManager.getInt("SplitPane.dividerSize");
        if (0 == this.dividerSize) {
            this.dividerSize = 7;
        }
    }

    public void setChildren(int n, ViewElement[] viewElementArray, double[] dArray) {
        assert (viewElementArray.length == dArray.length);
        this.orientation = n;
        List<Component> list = this.collectComponents();
        this.cells.clear();
        for (int i = 0; i < viewElementArray.length; ++i) {
            this.cells.add(new MultiSplitCell(viewElementArray[i], dArray[i], this.isHorizontalSplit()));
        }
        List<Component> list2 = this.collectComponents();
        ArrayList<Component> arrayList = new ArrayList<Component>(list);
        arrayList.removeAll(list2);
        ArrayList<Component> arrayList2 = new ArrayList<Component>(list2);
        arrayList2.removeAll(list);
        for (Component component : arrayList) {
            this.remove(component);
        }
        for (Component component : arrayList2) {
            this.add(component);
        }
        this.dirty = true;
    }

    int getCellCount() {
        return this.cells.size();
    }

    MultiSplitCell cellAt(int n) {
        assert (n >= 0);
        assert (n < this.cells.size());
        return this.cells.get(n);
    }

    public void removeViewElementAt(int n) {
        if (n < 0 || n >= this.cells.size()) {
            return;
        }
        MultiSplitCell multiSplitCell = this.cells.remove(n);
        this.remove(multiSplitCell.getComponent());
        this.dirty = true;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isVerticalSplit() {
        return this.orientation == 0;
    }

    public boolean isHorizontalSplit() {
        return this.orientation == 1;
    }

    private List<Component> collectComponents() {
        ArrayList<Component> arrayList = new ArrayList<Component>(this.getCellCount());
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell multiSplitCell = this.cellAt(i);
            Component component = multiSplitCell.getComponent();
            assert (null != component);
            arrayList.add(component);
        }
        return arrayList;
    }

    public void calculateSplitWeights(List<ViewElement> list, List<Double> list2) {
        double d;
        double d2 = d = this.isHorizontalSplit() ? (double)this.getSize().width : (double)this.getSize().height;
        if (d <= 0.0) {
            return;
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell multiSplitCell = this.cellAt(i);
            double d3 = (double)multiSplitCell.getSize() / d;
            list2.add(d3);
            list.add(multiSplitCell.getViewElement());
        }
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int n) {
        this.dirty |= n != this.dividerSize;
        this.dividerSize = n;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell multiSplitCell = this.cellAt(i);
            int n = multiSplitCell.getMinimumSize();
            Dimension dimension2 = multiSplitCell.getComponent().getMinimumSize();
            if (this.isHorizontalSplit()) {
                dimension.width += n;
                if (dimension2.height <= dimension.height) continue;
                dimension.height = dimension2.height;
                continue;
            }
            dimension.height += n;
            if (dimension2.width <= dimension.width) continue;
            dimension.width = dimension2.width;
        }
        if (this.isHorizontalSplit()) {
            dimension.width += (this.getCellCount() - 1) * this.getDividerSize();
        } else {
            dimension.height += (this.getCellCount() - 1) * this.getDividerSize();
        }
        return dimension;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.switchCursor(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (null == this.draggingDivider) {
            return;
        }
        this.draggingDivider.dragTo(mouseEvent.getPoint());
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (null == this.draggingDivider) {
            return;
        }
        Point point = new Point(mouseEvent.getPoint());
        this.draggingDivider.finishDraggingTo(point);
        this.draggingDivider = null;
        this.setCursor(Cursor.getDefaultCursor());
        mouseEvent.consume();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        MultiSplitDivider multiSplitDivider = this.dividerAtPoint(mouseEvent.getPoint());
        if (null == multiSplitDivider) {
            return;
        }
        this.draggingDivider = multiSplitDivider;
        multiSplitDivider.startDragging(mouseEvent.getPoint());
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (null == this.draggingDivider) {
            this.setCursor(Cursor.getDefaultCursor());
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void switchCursor(MouseEvent mouseEvent) {
        MultiSplitDivider multiSplitDivider = this.dividerAtPoint(mouseEvent.getPoint());
        if (null == multiSplitDivider) {
            this.setCursor(Cursor.getDefaultCursor());
        } else if (multiSplitDivider.isHorizontal()) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(8));
        }
    }

    private MultiSplitDivider dividerAtPoint(Point point) {
        for (MultiSplitDivider multiSplitDivider : this.dividers) {
            if (!multiSplitDivider.containsPoint(point)) continue;
            return multiSplitDivider;
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (MultiSplitDivider multiSplitDivider : this.dividers) {
            multiSplitDivider.paint(graphics);
        }
    }

    private void resize(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.getCellCount(); ++n2) {
            n3 += this.cellAt(n2).getRequiredSize();
        }
        n2 = this.getDividerSize() * (this.getCellCount() - 1);
        int n4 = n - n2;
        int n5 = n4 - n3;
        if (n5 > 0) {
            this.grow(n5);
        } else if (n5 < 0 && (n5 = this.shrink(n5)) > 0) {
            n4 -= n5;
        }
        int n6 = 0;
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell multiSplitCell = this.cellAt(i);
            n6 += multiSplitCell.getRequiredSize();
        }
        if (n6 < n4) {
            MultiSplitCell multiSplitCell = this.cellAt(this.getCellCount() - 1);
            multiSplitCell.setRequiredSize(multiSplitCell.getRequiredSize() + (n4 - n6));
        }
    }

    private void grow(int n) {
        List<MultiSplitCell> list = this.getResizeHungryCells();
        if (!list.isEmpty()) {
            this.normalizeResizeWeights(list);
            this.distributeDelta(n, list);
        } else {
            ArrayList<MultiSplitCell> arrayList = new ArrayList<MultiSplitCell>(this.cells);
            this.normalizeResizeWeights(arrayList);
            this.distributeDelta(n, arrayList);
        }
    }

    private int shrink(int n) {
        int n2 = -n;
        List<MultiSplitCell> list = this.getResizeHungryCells();
        int n3 = this.calculateShrinkableArea(list);
        if (n3 >= n2) {
            n3 = n2;
            n2 = 0;
        } else {
            n2 -= n3;
        }
        if (n3 > 0) {
            this.distributeDelta(-n3, list);
        }
        if (n2 > 0) {
            ArrayList<MultiSplitCell> arrayList = new ArrayList<MultiSplitCell>(this.cells);
            n3 = this.calculateShrinkableArea(arrayList);
            if (n3 >= n2) {
                n3 = n2;
                n2 = 0;
            } else {
                n2 -= n3;
            }
            if (n3 > 0) {
                this.distributeDelta(-n3, arrayList);
            }
        }
        return n2;
    }

    private int calculateShrinkableArea(List<MultiSplitCell> list) {
        int n;
        int n2;
        int n3 = 0;
        ArrayList<MultiSplitCell> arrayList = new ArrayList<MultiSplitCell>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            MultiSplitCell multiSplitCell = list.get(i);
            n2 = multiSplitCell.getRequiredSize();
            if (n2 - (n = multiSplitCell.getMinimumSize()) > 0) {
                n3 += n2 - n;
                continue;
            }
            arrayList.add(multiSplitCell);
        }
        list.removeAll(arrayList);
        for (MultiSplitCell multiSplitCell : list) {
            n2 = multiSplitCell.getRequiredSize();
            n = multiSplitCell.getMinimumSize();
            multiSplitCell.setNormalizedResizeWeight(1.0 * (double)(n2 - n) / (double)n3);
        }
        return n3;
    }

    private void distributeDelta(int n, List<MultiSplitCell> list) {
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            MultiSplitCell multiSplitCell = list.get(i);
            int n3 = (int)(multiSplitCell.getNormalizedResizeWeight() * (double)n);
            n2 += n3;
            if (i == list.size() - 1) {
                n3 += n - n2;
            }
            multiSplitCell.setRequiredSize(multiSplitCell.getRequiredSize() + n3);
        }
    }

    private void normalizeResizeWeights(List list) {
        if (list.isEmpty()) {
            return;
        }
        double d = 0.0;
        for (MultiSplitCell multiSplitCell : list) {
            d += multiSplitCell.getResizeWeight();
        }
        double d2 = (1.0 - d) / (double)list.size();
        for (MultiSplitCell multiSplitCell : list) {
            multiSplitCell.setNormalizedResizeWeight(multiSplitCell.getResizeWeight() + d2);
        }
    }

    List<MultiSplitCell> getResizeHungryCells() {
        ArrayList<MultiSplitCell> arrayList = new ArrayList<MultiSplitCell>(this.cells.size());
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell multiSplitCell = this.cellAt(i);
            if (multiSplitCell.getResizeWeight() <= 0.0) continue;
            arrayList.add(multiSplitCell);
        }
        return arrayList;
    }

    void createDividers() {
        this.dividers.clear();
        for (int i = 0; i < this.getCellCount() - 1; ++i) {
            MultiSplitCell multiSplitCell = this.cellAt(i);
            MultiSplitCell multiSplitCell2 = this.cellAt(i + 1);
            MultiSplitDivider multiSplitDivider = new MultiSplitDivider(this, multiSplitCell, multiSplitCell2);
            this.dividers.add(multiSplitDivider);
        }
    }

    void splitterMoved() {
        this.userMovedSplit = true;
        this.validate();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiSplitPane();
        }
        return this.accessibleContext;
    }

    int getDividerAccessibleIndex(MultiSplitDivider multiSplitDivider) {
        int n = this.dividers.indexOf(multiSplitDivider);
        return n += this.getAccessibleContext().getAccessibleChildrenCount() - this.dividers.size();
    }

    protected class AccessibleMultiSplitPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleMultiSplitPane() {
            super(MultiSplitPane.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (MultiSplitPane.this.isHorizontalSplit()) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }

        public Accessible getAccessibleAt(Point point) {
            MultiSplitDivider multiSplitDivider = MultiSplitPane.this.dividerAtPoint(point);
            if (null != multiSplitDivider) {
                return multiSplitDivider;
            }
            return super.getAccessibleAt(point);
        }

        public Accessible getAccessibleChild(int n) {
            int n2 = super.getAccessibleChildrenCount();
            if (n < n2) {
                return super.getAccessibleChild(n);
            }
            if (n - n2 >= MultiSplitPane.this.dividers.size()) {
                return null;
            }
            MultiSplitDivider multiSplitDivider = (MultiSplitDivider)MultiSplitPane.this.dividers.get(n - n2);
            return multiSplitDivider;
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount() + MultiSplitPane.this.dividers.size();
        }
    }

    protected class MultiSplitLayout
    implements LayoutManager {
        protected MultiSplitLayout() {
        }

        public void layoutContainer(Container container) {
            if (container != MultiSplitPane.this) {
                return;
            }
            int n = MultiSplitPane.this.isHorizontalSplit() ? MultiSplitPane.this.getSize().width : MultiSplitPane.this.getSize().height;
            for (int i = 0; i < MultiSplitPane.this.getCellCount(); ++i) {
                MultiSplitCell multiSplitCell = MultiSplitPane.this.cellAt(i);
                multiSplitCell.maybeResetToInitialSize(n);
            }
            MultiSplitPane.this.resize(n);
            this.layoutCells();
            if (MultiSplitPane.this.userMovedSplit) {
                MultiSplitPane.this.userMovedSplit = false;
                MultiSplitPane.this.firePropertyChange("splitPositions", null, this);
            }
            MultiSplitPane.this.createDividers();
        }

        private void layoutCells() {
            int n = 0;
            int n2 = 0;
            int n3 = MultiSplitPane.this.getWidth();
            int n4 = MultiSplitPane.this.getHeight();
            for (int i = 0; i < MultiSplitPane.this.getCellCount(); ++i) {
                MultiSplitCell multiSplitCell = MultiSplitPane.this.cellAt(i);
                if (multiSplitCell.getComponent().getParent() != MultiSplitPane.this) {
                    MultiSplitPane.this.add(multiSplitCell.getComponent());
                }
                if (MultiSplitPane.this.isHorizontalSplit()) {
                    n3 = multiSplitCell.getRequiredSize();
                } else {
                    n4 = multiSplitCell.getRequiredSize();
                }
                multiSplitCell.layout(n, n2, n3, n4);
                if (MultiSplitPane.this.isHorizontalSplit()) {
                    n += n3;
                    if (i >= MultiSplitPane.this.getCellCount()) continue;
                    n += MultiSplitPane.this.getDividerSize();
                    continue;
                }
                n2 += n4;
                if (i >= MultiSplitPane.this.getCellCount() - 1) continue;
                n2 += MultiSplitPane.this.getDividerSize();
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return container.getSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }
    }
}

