/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WriteLock
extends FileLock {
    static final Map allLocks;
    private File lockFile;
    static final /* synthetic */ boolean $assertionsDisabled;

    static WriteLock tryLock(File file) throws IOException {
        return WriteLock.getInstance(file, false);
    }

    static WriteLock tryNioLock(File file) throws IOException {
        return WriteLock.getInstance(file, true);
    }

    static WriteLock tryLightWeightLock(File file) throws IOException {
        return WriteLock.getLightWeightInstance(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void relock(File file, File file2) {
        Object object;
        ArrayList<WriteLock> arrayList = new ArrayList<WriteLock>();
        Set set = allLocks.keySet();
        Object object2 = allLocks;
        synchronized (object2) {
            object = set.iterator();
            while (object.hasNext()) {
                Reference reference;
                WriteLock writeLock;
                File file3 = (File)object.next();
                File file4 = null;
                String string = WriteLock.getRelativePath(file, file3);
                if (string != null) {
                    file4 = new File(file2, string);
                } else if (file3.equals(WriteLockUtils.getAssociatedLockFile(file))) {
                    file4 = WriteLockUtils.getAssociatedLockFile(file2);
                    if (file3.exists()) {
                        file3.renameTo(file4);
                    }
                }
                if (file4 == null || (writeLock = (WriteLock)((Object)(reference = (Reference)allLocks.get(file3)).get())) == null) continue;
                object.remove();
                writeLock.lockFile = file4;
                arrayList.add(writeLock);
            }
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (WriteLock)((Object)object2.next());
            allLocks.put(((WriteLock)((Object)object)).lockFile, new WeakReference(object));
        }
    }

    private static String getRelativePath(File file, File file2) {
        File file3;
        Stack<String> stack = new Stack<String>();
        for (file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            stack.push(file3.getName());
        }
        if (file3 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (!stack.isEmpty()) {
            stringBuilder.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    private static WriteLock getLightWeightInstance(File file) throws IOException {
        File file2 = WriteLockUtils.getAssociatedLockFile(file);
        boolean bl = allLocks.keySet().contains(file2);
        if (bl) {
            throw new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileAlreadyLocked", (Object)file.getAbsolutePath()));
        }
        return new WriteLock(file2);
    }

    private static WriteLock getInstance(File file, boolean bl) throws IOException {
        boolean bl2 = false;
        IOException iOException = null;
        File file2 = WriteLockUtils.getAssociatedLockFile(file);
        if (!file2.exists()) {
            bl2 = true;
        }
        RandomAccessFile randomAccessFile = WriteLock.getAccessToFile(file2);
        if (!$assertionsDisabled && !file2.exists()) {
            throw new AssertionError();
        }
        FileChannel fileChannel = randomAccessFile.getChannel();
        if (fileChannel != null && fileChannel.isOpen()) {
            try {
                String string = WriteLockUtils.getContentOfLckFile(file2, fileChannel);
                if (string == null && (bl2 || file2.length() == 0L)) {
                    if (!$assertionsDisabled && file2.length() != 0L) {
                        throw new AssertionError();
                    }
                    string = WriteLockUtils.writeContentOfLckFile(file2, fileChannel);
                }
                if (string != null && !allLocks.keySet().contains(new File(string))) {
                    if (fileChannel != null && fileChannel.isOpen() && !bl) {
                        fileChannel.close();
                    }
                    return bl ? new NioLock(file2, fileChannel, fileChannel.tryLock()) : new WriteLock(file2);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (fileChannel != null && fileChannel.isOpen()) {
            fileChannel.close();
        }
        if (bl2 && file2.exists()) {
            file2.delete();
        }
        if (iOException == null) {
            iOException = file2.exists() ? new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileLockAlreadyExists", (Object)file.getAbsolutePath(), (Object)file2.getAbsolutePath())) : new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileAlreadyLocked", (Object)file.getAbsolutePath()));
        }
        FSException.annotateException(iOException);
        throw iOException;
    }

    private static RandomAccessFile getAccessToFile(File file) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rwd");
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            if (!file.exists()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canRead()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canWrite()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (file.getParentFile() == null) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.getParentFile().exists()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            }
            throw fileNotFoundException2;
        }
        return randomAccessFile;
    }

    private WriteLock(File file) {
        this.lockFile = file;
        this.register();
    }

    public boolean isValid(File file) {
        boolean bl = this.isValid();
        if (bl) {
            File file2 = WriteLockUtils.getAssociatedLockFile(file);
            bl = this.lockFile.equals(file2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Class clazz = WriteLockFactory.class;
        synchronized (clazz) {
            if (this.isValid()) {
                this.deregister();
                super.releaseLock();
            }
            if (this.getLockFile().exists()) {
                boolean bl = this.getLockFile().delete();
            }
        }
    }

    private final void deregister() {
        allLocks.remove(this.getLockFile());
    }

    private final void register() {
        allLocks.put(this.getLockFile(), new WeakReference<WriteLock>(this));
    }

    final File getLockFile() {
        return this.lockFile;
    }

    public final String toString() {
        String string = this.getLockFile().getName();
        String string2 = string.substring(".LCK".length(), string.length() - "~".length());
        return new File(this.getLockFile().getParentFile(), string2).getAbsolutePath();
    }

    static {
        $assertionsDisabled = !WriteLock.class.desiredAssertionStatus();
        allLocks = Collections.synchronizedMap(new WeakHashMap());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Set set = allLocks.keySet();
                Map map = allLocks;
                synchronized (map) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        if (!file.exists() || !WriteLockUtils.hasActiveLockFileSigns(file.getAbsolutePath())) continue;
                        file.delete();
                    }
                }
            }
        });
    }

    private static class NioLock
    extends WriteLock {
        private FileChannel channel;
        private java.nio.channels.FileLock nioLock;
        static final /* synthetic */ boolean $assertionsDisabled;

        NioLock(File file, FileChannel fileChannel, java.nio.channels.FileLock fileLock) {
            super(file);
            if (!$assertionsDisabled && fileLock == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !fileLock.isValid()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && fileChannel == null) {
                throw new AssertionError();
            }
            this.channel = fileChannel;
            this.nioLock = fileLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLock() {
            Class clazz = class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory == null ? (class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory = WriteLock.class$("org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory")) : class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory;
            synchronized (clazz) {
                try {
                    if (this.nioLock.isValid()) {
                        this.nioLock.release();
                    }
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                super.releaseLock();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock == null ? (class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock = WriteLock.class$("org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLock")) : class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock).desiredAssertionStatus();
        }
    }
}

