/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.CookieSetLkp;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CookieSet
implements Lookup.Provider {
    private static ThreadLocal<Object> QUERY_MODE = new ThreadLocal();
    private HashMap<Class, R> map = new HashMap(31);
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final CookieSetLkp ic;
    private Lookup lookup;

    public CookieSet() {
        this(null, null);
    }

    private CookieSet(CookieSetLkp cookieSetLkp, Lookup lookup) {
        this.ic = cookieSetLkp;
        this.lookup = lookup;
    }

    public static CookieSet createGeneric(Before before) {
        CookieSetLkp cookieSetLkp = new CookieSetLkp(before);
        return new CookieSet(cookieSetLkp, (Lookup)cookieSetLkp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        ThreadLocal<Object> threadLocal = QUERY_MODE;
        synchronized (threadLocal) {
            if (this.lookup == null) {
                AbstractNode abstractNode = new AbstractNode(this);
                this.lookup = abstractNode.getLookup();
            }
        }
        return this.lookup;
    }

    public void add(Node.Cookie cookie) {
        this.addImpl(cookie);
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImpl(Object object) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(object.getClass(), object);
        }
        if (this.ic != null) {
            this.ic.add(object);
        }
    }

    public void remove(Node.Cookie cookie) {
        this.removeImpl(cookie);
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeImpl(Object object) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.unregisterCookie(object.getClass(), object);
        }
        if (this.ic != null) {
            this.ic.remove(object);
        }
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (this.ic != null) {
            this.ic.beforeLookupImpl(clazz);
        }
        return this.lookupCookie(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Node.Cookie> T lookupCookie(Class<T> clazz) {
        Node.Cookie cookie = null;
        Object object = QUERY_MODE.get();
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            R r = this.findR(clazz);
            if (r == null) {
                if (object == null || this.ic == null) {
                    return null;
                }
            } else {
                cookie = r.cookie();
                if (object instanceof Set) {
                    Set set = (Set)object;
                    set.addAll(this.map.keySet());
                }
            }
        }
        if (cookie instanceof CookieEntry) {
            if (clazz == object) {
                QUERY_MODE.set(cookie);
                cookie = null;
            } else {
                cookie = ((CookieEntry)cookie).getCookie(true);
            }
        } else if (!(cookie != null || this.ic == null || Node.Cookie.class.isAssignableFrom(clazz) && clazz != Node.Cookie.class)) {
            CookieSet.enhancedQueryMode(this.lookup, clazz);
            cookie = null;
        }
        return (T)((Node.Cookie)clazz.cast(cookie));
    }

    static void enhancedQueryMode(Lookup lookup, Class<?> clazz) {
        Object object = QUERY_MODE.get();
        if (object != clazz) {
            return;
        }
        Collection collection = lookup.lookupResult(clazz).allItems();
        if (collection.size() == 0) {
            return;
        }
        AbstractLookup.Pair[] pairArray = new AbstractLookup.Pair[collection.size()];
        Iterator iterator = collection.iterator();
        for (int i = 0; i < pairArray.length; ++i) {
            pairArray[i] = new PairWrap((Lookup.Item)iterator.next());
        }
        QUERY_MODE.set(pairArray);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    static Object entryQueryMode(Class clazz) {
        Object object = QUERY_MODE.get();
        QUERY_MODE.set(clazz);
        return object;
    }

    static Object entryAllClassesMode() {
        Object object = QUERY_MODE.get();
        QUERY_MODE.set(new HashSet());
        return object;
    }

    static Collection<AbstractLookup.Pair> exitQueryMode(Object object) {
        Object object2 = QUERY_MODE.get();
        QUERY_MODE.set(object);
        if (object2 instanceof CookieEntry) {
            return Collections.singleton(new CookieEntryPair((CookieEntry)object2));
        }
        if (object2 instanceof AbstractLookup.Pair[]) {
            return Arrays.asList((AbstractLookup.Pair[])object2);
        }
        return null;
    }

    static Set exitAllClassesMode(Object object) {
        Object object2 = QUERY_MODE.get();
        QUERY_MODE.set(object);
        if (object2 instanceof HashSet) {
            return (Set)object2;
        }
        return null;
    }

    final void fireChangeEvent() {
        this.cs.fireChange();
    }

    private void registerCookie(Class<?> clazz, Object object) {
        if (clazz == null || !Node.Cookie.class.isAssignableFrom(clazz)) {
            return;
        }
        Class<Node.Cookie> clazz2 = clazz.asSubclass(Node.Cookie.class);
        R r = this.findR(clazz2);
        if (r == null) {
            r = new R();
            this.map.put(clazz, r);
        }
        r.add((Node.Cookie)object);
        this.registerCookie(clazz.getSuperclass(), object);
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            this.registerCookie(classArray[i], object);
        }
    }

    private void unregisterCookie(Class<?> clazz, Object object) {
        if (clazz == null || !Node.Cookie.class.isAssignableFrom(clazz)) {
            return;
        }
        Class<Node.Cookie> clazz2 = clazz.asSubclass(Node.Cookie.class);
        R r = this.findR(clazz2);
        if (r != null) {
            r.remove((Node.Cookie)object);
        }
        this.unregisterCookie(clazz.getSuperclass(), object);
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            this.unregisterCookie(classArray[i], object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class<? extends Node.Cookie> clazz, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(clazz, new CookieEntry(factory, clazz));
        }
        if (this.ic != null) {
            this.ic.add(new FactAndClass(clazz, factory), C.INSTANCE);
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class<? extends Node.Cookie>[] classArray, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        Class<? extends Node.Cookie>[] classArray2 = this;
        synchronized (this) {
            for (int i = 0; i < classArray.length; ++i) {
                super.registerCookie(classArray[i], new CookieEntry(factory, classArray[i]));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this.ic != null) {
                for (Class<? extends Node.Cookie> clazz : classArray) {
                    this.ic.add(new FactAndClass(clazz, factory), C.INSTANCE);
                }
            }
            this.fireChangeEvent();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Class<? extends Node.Cookie> clazz, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            Node.Cookie cookie;
            R r = this.findR(clazz);
            if (r != null && (cookie = r.cookie()) instanceof CookieEntry) {
                CookieEntry cookieEntry = (CookieEntry)cookie;
                if (cookieEntry.factory == factory) {
                    this.unregisterCookie(clazz, cookie);
                }
            }
        }
        if (this.ic != null) {
            this.ic.remove(new FactAndClass(clazz, factory), C.INSTANCE);
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Class<? extends Node.Cookie>[] classArray, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        Class<? extends Node.Cookie>[] classArray2 = this;
        synchronized (this) {
            for (int i = 0; i < classArray.length; ++i) {
                Node.Cookie object;
                R r = this.findR(classArray[i]);
                if (r == null || !((object = r.cookie()) instanceof CookieEntry)) continue;
                CookieEntry cookieEntry = (CookieEntry)object;
                if (cookieEntry.factory != factory) continue;
                super.unregisterCookie(classArray[i], object);
            }
            // ** MonitorExit[classArray2] (shouldn't be in output)
            if (this.ic != null) {
                for (Class<? extends Node.Cookie> clazz : classArray) {
                    this.ic.remove(new FactAndClass(clazz, factory), C.INSTANCE);
                }
            }
            this.fireChangeEvent();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void assign(Class<? extends T> clazz, T ... TArray) {
        if (Node.Cookie.class.isAssignableFrom(clazz)) {
            T[] TArray2;
            Class<Node.Cookie> clazz2 = clazz.asSubclass(Node.Cookie.class);
            while ((TArray2 = this.lookupCookie(clazz2)) != null) {
                this.removeImpl(TArray2);
            }
            for (T t : TArray) {
                this.addImpl(t);
            }
            this.fireChangeEvent();
        } else if (this.ic != null) {
            CookieSet cookieSet = this;
            synchronized (cookieSet) {
                for (T t : TArray) {
                    this.registerCookie(t.getClass(), t);
                }
            }
            this.ic.replaceInstances(clazz, TArray, this);
        }
    }

    private R findR(Class<? extends Node.Cookie> clazz) {
        return this.map.get(clazz);
    }

    private static Class<? extends Node.Cookie> baseForCookie(Node.Cookie cookie) {
        if (cookie instanceof CookieEntry) {
            return ((CookieEntry)cookie).klass;
        }
        return cookie.getClass();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Before {
        public void beforeLookup(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class C
    implements InstanceContent.Convertor<FactAndClass, Node.Cookie> {
        static final C INSTANCE = new C();

        private C() {
        }

        public Node.Cookie convert(FactAndClass factAndClass) {
            return factAndClass.factory.createCookie(factAndClass.clazz);
        }

        public Class<? extends Node.Cookie> type(FactAndClass factAndClass) {
            return factAndClass.clazz;
        }

        public String id(FactAndClass factAndClass) {
            return factAndClass.clazz.getName();
        }

        public String displayName(FactAndClass factAndClass) {
            return factAndClass.clazz.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CookieEntry
    implements Node.Cookie {
        final Factory factory;
        private final Class<? extends Node.Cookie> klass;
        private Reference<Node.Cookie> cookie;

        public CookieEntry(Factory factory, Class<? extends Node.Cookie> clazz) {
            this.factory = factory;
            this.klass = clazz;
        }

        public synchronized Node.Cookie getCookie(boolean bl) {
            Node.Cookie cookie;
            if (bl) {
                if (this.cookie == null || (cookie = this.cookie.get()) == null) {
                    cookie = this.factory.createCookie(this.klass);
                    if (cookie == null) {
                        return null;
                    }
                    this.cookie = new WeakReference<Node.Cookie>(cookie);
                }
            } else {
                cookie = this.cookie == null ? null : this.cookie.get();
            }
            return cookie;
        }
    }

    private static final class CookieEntryPair
    extends AbstractLookup.Pair {
        private CookieEntry entry;

        public CookieEntryPair(CookieEntry cookieEntry) {
            this.entry = cookieEntry;
        }

        protected boolean creatorOf(Object object) {
            return object == this.entry.getCookie(false);
        }

        public String getDisplayName() {
            return this.getId();
        }

        public String getId() {
            return this.entry.klass.getName();
        }

        public Object getInstance() {
            return this.entry.getCookie(true);
        }

        public Class getType() {
            return this.entry.klass;
        }

        protected boolean instanceOf(Class clazz) {
            Class clazz2 = clazz;
            return clazz2.isAssignableFrom(this.entry.klass);
        }

        public int hashCode() {
            return this.entry.hashCode() + 5;
        }

        public boolean equals(Object object) {
            if (object instanceof CookieEntryPair) {
                return ((CookieEntryPair)((Object)object)).entry == this.entry;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FactAndClass {
        final Class<? extends Node.Cookie> clazz;
        final Factory factory;

        public FactAndClass(Class<? extends Node.Cookie> clazz, Factory factory) {
            this.clazz = clazz;
            this.factory = factory;
        }

        public int hashCode() {
            return this.clazz.hashCode() + this.factory.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof FactAndClass) {
                FactAndClass factAndClass = (FactAndClass)object;
                return factAndClass.clazz.equals(this.clazz) && factAndClass.factory == this.factory;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public <T extends Node.Cookie> T createCookie(Class<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PairWrap
    extends AbstractLookup.Pair {
        private Lookup.Item<?> item;
        private boolean created;

        public PairWrap(Lookup.Item<?> item) {
            this.item = item;
        }

        protected boolean instanceOf(Class clazz) {
            Class clazz2 = clazz;
            return clazz2.isAssignableFrom(this.getType());
        }

        protected boolean creatorOf(Object object) {
            return this.created && this.getInstance() == object;
        }

        public Object getInstance() {
            this.created = true;
            return this.item.getInstance();
        }

        public Class<? extends Object> getType() {
            return this.item.getType();
        }

        public String getId() {
            return this.item.getId();
        }

        public String getDisplayName() {
            return this.item.getDisplayName();
        }

        public int hashCode() {
            return 777 + this.item.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof PairWrap) {
                PairWrap pairWrap = (PairWrap)((Object)object);
                return this.item.equals(pairWrap.item);
            }
            return false;
        }
    }

    private static final class R {
        public List<Node.Cookie> cookies;
        public Class base;

        R() {
        }

        public void add(Node.Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<Node.Cookie>(1);
                this.cookies.add(cookie);
                this.base = CookieSet.baseForCookie(cookie);
                return;
            }
            Class clazz = CookieSet.baseForCookie(cookie);
            if (this.base == null || clazz.isAssignableFrom(this.base)) {
                this.cookies.set(0, cookie);
                this.base = clazz;
            } else {
                this.cookies.add(cookie);
            }
        }

        public boolean remove(Node.Cookie cookie) {
            if (this.cookies == null) {
                return true;
            }
            if (this.cookies.remove(cookie) && this.cookies.size() == 0) {
                this.base = null;
                this.cookies = null;
                return true;
            }
            this.base = CookieSet.baseForCookie(this.cookies.get(0));
            return false;
        }

        public Node.Cookie cookie() {
            return this.cookies == null || this.cookies.isEmpty() ? null : this.cookies.get(0);
        }
    }
}

