/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.GtkEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;

public final class GtkEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static Map<Integer, String[]> buttonIconPaths;

    public GtkEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new GtkEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    public Rectangle getTabRect(int n, Rectangle rectangle) {
        Rectangle rectangle2 = super.getTabRect(n, rectangle);
        rectangle2.y = 0;
        rectangle2.height = this.displayer.getHeight();
        return rectangle2;
    }

    public void install() {
        super.install();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 12;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    protected void paintAfterTabs(Graphics graphics) {
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new GtkEditorTabCellRenderer();
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollleft_disabled.png";
            stringArray[3] = stringArray[0];
            stringArray[1] = stringArray[0];
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollright_disabled.png";
            stringArray[3] = stringArray[0];
            stringArray[1] = stringArray[0];
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/gtk_popup_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/gtk_popup_disabled.png";
            stringArray[3] = stringArray[0];
            stringArray[1] = stringArray[0];
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/gtk_maximize_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/gtk_maximize_disabled.png";
            stringArray[3] = stringArray[0];
            stringArray[1] = stringArray[0];
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/gtk_restore_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/gtk_restore_disabled.png";
            stringArray[3] = stringArray[0];
            stringArray[1] = stringArray[0];
            buttonIconPaths.put(4, stringArray);
        }
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        GtkEditorTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    protected Rectangle getControlButtonsRectangle(Container container) {
        Component component = this.getControlButtons();
        return new Rectangle(container.getWidth() - component.getWidth() - 4, 4, component.getWidth(), component.getHeight());
    }

    public Insets getTabAreaInsets() {
        Insets insets = super.getTabAreaInsets();
        insets.right += 4;
        return insets;
    }
}

