/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.LocationInformer;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayerUI;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AquaEditorTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.AquaViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BasicSlidingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ToolbarTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinClassicViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinXPEditorTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinXPViewTabDisplayerUI;

public final class TabDisplayer
extends JComponent
implements Accessible {
    private boolean initialized = false;
    private TabDataModel model;
    private SingleSelectionModel sel = null;
    private boolean active;
    private final int type;
    public static final int TYPE_VIEW = 0;
    public static final int TYPE_EDITOR = 1;
    public static final int TYPE_SLIDING = 2;
    public static final int TYPE_TOOLBAR = 3;
    public static final String PROP_ACTIVE = "active";
    public static final String COMMAND_CLOSE = "close";
    public static final String COMMAND_SELECT = "select";
    public static final String COMMAND_POPUP_REQUEST = "popup";
    public static final String COMMAND_MAXIMIZE = "maximize";
    public static final String COMMAND_CLOSE_ALL = "closeAll";
    public static final String COMMAND_CLOSE_ALL_BUT_THIS = "closeAllButThis";
    public static final String COMMAND_ENABLE_AUTO_HIDE = "enableAutoHide";
    public static final String COMMAND_DISABLE_AUTO_HIDE = "disableAutoHide";
    public static final String EDITOR_TAB_DISPLAYER_UI_CLASS_ID = "EditorTabDisplayerUI";
    public static final String VIEW_TAB_DISPLAYER_UI_CLASS_ID = "ViewTabDisplayerUI";
    public static final String SLIDING_TAB_DISPLAYER_UI_CLASS_ID = "SlidingTabDisplayerUI";
    public static final String TOOLBAR_TAB_DISPLAYER_UI_CLASS_ID = "ToolbarTabDisplayerUI";
    public static final String PROP_ORIENTATION = "orientation";
    public static final Object ORIENTATION_EAST = "east";
    public static final Object ORIENTATION_WEST = "west";
    public static final Object ORIENTATION_NORTH = "north";
    public static final Object ORIENTATION_SOUTH = "south";
    public static final Object ORIENTATION_CENTER = "center";
    public static final Object ORIENTATION_INVISIBLE = "invisible";
    private transient List<ActionListener> actionListenerList;
    private WinsysInfoForTabbed winsysInfo = null;
    @Deprecated
    private LocationInformer locationInformer = null;
    private boolean showClose = !Boolean.getBoolean("nb.tabs.suppressCloseButton");

    public TabDisplayer() {
        this(new DefaultTabDataModel(), 0);
    }

    public TabDisplayer(TabDataModel tabDataModel, int n) {
        this(tabDataModel, n, (WinsysInfoForTabbed)null);
    }

    @Deprecated
    public TabDisplayer(TabDataModel tabDataModel, int n, LocationInformer locationInformer) {
        this(tabDataModel, n, (WinsysInfoForTabbed)null);
        this.locationInformer = locationInformer;
    }

    public TabDisplayer(TabDataModel tabDataModel, int n, WinsysInfoForTabbed winsysInfoForTabbed) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown UI type: " + n);
            }
        }
        this.model = tabDataModel;
        this.type = n;
        this.winsysInfo = winsysInfoForTabbed;
        this.putClientProperty(PROP_ORIENTATION, ORIENTATION_NORTH);
        this.initialized = true;
        this.updateUI();
        this.setFocusable(false);
    }

    public final TabDisplayerUI getUI() {
        return (TabDisplayerUI)this.ui;
    }

    public final void updateUI() {
        if (!this.initialized) {
            return;
        }
        if (this.type == 3) {
            this.setUI(new ToolbarTabDisplayerUI(this));
            return;
        }
        if (this.type == 2) {
            this.setUI(new BasicSlidingTabDisplayerUI(this));
            return;
        }
        ComponentUI componentUI = null;
        if (UIManager.get(this.getUIClassID()) != null) {
            try {
                componentUI = UIManager.getUI(this);
            }
            catch (Error error) {
                System.err.println("Could not load a UI for " + this.getUIClassID() + " - missing class?");
            }
        } else {
            componentUI = this.findUIStandalone();
        }
        if (componentUI == null) {
            componentUI = this.getType() == 0 ? WinClassicViewTabDisplayerUI.createUI(this) : WinClassicEditorTabDisplayerUI.createUI(this);
        }
        this.setUI((TabDisplayerUI)componentUI);
    }

    private ComponentUI findUIStandalone() {
        ComponentUI componentUI = null;
        String string = UIManager.getLookAndFeel().getID();
        switch (this.type) {
            case 0: {
                if ("Aqua".equals(string)) {
                    componentUI = AquaViewTabDisplayerUI.createUI(this);
                    break;
                }
                if (!"Windows".equals(string)) break;
                componentUI = TabDisplayer.isXPLF() ? WinXPViewTabDisplayerUI.createUI(this) : WinClassicViewTabDisplayerUI.createUI(this);
                break;
            }
            case 1: {
                if ("Aqua".equals(string)) {
                    componentUI = AquaEditorTabDisplayerUI.createUI(this);
                    break;
                }
                if (!"Windows".equals(string)) break;
                componentUI = TabDisplayer.isXPLF() ? WinXPEditorTabDisplayerUI.createUI(this) : WinClassicEditorTabDisplayerUI.createUI(this);
            }
        }
        return componentUI;
    }

    private static boolean isXPLF() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return bl == null ? false : bl;
    }

    public String getUIClassID() {
        switch (this.getType()) {
            case 0: {
                return VIEW_TAB_DISPLAYER_UI_CLASS_ID;
            }
            case 1: {
                return EDITOR_TAB_DISPLAYER_UI_CLASS_ID;
            }
            case 2: {
                return SLIDING_TAB_DISPLAYER_UI_CLASS_ID;
            }
            case 3: {
                return TOOLBAR_TAB_DISPLAYER_UI_CLASS_ID;
            }
        }
        throw new IllegalArgumentException("Unknown UI type: " + this.getType());
    }

    public final int getType() {
        return this.type;
    }

    public final Dimension getPreferredSize() {
        return this.getUI().getPreferredSize(this);
    }

    public final Dimension getMinimumSize() {
        return this.getUI().getMinimumSize(this);
    }

    public final void requestAttention(int n) {
        this.getUI().requestAttention(n);
    }

    public final void cancelRequestAttention(int n) {
        this.getUI().cancelRequestAttention(n);
    }

    public final boolean requestAttention(TabData tabData) {
        boolean bl;
        int n = this.getModel().indexOf(tabData);
        boolean bl2 = bl = n >= 0;
        if (bl) {
            this.requestAttention(n);
        }
        return bl;
    }

    void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.sel = singleSelectionModel;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.sel;
    }

    public final TabDataModel getModel() {
        return this.model;
    }

    public final void setActive(boolean bl) {
        if (bl != this.active) {
            this.active = bl;
            this.firePropertyChange(PROP_ACTIVE, !bl, bl);
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        if (this.ui != null) {
            int n;
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getSource() != this) {
                Component component = (Component)mouseEvent.getSource();
                point = SwingUtilities.convertPoint(component, point, this);
            }
            if ((n = this.getUI().tabForCoordinate(point)) != -1) {
                return this.getModel().getTab((int)n).tip;
            }
        }
        return super.getToolTipText(mouseEvent);
    }

    public final void makeTabVisible(int n) {
        this.getUI().makeTabVisible(n);
    }

    public final Rectangle getTabRect(int n, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        this.getUI().getTabRect(n, rectangle);
        return rectangle;
    }

    @Deprecated
    public final Image getDragImage(int n) {
        return null;
    }

    public final synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList<ActionListener>();
        }
        this.actionListenerList.add(actionListener);
    }

    public final synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(actionListener);
        }
    }

    public void registerShortcuts(JComponent jComponent) {
        this.getUI().registerShortcuts(jComponent);
    }

    public void unregisterShortcuts(JComponent jComponent) {
        this.getUI().unregisterShortcuts(jComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postActionEvent(TabActionEvent tabActionEvent) {
        List<ActionListener> list;
        TabDisplayer tabDisplayer = this;
        synchronized (tabDisplayer) {
            if (this.actionListenerList == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListenerList);
        }
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).actionPerformed(tabActionEvent);
        }
    }

    public int tabForCoordinate(Point point) {
        return this.getUI().tabForCoordinate(point);
    }

    public WinsysInfoForTabbed getWinsysInfo() {
        return this.winsysInfo;
    }

    @Deprecated
    public LocationInformer getLocationInformer() {
        return this.locationInformer;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTabDisplayer();
        }
        return this.accessibleContext;
    }

    public final void setShowCloseButton(boolean bl) {
        boolean bl2 = this.isShowCloseButton();
        if (bl2 != bl) {
            this.showClose = bl;
            if (this.isShowing()) {
                this.repaint();
            }
            this.firePropertyChange("showCloseButton", !bl, bl);
        }
    }

    public final boolean isShowCloseButton() {
        return this.showClose;
    }

    protected class AccessibleTabDisplayer
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        public AccessibleTabDisplayer() {
            super(TabDisplayer.this);
            TabDisplayer.this.getModel().addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public int getAccessibleChildrenCount() {
            return TabDisplayer.this.getModel().size();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= TabDisplayer.this.getModel().size()) {
                return null;
            }
            TabData tabData = TabDisplayer.this.getModel().getTab(n);
            if (tabData.getComponent() instanceof Accessible) {
                return (Accessible)((Object)tabData.getComponent());
            }
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = TabDisplayer.this.tabForCoordinate(point);
            if (n == -1) {
                n = TabDisplayer.this.getSelectionModel().getSelectedIndex();
            }
            return this.getAccessibleChild(n);
        }

        public int getAccessibleSelectionCount() {
            return 1;
        }

        public Accessible getAccessibleSelection(int n) {
            int n2 = TabDisplayer.this.getSelectionModel().getSelectedIndex();
            return this.getAccessibleChild(n2);
        }

        public boolean isAccessibleChildSelected(int n) {
            return n == TabDisplayer.this.getSelectionModel().getSelectedIndex();
        }

        public void addAccessibleSelection(int n) {
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

